/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.properties;

import fr.esrf.tangoatk.core.Property;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.Caret;

class PropertyListAdapter
implements PropertyChangeListener {
    JPanel valuePanel;
    JPanel namePanel;
    Map properties;
    Map valueMap;
    Map fieldMap;
    List keys;
    protected GridBagConstraints constraints = new GridBagConstraints();
    boolean editable;

    PropertyListAdapter() {
    }

    protected void gbAdd(JPanel jPanel, JComponent jComponent, int n, int n2) {
        this.constraints.anchor = 18;
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.fill = 2;
        this.constraints.weightx = 0.1;
        jPanel.add((Component)jComponent, this.constraints);
        this.constraints.gridy = n2 + 1;
        jPanel.add((Component)new JSeparator(), this.constraints);
    }

    public void setModel(Map map, JPanel jPanel, JPanel jPanel2) {
        this.valuePanel = jPanel;
        this.namePanel = jPanel2;
        jPanel.removeAll();
        jPanel2.removeAll();
        this.valueMap = new HashMap();
        this.fieldMap = new HashMap();
        this.properties = map;
        this.keys = new Vector();
        this.keys.addAll(map.keySet());
        Iterator iterator = this.keys.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(jPanel2.getFont());
            Property property = (Property)map.get(string);
            property.addPresentationListener((PropertyChangeListener)this);
            JTextField jTextField = new JTextField(property.getPresentation());
            this.valueMap.put(jTextField, property);
            this.fieldMap.put(property, jTextField);
            jTextField.setBorder(BorderFactory.createEmptyBorder());
            jTextField.setBackground(jPanel.getBackground());
            jTextField.setDisabledTextColor(jPanel.getForeground());
            if (property.isEditable() && this.isEditable()) {
                jTextField.setEnabled(false);
                jTextField.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        JTextField jTextField = (JTextField)mouseEvent.getSource();
                        jTextField.setEnabled(true);
                        Caret caret = jTextField.getCaret();
                        caret.setDot(jTextField.getText().length());
                        jTextField.setCaret(caret);
                        jTextField.setBackground(Color.white);
                    }
                });
                jTextField.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent keyEvent) {
                        PropertyListAdapter.this.inputKeyPressed(keyEvent);
                    }
                });
            } else {
                jTextField.setEditable(false);
            }
            this.gbAdd(jPanel2, jLabel, 0, n);
            this.gbAdd(jPanel, jTextField, 0, n);
            n += 2;
        }
    }

    void store() {
        for (Property property : this.fieldMap.keySet()) {
            if (!property.isEditable()) continue;
            JTextField jTextField = (JTextField)this.fieldMap.get(property);
            this.done(jTextField);
            property.setValue((Object)jTextField.getText());
            property.store();
        }
    }

    void cancel() {
        for (Property property : this.fieldMap.keySet()) {
            if (!property.isEditable()) continue;
            JTextField jTextField = (JTextField)this.fieldMap.get(property);
            jTextField.setText(property.getPresentation());
            this.done(jTextField);
        }
    }

    public void inputKeyPressed(KeyEvent keyEvent) {
        JTextField jTextField = (JTextField)keyEvent.getComponent();
        if (keyEvent.getKeyCode() == 27) {
            Property property = (Property)this.valueMap.get(jTextField);
            jTextField.setText(property.getPresentation());
            this.done(jTextField);
            return;
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void done(JTextField jTextField) {
        Caret caret = jTextField.getCaret();
        caret.setVisible(false);
        jTextField.setCaret(caret);
        jTextField.setEnabled(false);
        jTextField.setBackground(this.valuePanel.getBackground());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Property property = (Property)propertyChangeEvent.getSource();
        JTextField jTextField = (JTextField)this.fieldMap.get(property);
        if (jTextField == null) {
            return;
        }
        jTextField.setText(propertyChangeEvent.getNewValue().toString());
    }
}

