/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ThreeStateSwitch;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ThreeStateSwitchCommandViewer
extends ThreeStateSwitch
implements ActionListener,
INumberScalarListener {
    ICommand onCmd = null;
    ICommand offCmd = null;
    INumberScalar stateAtt = null;

    public ThreeStateSwitchCommandViewer() {
        this.addActionListener(this);
    }

    public ThreeStateSwitchCommandViewer(String string, Font font) {
        super(string, font);
        this.addActionListener(this);
    }

    public void setModel(INumberScalar iNumberScalar, ICommand iCommand, ICommand iCommand2) {
        if (this.stateAtt != null) {
            this.stateAtt.removeNumberScalarListener((INumberScalarListener)this);
            this.onCmd.removeErrorListener((IErrorListener)this);
            this.offCmd.removeErrorListener((IErrorListener)this);
            this.stateAtt = null;
        }
        if (iNumberScalar != null) {
            this.stateAtt = iNumberScalar;
            this.onCmd = iCommand;
            this.offCmd = iCommand2;
            this.stateAtt.addNumberScalarListener((INumberScalarListener)this);
            this.onCmd.addErrorListener((IErrorListener)this);
            this.offCmd.addErrorListener((IErrorListener)this);
        }
    }

    public void clearModel() {
        this.setModel(null, null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        switch (this.getState()) {
            case 1: {
                this.onCmd.execute();
                break;
            }
            case 2: {
                this.offCmd.execute();
                break;
            }
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (errorEvent.getSource() == this.onCmd) {
            JOptionPane.showMessageDialog(this, "Failed to switch on:\n" + errorEvent.getError().getMessage());
        } else if (errorEvent.getSource() == this.offCmd) {
            JOptionPane.showMessageDialog(this, "Failed to switch off:\n" + errorEvent.getError().getMessage());
        } else if (errorEvent.getSource() == this.stateAtt) {
            this.setState(0);
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        if (numberScalarEvent.getSource() == this.stateAtt) {
            int n = (int)numberScalarEvent.getValue();
            switch (n) {
                case 1: {
                    this.setState(1);
                    break;
                }
                case 0: {
                    this.setState(2);
                    break;
                }
                default: {
                    this.setState(0);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        ThreeStateSwitchCommandViewer threeStateSwitchCommandViewer = new ThreeStateSwitchCommandViewer();
        threeStateSwitchCommandViewer.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(threeStateSwitchCommandViewer);
        jFrame.setContentPane(jPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

