/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.BooleanScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class SignalScalarCheckBoxViewer
extends JCheckBox
implements ActionListener,
IBooleanScalarListener,
INumberScalarListener,
ISetErrorListener,
JDrawable {
    protected IAttribute attModel = null;
    protected String trueLabel = null;
    protected String falseLabel = null;
    protected String fixedLabel = null;
    protected boolean hasToolTip = false;
    protected boolean qualityEnabled = false;
    protected Color background;
    protected String[] exts = new String[]{"text"};
    protected boolean enabled;

    public SignalScalarCheckBoxViewer() {
        this.addActionListener(this);
        this.background = this.getBackground();
        this.enabled = this.isEnabled();
    }

    public SignalScalarCheckBoxViewer(String string) {
        super(string);
        this.addActionListener(this);
        this.background = this.getBackground();
        this.enabled = this.isEnabled();
    }

    public IAttribute getAttModel() {
        return this.attModel;
    }

    public void setBooleanScalarModel(IBooleanScalar iBooleanScalar) {
        if (this.attModel != null) {
            this.clearModel();
        }
        if (iBooleanScalar != null) {
            this.attModel = iBooleanScalar;
            ((IBooleanScalar)this.attModel).addBooleanScalarListener((IBooleanScalarListener)this);
            if (this.attModel.isWritable()) {
                this.attModel.addSetErrorListener((ISetErrorListener)this);
            }
            if (this.trueLabel == null && this.falseLabel == null && this.fixedLabel == null) {
                this.setText(iBooleanScalar.getLabel());
            }
            if (this.hasToolTip) {
                this.setToolTipText(iBooleanScalar.getName());
            }
            this.setBoolValue(((IBooleanScalar)this.attModel).getDeviceValue());
        }
    }

    public void setNumberScalarModel(INumberScalar iNumberScalar) {
        if (this.attModel != null) {
            this.clearModel();
        }
        if (iNumberScalar != null) {
            this.attModel = iNumberScalar;
            ((INumberScalar)this.attModel).addNumberScalarListener((INumberScalarListener)this);
            if (this.attModel.isWritable()) {
                this.attModel.addSetErrorListener((ISetErrorListener)this);
            }
            if (this.trueLabel == null && this.falseLabel == null && this.fixedLabel == null) {
                this.setText(iNumberScalar.getLabel());
            }
            if (this.hasToolTip) {
                this.setToolTipText(iNumberScalar.getName());
            }
            this.setBoolValue(((INumberScalar)this.attModel).getNumberScalarDeviceValue());
        }
    }

    public void clearModel() {
        if (this.attModel != null) {
            if (this.attModel instanceof IBooleanScalar) {
                ((IBooleanScalar)this.attModel).removeBooleanScalarListener((IBooleanScalarListener)this);
            } else if (this.attModel instanceof INumberScalar) {
                ((INumberScalar)this.attModel).removeNumberScalarListener((INumberScalarListener)this);
            }
            if (this.attModel.isWritable()) {
                this.attModel.removeSetErrorListener((ISetErrorListener)this);
            }
            this.attModel = null;
            this.setText("");
        }
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String string) {
        this.trueLabel = string;
        if (this.trueLabel == null || this.falseLabel == null) {
            if (this.attModel != null) {
                this.setText(this.attModel.getLabel());
            } else {
                this.setText(null);
            }
        } else if (this.isSelected()) {
            this.setText(this.trueLabel);
        }
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String string) {
        this.falseLabel = string;
        if (this.trueLabel == null || this.falseLabel == null) {
            if (this.attModel != null) {
                this.setText(this.attModel.getLabel());
            } else {
                this.setText(null);
            }
        } else if (!this.isSelected()) {
            this.setText(this.falseLabel);
        }
    }

    public boolean getHasToolTip() {
        return this.hasToolTip;
    }

    public void setHasToolTip(boolean bl) {
        if (this.hasToolTip != bl) {
            if (!bl) {
                this.setToolTipText(null);
            } else if (this.attModel != null) {
                this.setToolTipText(this.attModel.getName());
            }
            this.hasToolTip = bl;
        }
    }

    public boolean getQualityEnabled() {
        return this.qualityEnabled;
    }

    public void setQualityEnabled(boolean bl) {
        this.qualityEnabled = bl;
        if (!this.qualityEnabled) {
            super.setBackground(this.background);
            this.repaint();
        }
    }

    public void initForEditing() {
        this.setText("CheckBox");
    }

    public JComponent getComponent() {
        return this;
    }

    public String getDescription(String string) {
        if (string.equalsIgnoreCase("text")) {
            return "Overrides text given by the model.";
        }
        return "";
    }

    public String[] getExtensionList() {
        return this.exts;
    }

    public boolean setExtendedParam(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("text")) {
            this.fixedLabel = string2;
            if (this.fixedLabel.length() == 0) {
                this.fixedLabel = null;
                this.setText("CheckBox");
            } else {
                this.setText(this.fixedLabel);
            }
            return true;
        }
        return false;
    }

    public String getExtendedParam(String string) {
        if (string.equalsIgnoreCase("text") && this.fixedLabel != null) {
            return this.fixedLabel;
        }
        return "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.attModel == null) {
            return;
        }
        if (!this.attModel.isWritable()) {
            this.setSelected(!this.isSelected());
            return;
        }
        if (this.attModel instanceof IBooleanScalar) {
            if (this.isSelected()) {
                ((IBooleanScalar)this.attModel).setValue(true);
            } else {
                ((IBooleanScalar)this.attModel).setValue(false);
            }
        } else if (this.attModel instanceof INumberScalar) {
            if (this.isSelected()) {
                ((INumberScalar)this.attModel).setValue(1.0);
            } else {
                ((INumberScalar)this.attModel).setValue(0.0);
            }
        }
    }

    public void booleanScalarChange(BooleanScalarEvent booleanScalarEvent) {
        this.setBoolValue(booleanScalarEvent.getValue());
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        this.setBoolValue(numberScalarEvent.getValue());
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        String string = attributeStateEvent.getState();
        if (!this.qualityEnabled) {
            return;
        }
        super.setBackground(ATKConstant.getColor4Quality(string));
        this.repaint();
    }

    public void errorChange(ErrorEvent errorEvent) {
        super.setEnabled(false);
    }

    protected void setBoolValue(boolean bl) {
        if (this.enabled && !this.isEnabled()) {
            super.setEnabled(this.enabled);
        }
        this.setSelected(bl);
        if (this.trueLabel != null || this.falseLabel != null) {
            if (bl) {
                this.setText(this.trueLabel);
            } else {
                this.setText(this.falseLabel);
            }
        }
    }

    protected void setBoolValue(double d) {
        this.setBoolValue(d != 0.0);
    }

    public void setErrorOccured(ErrorEvent errorEvent) {
        if (this.attModel == null) {
            return;
        }
        if (errorEvent.getSource() != this.attModel) {
            return;
        }
        if (this.attModel instanceof IBooleanScalar) {
            this.setBoolValue(((IBooleanScalar)this.attModel).getDeviceValue());
        } else if (this.attModel instanceof INumberScalar) {
            this.setBoolValue(((INumberScalar)this.attModel).getNumberScalarDeviceValue());
        }
    }

    public void setBackground(Color color) {
        this.background = color;
        super.setBackground(color);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        super.setEnabled(bl);
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        JFrame jFrame = new JFrame();
        SignalScalarCheckBoxViewer signalScalarCheckBoxViewer = new SignalScalarCheckBoxViewer();
        String string = "tango/tangotest/1/boolean_scalar";
        try {
            IEntity iEntity;
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            if (!((iEntity = attributeList.add(string)) instanceof IBooleanScalar) && !(iEntity instanceof INumberScalar)) {
                System.out.println(string + " is not a valid attribute");
                System.exit(0);
            }
            if (iEntity instanceof IBooleanScalar) {
                signalScalarCheckBoxViewer.setBooleanScalarModel((IBooleanScalar)iEntity);
            } else {
                signalScalarCheckBoxViewer.setNumberScalarModel((INumberScalar)iEntity);
            }
        }
        catch (Exception exception) {
            System.out.println("Cannot connect to " + string);
        }
        jFrame.setContentPane(signalScalarCheckBoxViewer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

