/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import com.braju.format.Format;
import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IAttributeStateListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.chart.AdvancedJLChart;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.EtchedBorder;

public class NumberSpectrumViewer
extends AdvancedJLChart
implements ISpectrumListener,
IJLChartActionListener,
IJLChartListener,
JDrawable {
    protected INumberSpectrum model = null;
    protected JLDataView dvy;
    protected SimplePropertyFrame pf = null;
    protected double A0 = 0.0;
    protected double A1 = 1.0;
    protected String xAxisUnit = "";
    protected String format;
    protected boolean unitVisible = false;
    protected boolean qualityVisible = false;
    protected static final String DISPLAY_UNIT_STRING = "Display/Hide Unit";
    protected static final String DISPLAY_QUALITY_STRING = "Display/Hide Attribute Quality";
    static String[] exts = new String[]{"graphSettings"};

    public NumberSpectrumViewer() {
        this.setBorder(new EtchedBorder());
        this.setBackground(new Color(180, 180, 180));
        this.getY1Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.dvy = new JLDataView();
        this.getY1Axis().addDataView(this.dvy);
        this.addUserAction("Attribute properties");
        this.addUserAction(DISPLAY_UNIT_STRING);
        this.addUserAction(DISPLAY_QUALITY_STRING);
        this.addJLChartActionListener(this);
        this.setJLChartListener(this);
    }

    public String getXAxisUnit() {
        return this.xAxisUnit;
    }

    public void setXAxisUnit(String string) {
        this.xAxisUnit = string;
    }

    public void setXAxisAffineTransform(double d, double d2) {
        this.A0 = d;
        this.A1 = d2;
    }

    public void initForEditing() {
        this.dvy.add(0.0, 0.0);
        this.dvy.add(2.0, 1.0);
        this.dvy.add(4.0, 1.2);
        this.dvy.add(6.0, 3.0);
        this.dvy.add(8.0, 0.2);
        this.dvy.add(10.0, 1.5);
        this.setPreferredSize(new Dimension(400, 300));
    }

    public JComponent getComponent() {
        return this;
    }

    public String getDescription(String string) {
        if (string.equalsIgnoreCase("graphSettings")) {
            return this.getHelpString();
        }
        return "";
    }

    public String[] getExtensionList() {
        return exts;
    }

    public boolean setExtendedParam(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("graphSettings")) {
            String string3;
            if (!string2.endsWith("\n")) {
                string2 = string2 + "\n";
            }
            if ((string3 = this.setSettings(string2)).length() > 0) {
                this.showJdrawError(bl, "graphSettings", string3);
            }
            return true;
        }
        return false;
    }

    public String getExtendedParam(String string) {
        if (string.equalsIgnoreCase("graphSettings")) {
            return this.getSettings();
        }
        return "";
    }

    private void showJdrawError(boolean bl, String string, String string2) {
        if (bl) {
            JOptionPane.showMessageDialog(null, "NumberSpectrumViewer: " + string + " incorrect.\n" + string2, "Error", 0);
        }
    }

    public void actionPerformed(JLChartActionEvent jLChartActionEvent) {
        if (jLChartActionEvent.getName().equals("Attribute properties")) {
            if (this.pf == null) {
                this.pf = new SimplePropertyFrame();
                this.pf.setModel((IAttribute)this.model);
            }
            this.pf.setVisible(true);
        } else if (DISPLAY_UNIT_STRING.equals(jLChartActionEvent.getName())) {
            this.setUnitVisible(!this.isUnitVisible());
        } else if (DISPLAY_QUALITY_STRING.equals(jLChartActionEvent.getName())) {
            this.setQualityVisible(!this.isQualityVisible());
        }
    }

    public boolean getActionState(JLChartActionEvent jLChartActionEvent) {
        return this.model != null;
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (this.isQualityVisible()) {
            this.setToolTipText(this.model.getName() + ": " + "UNKNOWN");
            this.dvy.setLabelColor(ATKConstant.getColor4Quality("UNKNOWN"));
        }
        this.dvy.reset();
        this.repaint();
        this.refreshTableSingle(this.dvy);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        if (this.isQualityVisible()) {
            this.setToolTipText(this.model.getName() + ": " + attributeStateEvent.getState());
            this.dvy.setLabelColor(ATKConstant.getColor4Quality(attributeStateEvent.getState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        double[] dArray = numberSpectrumEvent.getValue();
        int n = dArray.length;
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            this.dvy.reset();
            for (int i = 0; i < n; ++i) {
                this.dvy.add(this.A0 + this.A1 * (double)i, dArray[i], false);
            }
            this.dvy.updateFilters();
            this.repaint();
            this.refreshTableSingle(this.dvy);
        }
    }

    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        String[] stringArray;
        if (this.model != null) {
            String string;
            if (this.format == null) {
                string = Double.toString(jLChartEvent.getTransformedYValue());
            } else if (this.format.indexOf(37) == -1) {
                string = AttrManip.format((String)this.format, (double)jLChartEvent.getTransformedYValue());
            } else {
                Object[] objectArray = new Object[]{new Double(jLChartEvent.getTransformedYValue())};
                string = Format.sprintf((String)this.format, (Object[])objectArray);
            }
            stringArray = new String[]{this.model.getName(), this.xAxisUnit.length() > 0 ? "X=" + jLChartEvent.getTransformedXValue() + " " + this.xAxisUnit : "X=" + jLChartEvent.getTransformedXValue(), "Y=" + string + " " + this.model.getUnit()};
        } else {
            stringArray = new String[]{this.xAxisUnit.length() > 0 ? "X=" + jLChartEvent.getTransformedXValue() + " " + this.xAxisUnit : "X=" + jLChartEvent.getTransformedXValue(), "Y=" + jLChartEvent.getTransformedYValue()};
        }
        return stringArray;
    }

    public void setModel(INumberSpectrum iNumberSpectrum) {
        if (this.model != null) {
            this.model.removeSpectrumListener((ISpectrumListener)this);
            this.model.removeStateListener((IAttributeStateListener)this);
            if (this.pf != null) {
                this.pf.setModel(null);
            }
        }
        this.model = iNumberSpectrum;
        if (iNumberSpectrum != null) {
            this.format = this.model.getFormat();
            this.dvy.setUserFormat(this.format);
            this.dvy.setUnit(iNumberSpectrum.getUnit());
            this.dvy.setName(iNumberSpectrum.getName());
            if (this.isQualityVisible()) {
                this.setToolTipText(this.model.getName() + ": " + this.model.getState());
                this.dvy.setLabelColor(ATKConstant.getColor4Quality(this.model.getState()));
            }
            this.model.addSpectrumListener((ISpectrumListener)this);
            this.model.addStateListener((IAttributeStateListener)this);
            if (this.pf != null) {
                this.pf.setModel((IAttribute)this.model);
            }
            if (this.unitVisible) {
                this.getY1Axis().setName(iNumberSpectrum.getUnit());
            } else {
                this.getY1Axis().setName("");
            }
        } else {
            this.setToolTipText(null);
            this.dvy.setLabelColor(Color.BLACK);
        }
        this.repaint();
    }

    public String setSettings(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.parseText(string)) {
            return "NumberSpectrumViewer.setSettings: Failed to parse given config";
        }
        this.applyConfiguration(cfFileReader);
        Vector<String> vector = cfFileReader.getParam("xaxis_transform");
        if (vector != null) {
            this.setXAxisAffineTransform(OFormat.getDouble(vector.get(0).toString()), OFormat.getDouble(vector.get(1).toString()));
        }
        if ((vector = cfFileReader.getParam("xaxis_unit")) != null) {
            this.xAxisUnit = vector.get(0).toString();
        }
        this.getXAxis().applyConfiguration("x", cfFileReader);
        this.getY1Axis().applyConfiguration("y1", cfFileReader);
        this.dvy.applyConfiguration("dvy", cfFileReader);
        return "";
    }

    public String getSettings() {
        String string = "";
        string = string + this.getConfiguration();
        string = string + "xaxis_transform:" + this.A0 + "," + this.A1 + "\n";
        string = string + "xaxis_unit:'" + this.xAxisUnit + "'\n";
        string = string + this.getXAxis().getConfiguration("x");
        string = string + this.getY1Axis().getConfiguration("y1");
        string = string + this.dvy.getConfiguration("dvy");
        return string;
    }

    public boolean isUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean bl) {
        this.unitVisible = bl;
        if (bl && this.model != null) {
            this.getY1Axis().setName(this.model.getUnit());
        } else {
            this.getY1Axis().setName("");
        }
        this.repaint();
    }

    public boolean isQualityVisible() {
        return this.qualityVisible;
    }

    public void setQualityVisible(boolean bl) {
        if (this.qualityVisible != bl) {
            this.qualityVisible = bl;
            if (bl) {
                if (this.model != null) {
                    this.setToolTipText(this.model.getName() + ": " + this.model.getState());
                    this.dvy.setLabelColor(ATKConstant.getColor4Quality(this.model.getState()));
                }
            } else {
                this.setToolTipText(null);
                this.dvy.setLabelColor(Color.BLACK);
            }
            this.repaint();
        }
    }

    public void removeDataView(JLDataView jLDataView) {
        if (jLDataView != this.dvy) {
            super.removeDataView(jLDataView);
        }
    }

    protected boolean prepareDataViewMenu(JLDataView jLDataView) {
        if (jLDataView == this.dvy) {
            return false;
        }
        boolean bl = super.prepareDataViewMenu(jLDataView);
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            NumberSpectrumViewer numberSpectrumViewer = new NumberSpectrumViewer();
            numberSpectrumViewer.setModel((INumberSpectrum)attributeList.add("jlp/test/1/att_spectrum"));
            numberSpectrumViewer.setBorder(BorderFactory.createLoweredBevelBorder());
            numberSpectrumViewer.setFont(new Font("Dialog", 0, 12));
            numberSpectrumViewer.setXAxisAffineTransform(0.0, 1000.0);
            numberSpectrumViewer.setXAxisUnit("mA");
            JFrame jFrame = new JFrame();
            attributeList.startRefresher();
            jFrame.setContentPane(numberSpectrumViewer);
            jFrame.setSize(640, 480);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

