/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.EtchedBorder;

public class DualSpectrumImageViewer
extends JLChart
implements IImageListener,
IJLChartActionListener,
IJLChartListener {
    INumberImage model;
    JLDataView dvy;
    SimplePropertyFrame pf = null;

    public DualSpectrumImageViewer() {
        this.setBorder(new EtchedBorder());
        this.setBackground(new Color(180, 180, 180));
        this.getY1Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.dvy = new JLDataView();
        this.getY1Axis().addDataView(this.dvy);
        this.addUserAction("Attribute properties");
        this.addJLChartActionListener(this);
        this.setJLChartListener(this);
    }

    public void actionPerformed(JLChartActionEvent jLChartActionEvent) {
        if (jLChartActionEvent.getName().equals("Attribute properties")) {
            if (this.pf == null) {
                this.pf = new SimplePropertyFrame();
                this.pf.setModel((IAttribute)this.model);
            }
            this.pf.setVisible(true);
        }
    }

    public boolean getActionState(JLChartActionEvent jLChartActionEvent) {
        return this.model != null;
    }

    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        String[] stringArray = new String[]{this.model.getName(), "X=" + jLChartEvent.getTransformedXValue(), "Y=" + jLChartEvent.getTransformedYValue() + " " + this.model.getUnit()};
        return stringArray;
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void imageChange(NumberImageEvent numberImageEvent) {
        double[][] dArray = numberImageEvent.getValue();
        if (dArray.length >= 2) {
            int n = dArray[0].length;
            this.dvy.reset();
            for (int i = 0; i < n; ++i) {
                this.dvy.add(dArray[0][i], dArray[1][i]);
            }
            this.repaint();
        }
    }

    public JLDataView getYView() {
        return this.dvy;
    }

    public void setModel(INumberImage iNumberImage) {
        if (this.model != null) {
            this.model.removeImageListener((IImageListener)this);
            if (this.pf != null) {
                this.pf.setModel(null);
            }
        }
        this.model = iNumberImage;
        if (this.model != null) {
            this.dvy.setUnit(iNumberImage.getUnit());
            this.dvy.setName(iNumberImage.getName());
            this.model.addImageListener((IImageListener)this);
            if (this.pf != null) {
                this.pf.setModel((IAttribute)this.model);
            }
        }
    }

    public String setSettings(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.parseText(string)) {
            return "DualSpectrumImageViewer.setSettings: Failed to parse given config";
        }
        this.applyConfiguration(cfFileReader);
        this.getXAxis().applyConfiguration("x", cfFileReader);
        this.getY1Axis().applyConfiguration("y1", cfFileReader);
        this.dvy.applyConfiguration("dvy", cfFileReader);
        return "";
    }

    public String getSettings() {
        String string = "";
        string = string + this.getConfiguration();
        string = string + this.getXAxis().getConfiguration("x");
        string = string + this.getY1Axis().getConfiguration("y1");
        string = string + this.dvy.getConfiguration("dvy");
        return string;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        DualSpectrumImageViewer dualSpectrumImageViewer = new DualSpectrumImageViewer();
        if (stringArray.length != 1) {
            JOptionPane.showMessageDialog(null, "Invalid parameters:\nUsage: DualSpectrumImageViewer full_att_name (where full_att_name is a 2 lines image attribue)", "Error", 0);
            System.exit(0);
        }
        try {
            AttributeList attributeList = new AttributeList();
            INumberImage iNumberImage = (INumberImage)attributeList.add(stringArray[0]);
            dualSpectrumImageViewer.setModel(iNumberImage);
            jFrame.getContentPane().setLayout(new GridLayout(1, 1));
            jFrame.getContentPane().add(dualSpectrumImageViewer);
            jFrame.setDefaultCloseOperation(3);
            jFrame.setTitle("DualSpectrumViewer:" + stringArray[0]);
            jFrame.setSize(640, 480);
            jFrame.setVisible(true);
            attributeList.setRefreshInterval(3000);
            attributeList.startRefresher();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

