/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.applet.Applet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.JacORBConfiguration;
import org.jacorb.imr.ImRAccessImpl;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.DataInputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ImRAccess;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.RTORB;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.dii.ExceptionList;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.dynany.DynAnyFactoryImpl;
import org.jacorb.orb.etf.FactoriesBase;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.policies.ClientProtocolPolicy;
import org.jacorb.orb.policies.MaxHopsPolicy;
import org.jacorb.orb.policies.PolicyManager;
import org.jacorb.orb.policies.QueueOrderPolicy;
import org.jacorb.orb.policies.RebindPolicy;
import org.jacorb.orb.policies.RelativeRequestTimeoutPolicy;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.jacorb.orb.policies.ReplyEndTimePolicy;
import org.jacorb.orb.policies.ReplyPriorityPolicy;
import org.jacorb.orb.policies.ReplyStartTimePolicy;
import org.jacorb.orb.policies.RequestEndTimePolicy;
import org.jacorb.orb.policies.RequestPriorityPolicy;
import org.jacorb.orb.policies.RequestStartTimePolicy;
import org.jacorb.orb.policies.RoutingPolicy;
import org.jacorb.orb.policies.SyncScopePolicy;
import org.jacorb.orb.portableInterceptor.CodecFactoryImpl;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.Current;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.poa.RPPoolManagerFactory;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.MultipleComponentProfileHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.Servant;

public final class ORB
extends ORBSingleton
implements POAListener,
Configurable {
    private static final String versionString = "2.3.0";
    private static final String dateString = "17-Feb-2007";
    private static final String nullIORString = "IOR:00000000000000010000000000000000";
    private org.jacorb.config.Configuration configuration = null;
    private boolean cacheReferences;
    private String implName;
    private int giopMinorVersion;
    private boolean giopAdd_1_0_Profiles;
    private String hashTableClassName;
    private boolean useIMR;
    private ProtocolAddressBase imrProxyAddress = null;
    private ProtocolAddressBase iorProxyAddress;
    private final Map initial_references = new HashMap();
    private org.jacorb.poa.POA rootpoa;
    private Current poaCurrent;
    private BasicAdapter basicAdapter;
    private InterceptorManager interceptor_manager = null;
    private boolean hasClientInterceptors = false;
    private boolean hasServerInterceptors = false;
    private final org.omg.PortableInterceptor.Current piCurrent = new PICurrent();
    private Map knownReferences = null;
    private ClientConnectionManager clientConnectionManager;
    private TransportManager transport_manager = null;
    private GIOPConnectionManager giop_connection_manager = null;
    private BufferManager bufferManager;
    private final Map valueFactories = new HashMap();
    private final Map boxedValueHelpers = new HashMap();
    private final Map objectKeyMap = new HashMap();
    private Logger logger;
    public String[] _args;
    private final java.lang.Object runSync = new java.lang.Object();
    private boolean run = true;
    private boolean shutdown_in_progress = false;
    private boolean destroyed = false;
    private final java.lang.Object shutdown_synch = new java.lang.Object();
    private ImRAccess imr = null;
    private int persistentPOACount;
    public static final String orb_id = "jacorb:2.3.0";
    private final Set requests = Collections.synchronizedSet(new HashSet());
    private Request request = null;
    private RTORB rtORB;
    private PolicyManager policyManager;
    private final Map policy_factories = Collections.synchronizedMap(new HashMap());
    private static final String[] services = new String[]{"RootPOA", "POACurrent", "DynAnyFactory", "PICurrent", "CodecFactory", "RTORB"};
    private boolean bidir_giop = false;
    private final String serverIdStr = String.valueOf((long)(Math.random() * 9.999999999E9));
    private final byte[] serverId = this.serverIdStr.getBytes();
    private RPPoolManagerFactory poolManagerFactory;
    private boolean failOnORBInitializerError;
    private boolean firstConnection = true;
    private Map connectedObjects = new HashMap();

    public ORB() {
        super(false);
    }

    public void putObjectKeyMap(String string, String string2) {
        this.objectKeyMap.put(string, string2);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb");
        this.cacheReferences = this.configuration.getAttributeAsBoolean("jacorb.reference_caching", false);
        this.implName = this.configuration.getAttribute("jacorb.implname", "");
        this.giopMinorVersion = this.configuration.getAttributeAsInteger("jacorb.giop_minor_version", 2);
        this.giopAdd_1_0_Profiles = this.configuration.getAttributeAsBoolean("jacorb.giop.add_1_0_profiles", false);
        this.hashTableClassName = this.configuration.getAttribute("jacorb.hashtable_class", HashMap.class.getName());
        this.useIMR = this.configuration.getAttributeAsBoolean("jacorb.use_imr", false);
        String string = this.configuration.getAttribute("jacorb.imr.ior_proxy_host", null);
        int n = this.configuration.getAttributeAsInteger("jacorb.imr.ior_proxy_port", -1);
        String string2 = this.configuration.getAttribute("jacorb.imr.ior_proxy_address", null);
        this.imrProxyAddress = this.createAddress(string, n, string2);
        string = this.configuration.getAttribute("jacorb.ior_proxy_host", null);
        n = this.configuration.getAttributeAsInteger("jacorb.ior_proxy_port", -1);
        string2 = this.configuration.getAttribute("jacorb.ior_proxy_address", null);
        this.iorProxyAddress = this.createAddress(string, n, string2);
        this.failOnORBInitializerError = this.configuration.getAttributeAsBoolean("jacorb.orb_initializer.fail_on_error", false);
        this.printVersion(this.configuration);
        BufferManager.configure(this.configuration);
        try {
            this.bufferManager = BufferManager.getInstance();
        }
        catch (BAD_INV_ORDER bAD_INV_ORDER) {
            this.logger.fatalError("unexpected exception", bAD_INV_ORDER);
            throw new INTERNAL(bAD_INV_ORDER.toString());
        }
        this.configureObjectKeyMap(this.configuration);
        if (this.poolManagerFactory != null) {
            // empty if block
        }
        this.poolManagerFactory = new RPPoolManagerFactory(this);
    }

    private ProtocolAddressBase createAddress(String string, int n, String string2) {
        ProtocolAddressBase protocolAddressBase;
        try {
            if (string2 == null) {
                if (string != null || n != -1) {
                    protocolAddressBase = new IIOPAddress();
                    protocolAddressBase.configure(this.configuration);
                    if (string != null) {
                        ((IIOPAddress)protocolAddressBase).setHostname(string);
                    }
                    if (n != -1) {
                        ((IIOPAddress)protocolAddressBase).setPort(n);
                    }
                } else {
                    protocolAddressBase = null;
                }
            } else {
                protocolAddressBase = this.createAddress(string2);
            }
        }
        catch (Exception exception) {
            this.logger.error("error initializing ProxyAddress", exception);
            throw new INITIALIZE(exception.toString());
        }
        return protocolAddressBase;
    }

    private void printVersion(org.jacorb.config.Configuration configuration) {
        boolean bl = configuration.getAttributeAsBoolean("jacorb.orb.print_version", true);
        if (!bl) {
            return;
        }
        Logger logger = configuration.getNamedLogger("jacorb.orb.print_version");
        logger.info("\n\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\tJacORB V 2.3.0, www.jacorb.org\n\t(C) The JacORB project 17-Feb-2007\n\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    public org.jacorb.config.Configuration getConfiguration() {
        return this.configuration;
    }

    public String id() {
        return orb_id;
    }

    public boolean useBiDirGIOP() {
        return this.bidir_giop;
    }

    public void turnOnBiDirGIOP() {
        if (!this.bidir_giop) {
            this.bidir_giop = true;
            this.clientConnectionManager.setRequestListener(this.basicAdapter.getRequestListener());
        }
    }

    public ProtocolAddressBase createAddress(String string) {
        List list = this.getTransportManager().getFactoriesList();
        ProtocolAddressBase protocolAddressBase = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && protocolAddressBase == null) {
            FactoriesBase factoriesBase = (FactoriesBase)iterator.next();
            protocolAddressBase = factoriesBase.create_protocol_address(string);
        }
        return protocolAddressBase;
    }

    public synchronized Object _getObject(ParsedIOR parsedIOR) {
        Delegate delegate;
        String string = parsedIOR.getIORString();
        ObjectImpl objectImpl = (ObjectImpl)this.knownReferences.get(string);
        if (objectImpl != null) {
            delegate = (Delegate)objectImpl._get_delegate();
            if (delegate != null) {
                ParsedIOR parsedIOR2 = delegate.getParsedIOR();
                if (parsedIOR2 == null) {
                    this.knownReferences.remove(string);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Removing an invalid reference from cache.");
                    }
                } else if (parsedIOR.getEffectiveProfile().is_match(parsedIOR2.getEffectiveProfile())) {
                    return objectImpl._duplicate();
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Remove stale reference from cache ");
                }
                this.knownReferences.remove(string);
            }
        }
        delegate = new Delegate(this, parsedIOR);
        try {
            delegate.configure(this.configuration);
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("ConfigurationException", configurationException);
        }
        objectImpl = delegate.getReference(null);
        if (this.cacheReferences) {
            this.knownReferences.put(string, objectImpl);
        }
        return objectImpl;
    }

    org.jacorb.poa.POA findPOA(Delegate delegate, Object object) {
        String string = null;
        if (this.rootpoa == null || this.basicAdapter == null) {
            return null;
        }
        try {
            string = POAUtil.extractImplName(delegate.getObjectKey());
        }
        catch (POAInternalError pOAInternalError) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: reference generated by foreign POA");
            }
            return null;
        }
        if (string == null) {
            if (this.implName.length() > 0 || this.serverIdStr.length() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: impl_name mismatch - null != " + this.implName);
                }
                return null;
            }
        } else if (!this.implName.equals(string) && !this.serverIdStr.equals(string)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: impl_name mismatch - " + string + " != " + this.implName);
            }
            return null;
        }
        try {
            String string2;
            org.jacorb.poa.POA pOA = this.rootpoa;
            String string3 = POAUtil.extractPOAName(delegate.getObjectKey());
            List list = POAUtil.extractScopedPOANames(string3);
            for (int i = 0; i < list.size() && !"".equals(string2 = (String)list.get(i)); ++i) {
                try {
                    pOA = pOA._getChildPOA(string2);
                    continue;
                }
                catch (ParentIsHolding parentIsHolding) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("findPOA: holding adapter");
                    }
                    return null;
                }
            }
            byte[] byArray = POAUtil.extractOID(object);
            if (pOA.isSystemId() && !pOA.previouslyGeneratedObjectId(byArray)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: not a previously generated object key.");
                }
                return null;
            }
            return pOA;
        }
        catch (Exception exception) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(exception.getMessage());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: nothing found");
            }
            return null;
        }
    }

    public ClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public synchronized GIOPConnectionManager getGIOPConnectionManager() {
        if (this.giop_connection_manager == null) {
            this.giop_connection_manager = new GIOPConnectionManager();
            try {
                this.giop_connection_manager.configure(this.configuration);
            }
            catch (ConfigurationException configurationException) {
                throw new INTERNAL(configurationException.toString());
            }
        }
        return this.giop_connection_manager;
    }

    synchronized void _release(String string) {
        this.knownReferences.remove(string);
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        switch (n) {
            case 34: {
                return new MaxHopsPolicy(any);
            }
            case 35: {
                return new QueueOrderPolicy(any);
            }
            case 23: {
                return new RebindPolicy(any);
            }
            case 31: {
                return new RelativeRequestTimeoutPolicy(any);
            }
            case 32: {
                return new RelativeRoundtripTimeoutPolicy(any);
            }
            case 30: {
                return new ReplyEndTimePolicy(any);
            }
            case 26: {
                return new ReplyPriorityPolicy(any);
            }
            case 29: {
                return new ReplyStartTimePolicy(any);
            }
            case 28: {
                return new RequestEndTimePolicy(any);
            }
            case 25: {
                return new RequestPriorityPolicy(any);
            }
            case 27: {
                return new RequestStartTimePolicy(any);
            }
            case 33: {
                return new RoutingPolicy(any);
            }
            case 24: {
                return new SyncScopePolicy(any);
            }
            case 43: {
                return new ClientProtocolPolicy(any);
            }
        }
        PolicyFactory policyFactory = (PolicyFactory)this.policy_factories.get(ObjectUtil.newInteger(n));
        if (policyFactory == null) {
            throw new PolicyError();
        }
        return policyFactory.create_policy(n, any);
    }

    public boolean hasPolicyFactoryForType(int n) {
        return this.policy_factories.containsKey(ObjectUtil.newInteger(n));
    }

    public ContextList create_context_list() {
        throw new NO_IMPLEMENT();
    }

    public Environment create_environment() {
        throw new NO_IMPLEMENT();
    }

    public OutputStream create_output_stream() {
        return new CDROutputStream(this);
    }

    IOR createIOR(String string, byte[] byArray, boolean bl, org.jacorb.poa.POA pOA, Map map) {
        java.lang.Object object;
        TaggedComponentList taggedComponentList;
        TaggedProfile[] taggedProfileArray;
        IDLEntity iDLEntity2;
        HashMap<Integer, java.lang.Object> hashMap;
        ArrayList<java.lang.Object> arrayList;
        block9: {
            arrayList = new ArrayList<java.lang.Object>();
            hashMap = new HashMap<Integer, java.lang.Object>();
            int[] nArray = new int[this.basicAdapter.getEndpointProfiles().size()];
            int n = 0;
            for (IDLEntity iDLEntity2 : this.basicAdapter.getEndpointProfiles()) {
                iDLEntity2.set_object_key(byArray);
                arrayList.add(iDLEntity2);
                nArray[n++] = iDLEntity2.tag();
                taggedProfileArray = new TaggedComponentList();
                taggedProfileArray.addComponent(this.create_ORB_TYPE_ID());
                hashMap.put(ObjectUtil.newInteger(iDLEntity2.tag()), taggedProfileArray);
                if (!(iDLEntity2 instanceof ProfileBase)) continue;
                this.patchAddress((ProfileBase)iDLEntity2, string, bl);
                if (!pOA.isSSLRequired()) continue;
                ((ProfileBase)iDLEntity2).patchPrimaryAddress(null);
            }
            taggedComponentList = new TaggedComponentList();
            hashMap.put(ObjectUtil.newInteger(1), taggedComponentList);
            if (this.interceptor_manager != null && this.interceptor_manager.hasIORInterceptors()) {
                iDLEntity2 = new IORInfoImpl(this, pOA, hashMap, map, arrayList);
                this.interceptor_manager.setProfileTags(nArray);
                try {
                    this.interceptor_manager.getIORIterator().iterate((IORInfoImpl)iDLEntity2);
                }
                catch (Exception exception) {
                    if (!this.logger.isErrorEnabled()) break block9;
                    this.logger.error(exception.getMessage());
                }
            }
        }
        if ((iDLEntity2 = this.findIIOPProfile(arrayList)) != null && (this.giopMinorVersion == 0 || this.giopAdd_1_0_Profiles)) {
            taggedProfileArray = ((IIOPProfile)iDLEntity2).to_GIOP_1_0();
            arrayList.add(taggedProfileArray);
            object = (TaggedComponentList)hashMap.get(ObjectUtil.newInteger(0));
            taggedComponentList.addAll(((ProfileBase)iDLEntity2).getComponents());
            taggedComponentList.addAll((TaggedComponentList)object);
            if (this.giopMinorVersion == 0) {
                arrayList.remove(iDLEntity2);
            }
        }
        taggedProfileArray = null;
        if (taggedComponentList.isEmpty()) {
            taggedProfileArray = new TaggedProfile[arrayList.size()];
        } else {
            taggedProfileArray = new TaggedProfile[arrayList.size() + 1];
            taggedProfileArray[taggedProfileArray.length - 1] = this.createMultipleComponentsProfile(taggedComponentList);
        }
        object = new TaggedProfileHolder();
        TaggedComponentSeqHolder taggedComponentSeqHolder = new TaggedComponentSeqHolder();
        for (int i = 0; i < arrayList.size(); ++i) {
            Profile profile = (Profile)arrayList.get(i);
            TaggedComponentList taggedComponentList2 = (TaggedComponentList)hashMap.get(ObjectUtil.newInteger(profile.tag()));
            taggedComponentSeqHolder.value = taggedComponentList2.asArray();
            profile.marshal((TaggedProfileHolder)object, taggedComponentSeqHolder);
            taggedProfileArray[i] = ((TaggedProfileHolder)object).value;
        }
        return new IOR(string, taggedProfileArray);
    }

    private TaggedProfile createMultipleComponentsProfile(TaggedComponentList taggedComponentList) {
        CDROutputStream cDROutputStream = new CDROutputStream(this);
        cDROutputStream.beginEncapsulatedArray();
        MultipleComponentProfileHelper.write(cDROutputStream, taggedComponentList.asArray());
        return new TaggedProfile(1, cDROutputStream.getBufferCopy());
    }

    private IIOPProfile findIIOPProfile(List list) {
        for (Profile profile : list) {
            if (!(profile instanceof IIOPProfile)) continue;
            return (IIOPProfile)profile;
        }
        return null;
    }

    public Context get_default_context() {
        throw new NO_IMPLEMENT();
    }

    public BasicAdapter getBasicAdapter() {
        if (this.basicAdapter == null) {
            throw new INITIALIZE("Adapters not initialized; resolve RootPOA.");
        }
        return this.basicAdapter;
    }

    public synchronized Current getPOACurrent() {
        if (this.poaCurrent == null) {
            this.poaCurrent = new Current();
        }
        return this.poaCurrent;
    }

    public Object getReference(org.jacorb.poa.POA pOA, byte[] byArray, String string, boolean bl) {
        IOR iOR = this.createIOR(string == null ? "IDL:omg.org/CORBA/Object:1.0" : string, byArray, bl, pOA, null);
        if (iOR == null && this.logger.isErrorEnabled()) {
            this.logger.error("Interal error: createIOR returns null");
        }
        Delegate delegate = new Delegate(this, iOR);
        try {
            delegate.configure(this.configuration);
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("configuration exception", configurationException);
        }
        return delegate.getReference(pOA);
    }

    public synchronized org.jacorb.poa.POA getRootPOA() throws INITIALIZE {
        if (this.rootpoa == null) {
            this.rootpoa = org.jacorb.poa.POA._POA_init(this);
            this.basicAdapter = new BasicAdapter(this, this.rootpoa, this.getTransportManager(), this.getGIOPConnectionManager());
            try {
                this.rootpoa.configure(this.configuration);
                this.basicAdapter.configure(this.configuration);
            }
            catch (ConfigurationException configurationException) {
                throw new INITIALIZE("ConfigurationException: " + configurationException.toString());
            }
            this.rootpoa._addPOAEventListener(this);
        }
        return this.rootpoa;
    }

    public String[] list_initial_services() {
        ArrayList<String> arrayList = new ArrayList<String>(this.initial_references.size() + services.length);
        arrayList.addAll(Arrays.asList(services));
        Iterator iterator = this.initial_references.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add((String)iterator.next());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void poaCreated(org.jacorb.poa.POA pOA) {
        pOA._addPOAEventListener(this);
        if (pOA.isPersistent()) {
            ++this.persistentPOACount;
            this.getImR();
            if (this.imr != null) {
                String string = this.implName;
                ProtocolAddressBase protocolAddressBase = this.getServerAddress();
                if (protocolAddressBase instanceof IIOPAddress) {
                    String string2 = ((IIOPAddress)protocolAddressBase).getHostname();
                    int n = ((IIOPAddress)protocolAddressBase).getPort();
                    this.imr.registerPOA(string + "/" + pOA._getQualifiedName(), string, string2, n);
                }
            }
        }
    }

    private synchronized void getImR() {
        if (this.imr == null && this.useIMR) {
            try {
                this.imr = ImRAccessImpl.connect(this);
            }
            catch (Exception exception) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Error: No connection to ImplementationRepository");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(exception.getMessage());
                }
                if (exception instanceof INTERNAL) {
                    throw new OBJ_ADAPTER("Unable to resolve ImR");
                }
                if (exception instanceof TRANSIENT) {
                    throw (TRANSIENT)exception;
                }
                throw new OBJ_ADAPTER(exception.toString());
            }
        }
    }

    private void patchAddress(ProfileBase profileBase, String string, boolean bl) {
        if ("IDL:org/jacorb/imr/ImplementationRepository:1.0".equals(string)) {
            profileBase.patchPrimaryAddress(this.imrProxyAddress);
        } else if (!bl && this.useIMR) {
            this.getImR();
            profileBase.patchPrimaryAddress(this.imr.getImRAddress());
            profileBase.patchPrimaryAddress(this.imrProxyAddress);
        } else {
            profileBase.patchPrimaryAddress(this.iorProxyAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaggedComponent create_ORB_TYPE_ID() {
        CDROutputStream cDROutputStream = new CDROutputStream(this);
        try {
            cDROutputStream.beginEncapsulatedArray();
            cDROutputStream.write_long(1245790976);
            TaggedComponent taggedComponent = new TaggedComponent(0, cDROutputStream.getBufferCopy());
            return taggedComponent;
        }
        finally {
            cDROutputStream.close();
        }
    }

    private synchronized ProtocolAddressBase getServerAddress() {
        ProtocolAddressBase protocolAddressBase = this.iorProxyAddress;
        if (protocolAddressBase == null) {
            List list = this.getBasicAdapter().getEndpointProfiles();
            for (Profile profile : list) {
                if (!(profile instanceof IIOPProfile)) continue;
                protocolAddressBase = ((IIOPProfile)profile).getAddress();
                break;
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Using proxy address " + protocolAddressBase.toString() + " in IOR");
        }
        return protocolAddressBase;
    }

    public void poaStateChanged(org.jacorb.poa.POA pOA, int n) {
        if ((n == 4 || n == 3) && pOA.isPersistent() && this.imr != null && --this.persistentPOACount == 0) {
            this.imr.setServerDown(this.implName);
        }
    }

    public void referenceCreated(Object object) {
    }

    public boolean get_service_information(short s, ServiceInformationHolder serviceInformationHolder) {
        throw new NO_IMPLEMENT();
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        if (this.initial_references.containsKey(string)) {
            return (Object)this.initial_references.get(string);
        }
        Object object = null;
        String string2 = null;
        try {
            string2 = this.configuration.getAttribute("ORBInitRef." + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                object = this.string_to_object(string2);
            }
            catch (Exception exception) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not create initial reference for \"" + string + "\"\n" + "Please check property \"ORBInitRef." + string + '\"');
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(exception.getMessage());
                }
                throw new InvalidName();
            }
        } else {
            if ("RootPOA".equals(string)) {
                return this.getRootPOA();
            }
            if ("POACurrent".equals(string)) {
                return this.getPOACurrent();
            }
            if ("SecurityCurrent".equals(string)) {
                throw new InvalidName("Level2 SecurityImplementation has been removed");
            }
            if ("DynAnyFactory".equals(string)) {
                object = new DynAnyFactoryImpl(this);
            } else {
                if ("PICurrent".equals(string)) {
                    return this.piCurrent;
                }
                if ("ORBPolicyManager".equals(string)) {
                    if (this.policyManager == null) {
                        this.policyManager = new PolicyManager(this.getConfiguration());
                    }
                    return this.policyManager;
                }
                if ("CodecFactory".equals(string)) {
                    object = new CodecFactoryImpl(this);
                } else if ("RTORB".equals(string)) {
                    object = this.getRTORB();
                } else {
                    throw new InvalidName();
                }
            }
        }
        if (object != null) {
            this.initial_references.put(string, object);
        }
        return object;
    }

    PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    private synchronized RTORB getRTORB() {
        if (this.rtORB == null) {
            this.rtORB = new RTORB(this);
        }
        return this.rtORB;
    }

    public void register_initial_reference(String string, Object object) throws InvalidName {
        if (string == null || string.length() == 0 || this.initial_references.containsKey(string)) {
            throw new InvalidName();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering initial ref " + string);
        }
        this.initial_references.put(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run");
        }
        java.lang.Object object = this.runSync;
        synchronized (object) {
            try {
                while (this.run) {
                    this.runSync.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run, exit");
        }
    }

    public void send_multiple_requests_oneway(org.omg.CORBA.Request[] requestArray) {
        for (int i = 0; i < requestArray.length; ++i) {
            requestArray[i].send_oneway();
        }
    }

    public void send_multiple_requests_deferred(org.omg.CORBA.Request[] requestArray) {
        for (int i = 0; i < requestArray.length; ++i) {
            requestArray[i].send_deferred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean poll_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            for (Request request : this.requests) {
                if (!request.poll_response()) continue;
                this.request = request;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.CORBA.Request get_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Request request = null;
            if (this.request != null) {
                this.request.get_response();
                request = this.request;
                this.request = null;
                return request;
            }
            block3: while (true) {
                Iterator iterator = this.requests.iterator();
                do {
                    if (!iterator.hasNext()) continue block3;
                } while (!(request = (Request)iterator.next()).poll_response());
                break;
            }
            request.get_response();
            return request;
        }
    }

    public void addRequest(org.omg.CORBA.Request request) {
        this.requests.add(request);
    }

    public void removeRequest(org.omg.CORBA.Request request) {
        this.requests.remove(request);
    }

    protected void set_parameters(String[] stringArray, Properties properties) {
        try {
            this.configure(JacORBConfiguration.getConfiguration(properties, this, false));
        }
        catch (ConfigurationException configurationException) {
            if (this.logger != null && this.logger.isErrorEnabled()) {
                this.logger.error("error during configuration", configurationException);
            } else {
                configurationException.printStackTrace();
            }
            throw new INITIALIZE(configurationException.getMessage());
        }
        if (stringArray != null) {
            this._args = stringArray;
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string;
                String string2 = stringArray[i].trim();
                if (string2.startsWith("-ORBInitRef.")) {
                    string = string2.substring(1);
                    n = string.indexOf(61);
                    if (n == -1) {
                        throw new BAD_PARAM("InitRef format invalid for " + string);
                    }
                    ((DefaultConfiguration)((java.lang.Object)this.configuration)).setAttribute(string.substring(0, n), string.substring(n + 1));
                    continue;
                }
                if (!"-ORBInitRef".equals(string2)) continue;
                if (stringArray.length - 1 < i + 1) {
                    this.logger.error("WARNING: -ORBInitRef argument without value");
                    throw new BAD_PARAM("-ORBInitRef argument without value");
                }
                if ((n = (string = stringArray[++i].trim()).indexOf(61)) == -1) {
                    throw new BAD_PARAM("InitRef format invalid for " + string);
                }
                ((DefaultConfiguration)((java.lang.Object)this.configuration)).setAttribute("ORBInitRef." + string.substring(0, n), string.substring(n + 1));
            }
        }
        this.internalInit();
    }

    protected void set_parameters(Applet applet, Properties properties) {
        try {
            this.configure(JacORBConfiguration.getConfiguration(properties, this, true));
        }
        catch (ConfigurationException configurationException) {
            this.logger.fatalError("configuration exception during configure", configurationException);
            throw new INITIALIZE(configurationException.toString());
        }
        this.internalInit();
    }

    private void internalInit() {
        List list = this.getORBInitializers();
        ORBInitInfoImpl oRBInitInfoImpl = new ORBInitInfoImpl(this);
        this.interceptorPreInit(list, oRBInitInfoImpl);
        this.initClientConnectionManager();
        this.initKnownReferencesMap();
        this.interceptorPostInit(list, oRBInitInfoImpl);
        this.internalInit(oRBInitInfoImpl);
    }

    private void initClientConnectionManager() {
        try {
            this.clientConnectionManager = new ClientConnectionManager(this, this.getTransportManager(), this.getGIOPConnectionManager());
            this.clientConnectionManager.configure(this.configuration);
        }
        catch (ConfigurationException configurationException) {
            this.logger.fatalError("unexpected exception", configurationException);
            throw new INTERNAL(configurationException.toString());
        }
    }

    private void initKnownReferencesMap() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Property \"jacorb.hashtable_class\" is set to: " + this.hashTableClassName);
        }
        try {
            this.knownReferences = (Map)ObjectUtil.classForName(this.hashTableClassName).newInstance();
        }
        catch (Exception exception) {
            this.logger.fatalError("unable to create known references map", exception);
            throw new INTERNAL(exception.toString());
        }
    }

    private void internalInit(ORBInitInfoImpl oRBInitInfoImpl) {
        oRBInitInfoImpl.setInvalid();
        List list = oRBInitInfoImpl.getClientInterceptors();
        List list2 = oRBInitInfoImpl.getServerInterceptors();
        List list3 = oRBInitInfoImpl.getIORInterceptors();
        this.hasClientInterceptors = !list.isEmpty();
        boolean bl = this.hasServerInterceptors = !list2.isEmpty();
        if (this.hasClientInterceptors || this.hasServerInterceptors || !list3.isEmpty()) {
            this.interceptor_manager = new InterceptorManager(list, list2, list3, oRBInitInfoImpl.getSlotCount(), this);
        }
        this.policy_factories.putAll(oRBInitInfoImpl.getPolicyFactories());
    }

    private void interceptorPreInit(List list, ORBInitInfo oRBInitInfo) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ORBInitializer oRBInitializer = (ORBInitializer)iterator.next();
            try {
                oRBInitializer.pre_init(oRBInitInfo);
            }
            catch (Exception exception) {
                if (this.failOnORBInitializerError) {
                    this.logger.error(oRBInitializer.getClass().getName() + ": aborting due to error during ORBInitializer::pre_init", exception);
                    throw new INITIALIZE(exception.toString());
                }
                this.logger.warn(oRBInitializer.getClass().getName() + ": ignoring error during ORBInitializer::pre_init. the ORBInitializer will be removed from the current configuration", exception);
                iterator.remove();
            }
        }
    }

    private void interceptorPostInit(List list, ORBInitInfo oRBInitInfo) {
        for (ORBInitializer oRBInitializer : list) {
            try {
                oRBInitializer.post_init(oRBInitInfo);
            }
            catch (Exception exception) {
                if (this.failOnORBInitializerError) {
                    this.logger.error(oRBInitializer.getClass().getName() + ": aborting due to error during ORBInitializer::pre_init", exception);
                    throw new INITIALIZE(exception.toString());
                }
                this.logger.warn(oRBInitializer.getClass().getName() + ": ignoring error during ORBInitializer::pre_init. the ORBInitializer will be removed from the current configuration", exception);
            }
        }
    }

    private List getORBInitializers() {
        ArrayList arrayList = new ArrayList();
        List list = this.configuration.getAttributeNamesWithPrefix("org.omg.PortableInterceptor.ORBInitializerClass.");
        for (String string : list) {
            String string2 = this.configuration.getAttribute(string, "");
            if (string2.length() == 0 && string.length() > "org.omg.PortableInterceptor.ORBInitializerClass.".length()) {
                string2 = string.substring("org.omg.PortableInterceptor.ORBInitializerClass.".length());
            }
            if (string2 == null) continue;
            try {
                java.lang.Object t = ObjectUtil.classForName(string2).newInstance();
                if (t instanceof ORBInitializer) {
                    arrayList.add(t);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("added ORBInitializer: " + string2);
                    continue;
                }
                if (this.failOnORBInitializerError) {
                    this.logger.error("aborting due to wrong configuration for property " + string + ": " + string2 + " is not an ORBInitializer");
                    throw new BAD_PARAM("Wrong configuration for property " + string + ": " + string2 + " is not an ORBInitializer");
                }
                this.logger.warn("ignoring wrong configuration for property " + string + ": " + string2 + " is not an ORBInitializer");
            }
            catch (Exception exception) {
                if (this.failOnORBInitializerError) {
                    this.logger.error("unable to build ORBInitializer from class " + string2 + ": Aborting", exception);
                    throw new INITIALIZE(exception.toString());
                }
                this.logger.warn("unable to build ORBInitializer from class " + string2 + ": Ignoring");
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("prepare ORB for shutdown...");
        }
        java.lang.Object object = this.shutdown_synch;
        synchronized (object) {
            if (this.shutdown_in_progress && !bl) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ORB is already shutting down.");
                }
                return;
            }
            while (this.shutdown_in_progress) {
                try {
                    this.shutdown_synch.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.shutdown_in_progress = true;
        }
        if (!this.isRunning()) {
            object = this.shutdown_synch;
            synchronized (object) {
                this.shutdown_in_progress = false;
                this.shutdown_synch.notifyAll();
            }
            return;
        }
        this.logger.info("ORB going down...");
        if (this.rootpoa != null) {
            this.rootpoa.destroy(true, bl);
            this.rootpoa = null;
        }
        if (this.basicAdapter != null) {
            this.basicAdapter.stopListeners();
        }
        if (this.giop_connection_manager != null) {
            this.giop_connection_manager.shutdown();
        }
        this.clientConnectionManager.shutdown();
        this.knownReferences.clear();
        this.bufferManager.release();
        this.poolManagerFactory.destroy();
        object = this.runSync;
        synchronized (object) {
            this.run = false;
            this.runSync.notifyAll();
        }
        object = this.shutdown_synch;
        synchronized (object) {
            this.shutdown_in_progress = false;
            this.shutdown_synch.notifyAll();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB shutdown complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.destroyed) {
            throw new OBJECT_NOT_EXIST();
        }
        java.lang.Object object = this.runSync;
        synchronized (object) {
            if (this.run) {
                this.shutdown(true);
            }
        }
        if (this.interceptor_manager != null) {
            this.interceptor_manager.destroy();
        }
        this.destroyed = true;
    }

    public Object string_to_object(String string) {
        this.perform_work();
        if (string == null) {
            return null;
        }
        try {
            ParsedIOR parsedIOR = new ParsedIOR(this, string);
            if (parsedIOR.isNull()) {
                return null;
            }
            return this._getObject(parsedIOR);
        }
        catch (Exception exception) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Exception while converting string to object", exception);
            }
            throw new BAD_PARAM(10, CompletionStatus.COMPLETED_NO);
        }
    }

    public Object get_value_def(String string) throws BAD_PARAM {
        throw new NO_IMPLEMENT();
    }

    public void set_delegate(java.lang.Object object) {
        if (!(object instanceof Servant)) {
            throw new BAD_PARAM("Argument must be of type org.omg.PortableServer.Servant");
        }
        try {
            ((Servant)object)._get_delegate();
        }
        catch (BAD_INV_ORDER bAD_INV_ORDER) {
            ServantDelegate servantDelegate = new ServantDelegate(this);
            ((Servant)object)._set_delegate(servantDelegate);
        }
    }

    public String object_to_string(Object object) {
        this.perform_work();
        if (object == null) {
            return nullIORString;
        }
        if (object instanceof LocalObject) {
            throw new MARSHAL("Attempt to stringify a local object");
        }
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)object)._get_delegate();
        if (delegate instanceof Delegate) {
            return delegate.toString();
        }
        throw new BAD_PARAM("Argument has a delegate whose class is " + delegate.getClass().getName() + ", a org.jacorb.orb.Delegate was expected");
    }

    public void perform_work() {
        this.work_pending();
    }

    public boolean work_pending() {
        if (!this.isRunning()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ORB has been shutdown");
            }
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
        return false;
    }

    public ValueFactory register_value_factory(String string, ValueFactory valueFactory) {
        return this.valueFactories.put(string, valueFactory);
    }

    public void unregister_value_factory(String string) {
        this.valueFactories.remove(string);
    }

    public ValueFactory lookup_value_factory(String string) {
        ValueFactory valueFactory = (ValueFactory)this.valueFactories.get(string);
        if (valueFactory == null && string.startsWith("IDL")) {
            String string2 = RepositoryID.className(string, null);
            valueFactory = this.findValueFactory(string2);
            this.valueFactories.put(string, valueFactory);
        }
        return valueFactory;
    }

    private ValueFactory findValueFactory(String string) {
        Class clazz = this.findClass(string + "DefaultFactory", true);
        if (clazz != null) {
            return (ValueFactory)this.instantiate(clazz);
        }
        Class clazz2 = this.findClass(string, false);
        clazz = this.findClass(string + "Impl", false);
        if (clazz != null && clazz2.isAssignableFrom(clazz)) {
            if (ValueFactory.class.isAssignableFrom(clazz)) {
                return (ValueFactory)this.instantiate(clazz);
            }
            return new JacORBValueFactory(clazz);
        }
        return null;
    }

    private Class findClass(String string, boolean bl) {
        Class clazz;
        block4: {
            clazz = null;
            try {
                clazz = ObjectUtil.classForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!bl || !string.startsWith("org.omg")) break block4;
                try {
                    clazz = ObjectUtil.classForName("omg.org" + string.substring(7));
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
        }
        return clazz;
    }

    private java.lang.Object instantiate(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("cannot instantiate class " + clazz.getName() + " (IllegalAccessException)");
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("cannot instantiate class " + clazz.getName() + " (InstantiationException)");
        }
    }

    public BoxedValueHelper getBoxedValueHelper(String string) {
        BoxedValueHelper boxedValueHelper = (BoxedValueHelper)this.boxedValueHelpers.get(string);
        if (boxedValueHelper == null) {
            if (this.boxedValueHelpers.containsKey(string)) {
                return null;
            }
            boxedValueHelper = RepositoryID.createBoxedValueHelper(string, null);
            this.boxedValueHelpers.put(string, boxedValueHelper);
        }
        return boxedValueHelper;
    }

    public boolean hasClientRequestInterceptors() {
        return this.hasClientInterceptors;
    }

    public boolean hasServerRequestInterceptors() {
        return this.hasServerInterceptors;
    }

    public boolean hasRequestInterceptors() {
        return this.hasServerInterceptors || this.hasClientInterceptors;
    }

    public InterceptorManager getInterceptorManager() {
        return this.interceptor_manager;
    }

    public synchronized TransportManager getTransportManager() {
        if (this.transport_manager == null) {
            this.transport_manager = new TransportManager(this);
            try {
                this.transport_manager.configure(this.configuration);
            }
            catch (ConfigurationException configurationException) {
                throw new INITIALIZE(configurationException.toString());
            }
        }
        return this.transport_manager;
    }

    public org.omg.CORBA.ExceptionList create_exception_list() {
        return new ExceptionList();
    }

    public org.omg.CORBA.NVList create_list(int n) {
        return new NVList(this, n);
    }

    public org.omg.CORBA.NamedValue create_named_value(String string, Any any, int n) {
        return new NamedValue(string, any, n);
    }

    public org.omg.CORBA.NVList create_operation_list(Object object) {
        if (!(object instanceof OperationDef)) {
            throw new BAD_PARAM("Argument must be of type org.omg.CORBA.OperationDef");
        }
        OperationDef operationDef = (OperationDef)object;
        return this.create_operation_list(operationDef);
    }

    public org.omg.CORBA.NVList create_operation_list(OperationDef operationDef) {
        int n = 0;
        ParameterDescription[] parameterDescriptionArray = operationDef.params();
        if (parameterDescriptionArray != null) {
            n = parameterDescriptionArray.length;
        }
        NVList nVList = new NVList(this, n);
        block5: for (int i = 0; i < n; ++i) {
            ParameterDescription parameterDescription = parameterDescriptionArray[i];
            Any any = this.create_any();
            any.type(parameterDescription.type);
            switch (parameterDescription.mode.value()) {
                case 0: {
                    ((org.omg.CORBA.NVList)nVList).add_value(parameterDescription.name, any, 1);
                    continue block5;
                }
                case 1: {
                    ((org.omg.CORBA.NVList)nVList).add_value(parameterDescription.name, any, 2);
                    continue block5;
                }
                case 2: {
                    ((org.omg.CORBA.NVList)nVList).add_value(parameterDescription.name, any, 3);
                    continue block5;
                }
                default: {
                    throw new BAD_PARAM("Invalid value for ParamaterMode");
                }
            }
        }
        return nVList;
    }

    private void configureObjectKeyMap(Configuration configuration) {
        org.jacorb.config.Configuration configuration2 = (org.jacorb.config.Configuration)configuration;
        List list = configuration2.getAttributeNamesWithPrefix("jacorb.orb.objectKeyMap.");
        try {
            for (String string : list) {
                this.objectKeyMap.put(string.substring("jacorb.orb.objectKeyMap.".length()), configuration2.getAttribute(string));
            }
        }
        catch (ConfigurationException configurationException) {
            this.logger.fatalError("unexpected exception", configurationException);
            throw new INTERNAL(configurationException.toString());
        }
    }

    public void addObjectKey(String string, String string2) {
        this.objectKeyMap.put(string, string2);
    }

    public byte[] mapObjectKey(byte[] byArray) {
        ParsedIOR parsedIOR = null;
        String string = null;
        String string2 = null;
        if (this.objectKeyMap.size() != 0 && (string = (String)this.objectKeyMap.get(string2 = new String(byArray))) != null) {
            if (ParsedIOR.isParsableProtocol(string)) {
                try {
                    parsedIOR = new ParsedIOR(this, string);
                    return parsedIOR.get_object_key();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Error - could not read protocol " + string);
                    }
                    return byArray;
                }
            }
            return CorbaLoc.parseKey(string);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRunning() {
        java.lang.Object object = this.runSync;
        synchronized (object) {
            return this.run;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object object) {
        if (!(object instanceof ObjectImpl)) {
            throw new BAD_PARAM("connect parameter must extend org.omg.CORBA.portable.ObjectImpl");
        }
        if (!(object instanceof InvokeHandler)) {
            throw new BAD_PARAM("connect parameter must implement org.omg.CORBA.portable.InvokeHandler");
        }
        Map map = this.connectedObjects;
        synchronized (map) {
            if (!this.connectedObjects.containsKey(object)) {
                ObjectImpl objectImpl = (ObjectImpl)object;
                HandlerWrapper handlerWrapper = new HandlerWrapper(objectImpl);
                Object object2 = handlerWrapper._this_object(this);
                objectImpl._set_delegate(((ObjectImpl)object2)._get_delegate());
                this.connectedObjects.put(object, handlerWrapper);
                if (this.firstConnection) {
                    this.firstConnection = false;
                    POAManager pOAManager = this.getRootPOA().the_POAManager();
                    if (pOAManager.get_state() == State.HOLDING) {
                        try {
                            pOAManager.activate();
                        }
                        catch (AdapterInactive adapterInactive) {
                            this.logger.fatalError("unexpected exception", adapterInactive);
                            throw new INTERNAL(adapterInactive.toString());
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(Object object) {
        if (!(object instanceof ObjectImpl)) {
            throw new BAD_PARAM("disconnect parameter must extend org.omg.CORBA.portable.ObjectImpl");
        }
        if (!(object instanceof InvokeHandler)) {
            throw new BAD_PARAM("disconnect parameter must implement org.omg.CORBA.portable.InvokeHandler");
        }
        Map map = this.connectedObjects;
        synchronized (map) {
            Servant servant = (Servant)this.connectedObjects.get(object);
            if (servant != null) {
                this.connectedObjects.remove(object);
                try {
                    this.getRootPOA().deactivate_object(this.getRootPOA().servant_to_id(servant));
                }
                catch (Exception exception) {
                    this.logger.fatalError("unexpected exception", exception);
                    throw new INTERNAL(exception.toString());
                }
            }
        }
    }

    public String getServerIdString() {
        return this.serverIdStr;
    }

    public byte[] getServerId() {
        return this.serverId;
    }

    public RPPoolManager newRPPoolManager(boolean bl) {
        return this.poolManagerFactory.newRPPoolManager(bl);
    }

    public void notifyTransportListeners(GIOPConnection gIOPConnection) {
        this.transport_manager.notifyTransportListeners(gIOPConnection);
    }

    public String getImplName() {
        return this.implName;
    }

    static class HandlerWrapper
    extends Servant
    implements InvokeHandler {
        private final InvokeHandler wrappedHandler;

        public HandlerWrapper(ObjectImpl objectImpl) {
            this.wrappedHandler = (InvokeHandler)((java.lang.Object)objectImpl);
        }

        public String[] _all_interfaces(POA pOA, byte[] byArray) {
            return ((ObjectImpl)((java.lang.Object)this.wrappedHandler))._ids();
        }

        public OutputStream _invoke(String string, org.omg.CORBA.portable.InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
            return this.wrappedHandler._invoke(string, inputStream, responseHandler);
        }
    }

    private class PICurrent
    extends LocalObject
    implements org.omg.PortableInterceptor.Current {
        private PICurrent() {
        }

        private org.omg.PortableInterceptor.Current getTarget() {
            if (ORB.this.interceptor_manager == null) {
                return InterceptorManager.EMPTY_CURRENT;
            }
            return ORB.this.interceptor_manager.getCurrent();
        }

        public Any get_slot(int n) throws InvalidSlot {
            return this.getTarget().get_slot(n);
        }

        public void set_slot(int n, Any any) throws InvalidSlot {
            this.getTarget().set_slot(n, any);
        }
    }

    private class JacORBValueFactory
    implements ValueFactory {
        private final Class implementationClass;

        public JacORBValueFactory(Class clazz) {
            this.implementationClass = clazz;
        }

        public Serializable read_value(InputStream inputStream) {
            java.lang.Object object = ORB.this.instantiate(this.implementationClass);
            if (object instanceof Streamable) {
                StreamableValue streamableValue = (StreamableValue)ORB.this.instantiate(this.implementationClass);
                return inputStream.read_value(streamableValue);
            }
            if (object instanceof CustomValue) {
                ((CustomValue)object).unmarshal(new DataInputStream(inputStream));
                return (CustomValue)object;
            }
            throw new MARSHAL("Unknown Value type " + object);
        }
    }
}

