/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.TangoConst;
import java.util.Hashtable;

public class QualityUtilities {
    private Hashtable<AttrQuality, String> QUALITYTABLE = new Hashtable();
    private static QualityUtilities m_QualityUtilities = null;
    public static final String[] QUALITYIST = TangoConst.Tango_QualityName;

    private QualityUtilities() {
        this.QUALITYTABLE.put(AttrQuality.ATTR_VALID, QUALITYIST[0]);
        this.QUALITYTABLE.put(AttrQuality.ATTR_INVALID, QUALITYIST[1]);
        this.QUALITYTABLE.put(AttrQuality.ATTR_ALARM, QUALITYIST[2]);
        this.QUALITYTABLE.put(AttrQuality.ATTR_CHANGING, QUALITYIST[3]);
        this.QUALITYTABLE.put(AttrQuality.ATTR_WARNING, QUALITYIST[4]);
    }

    public static QualityUtilities getInstance() {
        if (m_QualityUtilities == null) {
            m_QualityUtilities = new QualityUtilities();
        }
        return m_QualityUtilities;
    }

    public static Hashtable getQualityTable() {
        return QualityUtilities.getInstance().QUALITYTABLE;
    }

    public static AttrQuality getQualityForName(String aQualityName) {
        try {
            aQualityName = "ATTR_" + aQualityName.trim().toUpperCase();
            return (AttrQuality)AttrQuality.class.getField(aQualityName).get(aQualityName);
        }
        catch (Exception e) {
            return AttrQuality.ATTR_INVALID;
        }
    }

    public static String getNameForQuality(AttrQuality aQuality) {
        return ApiUtil.qualityName(aQuality);
    }

    public static String getNameForQuality(short att_q_val) {
        return ApiUtil.qualityName(att_q_val);
    }

    public static boolean isQualityExist(String aQualityName) {
        return QualityUtilities.getInstance().QUALITYTABLE.containsValue(aQualityName);
    }
}

