/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.Tango.factory;

import fr.esrf.Tango.factory.ITangoFactory;
import fr.esrf.TangoApi.IApiUtilDAO;
import fr.esrf.TangoApi.IConnectionDAO;
import fr.esrf.TangoApi.IDatabaseDAO;
import fr.esrf.TangoApi.IDeviceAttributeDAO;
import fr.esrf.TangoApi.IDeviceDataDAO;
import fr.esrf.TangoApi.IDeviceDataHistoryDAO;
import fr.esrf.TangoApi.IDeviceProxyDAO;
import fr.esrf.TangoApi.IIORDumpDAO;
import fr.esrf.TangoApi.factory.DefaultTangoFactoryImpl;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class TangoFactory {
    public static final String FACTORY_PROPERTIES = "tango_factory.properties";
    public static final String TANGO_FACTORY = "TANGO_FACTORY";
    private static TangoFactory singleton = null;
    private Properties properties = null;
    private ITangoFactory tangoFactory;
    private boolean isDefaultFactory = true;

    public TangoFactory() {
        this.initTangoFactory();
    }

    public void initTangoFactory() {
        this.properties = TangoFactory.getPropertiesFile();
        if (this.properties == null || this.properties.size() == 0 || !this.properties.containsKey(TANGO_FACTORY)) {
            this.tangoFactory = new DefaultTangoFactoryImpl();
        } else {
            String factoryClassName = this.properties.getProperty(TANGO_FACTORY);
            this.tangoFactory = (ITangoFactory)TangoFactory.getObject(factoryClassName);
            this.isDefaultFactory = false;
        }
    }

    public static TangoFactory getSingleton() {
        if (singleton == null) {
            TangoFactory.createSingleton();
        }
        return singleton;
    }

    public static void createSingleton() {
        singleton = new TangoFactory();
    }

    public IConnectionDAO getConnectionDAO() {
        return this.tangoFactory.getConnectionDAO();
    }

    public IDeviceProxyDAO getDeviceProxyDAO() {
        return this.tangoFactory.getDeviceProxyDAO();
    }

    public IDatabaseDAO getDatabaseDAO() {
        return this.tangoFactory.getDatabaseDAO();
    }

    public IDeviceAttributeDAO getDeviceAttributeDAO() {
        return this.tangoFactory.getDeviceAttributeDAO();
    }

    public IDeviceDataDAO getDeviceDataDAO() {
        return this.tangoFactory.getDeviceDataDAO();
    }

    public IDeviceDataHistoryDAO getDeviceDataHistoryDAO() {
        return this.tangoFactory.getDeviceDataHistoryDAO();
    }

    public IApiUtilDAO getApiUtilDAO() {
        return this.tangoFactory.getApiUtilDAO();
    }

    public IIORDumpDAO getIORDumpDAO() {
        return this.tangoFactory.getIORDumpDAO();
    }

    private static Properties getPropertiesFile() {
        InputStream stream = null;
        BufferedInputStream bufStream = null;
        try {
            stream = TangoFactory.class.getClassLoader().getResourceAsStream(FACTORY_PROPERTIES);
            Properties properties = new Properties();
            if (stream != null) {
                bufStream = new BufferedInputStream(stream);
                properties.clear();
                properties.load(bufStream);
            }
            return properties;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getObject(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> contructor = clazz.getConstructor(new Class[0]);
            Object object = contructor.newInstance(new Object[0]);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isDefaultFactory() {
        return this.isDefaultFactory;
    }

    public void setDefaultFactory(boolean isDefaultFactory) {
        this.isDefaultFactory = isDefaultFactory;
    }
}

