/*
 * Decompiled with CFR 0.152.
 */
package pogo.servers2www;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.Except;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PogoUtil;
import pogo.servers2www.ModuleFamily;

public class ScanRepository
implements PogoDefs {
    private boolean test = false;
    private String cvsroot;
    public Vector modules;
    public Vector servers;
    public String name;

    public ScanRepository(String cvsroot, String repository) throws Exception {
        System.out.println("ScanRepository(" + cvsroot + ", " + repository + ")");
        this.cvsroot = cvsroot;
        this.servers = new Vector();
        this.modules = new Vector();
        if (cvsroot.indexOf("tango-ds") >= 0) {
            this.scanTangoDsModuleFile(repository);
        } else {
            String[] mod_names = ScanRepository.getModuleFamilies();
            for (int i = 0; i < mod_names.length; ++i) {
                this.servers.add(new ModuleFamily(mod_names[i], repository));
            }
            this.servers.add(new ModuleFamily("Miscellaneous", repository));
            System.out.println("Scanning " + cvsroot);
            this.scanModuleFile();
        }
        for (int s = 0; s < this.servers.size(); ++s) {
            ModuleFamily family = (ModuleFamily)this.servers.elementAt(s);
            family.sort();
        }
        System.out.println(this);
    }

    private void scanTangoDsModuleFile(String repository) throws Exception {
        PogoString code = new PogoString(PogoUtil.readFile(this.cvsroot + "/CVSROOT/modules"));
        String[] lines = code.string2array("\n");
        String target = "###";
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].indexOf("#") == 0) continue;
            if (lines[i - 1].indexOf(target) == 0) {
                String name = lines[i - 1].substring(target.length()).trim();
                name = name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
                ModuleFamily family = new ModuleFamily(name, repository);
                this.servers.add(family);
            }
            StringTokenizer st = new StringTokenizer(lines[i]);
            String module = st.nextToken();
            String path = st.nextToken();
            ModuleFamily family = (ModuleFamily)this.servers.lastElement();
            family.add(module);
            this.modules.add(module);
        }
    }

    private void scanModuleFile() throws Exception {
        PogoString code = new PogoString(PogoUtil.readFile(this.cvsroot + "/CVSROOT/modules"));
        String[] lines = code.string2array("\n");
        for (int i = 0; i < lines.length; ++i) {
            StringTokenizer st;
            if (lines[i].indexOf("#") == 0 || (st = new StringTokenizer(lines[i])).countTokens() < 2) continue;
            String module = st.nextToken();
            String path = st.nextToken();
            if (path.indexOf("cppserver") < 0 && path.indexOf("jserver") < 0 && path.indexOf("pyserver") < 0) continue;
            boolean found = false;
            for (int s = 0; s < this.servers.size() - 1 && !found; ++s) {
                ModuleFamily family = (ModuleFamily)this.servers.elementAt(s);
                String name = family.name + ":";
                if (lines[i - 1].indexOf(name) <= 0) continue;
                family.add(module);
                found = true;
            }
            if (!found) {
                ModuleFamily family = (ModuleFamily)this.servers.lastElement();
                family.add(module);
            }
            this.modules.add(module);
        }
    }

    public static String[] getModuleFamilies() throws DevFailed {
        DbDatum data = ApiUtil.get_db_obj().get_property("Pogo", "ModuleFamilies");
        String[] mod_names = data.extractStringArray();
        return mod_names;
    }

    private int nb_modules() {
        return this.modules.size();
    }

    private void tangoDsToEsrfStruct() {
        for (int i = 0; i < this.nb_modules(); ++i) {
            String module = (String)this.modules.elementAt(i);
            String cmd = "mv " + module + "/include/* " + module;
            System.out.println("----->  " + cmd);
            try {
                PogoGene.copyDirectory(module + "/include", module);
            }
            catch (Exception e) {
                // empty catch block
            }
            cmd = "mv " + module + "/src/* " + module;
            System.out.println("----->  " + cmd);
            try {
                PogoGene.copyDirectory(module + "/src", module);
            }
            catch (Exception e) {
                // empty catch block
            }
            cmd = "mv " + module + "/doc/doc_html/* " + module;
            System.out.println("----->  " + cmd);
            try {
                String targetdir = module + "/doc_html";
                File f = new File(targetdir);
                if (!f.exists()) {
                    f.mkdir();
                }
                PogoGene.copyDirectory(module + "/CVS", targetdir);
                PogoGene.copyDirectory(module + "/doc", targetdir);
                PogoGene.copyDirectory(module + "/doc/doc_html", targetdir);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public int cvsCheckOutModules() throws Exception {
        if (this.test) {
            return this.nb_modules();
        }
        Vector tags = PogoUtil.getLastCvsTags(this.cvsroot);
        for (int i = 0; i < this.nb_modules(); ++i) {
            String module = (String)this.modules.elementAt(i);
            String tag = PogoUtil.getLastCvsTag(tags, module);
            String cmd = "cvs -Q -d " + this.cvsroot + "  co ";
            if (tag != null) {
                cmd = cmd + " -r " + tag + "  ";
            }
            cmd = cmd + module;
            System.out.println(cmd);
            System.out.println("Checking out :  " + module);
            try {
                ScanRepository.executeShellCmd(cmd);
                continue;
            }
            catch (PogoException e) {
                System.out.println(e);
                this.modules.remove(i);
            }
        }
        if (this.cvsroot.indexOf("tango-ds") >= 0) {
            this.tangoDsToEsrfStruct();
        }
        return this.nb_modules();
    }

    public void cvsReleaseModules() throws Exception {
        if (this.test) {
            return;
        }
        for (int i = 0; i < this.nb_modules(); ++i) {
            String cmd = "cvs -Q -d " + this.cvsroot + " release -d " + (String)this.modules.elementAt(i);
            System.out.println(cmd);
            ScanRepository.executeShellCmd(cmd);
        }
    }

    public static void executeShellCmd(String cmd) throws Exception {
        String str;
        Process proc = Runtime.getRuntime().exec(cmd);
        InputStream istr = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(istr));
        StringBuffer sb = new StringBuffer("");
        while ((str = br.readLine()) != null) {
            System.out.println(str);
            sb.append(str + "\n");
        }
        proc.waitFor();
        int retVal = proc.exitValue();
        if (retVal != 0) {
            InputStream errstr = proc.getErrorStream();
            br = new BufferedReader(new InputStreamReader(errstr));
            while ((str = br.readLine()) != null) {
                System.out.println(str);
                sb.append(str + "\n");
            }
            throw new PogoException("the shell command\n" + cmd + "\nreturns : " + retVal + " !\n\n" + sb.toString());
        }
        System.out.println(sb);
    }

    public String toString() {
        int cnt = 0;
        String s = "";
        for (int i = 0; i < this.servers.size(); ++i) {
            ModuleFamily family = (ModuleFamily)this.servers.elementAt(i);
            s = s + family.toString() + "\n";
            cnt += family.size();
        }
        s = s + "\n\t" + cnt + " Tango device servers\n";
        return s;
    }

    public static void main(String[] args) {
        String cvsroot = System.getProperty("CVSROOT");
        try {
            if (cvsroot == null) {
                throw new PogoException("CVSROOT Not set !");
            }
            long t0 = System.currentTimeMillis();
            new ScanRepository(cvsroot, "ESRF");
            long t1 = System.currentTimeMillis();
            System.out.println("elapsed time : " + (t1 - t0) + " ms");
        }
        catch (Exception e) {
            Except.print_exception((Exception)e);
        }
    }
}

