/*
 * Decompiled with CFR 0.152.
 */
package pogo.servers2www;

import fr.esrf.TangoDs.Except;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoGeneDoc;
import pogo.gene.PogoUtil;
import pogo.servers2www.ModuleFamily;

public class HTMLpage
implements PogoDefs {
    private static String servers_dir = null;
    private static String templates_dir = null;
    private ModuleFamily family;
    private static String header = null;
    private static final String head_list = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HTML>\n<HEAD>\n<Title> Tango Device Server User's Guide </Title>\n   <META NAME=\"GENERATOR\" CONTENT=\"Mozilla/4.08 [en] (X11; I; HP-UX B.10.20 9000/777) [Netscape]\">\n   <TITLE> DS User's Guide </TITLE>\n</HEAD>\n";
    private static final String body = "<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<!------------------ Contents ----------------------->\n\n";
    private static final String index = "<FRAMESET cols=\"20%,80%\">\n<FRAME src=\"ClassList.html\"   name=\"left\">\n<FRAME src=\"Tango-cs_Miscellaneous.html\" name=\"right\">\n</FRAMESET>\n</HTML>\n";
    private static final String warning = "<Center><b>\nWARNING:\nThese classes have been developped for a specific usage\nand are not guaranteed for all platforms.\n</Center></b>\n<Br>\n<Br>\n";

    public HTMLpage(ModuleFamily family) {
        this.family = family;
    }

    private void storeFiles(PogoClass server) throws Exception {
        String path;
        servers_dir = server.projectFiles.getHtmlServerslist();
        File f = new File(servers_dir);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(path = servers_dir + "/" + server.class_name)).exists()) {
            f.mkdir();
        }
        PogoGene.copyDirectory(server.projectFiles.getDocHtml(), path + "/doc_html");
        PogoGene.copyDirectory(server.projectFiles.getPath() + "/CVS", path + "/CVS");
    }

    private String checkForTangoDir(String dirname) throws PogoException {
        System.out.println("checkForTangoDir for " + dirname);
        File d = new File(dirname);
        String[] filenames = d.list();
        for (int i = 0; i < filenames.length; ++i) {
            String filename = dirname + "/" + filenames[i];
            File f = new File(filename);
            if (!f.isDirectory()) continue;
            String[] files = PogoUtil.getTangoFilesList(filename);
            if (files.length > 0) {
                return files[0];
            }
            String ret = this.checkForTangoDir(filename);
            if (ret == null || ret.length() <= 0) continue;
            return ret;
        }
        return null;
    }

    private String[] createServerItem(String dirname) throws Exception {
        String[] list = PogoUtil.getTangoFilesList(dirname);
        String servname = list.length == 0 ? this.checkForTangoDir(dirname) : list[0];
        if (servname == null) {
            Except.throw_exception((String)"NOT_TANGO", (String)"Not a TANGO server", (String)"servers2www/HTMLpage.createServerItem");
        }
        PogoClass server = new PogoClass(servname);
        String[] retstr = server.buildServersListHtmlLine(this.family.repository, this.family.name);
        PogoGeneDoc pogo = new PogoGeneDoc(server);
        pogo.generate();
        pogo.addCvsFamily(this.family.name);
        this.storeFiles(server);
        this.buildTarFile(server);
        templates_dir = server.templates_dir;
        return retstr;
    }

    private void buildTarFile(PogoClass server) throws Exception {
        File target_dir;
        if (server.projectFiles.getPath().equals(server.class_name)) {
            String dirname = server.projectFiles.getPath().toLowerCase();
            System.out.println("Renaming " + server.projectFiles.getPath() + " to " + dirname);
            String cmd = "mv " + server.projectFiles.getPath() + "  " + dirname;
            PogoUtil.executeShellCmd(cmd);
            server.projectFiles.setPath(dirname);
        }
        if (!(target_dir = new File(server.class_name)).exists()) {
            target_dir.mkdir();
        }
        PogoGene.copyDirectory(server.projectFiles.getPath(), target_dir.toString());
        String tar_file = server.projectFiles.getHtmlServerslist() + "/" + server.class_name + "/" + server.class_name + ".tar.gz ";
        String cmd = "tar -czf " + tar_file + " " + target_dir.toString();
        System.out.println(cmd);
        PogoUtil.executeShellCmd(cmd);
    }

    private String buildTableLine(String[] line) {
        String retstr = "<Tr><Td>" + line[0] + "</Td>\n";
        retstr = retstr + "<Td>" + line[1] + "</Td>\n";
        retstr = retstr + "<Td>" + line[2] + "</Td></Tr>\n\n";
        return retstr;
    }

    private static String readHeaderFile() throws Exception {
        String str = PogoUtil.readFile(templates_dir + "/html/header.html");
        return str.substring(0, str.indexOf("</Body>"));
    }

    private static String writeHtmlPage(String filename, String str, boolean full) throws Exception {
        if (full) {
            str = str + "<Center>\nLast Update: ";
            str = str + new Date().toString() + "\n</Center>\n";
            String footer = PogoUtil.readFile(templates_dir + "/html/footer.html");
            str = str + footer;
        }
        String out_file = servers_dir + "/" + filename;
        FileOutputStream fidout = new FileOutputStream(out_file);
        fidout.write(str.getBytes());
        fidout.close();
        return new String(out_file + " file has been generated !");
    }

    public String generateServersList() throws Exception {
        Vector<String[]> servers = new Vector<String[]>();
        for (int i = 0; i < this.family.size(); ++i) {
            try {
                String[] item = this.createServerItem(this.family.serverAt(i));
                servers.add(item);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MyCompare comp = new MyCompare();
        Collections.sort(servers, comp);
        if (servers.size() == 0) {
            this.family.clear();
            return "";
        }
        String[] col_titles = new String[]{"Class Name", "Lang.", "Description"};
        String table = PogoGeneDoc.buildTableHeader(this.tableName(), col_titles);
        for (int i = 0; i < servers.size(); ++i) {
            String[] item = (String[])servers.elementAt(i);
            table = table + this.buildTableLine(item);
        }
        table = table + "</Table>\n<br>\n<br>\n<br>\n";
        if (header == null) {
            header = HTMLpage.readHeaderFile();
        }
        String page = header + warning + table;
        return HTMLpage.writeHtmlPage(this.family.fileName() + ".html", page, true);
    }

    private String tableName() {
        return HTMLpage.tableName(this.family);
    }

    private static String tableName(ModuleFamily f) {
        return "" + f.size() + "  " + f.name + "  Classes  hosted by " + f.repository;
    }

    public static void generateIndexFile(Vector families, int nb_servers) throws Exception {
        if (templates_dir == null && (templates_dir = System.getProperty("TEMPL_HOME")) == null) {
            throw new PogoException("No Template Property (TEMPL_HOME) Fixed !");
        }
        HTMLpage.writeHtmlPage("index.html", "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HTML>\n<HEAD>\n<Title> Tango Device Server User's Guide </Title>\n   <META NAME=\"GENERATOR\" CONTENT=\"Mozilla/4.08 [en] (X11; I; HP-UX B.10.20 9000/777) [Netscape]\">\n   <TITLE> DS User's Guide </TITLE>\n</HEAD>\n<FRAMESET cols=\"20%,80%\">\n<FRAME src=\"ClassList.html\"   name=\"left\">\n<FRAME src=\"Tango-cs_Miscellaneous.html\" name=\"right\">\n</FRAMESET>\n</HTML>\n", false);
        String page = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HTML>\n<HEAD>\n<Title> Tango Device Server User's Guide </Title>\n   <META NAME=\"GENERATOR\" CONTENT=\"Mozilla/4.08 [en] (X11; I; HP-UX B.10.20 9000/777) [Netscape]\">\n   <TITLE> DS User's Guide </TITLE>\n</HEAD>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#7F00FF\" ALINK=\"#FF0000\">\n<!------------------ Contents ----------------------->\n\n";
        page = page + "<Center><Font size=+1><b>" + nb_servers + " Tango classes </b></Center></Font><Br>\n";
        page = page + "<a href=\"SearchItem.html\" Target=\"right\"> Search key Word</a><Br>\n";
        page = page + "<a href=\"FullList.html\" Target=\"right\"> Alphabetical Order</a><Br>\n";
        String repos_name = "";
        for (int i = 0; i < families.size(); ++i) {
            ModuleFamily family = (ModuleFamily)families.elementAt(i);
            if (family.size() <= 0) continue;
            if (!family.repository.equals(repos_name)) {
                if (i > 0) {
                    page = page + "</Font>\n";
                }
                page = page + "\n<Br>\n<b>" + family.repository + ":</b>\n";
                page = page + "<Font size=-1>\n";
                repos_name = family.repository;
            }
            page = page + "\t<li> <a href=" + family.fileName() + ".html Target=\"right\">\t" + family.name + " </a>\n";
        }
        page = page + "</Font>\n";
        page = page + HTMLpage.addHowIsGenerated();
        HTMLpage.writeHtmlPage("ClassList.html", page, false);
    }

    private static String addHowIsGenerated() throws Exception {
        String link = "<Br><Br><Br><Br><Br><Br><Br>\n";
        link = link + "<Font size=-1><Br>\n";
        link = link + "<a href=\"HowIsGenerated.html\" target=right>";
        link = link + " How these pages are generated ?</a><Br>\n";
        link = link + "(Specific ESRF)<Br>\n";
        link = link + "</Font>";
        return link;
    }

    class MyCompare
    implements Comparator {
        MyCompare() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((String[])o1)[0].toLowerCase();
            String s2 = ((String[])o2)[0].toLowerCase();
            return s1.compareTo(s2);
        }
    }
}

