/*
 * Decompiled with CFR 0.152.
 */
package app_util;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;

public class MultiLineToolTipUI
extends ToolTipUI {
    static MultiLineToolTipUI singleton = new MultiLineToolTipUI();
    private static int inset = 3;
    private static int accelerator_offset = 15;

    private MultiLineToolTipUI() {
    }

    public static void initialize() {
        String key = "ToolTipUI";
        Class<?> cls = singleton.getClass();
        String name = cls.getName();
        UIManager.put(key, name);
        UIManager.put(name, cls);
    }

    public static ComponentUI createUI(JComponent c) {
        return singleton;
    }

    public void installUI(JComponent c) {
        this.installDefaults(c);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults(c);
    }

    protected void installDefaults(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(c, "ToolTip.border");
    }

    protected void uninstallDefaults(JComponent c) {
        LookAndFeel.uninstallBorder(c);
    }

    public void paint(Graphics g, JComponent c) {
        Font font = c.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Dimension dimension = c.getSize();
        int fontHeight = fontMetrics.getHeight();
        int fontAscent = fontMetrics.getAscent();
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            return;
        }
        String[] lines = tipText.split("\n");
        int num_lines = lines.length;
        g.setColor(c.getBackground());
        g.fillRect(0, 0, dimension.width, dimension.height);
        g.setColor(c.getForeground());
        int i = 0;
        int height = 2 + fontAscent;
        while (i < num_lines) {
            String keyText;
            g.drawString(lines[i], inset, height);
            if (i == num_lines - 1 && !(keyText = this.getAcceleratorString((JToolTip)c)).equals("")) {
                Font small = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
                g.setFont(small);
                g.drawString(keyText, fontMetrics.stringWidth(lines[i]) + accelerator_offset, height);
            }
            ++i;
            height += fontHeight;
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            return new Dimension(6, 6);
        }
        String[] lines = tipText.split("\n");
        int num_lines = lines.length;
        int height = num_lines * fontHeight;
        int width = 0;
        for (int i = 0; i < num_lines; ++i) {
            int onewidth = fontMetrics.stringWidth(lines[i]);
            if (i == num_lines - 1) {
                String keyText = this.getAcceleratorString((JToolTip)c);
                onewidth += fontMetrics.stringWidth(keyText) + accelerator_offset;
            }
            width = Math.max(width, onewidth);
        }
        return new Dimension(width + inset * 2, height + inset * 2);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public String getAcceleratorString(JToolTip tip) {
        JComponent comp = tip.getComponent();
        if (comp == null) {
            return "";
        }
        KeyStroke[] keys = comp.getRegisteredKeyStrokes();
        String controlKeyStr = "";
        for (int i = 0; i < keys.length; ++i) {
            char c = (char)keys[i].getKeyCode();
            int mod = keys[i].getModifiers();
            if (mod == 2) {
                controlKeyStr = "cntl+" + (char)keys[i].getKeyCode();
                break;
            }
            if (mod != 8) continue;
            controlKeyStr = "alt+" + (char)keys[i].getKeyCode();
            break;
        }
        return controlKeyStr;
    }
}

