/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.BorderLayout;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.MainPanel;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskDeviceAttributePropertyNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelAlias
extends TreePanel {
    public TreePanelAlias(MainPanel mainPanel) {
        this.invoker = mainPanel;
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    public TangoNode createRoot() {
        return new RootNode();
    }

    class AliasNode
    extends TangoNode {
        private String aliasName;

        AliasNode(String string) {
            this.aliasName = string;
        }

        void populateNode() throws DevFailed {
            String string = TreePanelAlias.this.db.get_alias_device(this.aliasName);
            this.add(new TaskDevicePropertyNode(TreePanelAlias.this.self, TreePanelAlias.this.db, string));
            this.add(new TaskPollingNode(TreePanelAlias.this.db, string));
            this.add(new TaskEventNode(TreePanelAlias.this.db, string));
            this.add(new TaskAttributeNode(TreePanelAlias.this.db, string));
            this.add(new AttributeNode(string));
            this.add(new TaskLoggingNode(TreePanelAlias.this.db, string));
        }

        public String toString() {
            return this.aliasName;
        }

        public ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        public int[] getAction() {
            return new int[]{11, 13};
        }

        public void goToDeviceNode() {
            try {
                String string = TreePanelAlias.this.db.get_alias_device(this.aliasName);
                TreePanelAlias.this.invoker.goToDeviceNode(string);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }

        public void execAction(int n) {
            switch (n) {
                case 11: {
                    TreePanelAlias.this.testDevice(this.aliasName);
                    break;
                }
                case 13: {
                    this.goToDeviceNode();
                }
            }
        }
    }

    class AttributeNode
    extends TangoNode {
        private String devName;

        AttributeNode(String string) {
            this.devName = string;
        }

        void populateNode() throws DevFailed {
            String[] stringArray = null;
            int n = 0;
            DeviceProxy deviceProxy = new DeviceProxy(this.devName);
            try {
                stringArray = deviceProxy.get_attribute_list();
                n = deviceProxy.get_idl_version();
            }
            catch (DevFailed devFailed) {
                stringArray = TreePanelAlias.this.db.get_device_attribute_list(this.devName);
            }
            JiveUtils.sortList(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(new TaskDeviceAttributePropertyNode(TreePanelAlias.this.self, TreePanelAlias.this.db, this.devName, stringArray[i], n));
            }
        }

        public String toString() {
            return "Attribute properties";
        }

        public ImageIcon getIcon() {
            return TangoNodeRenderer.atticon;
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        void populateNode() throws DevFailed {
            String[] stringArray = TreePanelAlias.this.db.get_device_alias_list("*");
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(new AliasNode(stringArray[i]));
            }
        }

        public String toString() {
            return "Alias: ";
        }
    }
}

