/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jive.AttributePanel;
import jive.DetailsDlg;
import jive.JiveUtils;
import jive.TangoHelp;

public class TangoTreeNode
extends DefaultMutableTreeNode {
    private boolean areChildrenDefined = false;
    public int type;
    public int level;
    private String value;
    private Database db;
    private boolean valid;
    public String help;
    public int idl = 0;

    public TangoTreeNode(int n, int n2, String string, Database database, boolean bl) {
        this.initNode(n, n2, string, database, bl);
    }

    private void initNode(int n, int n2, String string, Database database, boolean bl) {
        this.level = n;
        this.type = n2;
        this.value = string;
        this.db = database;
        this.valid = bl;
        this.help = TangoHelp.getHelp(this.toString(), n2, n);
        if (!this.isValid()) {
            this.help = this.help != null ? this.help + "\n" : "";
            this.help = n == 4 && n2 == 2 ? this.help + "Warning: The class " + string + " is not defined for this server." : this.help + "Warning: The value stored in the database differs from the server value";
        }
    }

    void addNode(DbAttribute dbAttribute, String string, String string2) {
        boolean bl = true;
        if (string2 != null && !dbAttribute.is_empty(string)) {
            String string3 = dbAttribute.get_string_value(string);
            bl = string2.equalsIgnoreCase(string3);
        }
        this.areChildrenDefined = true;
        this.addNode(new TangoTreeNode(this.level + 1, this.type, string, this.db, bl));
    }

    void addNode(TangoTreeNode tangoTreeNode) {
        tangoTreeNode.idl = this.idl;
        this.add(tangoTreeNode);
    }

    void constructAttNode(String string, String string2) throws DevFailed {
        String[] stringArray;
        TangoTreeNode tangoTreeNode;
        String[] stringArray2 = new String[]{string2};
        DbAttribute dbAttribute = this.db.get_device_attribute_property(string, stringArray2)[0];
        DeviceProxy deviceProxy = new DeviceProxy(string);
        AttributeInfoEx attributeInfoEx = deviceProxy.get_attribute_info_ex(string2);
        if (attributeInfoEx.events != null) {
            tangoTreeNode = new TangoTreeNode(this.level + 1, this.type, "Archive Event", this.db, true);
            this.addNode(tangoTreeNode);
            tangoTreeNode.addNode(dbAttribute, "archive_abs_change", JiveUtils.convertEventString(attributeInfoEx.events.arch_event.abs_change));
            tangoTreeNode.addNode(dbAttribute, "archive_rel_change", JiveUtils.convertEventString(attributeInfoEx.events.arch_event.rel_change));
            tangoTreeNode.addNode(dbAttribute, "archive_period", attributeInfoEx.events.arch_event.period);
            stringArray = new TangoTreeNode(this.level + 1, this.type, "Change Event", this.db, true);
            this.addNode((TangoTreeNode)stringArray);
            stringArray.addNode(dbAttribute, "abs_change", JiveUtils.convertEventString(attributeInfoEx.events.ch_event.abs_change));
            stringArray.addNode(dbAttribute, "rel_change", JiveUtils.convertEventString(attributeInfoEx.events.ch_event.rel_change));
            TangoTreeNode tangoTreeNode2 = new TangoTreeNode(this.level + 1, this.type, "Periodic Event", this.db, true);
            this.addNode(tangoTreeNode2);
            tangoTreeNode2.addNode(dbAttribute, "event_period", attributeInfoEx.events.per_event.period);
        }
        tangoTreeNode = new TangoTreeNode(this.level + 1, this.type, "Alarms", this.db, true);
        this.addNode(tangoTreeNode);
        if (attributeInfoEx.alarms != null) {
            tangoTreeNode.addNode(dbAttribute, "min_alarm", attributeInfoEx.alarms.min_alarm);
            tangoTreeNode.addNode(dbAttribute, "max_alarm", attributeInfoEx.alarms.max_alarm);
            tangoTreeNode.addNode(dbAttribute, "min_warning", attributeInfoEx.alarms.min_warning);
            tangoTreeNode.addNode(dbAttribute, "max_warning", attributeInfoEx.alarms.max_warning);
            tangoTreeNode.addNode(dbAttribute, "delta_t", attributeInfoEx.alarms.delta_t);
            tangoTreeNode.addNode(dbAttribute, "delta_val", attributeInfoEx.alarms.delta_val);
        } else {
            tangoTreeNode.addNode(dbAttribute, "min_alarm", attributeInfoEx.min_alarm);
            tangoTreeNode.addNode(dbAttribute, "max_alarm", attributeInfoEx.max_alarm);
        }
        this.addNode(dbAttribute, "is_polled", null);
        this.addNode(dbAttribute, "polling_period", null);
        this.addNode(dbAttribute, "description", attributeInfoEx.description);
        this.addNode(dbAttribute, "label", attributeInfoEx.label);
        this.addNode(dbAttribute, "unit", attributeInfoEx.unit);
        this.addNode(dbAttribute, "standard_unit", attributeInfoEx.standard_unit);
        this.addNode(dbAttribute, "display_unit", attributeInfoEx.display_unit);
        this.addNode(dbAttribute, "format", attributeInfoEx.format);
        this.addNode(dbAttribute, "min_value", attributeInfoEx.min_value);
        this.addNode(dbAttribute, "max_value", attributeInfoEx.max_value);
        stringArray = dbAttribute.get_property_list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (JiveUtils.IsAttCfgItem(stringArray[i], this.idl) >= 0) continue;
            this.addNode(dbAttribute, stringArray[i], null);
        }
    }

    void constructClassNode() throws DevFailed {
        String string;
        String[] stringArray = null;
        String[] stringArray2 = null;
        try {
            string = "dserver/" + this.getParent().toString() + "/" + this.toString();
            DeviceProxy deviceProxy = new DeviceProxy(string);
            DeviceData deviceData = deviceProxy.command_inout("QueryClass");
            stringArray = deviceData.extractStringArray();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        string = new DbServer(this.getParent().toString() + "/" + this.toString());
        stringArray2 = string.get_class_list();
        if (stringArray != null) {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                this.addNode(new TangoTreeNode(this.level + 1, this.type, stringArray[n], this.db, true));
            }
            for (n = 0; n < stringArray2.length; ++n) {
                if (JiveUtils.contains(stringArray, stringArray2[n])) continue;
                this.addNode(new TangoTreeNode(this.level + 1, this.type, stringArray2[n], this.db, false));
            }
        } else {
            for (int i = 0; i < stringArray2.length; ++i) {
                this.addNode(new TangoTreeNode(this.level + 1, this.type, stringArray2[i], this.db, true));
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isLeaf() {
        switch (this.type) {
            case 1: {
                if (this.level == 4 && this.getParent().toString().equals("PROPERTY")) {
                    return true;
                }
                return this.level == 5 && this.getParent().getParent().toString().equals("ATTRIBUTE");
            }
            case 2: {
                return this.level >= 5;
            }
            case 3: {
                if (!(this.level != 5 || this.toString().equals("PROPERTY") || this.toString().equals("ATTRIBUTE") || this.toString().equals("COMMAND"))) {
                    return true;
                }
                if (this.level == 6 && this.getParent().toString().equals("PROPERTY")) {
                    return true;
                }
                if (this.level == 7 && this.getParent().getParent().toString().equals("ATTRIBUTE")) {
                    return !this.isAlarmCfgItem() && !this.isEventCfgItem();
                }
                if (this.level == 7 && this.getParent().getParent().toString().equals("COMMAND")) {
                    return true;
                }
                return this.level == 8 && this.getParent().getParent().getParent().toString().equals("ATTRIBUTE");
            }
            case 4: {
                return this.level == 3;
            }
            case 5: {
                return this.level >= 2;
            }
        }
        return false;
    }

    public boolean isDeviceNode() {
        return this.toString().equals("PROPERTY") || this.toString().equals("ATTRIBUTE") || this.toString().equals("COMMAND");
    }

    public boolean isPollCfgItem() {
        return JiveUtils.IsPollCfgItem(this.toString());
    }

    public boolean isAttCfgItem() {
        return JiveUtils.IsAttCfgItem(this.toString(), this.idl) != -1;
    }

    public boolean isAlarmCfgItem() {
        return JiveUtils.IsAlarmCfgItem(this.toString());
    }

    public boolean isEventCfgItem() {
        return JiveUtils.IsEventCfgItem(this.toString());
    }

    public boolean isSystemItem() {
        return JiveUtils.IsSystemItem(this.toString());
    }

    public boolean isLogCfgItem() {
        return JiveUtils.IsLogCfgItem(this.toString());
    }

    public boolean isCopiableItem() {
        return !this.isLogCfgItem() && !this.isPollCfgItem() && !this.isSystemItem() && !this.isAlarmCfgItem() && !this.isEventCfgItem();
    }

    public int getChildCount() {
        if (!this.areChildrenDefined) {
            this.defineChildNodes();
        }
        return super.getChildCount();
    }

    public Database getDB() {
        return this.db;
    }

    private void defineChildNodes() {
        block60: {
            int n;
            String[] stringArray;
            block58: {
                block59: {
                    this.areChildrenDefined = true;
                    if (this.level != 0) break block59;
                    this.add(new TangoTreeNode(1, 1, "CLASS", this.db, true));
                    this.add(new TangoTreeNode(1, 2, "SERVER", this.db, true));
                    this.add(new TangoTreeNode(1, 3, "DEVICE", this.db, true));
                    this.add(new TangoTreeNode(1, 4, "PROPERTY", this.db, true));
                    this.add(new TangoTreeNode(1, 5, "ALIAS", this.db, true));
                    break block60;
                }
                if (this.db == null) break block60;
                stringArray = null;
                try {
                    block6 : switch (this.type) {
                        case 1: {
                            DeviceProxy deviceProxy;
                            String[] stringArray2;
                            try {
                                switch (this.level) {
                                    case 1: {
                                        stringArray = this.db.get_class_list("*");
                                        break block6;
                                    }
                                    case 2: {
                                        stringArray = new String[]{"PROPERTY", "ATTRIBUTE"};
                                        break block6;
                                    }
                                    case 3: {
                                        if (this.toString().equals("PROPERTY")) {
                                            stringArray = this.db.get_class_property_list(this.getParent().toString(), "*");
                                            break block6;
                                        }
                                        stringArray = this.db.get_class_attribute_list(this.getParent().toString(), "*");
                                        break block6;
                                    }
                                    case 4: {
                                        stringArray2 = new String[]{this.toString()};
                                        deviceProxy = this.db.get_class_attribute_property(this.getParent().getParent().toString(), stringArray2);
                                        if (((String[])deviceProxy).length <= 0) break;
                                        stringArray = deviceProxy[0].get_property_list();
                                    }
                                }
                            }
                            catch (DevFailed devFailed) {
                                JiveUtils.showTangoError(devFailed);
                            }
                            break;
                        }
                        case 2: {
                            String[] stringArray2;
                            try {
                                switch (this.level) {
                                    case 1: {
                                        stringArray = this.db.get_server_name_list();
                                        break block6;
                                    }
                                    case 2: {
                                        stringArray = this.db.get_instance_name_list(this.toString());
                                        break block6;
                                    }
                                    case 3: {
                                        this.constructClassNode();
                                        return;
                                    }
                                    case 4: {
                                        stringArray2 = new DbServer(this.getParent().getParent().toString() + "/" + this.getParent().toString());
                                        stringArray = stringArray2.get_device_name(this.toString());
                                    }
                                }
                            }
                            catch (DevFailed devFailed) {
                                JiveUtils.showTangoError(devFailed);
                            }
                            break;
                        }
                        case 3: {
                            DeviceProxy deviceProxy;
                            String[] stringArray2;
                            try {
                                switch (this.level) {
                                    case 1: {
                                        stringArray = this.db.get_device_domain("*");
                                        break;
                                    }
                                    case 2: {
                                        stringArray = this.db.get_device_family(this.toString() + "/*");
                                        break;
                                    }
                                    case 3: {
                                        stringArray = this.db.get_device_member(this.getParent().toString() + "/" + this.toString() + "/*");
                                        break;
                                    }
                                    case 4: {
                                        stringArray2 = this.getParent().getParent().toString();
                                        stringArray = stringArray2.equalsIgnoreCase("dserver") ? new String[11] : new String[10];
                                        stringArray[0] = "poll_old_factor";
                                        stringArray[1] = "poll_ring_depth";
                                        stringArray[2] = "logging_level";
                                        stringArray[3] = "current_logging_level";
                                        stringArray[4] = "logging_target";
                                        stringArray[5] = "current_logging_target";
                                        stringArray[6] = "logging_rft";
                                        if (stringArray.length == 11) {
                                            stringArray[7] = "logging_path";
                                            stringArray[8] = "PROPERTY";
                                            stringArray[9] = "ATTRIBUTE";
                                            stringArray[10] = "COMMAND";
                                            break;
                                        }
                                        stringArray[7] = "PROPERTY";
                                        stringArray[8] = "ATTRIBUTE";
                                        stringArray[9] = "COMMAND";
                                        break;
                                    }
                                    case 5: {
                                        Object[] objectArray;
                                        String string = this.getDevname(1);
                                        if (this.toString().equals("PROPERTY")) {
                                            deviceProxy = this.db.get_device_property_list(string, "*");
                                            objectArray = new boolean[((String[])deviceProxy).length];
                                            int n2 = 0;
                                            int n3 = 0;
                                            for (n = 0; n < ((DeviceProxy)deviceProxy).length; ++n) {
                                                boolean bl = objectArray[n] = JiveUtils.IsPollCfgItem((String)deviceProxy[n]) || JiveUtils.IsLogCfgItem((String)deviceProxy[n]);
                                                if (objectArray[n]) continue;
                                                ++n2;
                                            }
                                            stringArray = new String[n2];
                                            for (n = 0; n < ((DeviceProxy)deviceProxy).length; ++n) {
                                                if (objectArray[n]) continue;
                                                stringArray[n3++] = deviceProxy[n];
                                            }
                                            JiveUtils.sortList(stringArray, null, this.idl);
                                            break;
                                        }
                                        if (this.toString().equals("ATTRIBUTE")) {
                                            deviceProxy = new DeviceProxy(string);
                                            stringArray = deviceProxy.get_attribute_list();
                                            this.idl = deviceProxy.get_idl_version();
                                            break;
                                        }
                                        if (this.toString().equals("COMMAND")) {
                                            deviceProxy = new DeviceProxy(string);
                                            objectArray = deviceProxy.command_list_query();
                                            stringArray = new String[objectArray.length];
                                            for (n = 0; n < objectArray.length; ++n) {
                                                stringArray[n] = objectArray[n].cmd_name;
                                            }
                                            break block58;
                                        }
                                        break block58;
                                    }
                                    case 6: {
                                        String string = this.getDevname(2);
                                        if (this.getParent().toString().equals("ATTRIBUTE")) {
                                            this.constructAttNode(string, this.toString());
                                            return;
                                        }
                                        if (this.getParent().toString().equals("COMMAND")) {
                                            stringArray = new String[]{"is_polled", "polling_period"};
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break;
                            }
                            catch (DevFailed devFailed) {
                                JiveUtils.showTangoError(devFailed);
                                break;
                            }
                        }
                        case 4: {
                            try {
                                switch (this.level) {
                                    case 1: {
                                        stringArray = this.db.get_object_list("*");
                                        break block6;
                                    }
                                    case 2: {
                                        stringArray = this.db.get_object_property_list(this.toString(), "*");
                                    }
                                }
                            }
                            catch (DevFailed devFailed) {
                                JiveUtils.showTangoError(devFailed);
                            }
                            break;
                        }
                        case 5: {
                            try {
                                switch (this.level) {
                                    case 1: {
                                        stringArray = this.db.get_device_alias_list("*");
                                    }
                                }
                                break;
                            }
                            catch (DevFailed devFailed) {
                                JiveUtils.showTangoError(devFailed);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception);
                    exception.printStackTrace();
                }
            }
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    this.addNode(new TangoTreeNode(this.level + 1, this.type, stringArray[n], this.db, true));
                }
            }
        }
    }

    public String[] getValue() {
        String[] stringArray;
        String string;
        String string2;
        block118: {
            block117: {
                string2 = "";
                string = "...";
                stringArray = new String[2];
                if (this.db != null) break block117;
                string2 = "No connection to database server.";
                break block118;
            }
            switch (this.type) {
                case 0: {
                    string = "Database info";
                    try {
                        string2 = this.db.get_info();
                        break;
                    }
                    catch (DevFailed devFailed) {
                        for (int i = 0; i < devFailed.errors.length; ++i) {
                            string2 = string2 + "Desc -> " + devFailed.errors[i].desc + "\n";
                            string2 = string2 + "Reason -> " + devFailed.errors[i].reason + "\n";
                            string2 = string2 + "Origin -> " + devFailed.errors[i].origin + "\n";
                        }
                        break;
                    }
                }
                case 1: {
                    String[] stringArray2;
                    if (this.level == 4 && this.getParent().toString().equals("PROPERTY")) {
                        try {
                            stringArray2 = this.db.get_class_property(this.getParent().getParent().toString(), this.toString()).extractStringArray();
                            string2 = JiveUtils.stringArrayToString(stringArray2);
                            string = "Property value";
                            if (stringArray2.length >= 2) {
                                string = string + " [" + stringArray2.length + " items]";
                            }
                        }
                        catch (Exception exception) {
                            System.out.println(exception);
                            exception.printStackTrace();
                        }
                    }
                    if (this.level != 5 || !this.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                    try {
                        stringArray2 = new String[]{this.getParent().toString()};
                        DbAttribute[] dbAttributeArray = this.db.get_class_attribute_property(this.getParent().getParent().getParent().toString(), stringArray2);
                        if (dbAttributeArray != null && dbAttributeArray.length > 0) {
                            string2 = string2 + dbAttributeArray[0].get_string_value(this.toString());
                        }
                        string = "Property value";
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                        exception.printStackTrace();
                    }
                    break;
                }
                case 2: 
                case 3: {
                    int n;
                    String[] stringArray3;
                    DbDevImportInfo dbDevImportInfo;
                    Object object;
                    Object object2;
                    if (this.type == 3 && this.level == 4 || this.type == 2 && this.level == 5) {
                        try {
                            try {
                                string2 = "- Device Info ----------------------------------------\n\n";
                                object2 = this.type == 2 ? this.toString() : this.getDevname(0);
                                object = new DeviceProxy((String)object2);
                                dbDevImportInfo = object.import_device();
                                string2 = string2 + dbDevImportInfo.toString();
                                string2 = string2 + "\n\n- Polling Status -------------------------------------\n\n";
                                stringArray3 = object.polling_status();
                                for (n = 0; n < stringArray3.length; ++n) {
                                    string2 = string2 + stringArray3[n] + "\n\n";
                                }
                                string = "Device info";
                            }
                            catch (DevFailed devFailed) {
                                for (n = 0; n < devFailed.errors.length; ++n) {
                                    string2 = string2 + "Desc -> " + devFailed.errors[n].desc + "\n";
                                    string2 = string2 + "Reason -> " + devFailed.errors[n].reason + "\n";
                                    string2 = string2 + "Origin -> " + devFailed.errors[n].origin + "\n";
                                }
                            }
                        }
                        catch (Exception exception) {
                            System.out.println(exception);
                            exception.printStackTrace();
                        }
                    }
                    if (this.type == 2 && this.level == 3) {
                        try {
                            try {
                                object2 = new DbServer(this.toString());
                                object = object2.get_info();
                                string2 = object.toString();
                                string = "Server info";
                            }
                            catch (DevFailed devFailed) {
                                for (n = 0; n < devFailed.errors.length; ++n) {
                                    string2 = string2 + "Desc -> " + devFailed.errors[n].desc + "\n";
                                    string2 = string2 + "Reason -> " + devFailed.errors[n].reason + "\n";
                                    string2 = string2 + "Origin -> " + devFailed.errors[n].origin + "\n";
                                }
                            }
                        }
                        catch (Exception exception) {
                            System.out.println(exception);
                            exception.printStackTrace();
                        }
                    }
                    if (this.type == 2) break;
                    if (this.level == 5 && !this.isDeviceNode()) {
                        object2 = null;
                        object = this.getDevname(1);
                        if (this.isPollCfgItem()) {
                            string = "Polling configuration property";
                        } else if (this.isLogCfgItem()) {
                            string = "Logging configuration property";
                        }
                        try {
                            if (this.toString().equals("current_logging_level")) {
                                object2 = JiveUtils.getLoggingStatus(this.db, (String)object, 0);
                                string2 = JiveUtils.stringArrayToString(object2);
                            } else if (this.toString().equals("current_logging_target")) {
                                object2 = JiveUtils.getLoggingStatus(this.db, (String)object, 1);
                                string2 = JiveUtils.stringArrayToString(object2);
                            } else {
                                object2 = this.db.get_device_property((String)object, this.toString()).extractStringArray();
                                string2 = JiveUtils.stringArrayToString(object2);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (object2 == null || ((String)object2).length == 0) {
                            if (this.toString().equals("poll_old_factor")) {
                                string2 = "4";
                            } else if (this.toString().equals("poll_ring_depth")) {
                                string2 = "10";
                            } else if (this.toString().equals("logging_rft")) {
                                string2 = "2";
                            }
                        } else if (((String)object2).length >= 2) {
                            string = string + " [" + ((String[])object2).length + " items]";
                        }
                    }
                    if (this.level == 6 && this.getParent().toString().equals("PROPERTY")) {
                        try {
                            string = this.isSystemItem() ? "System property" : "Property value";
                            object2 = this.getDevname(2);
                            object = this.db.get_device_property((String)object2, this.toString()).extractStringArray();
                            string2 = JiveUtils.stringArrayToString((String[])object);
                            if (object != null && ((DeviceProxy)object).length >= 2) {
                                string = string + " [" + ((DeviceProxy)object).length + " items]";
                            }
                        }
                        catch (Exception exception) {
                            System.out.println(exception);
                            exception.printStackTrace();
                        }
                    }
                    if (this.level == 6 && this.getParent().toString().equals("ATTRIBUTE")) {
                        object2 = this.getDevname(2);
                        try {
                            string2 = string2 + "- Attribute Info -------------------------------------\n\n";
                            object = new DeviceProxy((String)object2);
                            dbDevImportInfo = object.get_attribute_info(this.toString());
                            string2 = string2 + "Data type:     " + TangoConst.Tango_CmdArgTypeName[dbDevImportInfo.data_type] + "\n";
                            string2 = string2 + "Data format:   " + AttributePanel.getFormatString((AttributeInfo)dbDevImportInfo) + "\n";
                            string2 = string2 + "Display level: " + dbDevImportInfo.level + "\n";
                            string2 = string2 + "Writable:      " + AttributePanel.getWriteString((AttributeInfo)dbDevImportInfo) + "\n";
                            string2 = string2 + "Writable name: " + dbDevImportInfo.writable_attr_name + "\n";
                            if (dbDevImportInfo.extensions.length > 0) {
                                for (n = 0; n < dbDevImportInfo.extensions.length; ++n) {
                                    string2 = string2 + "Extension " + n + "  :" + dbDevImportInfo.extensions[0] + "\n";
                                }
                            } else {
                                string2 = string2 + "No extensions.\n";
                            }
                        }
                        catch (DevFailed devFailed) {
                            // empty catch block
                        }
                        string2 = string2 + "\n\n- Polling Status -------------------------------------\n\n";
                        object = JiveUtils.getPollingStatus((String)object2, this.toString(), "attribute", 4);
                        string2 = object == null ? string2 + "The attribute is not polled" : string2 + (String)object;
                        string = "Attribute info";
                    }
                    if (this.level == 7 && this.getParent().getParent().toString().equals("ATTRIBUTE")) {
                        try {
                            object2 = this.toString();
                            if (object2.equals("is_polled")) {
                                string2 = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "attribute", 1);
                                string2 = string2 == null ? "No" : "Yes";
                                string = "Polling configuration property";
                            } else if (object2.equals("polling_period")) {
                                string2 = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "attribute", 2);
                                if (string2 == null) {
                                    string2 = "";
                                }
                                string = "Polling configuration property";
                            } else if (!JiveUtils.IsAlarmCfgItem(this.toString()) && !JiveUtils.IsEventCfgItem(this.toString())) {
                                object = this.getDevname(3);
                                int n2 = JiveUtils.IsAttCfgItem(this.toString(), this.idl);
                                if (n2 < 0) {
                                    stringArray3 = new String[]{this.getParent().toString()};
                                    DbAttribute[] dbAttributeArray = this.db.get_device_attribute_property((String)object, stringArray3);
                                    if (dbAttributeArray != null && dbAttributeArray.length > 0) {
                                        string2 = string2 + dbAttributeArray[0].get_string_value(this.toString());
                                    }
                                    string = "Property value";
                                } else {
                                    stringArray3 = new DeviceProxy((String)object);
                                    AttributeInfoEx attributeInfoEx = stringArray3.get_attribute_info_ex(this.getParent().toString());
                                    switch (n2) {
                                        case 0: {
                                            string2 = string2 + attributeInfoEx.description;
                                            break;
                                        }
                                        case 1: {
                                            string2 = string2 + attributeInfoEx.label;
                                            break;
                                        }
                                        case 2: {
                                            string2 = string2 + attributeInfoEx.unit;
                                            break;
                                        }
                                        case 3: {
                                            string2 = string2 + attributeInfoEx.standard_unit;
                                            break;
                                        }
                                        case 4: {
                                            string2 = string2 + attributeInfoEx.display_unit;
                                            break;
                                        }
                                        case 5: {
                                            string2 = string2 + attributeInfoEx.format;
                                            break;
                                        }
                                        case 6: {
                                            string2 = string2 + attributeInfoEx.min_value;
                                            break;
                                        }
                                        case 7: {
                                            string2 = string2 + attributeInfoEx.max_value;
                                        }
                                    }
                                    string = "Attribute configuration property";
                                }
                            }
                        }
                        catch (Exception exception) {
                            System.out.println(exception);
                            exception.printStackTrace();
                        }
                    }
                    if (this.level == 8 && this.getParent().getParent().getParent().toString().equals("ATTRIBUTE")) {
                        object2 = this.getDevname(4);
                        string = "Attribute configuration property";
                        try {
                            object = new DeviceProxy((String)object2);
                            AttributeInfoEx attributeInfoEx = object.get_attribute_info_ex(this.getParent().getParent().toString());
                            int n3 = JiveUtils.IsAttCfgItem(this.toString(), this.idl);
                            switch (n3) {
                                case 8: {
                                    string2 = string2 + attributeInfoEx.min_alarm;
                                    break;
                                }
                                case 9: {
                                    string2 = string2 + attributeInfoEx.max_alarm;
                                    break;
                                }
                                case 10: {
                                    if (attributeInfoEx.alarms != null) {
                                        string2 = string2 + attributeInfoEx.alarms.min_warning;
                                    }
                                    break;
                                }
                                case 11: {
                                    if (attributeInfoEx.alarms != null) {
                                        string2 = string2 + attributeInfoEx.alarms.max_warning;
                                    }
                                    break;
                                }
                                case 12: {
                                    if (attributeInfoEx.alarms != null) {
                                        string2 = string2 + attributeInfoEx.alarms.delta_t;
                                    }
                                    break;
                                }
                                case 13: {
                                    if (attributeInfoEx.alarms != null) {
                                        string2 = string2 + attributeInfoEx.alarms.delta_val;
                                    }
                                    break;
                                }
                                case 14: {
                                    if (attributeInfoEx.events != null) {
                                        string2 = string2 + attributeInfoEx.events.ch_event.rel_change;
                                    }
                                    break;
                                }
                                case 15: {
                                    if (attributeInfoEx.events != null) {
                                        string2 = string2 + attributeInfoEx.events.ch_event.abs_change;
                                    }
                                    break;
                                }
                                case 16: {
                                    if (attributeInfoEx.events != null) {
                                        string2 = string2 + attributeInfoEx.events.per_event.period;
                                    }
                                    break;
                                }
                                case 17: {
                                    if (attributeInfoEx.events != null) {
                                        string2 = string2 + attributeInfoEx.events.arch_event.abs_change;
                                    }
                                    break;
                                }
                                case 18: {
                                    if (attributeInfoEx.events != null) {
                                        string2 = string2 + attributeInfoEx.events.arch_event.rel_change;
                                    }
                                    break;
                                }
                                case 19: {
                                    if (attributeInfoEx.events != null) {
                                        string2 = string2 + attributeInfoEx.events.arch_event.period;
                                    }
                                    break;
                                }
                                default: {
                                    string2 = "Not supported property :" + this.toString();
                                    break;
                                }
                            }
                        }
                        catch (Exception exception) {
                            System.out.println(exception);
                            exception.printStackTrace();
                        }
                    }
                    if (this.level == 6 && this.getParent().toString().equals("COMMAND")) {
                        string2 = JiveUtils.getPollingStatus(this.getDevname(2), this.toString(), "command", 4);
                        if (string2 == null) {
                            string2 = "The command is not polled";
                        }
                        string = "Command info";
                    }
                    if (this.level != 7 || !this.getParent().getParent().toString().equals("COMMAND")) break;
                    if (this.toString().equals("is_polled")) {
                        string2 = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "command", 1);
                        string2 = string2 == null ? "No" : "Yes";
                    } else if (this.toString().equals("polling_period") && (string2 = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "command", 2)) == null) {
                        string2 = "";
                    }
                    string = "Polling configuration property";
                    break;
                }
                case 4: {
                    if (this.level != 3) break;
                    try {
                        String[] stringArray4 = this.db.get_property(this.getParent().toString(), this.toString()).extractStringArray();
                        string2 = JiveUtils.stringArrayToString(stringArray4);
                        string = "Property value";
                        if (stringArray4.length < 2) break;
                        string = string + " [" + stringArray4.length + " items]";
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                        exception.printStackTrace();
                    }
                    break;
                }
                case 5: {
                    if (this.level != 2) break;
                    try {
                        String string3 = this.toString();
                        DbDevice dbDevice = new DbDevice(string3);
                        DbDevImportInfo dbDevImportInfo = dbDevice.import_device();
                        string2 = dbDevImportInfo.toString();
                        string = "Device info";
                        break;
                    }
                    catch (DevFailed devFailed) {
                        for (int i = 0; i < devFailed.errors.length; ++i) {
                            string2 = string2 + "Desc -> " + devFailed.errors[i].desc + "\n";
                            string2 = string2 + "Reason -> " + devFailed.errors[i].reason + "\n";
                            string2 = string2 + "Origin -> " + devFailed.errors[i].origin + "\n";
                        }
                        break;
                    }
                }
            }
        }
        stringArray[0] = string2;
        stringArray[1] = string;
        return stringArray;
    }

    public boolean setValue(String string) {
        switch (this.type) {
            case 1: {
                if (this.level == 2 && string.equals("%")) {
                    String string2 = this.toString();
                    int n = JOptionPane.showConfirmDialog(JiveUtils.parent, "This will erase all class and attribute properties for " + string2 + "\n Do you want to continue ?", "Confirm delete class properties", 0);
                    if (n == 0) {
                        return JiveUtils.removeClassProperties(this.db, string2);
                    }
                    return false;
                }
                if (this.level == 4 && this.getParent().toString().equals("PROPERTY")) {
                    try {
                        if (string.equals("%")) {
                            this.db.delete_class_property(this.getParent().getParent().toString(), JiveUtils.makeDbDatum(this.toString(), string));
                        } else {
                            this.db.put_class_property(this.getParent().getParent().toString(), JiveUtils.makeDbDatum(this.toString(), string));
                        }
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                        return false;
                    }
                }
                if (this.level != 5 || !this.getParent().getParent().toString().equals("ATTRIBUTE")) break;
                try {
                    String string3 = this.getParent().getParent().getParent().toString();
                    DbAttribute dbAttribute = new DbAttribute(this.getParent().toString());
                    dbAttribute.add(this.toString(), string);
                    if (!string.equals("%")) {
                        this.db.put_class_attribute_property(string3, dbAttribute);
                        break;
                    }
                    this.db.delete_class_attribute_property(string3, this.getParent().toString(), this.toString());
                    break;
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                    return false;
                }
            }
            case 2: {
                if (this.level == 3 && string.equals("%")) {
                    try {
                        this.db.delete_server(this.getParent().toString() + "/" + this.toString());
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                        return false;
                    }
                }
                if (this.level == 4) {
                    try {
                        if (string.equals("%")) {
                            for (int i = 0; i < this.getChildCount(); ++i) {
                                this.db.delete_device(this.getChildAt(i).toString());
                            }
                        }
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                        return false;
                    }
                }
                if (this.level != 5) break;
                try {
                    if (string.equals("%")) {
                        this.db.delete_device(this.toString());
                        break;
                    }
                    this.db.add_device(this.toString(), this.getParent().toString(), this.getParent().getParent().getParent().toString() + "/" + this.getParent().getParent().toString());
                    break;
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                    return false;
                }
            }
            case 3: {
                AttributeInfo[] attributeInfoArray;
                AttributeInfo attributeInfo;
                Object object;
                int n;
                String string4;
                if (this.level == 4 && string.equals("%")) {
                    String string5 = this.getDevname(0);
                    int n2 = JOptionPane.showConfirmDialog(JiveUtils.parent, "This will erase all device and attribute properties for " + string5 + "\n Do you want to continue ?\nHint: To remove the device itself from the database,\ngo to the server node and delete the device\nfrom its class.", "Confirm delte device properties", 0);
                    if (n2 == 0) {
                        return JiveUtils.removeDeviceProperties(this.db, string5);
                    }
                    return false;
                }
                if (this.level == 5 && !this.isDeviceNode()) {
                    string4 = this.getDevname(1);
                    try {
                        if (this.toString().equals("current_logging_target")) {
                            return JiveUtils.setLoggingTarget(this.db, string4, string);
                        }
                        if (this.toString().equals("current_logging_level")) {
                            return JiveUtils.setLoggingLevel(this.db, string4, string);
                        }
                        if (string.equals("%")) {
                            this.db.delete_device_property(string4, JiveUtils.makeDbDatum(this.toString(), string));
                        } else {
                            this.db.put_device_property(string4, JiveUtils.makeDbDatum(this.toString(), string));
                        }
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                        return false;
                    }
                }
                if (this.level == 6 && this.getParent().toString().equals("PROPERTY")) {
                    try {
                        string4 = this.getDevname(2);
                        if (string.equals("%")) {
                            this.db.delete_device_property(string4, JiveUtils.makeDbDatum(this.toString(), string));
                        } else {
                            this.db.put_device_property(string4, JiveUtils.makeDbDatum(this.toString(), string));
                        }
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                        return false;
                    }
                }
                if (this.level == 7 && this.getParent().getParent().toString().equals("ATTRIBUTE")) {
                    try {
                        string4 = this.getDevname(3);
                        n = JiveUtils.IsAttCfgItem(this.toString(), this.idl);
                        if (this.isPollCfgItem()) {
                            object = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "attribute", 2);
                            if (this.toString().equals("is_polled")) {
                                if (string.equalsIgnoreCase("yes")) {
                                    if (object == null) {
                                        JiveUtils.addPolling(string4, this.getParent().toString(), "attribute", "3000");
                                    }
                                } else if (object != null) {
                                    JiveUtils.remPolling(string4, this.getParent().toString(), "attribute");
                                }
                            } else if (this.toString().equals("polling_period") && string.length() > 0) {
                                if (object == null) {
                                    JiveUtils.addPolling(string4, this.getParent().toString(), "attribute", string);
                                } else {
                                    JiveUtils.addPolling(string4, this.getParent().toString(), "attribute", string);
                                }
                            }
                        } else if (n >= 0) {
                            object = new DeviceProxy(string4);
                            attributeInfo = object.get_attribute_info(this.getParent().toString());
                            switch (n) {
                                case 0: {
                                    attributeInfo.description = string;
                                    break;
                                }
                                case 1: {
                                    attributeInfo.label = string;
                                    break;
                                }
                                case 2: {
                                    attributeInfo.unit = string;
                                    break;
                                }
                                case 3: {
                                    attributeInfo.standard_unit = string;
                                    break;
                                }
                                case 4: {
                                    attributeInfo.display_unit = string;
                                    break;
                                }
                                case 5: {
                                    attributeInfo.format = string;
                                    break;
                                }
                                case 6: {
                                    attributeInfo.min_value = string;
                                    break;
                                }
                                case 7: {
                                    attributeInfo.max_value = string;
                                }
                            }
                            attributeInfoArray = new AttributeInfo[]{attributeInfo};
                            object.set_attribute_info(attributeInfoArray);
                        } else {
                            object = new DbAttribute(this.getParent().toString());
                            object.add(this.toString(), string);
                            if (string.equals("%")) {
                                this.db.delete_device_attribute_property(string4, (DbAttribute)object);
                            } else {
                                this.db.put_device_attribute_property(string4, (DbAttribute)object);
                            }
                        }
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                        return false;
                    }
                }
                if (this.level == 8 && this.getParent().getParent().getParent().toString().equals("ATTRIBUTE")) {
                    try {
                        string4 = this.getDevname(4);
                        n = JiveUtils.IsAttCfgItem(this.toString(), this.idl);
                        if (n >= 0) {
                            object = new DeviceProxy(string4);
                            attributeInfo = object.get_attribute_info_ex(this.getParent().getParent().toString());
                            if ((attributeInfo.alarms == null || attributeInfo.events == null) && n > 9) {
                                JiveUtils.showJiveError("The attribute property " + this.toString() + " is not supported by the device.");
                                return false;
                            }
                            switch (n) {
                                case 8: {
                                    attributeInfo.min_alarm = string;
                                    if (attributeInfo.alarms == null) break;
                                    attributeInfo.alarms.min_alarm = string;
                                    break;
                                }
                                case 9: {
                                    attributeInfo.max_alarm = string;
                                    if (attributeInfo.alarms == null) break;
                                    attributeInfo.alarms.max_alarm = string;
                                    break;
                                }
                                case 10: {
                                    attributeInfo.alarms.min_warning = string;
                                    break;
                                }
                                case 11: {
                                    attributeInfo.alarms.max_warning = string;
                                    break;
                                }
                                case 12: {
                                    attributeInfo.alarms.delta_t = string;
                                    break;
                                }
                                case 13: {
                                    attributeInfo.alarms.delta_val = string;
                                    break;
                                }
                                case 14: {
                                    attributeInfo.events.ch_event.rel_change = string;
                                    break;
                                }
                                case 15: {
                                    attributeInfo.events.ch_event.abs_change = string;
                                    break;
                                }
                                case 16: {
                                    attributeInfo.events.per_event.period = string;
                                    break;
                                }
                                case 17: {
                                    attributeInfo.events.arch_event.abs_change = string;
                                    break;
                                }
                                case 18: {
                                    attributeInfo.events.arch_event.rel_change = string;
                                    break;
                                }
                                case 19: {
                                    attributeInfo.events.arch_event.period = string;
                                    break;
                                }
                                default: {
                                    JiveUtils.showJiveError("Unexpected property : " + this.toString());
                                }
                            }
                            attributeInfoArray = new AttributeInfoEx[]{attributeInfo};
                            object.set_attribute_info((AttributeInfoEx[])attributeInfoArray);
                        }
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                        return false;
                    }
                }
                if (this.level != 7 || !this.getParent().getParent().toString().equals("COMMAND")) break;
                try {
                    string4 = this.getDevname(3);
                    if (!this.isPollCfgItem()) break;
                    String string6 = JiveUtils.getPollingStatus(this.getDevname(3), this.getParent().toString(), "command", 2);
                    if (this.toString().equals("is_polled")) {
                        if (string.equalsIgnoreCase("yes")) {
                            if (string6 != null) break;
                            JiveUtils.addPolling(string4, this.getParent().toString(), "command", "3000");
                            break;
                        }
                        if (string6 == null) break;
                        JiveUtils.remPolling(string4, this.getParent().toString(), "command");
                        break;
                    }
                    if (!this.toString().equals("polling_period")) break;
                    if (string6 == null) {
                        JiveUtils.addPolling(string4, this.getParent().toString(), "command", string);
                        break;
                    }
                    JiveUtils.addPolling(string4, this.getParent().toString(), "command", string);
                    break;
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                    return false;
                }
            }
            case 4: {
                if (this.level != 3) break;
                try {
                    if (string.equals("%")) {
                        this.db.delete_property(this.getParent().toString(), this.toString());
                        break;
                    }
                    this.db.put_property(this.getParent().toString(), JiveUtils.makeDbDatum(this.toString(), string));
                    break;
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                    return false;
                }
            }
        }
        return true;
    }

    public String getDevname(int n) {
        TreeNode treeNode = this;
        for (int i = 0; i < n; ++i) {
            treeNode = treeNode.getParent();
        }
        return treeNode.getParent().getParent().toString() + "/" + treeNode.getParent().toString() + "/" + treeNode.toString();
    }

    public void saveServerData(FileWriter fileWriter) throws IOException {
        String string = this.getParent().toString() + "/" + this.toString();
        try {
            DbServer dbServer = new DbServer(string);
            String[] stringArray = dbServer.get_class_list();
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                boolean bl;
                DbAttribute[] dbAttributeArray;
                String[] stringArray2;
                String[] stringArray3;
                int n2;
                String[] stringArray4;
                if (!JiveUtils.isSavedClass(stringArray[i])) {
                    fileWriter.write("#---------------------------------------------------------\n");
                    fileWriter.write("# CLASS " + stringArray[i] + " properties\n");
                    fileWriter.write("#---------------------------------------------------------\n\n");
                    stringArray4 = this.db.get_class_property_list(stringArray[i], "*");
                    for (n2 = 0; n2 < stringArray4.length; ++n2) {
                        stringArray3 = this.db.get_class_property(stringArray[i], stringArray4[n2]).extractStringArray();
                        if (stringArray4[n2].indexOf(32) != -1) {
                            stringArray4[n2] = "\"" + stringArray4[n2] + "\"";
                        }
                        JiveUtils.printFormatedRes("CLASS/" + stringArray[i] + "->" + stringArray4[n2] + ": ", stringArray3, fileWriter);
                    }
                    stringArray2 = this.db.get_class_attribute_list(stringArray[i], "*");
                    dbAttributeArray = this.db.get_class_attribute_property(stringArray[i], stringArray2);
                    bl = false;
                    for (n = 0; n < dbAttributeArray.length; ++n) {
                        stringArray4 = dbAttributeArray[n].get_property_list();
                        for (n2 = 0; n2 < stringArray4.length; ++n2) {
                            if (!bl) {
                                fileWriter.write("\n# CLASS " + stringArray[i] + " attribute properties\n\n");
                                bl = true;
                            }
                            if (stringArray4[n2].indexOf(32) != -1) {
                                stringArray4[n2] = "\"" + stringArray4[n2] + "\"";
                            }
                            stringArray3 = dbAttributeArray[n].get_value(n2);
                            JiveUtils.printFormatedRes("CLASS/" + stringArray[i] + "/" + stringArray2[n] + "->" + stringArray4[n2] + ": ", stringArray3, fileWriter);
                        }
                    }
                    fileWriter.write("\n");
                    JiveUtils.addSavedClass(stringArray[i]);
                }
                fileWriter.write("#---------------------------------------------------------\n");
                fileWriter.write("# SERVER " + string + ", " + stringArray[i] + " device declaration\n");
                fileWriter.write("#---------------------------------------------------------\n\n");
                stringArray3 = dbServer.get_device_name(stringArray[i]);
                JiveUtils.printFormatedRes(string + "/DEVICE/" + stringArray[i] + ": ", stringArray3, fileWriter);
                fileWriter.write("\n");
                for (int j = 0; j < stringArray3.length; ++j) {
                    String[] stringArray5;
                    stringArray4 = this.db.get_device_property_list(stringArray3[j], "*");
                    if (stringArray4.length > 0) {
                        fileWriter.write("\n# --- " + stringArray3[j] + " properties\n\n");
                        for (n2 = 0; n2 < stringArray4.length; ++n2) {
                            stringArray5 = this.db.get_device_property(stringArray3[j], stringArray4[n2]).extractStringArray();
                            if (stringArray4[n2].indexOf(32) != -1) {
                                stringArray4[n2] = "\"" + stringArray4[n2] + "\"";
                            }
                            JiveUtils.printFormatedRes(stringArray3[j] + "->" + stringArray4[n2] + ": ", stringArray5, fileWriter);
                        }
                    }
                    try {
                        stringArray5 = new DeviceProxy(stringArray3[j]);
                        stringArray2 = stringArray5.get_attribute_list();
                        dbAttributeArray = this.db.get_device_attribute_property(stringArray3[j], stringArray2);
                        bl = false;
                        for (n = 0; n < dbAttributeArray.length; ++n) {
                            stringArray4 = dbAttributeArray[n].get_property_list();
                            for (n2 = 0; n2 < stringArray4.length; ++n2) {
                                if (!bl) {
                                    fileWriter.write("\n# --- " + stringArray3[j] + " attribute properties\n\n");
                                    bl = true;
                                }
                                if (stringArray4[n2].indexOf(32) != -1) {
                                    stringArray4[n2] = "\"" + stringArray4[n2] + "\"";
                                }
                                String[] stringArray6 = dbAttributeArray[n].get_value(n2);
                                JiveUtils.printFormatedRes(stringArray3[j] + "/" + stringArray2[n] + "->" + stringArray4[n2] + ": ", stringArray6, fileWriter);
                            }
                        }
                        continue;
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showJiveError("Attribute properties for " + stringArray3[j] + " has not been saved !\n" + devFailed.errors[0].desc);
                    }
                }
                fileWriter.write("\n");
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    public void editProperties(String string) {
        int n = this.getChildCount();
        if (n > 0) {
            Serializable serializable;
            TreePath[] treePathArray = new TreePath[n];
            Object[][] objectArray = new Object[n][2];
            for (int i = 0; i < n; ++i) {
                serializable = (TangoTreeNode)this.getChildAt(i);
                treePathArray[i] = ((TangoTreeNode)serializable).getCompletePath();
                String[] stringArray = ((TangoTreeNode)serializable).getValue();
                objectArray[i][0] = JiveUtils.formatPath(treePathArray[i]);
                objectArray[i][1] = stringArray[0];
            }
            serializable = new DetailsDlg(JiveUtils.parent, objectArray, treePathArray);
            ((DetailsDlg)serializable).showDlg();
        } else {
            JiveUtils.showJiveError("No properties defined for " + string);
        }
    }

    public void editAttProperties(String string) {
        Serializable serializable;
        int n = this.getChildCount();
        TreePath[] treePathArray = new TreePath[n + 8];
        Object[][] objectArray = new Object[n + 8][2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object;
            serializable = (TangoTreeNode)this.getChildAt(i);
            if (((TangoTreeNode)serializable).isLeaf()) {
                object = ((TangoTreeNode)serializable).getValue();
                treePathArray[n2] = ((TangoTreeNode)serializable).getCompletePath();
                objectArray[n2][0] = JiveUtils.formatPath(treePathArray[n2]);
                objectArray[n2][1] = object[0];
                ++n2;
                continue;
            }
            for (int j = 0; j < ((TangoTreeNode)serializable).getChildCount(); ++j) {
                object = (TangoTreeNode)((DefaultMutableTreeNode)serializable).getChildAt(j);
                String[] stringArray = ((TangoTreeNode)object).getValue();
                treePathArray[n2] = ((TangoTreeNode)object).getCompletePath();
                objectArray[n2][0] = JiveUtils.formatPath(treePathArray[n2]);
                objectArray[n2][1] = stringArray[0];
                ++n2;
            }
        }
        serializable = new DetailsDlg(JiveUtils.parent, objectArray, treePathArray);
        ((DetailsDlg)serializable).showDlg();
    }

    public String toString() {
        return this.value;
    }

    public TreePath getCompletePath() {
        TangoTreeNode tangoTreeNode = this;
        Object[] objectArray = new TangoTreeNode[tangoTreeNode.level + 1];
        for (int i = objectArray.length - 1; i >= 0; --i) {
            objectArray[i] = tangoTreeNode;
            tangoTreeNode = (TangoTreeNode)tangoTreeNode.getParent();
        }
        return new TreePath(objectArray);
    }

    public String toStringEx() {
        int n;
        String string = "";
        TangoTreeNode tangoTreeNode = this;
        TangoTreeNode[] tangoTreeNodeArray = new TangoTreeNode[tangoTreeNode.level + 1];
        for (n = tangoTreeNodeArray.length - 1; n >= 0; --n) {
            tangoTreeNodeArray[n] = tangoTreeNode;
            tangoTreeNode = (TangoTreeNode)tangoTreeNode.getParent();
        }
        for (n = 0; n < tangoTreeNodeArray.length; ++n) {
            string = string + tangoTreeNodeArray[n].toString();
            string = string + "/";
        }
        return string;
    }
}

