/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorTree;
import admin.astor.TangoServer;
import admin.astor.tools.Utils;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PoolThreadsTree
extends JTree
implements TangoConst {
    static ImageIcon tango_icon;
    static ImageIcon class_icon;
    static ImageIcon cmd_icon;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private JDialog parent;
    private PoolThreadsInfo pool_info;
    private TangoRenderer renderer;
    private TangoServer server;
    private static final Color background;
    private DefaultMutableTreeNode dragged_node = null;

    public PoolThreadsTree(JDialog parent, TangoServer server) throws DevFailed {
        this.parent = parent;
        this.server = server;
        this.setBackground(background);
        this.pool_info = new PoolThreadsInfo();
        this.buildTree();
        this.expandChildren(this.root);
        this.setSelectionPath(null);
        this.setDragEnabled(true);
        this.setTransferHandler(new TransferHandler("Text"));
    }

    private void buildTree() {
        this.root = new DefaultMutableTreeNode(this.server);
        this.createThreadsNodes();
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.renderer = new TangoRenderer();
        this.setCellRenderer(this.renderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
            }

            public void treeExpanded(TreeExpansionEvent e) {
                PoolThreadsTree.this.expandedPerfomed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                PoolThreadsTree.this.treeMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                PoolThreadsTree.this.treeMouseReleased(evt);
            }

            public void mouseClicked(MouseEvent evt) {
                PoolThreadsTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        int mask = evt.getModifiers();
        if (evt.getClickCount() == 2 && (mask & 0x10) != 0 || (mask & 4) != 0) {
            // empty if block
        }
    }

    public void expandedPerfomed(TreeExpansionEvent evt) {
    }

    private void createThreadsNodes() {
        for (int i = 0; i < this.pool_info.size(); ++i) {
            PollThread thread = this.pool_info.threadAt(i);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(thread);
            this.root.add(node);
            for (Object obj : thread) {
                node.add(new DefaultMutableTreeNode(obj));
            }
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    boolean selectedObjectIsThread() {
        return this.getSelectedObject() instanceof PollThread;
    }

    private void expandChildren(DefaultMutableTreeNode node) {
        boolean level_done = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                if (level_done) continue;
                this.expandNode(child);
                level_done = true;
                continue;
            }
            this.expandChildren(child);
        }
    }

    private void expandNode(DefaultMutableTreeNode node) {
        Vector<DefaultMutableTreeNode> v = new Vector<DefaultMutableTreeNode>();
        v.add(node);
        while (node != this.root) {
            node = (DefaultMutableTreeNode)node.getParent();
            v.insertElementAt(node, 0);
        }
        Object[] tn = new DefaultMutableTreeNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            tn[i] = (TreeNode)v.get(i);
        }
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
    }

    private DefaultMutableTreeNode getFutureSelectedNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent_node;
        DefaultMutableTreeNode ret_node = parent_node = (DefaultMutableTreeNode)node.getParent();
        for (int i = 0; i < parent_node.getChildCount(); ++i) {
            DefaultMutableTreeNode child_node = (DefaultMutableTreeNode)parent_node.getChildAt(i);
            if (child_node != node) continue;
            if (i == parent_node.getChildCount() - 1) {
                if (i <= 0) continue;
                ret_node = (DefaultMutableTreeNode)parent_node.getChildAt(i - 1);
                continue;
            }
            ret_node = (DefaultMutableTreeNode)parent_node.getChildAt(i + 1);
        }
        return ret_node;
    }

    void removeThread() {
        Object obj;
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node != null && (obj = node.getUserObject()) instanceof PollThread) {
            if (node.getChildCount() == 0) {
                DefaultMutableTreeNode next_node = this.getFutureSelectedNode(node);
                this.treeModel.removeNodeFromParent(node);
                this.pool_info.remove(obj);
                Object[] tree_node = next_node.getPath();
                TreePath path = new TreePath(tree_node);
                this.setSelectionPath(path);
                this.scrollPathToVisible(path);
            } else {
                PopupError.show((Component)this.parent, "Cannot remove a not empty thread !");
            }
        }
    }

    DefaultMutableTreeNode addThreadNode() {
        PollThread new_thread = new PollThread(this.getNextThreadNum());
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new_thread);
        this.treeModel.insertNodeInto(node, this.root, this.root.getChildCount());
        return node;
    }

    private int getNextThreadNum() {
        int num = 0;
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode th_node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            num = ((PollThread)th_node.getUserObject()).num;
        }
        return ++num;
    }

    void putPoolThreadInfo() {
        int nb_thread = this.root.getChildCount();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode th_node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            int nb_dev = th_node.getChildCount();
            if (nb_dev <= 0) continue;
            String s = "";
            for (int j = 0; j < nb_dev; ++j) {
                s = s + th_node.getChildAt(j).toString();
                if (j >= nb_dev - 1) continue;
                s = s + ",";
            }
            v.add(s);
        }
        String[] conf = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            conf[i] = (String)v.get(i);
        }
        try {
            DbDatum[] argin = new DbDatum[]{new DbDatum("polling_threads_pool_size", nb_thread), new DbDatum("polling_threads_pool_conf", conf)};
            this.server.put_property(argin);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    private TreePath getUpperPath(int x, int y) {
        TreePath selectedPath = null;
        while (selectedPath == null && y > 10) {
            selectedPath = this.getPathForLocation(x, y);
            y -= 10;
        }
        return selectedPath;
    }

    private void treeMouseReleased(MouseEvent evt) {
        int mask = evt.getModifiers();
        if ((mask & 0x10) != 0) {
            if (this.dragged_node == null) {
                return;
            }
            TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null && (selectedPath = this.getUpperPath(evt.getX(), evt.getY())) == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
            Object o = node.getUserObject();
            int pos = 0;
            if (o instanceof String) {
                DefaultMutableTreeNode p_node = (DefaultMutableTreeNode)node.getParent();
                pos = p_node.getIndex(node);
                node = p_node;
            }
            this.moveLeaf(node, this.dragged_node, pos);
            this.dragged_node = null;
            Cursor cursor = new Cursor(0);
            this.parent.setCursor(cursor);
        }
    }

    private void treeMousePressed(MouseEvent evt) {
        int mask = evt.getModifiers();
        if ((mask & 0x10) != 0) {
            TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
            Object o = node.getUserObject();
            if (o instanceof String) {
                TransferHandler transfer = this.getTransferHandler();
                transfer.exportAsDrag(this, evt, 1);
                this.dragged_node = node;
                this.parent.setCursor(this.renderer.getNodeCursor(node));
            }
        }
    }

    private void moveLeaf(DefaultMutableTreeNode collec_node, DefaultMutableTreeNode leaf_node, int pos) {
        Object obj = collec_node.getUserObject();
        if (obj instanceof PollThread) {
            this.treeModel.removeNodeFromParent(leaf_node);
            if (pos < 0) {
                this.treeModel.insertNodeInto(leaf_node, collec_node, collec_node.getChildCount());
            } else {
                this.treeModel.insertNodeInto(leaf_node, collec_node, pos);
            }
            this.expandNode(leaf_node);
        }
    }

    static {
        background = AstorTree.background;
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int THREAD = 1;
        private final int DEVICE = 2;
        private Cursor dd_cursor;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            tango_icon = utils.getIcon("network5.gif");
            class_icon = utils.getIcon("class.gif");
            cmd_icon = utils.getIcon("attleaf.gif");
            this.dd_cursor = this.getNodeCursor("drg-drp.gif");
            this.fonts = new Font[3];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
        }

        Cursor getNodeCursor(DefaultMutableTreeNode node) {
            Object o = node.getUserObject();
            if (o instanceof String) {
                return this.dd_cursor;
            }
            return new Cursor(0);
        }

        Cursor getNodeCursor(String filename) {
            URL url = this.getClass().getResource("/app_util/img/" + filename);
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), filename);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(tango_icon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof PollThread) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(class_icon);
                } else {
                    this.setFont(this.fonts[2]);
                    this.setIcon(cmd_icon);
                }
            }
            return this;
        }
    }

    private class PoolThreadsInfo
    extends Vector {
        int size = 1;

        private PoolThreadsInfo() throws DevFailed {
            DbDatum[] argin = new DbDatum[]{new DbDatum("polling_threads_pool_size"), new DbDatum("polling_threads_pool_conf")};
            DbDatum[] argout = PoolThreadsTree.this.server.get_property(argin);
            String[] conf = new String[]{};
            if (argout[0].is_empty() && argout[1].is_empty()) {
                String[] s = PoolThreadsTree.this.server.queryDeviceFromDb();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < s.length; ++i) {
                    sb.append(s[i]);
                    if (i >= s.length - 1) continue;
                    sb.append(',');
                }
                conf = new String[]{sb.toString()};
            } else {
                if (!argout[0].is_empty()) {
                    this.size = argout[0].extractLong();
                }
                if (!argout[1].is_empty()) {
                    conf = argout[1].extractStringArray();
                }
            }
            this.buidConfig(conf);
        }

        private void buidConfig(String[] conf) {
            int i;
            for (i = 0; i < conf.length; ++i) {
                StringTokenizer stk = new StringTokenizer(conf[i], ",");
                PollThread thread = new PollThread(i);
                while (stk.hasMoreTokens()) {
                    thread.add(stk.nextToken());
                }
                this.add(thread);
            }
            for (i = conf.length; i < this.size; ++i) {
                this.add(new PollThread(i));
            }
        }

        private PollThread threadAt(int i) {
            return (PollThread)this.get(i);
        }
    }

    private class PollThread
    extends Vector {
        String name;
        int num;

        private PollThread(int num) {
            this.num = num;
            this.name = "Thread " + (num + 1);
        }

        public String toString() {
            return this.name;
        }
    }
}

