/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.DeviceHierarchy;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class DeviceHierarchyDialog
extends JDialog {
    private Component parent;
    private DeviceHierarchy tree;
    private JButton cancelBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane scrollPane1;
    private JScrollPane scrollPane2;
    private JSplitPane splitPane;
    private JTextArea textArea;
    private JLabel titleLabel;

    public DeviceHierarchyDialog(JFrame parent, String name) throws DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        this.init(name);
    }

    public DeviceHierarchyDialog(JDialog parent, String name) throws DevFailed {
        super((Dialog)parent, false);
        this.parent = parent;
        this.init(name);
    }

    private void init(String name) throws DevFailed {
        this.initComponents();
        this.initOwnComponents(name);
        this.titleLabel.setText("Basic Dialog for Swing Appli");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initOwnComponents(String name) throws DevFailed {
        this.tree = new DeviceHierarchy(this, name);
        this.scrollPane1.setViewportView(this.tree);
        this.scrollPane1.setPreferredSize(new Dimension(300, 400));
        this.scrollPane2.setPreferredSize(new Dimension(300, 400));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.splitPane = new JSplitPane();
        this.scrollPane1 = new JScrollPane();
        this.scrollPane2 = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DeviceHierarchyDialog.this.closeDialog(evt);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DeviceHierarchyDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.splitPane.setLeftComponent(this.scrollPane1);
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        this.scrollPane2.setViewportView(this.textArea);
        this.splitPane.setRightComponent(this.scrollPane2);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.pack();
    }

    void setText(String str) {
        this.textArea.setText(str);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        int w = this.parent.getWidth();
        if (w > 0) {
            this.setVisible(false);
            this.tree.stopThread();
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        String devname = "pv/thread-pool/test-1";
        String servname = "PoolThreadTest/pv";
        try {
            AstorUtil.getInstance().initIcons();
            DeviceHierarchyDialog dlg = new DeviceHierarchyDialog(new JFrame(), servname);
            dlg.setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), (String)"", (DevFailed)e);
        }
    }
}

