/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.AccessProxy;
import admin.astor.access.ClassAllowed;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ListSelectionDialog
extends JDialog {
    private JFrame parent;
    private int retVal = 0;
    private AccessProxy access_dev = null;
    private ClassAllowed def_class = null;
    private String[] cmd_exist;
    private int mode;
    private static final int CLASS_MODE = 0;
    private static final int COMMAND_MODE = 1;
    private String selection = null;
    private JButton cancelBtn;
    private JList cmdList;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JButton okBtn;
    private JLabel titleLabel;

    public ListSelectionDialog(JFrame parent, String[] exist) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.cmd_exist = exist;
        this.mode = 0;
        this.initComponents();
        this.initOwnComponents();
        this.titleLabel.setText("Classes found in database");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    public ListSelectionDialog(JFrame parent, ClassAllowed def_class, AccessProxy access_dev) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.def_class = def_class;
        this.access_dev = access_dev;
        this.mode = 1;
        this.initComponents();
        this.initOwnComponents();
        this.titleLabel.setText("Commands not allowed for " + def_class.name);
        this.pack();
        Point p = parent.getLocationOnScreen();
        p.x += 50;
        p.y += 50;
        this.setLocation(p);
    }

    private String[] notExising(String[] array1, String[] array2) {
        Vector<String> v = new Vector<String>();
        for (String s1 : array1) {
            String cmd = null;
            for (String s2 : array2) {
                if (!s1.toLowerCase().equals(s2.toLowerCase())) continue;
                cmd = s1;
            }
            if (cmd != null) continue;
            v.add(s1);
        }
        String[] ret = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            ret[i] = (String)v.get(i);
        }
        return ret;
    }

    private void initOwnComponents() throws DevFailed {
        Database dbase = ApiUtil.get_db_obj();
        this.jScrollPane1.setPreferredSize(new Dimension(300, 400));
        if (this.mode == 0) {
            String[] classes = dbase.get_class_list("*");
            classes = this.notExising(classes, this.cmd_exist);
            this.cmdList.setListData(classes);
        } else {
            String[] devices = dbase.get_device_exported_for_class(this.def_class.name);
            String[] commands = null;
            for (String devname : devices) {
                try {
                    System.out.println("try to read " + devname);
                    CommandInfo[] info = new DeviceProxy(devname).command_list_query();
                    commands = this.def_class.getNotAllowed(info);
                    break;
                }
                catch (DevFailed e) {
                }
            }
            if (commands != null) {
                this.cmdList.setListData(commands);
            } else {
                Except.throw_exception((String)"NoDeviceExported", (String)("There is no device exported for class " + this.def_class.name + " to get the command list !"), (String)"ListSelectionDialog.initOwnComponents()");
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.cmdList = new JList();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ListSelectionDialog.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListSelectionDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListSelectionDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.cmdList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ListSelectionDialog.this.cmdListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.cmdList);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    public String getSelection() {
        return this.selection;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.selection = (String)this.cmdList.getSelectedValue();
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void cmdListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.selection = (String)this.cmdList.getSelectedValue();
            this.retVal = 0;
            this.doClose();
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }
}

