/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.HostStateThread;
import admin.astor.LoggingDialog;
import admin.astor.TangoServer;
import app_util.PopupError;
import app_util.PopupMessage;
import app_util.PopupTable;
import app_util.PopupText;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class TangoHost
extends DeviceProxy {
    private TangoServer starter = null;
    private String name;
    private Vector servers;
    public String usage = null;
    public int state;
    public DevFailed except;
    public boolean do_polling = false;
    public boolean poll_serv_lists = false;
    public boolean all_servers = false;
    public String collection = null;
    public HostStateThread thread = null;
    public int notifyd_state;
    public JLabel notifd_label;
    public boolean use_events;
    public boolean check_notifd;
    public HostInfoDialog info_dialog = null;
    public boolean manage_starting = true;
    public TangoEventsAdapter supplier = null;
    public int idl_version = 0;
    private String adm_name;

    public TangoHost(String name) throws DevFailed {
        super(new String("tango/admin/" + name));
        int i;
        this.adm_name = "dserver/starter/" + name;
        this.set_transparency_reconnection(true);
        this.servers = new Vector();
        this.notifyd_state = 0;
        DbDatum data = this.get_property("HostCollection");
        if (!data.is_empty()) {
            this.collection = data.extractString();
        }
        this.name = (i = name.indexOf(".")) < 0 ? new String(name) : new String(name.substring(0, i));
        DbDatum prop = this.get_property("HostUsage");
        if (!prop.is_empty()) {
            this.usage = prop.extractString();
            if (this.usage.length() == 0) {
                this.usage = null;
            }
        }
        this.use_events = false;
        try {
            data = this.get_property("UseEvents");
            if (!data.is_empty()) {
                this.use_events = data.extractShort() != 0;
            }
        }
        catch (DevFailed e) {
            // empty catch block
        }
        this.check_notifd = this.use_events;
    }

    public void removeAllservers() {
        if (this.servers.size() > 0) {
            this.servers.removeAllElements();
        }
    }

    public void addServer(TangoServer ts) {
        this.servers.addElement(ts);
    }

    public TangoServer getServer(String servname) {
        servname = servname.trim();
        for (int i = 0; i < this.nbServers(); ++i) {
            TangoServer server = this.getServer(i);
            if (!server.getName().equals(servname)) continue;
            return server;
        }
        return null;
    }

    public TangoServer getServer(int idx) {
        return (TangoServer)this.servers.elementAt(idx);
    }

    public void removeServer(int idx) {
        this.servers.removeElementAt(idx);
    }

    public void removeServer(String servname) {
        for (int i = 0; i < this.nbServers(); ++i) {
            TangoServer server = this.getServer(i);
            if (!server.getName().equals(servname)) continue;
            this.removeServer(i);
            return;
        }
    }

    public int nbServers() {
        if (this.servers == null) {
            return 0;
        }
        return this.servers.size();
    }

    public String[] getServerAttribute() {
        try {
            DeviceAttribute att = this.read_attribute("Servers");
            return att.extractStringArray();
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
            return new String[0];
        }
    }

    public String readLogFile(String servname) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        DeviceData argout = this.command_inout("DevReadLog", argin);
        return argout.extractString();
    }

    public void registerServer(String servname) throws DevFailed {
        String devname = "dserver/" + servname;
        boolean running = false;
        try {
            DeviceProxy dev = new DeviceProxy(devname);
            dev.ping();
            running = true;
        }
        catch (DevFailed e) {
            // empty catch block
        }
        if (running) {
            IORdump d = new IORdump(devname);
            Except.throw_exception((String)"StartServerFailed", (String)(servname + " is already running on " + d.get_host()), (String)"DevWizard.startServer()");
        }
        DbDevExportInfo info = new DbDevExportInfo(devname, "null", this.name, "null");
        ApiUtil.get_db_obj().export_device(info);
        ApiUtil.get_db_obj().unexport_device(devname);
    }

    public void startOneServer(String servname) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        System.out.println("command_inout(DevStart, " + servname + ") on " + this.name());
        this.command_inout("DevStart", argin);
    }

    public void startServer(String servname) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        this.command_inout("DevStart", argin);
    }

    public void stopServer(String servname) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        this.command_inout("DevStop", argin);
    }

    public void hardKillServer(String servname) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert(servname);
        this.command_inout("HardKillServer", argin);
    }

    public void startServers(int level) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert((short)level);
        this.command_inout("DevStartAll", argin);
    }

    public void stopServers(int level) throws DevFailed {
        DeviceData argin = new DeviceData();
        argin.insert((short)level);
        this.command_inout("DevStopAll", argin);
    }

    public void displayLogging(JFrame parent) {
        try {
            DeviceData argin = new DeviceData();
            argin.insert("Starter");
            DeviceData argout = this.command_inout("DevReadLog", argin);
            String str = argout.extractString();
            String[] array = AstorUtil.string2array(str, "\n");
            String[][] array2 = new String[array.length][];
            for (int i = 0; i < array.length; ++i) {
                array2[i] = AstorUtil.string2array(array[i], "\t");
            }
            String[] colnames = new String[]{"Time", "\ufffdvents"};
            PopupTable table = new PopupTable(parent, "Starter on " + this.name, colnames, array2);
            table.setColumnWidth(new int[]{130, 300});
            table.setVisible(true);
        }
        catch (DevFailed e) {
            try {
                new LoggingDialog(parent, this).setVisible(true);
            }
            catch (DevFailed e2) {
                ErrorPane.showErrorMessage((Component)parent, (String)"", (DevFailed)e2);
            }
        }
    }

    public void displayInfo(Component parent) {
        String str = "";
        try {
            if (this.starter == null) {
                this.starter = new TangoServer(this.adm_name);
            }
            str = str + this.starter.getServerInfo(parent, this.state == 3);
            str = str + "\n\n----------- Controlled servers -----------\n";
            Database db = ApiUtil.get_db_obj();
            DeviceData argin = new DeviceData();
            argin.insert(this.name);
            DeviceData argout = db.command_inout("DbGetHostServerList", argin);
            String[] servnames = argout.extractStringArray();
            for (int i = 0; i < servnames.length; ++i) {
                DbServInfo s = db.get_server_info(servnames[i]);
                if (!s.controlled) continue;
                str = str + s.name + "\n";
            }
            String tagName = "";
            try {
                DevInfo info = this.info();
                String servinfo = info.doc_url;
                String tag = "CVS Tag = ";
                int start = servinfo.indexOf(tag);
                if (start > 0) {
                    int end = servinfo.indexOf(10, start += tag.length());
                    if (end > start) {
                        tagName = servinfo.substring(start, end);
                    }
                    str = str + "\n----------- Tag Release -----------\n        " + tagName;
                }
            }
            catch (DevFailed e) {}
        }
        catch (DevFailed e) {
            str = str + e.errors[0].desc;
            PopupError.show(parent, str, e);
            return;
        }
        str = str + "\n\n";
        PopupMessage.show(parent, str);
    }

    public void testStarter(Component parent) {
        try {
            if (this.starter == null) {
                this.starter = new TangoServer(this.adm_name);
            }
            this.starter.testDevice(parent, new Point(0, 0));
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (DevFailed)e);
        }
    }

    public void unexportStarter(Component parent) {
        try {
            DbDevImportInfo info = this.import_device();
            if (!info.exported) {
                PopupMessage.show(parent, this.name() + "  NOT  exported !");
                return;
            }
            this.unexport_device();
            String adm = "dserver/Starter/" + this.name;
            new DeviceProxy(adm).unexport_device();
            this.do_polling = false;
            PopupMessage.show(parent, adm + "   and    " + this.name() + "\n\n       have been unexported !");
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (DevFailed)e);
        }
    }

    public void setCollection(String new_collec) throws DevFailed {
        DbDatum[] prop = new DbDatum[]{new DbDatum("HostCollection", new_collec)};
        this.put_property(prop);
        this.collection = new_collec;
    }

    public void informStarterForInfo() throws DevFailed {
        this.command_inout("UpdateServersInfo");
    }

    public String getName() {
        return this.name;
    }

    void setPolling(String[] enabled_hosts) {
        if (enabled_hosts == null) {
            this.do_polling = true;
        } else if (enabled_hosts.length > 0 && enabled_hosts[0].equals("none")) {
            this.do_polling = false;
        } else if (enabled_hosts.length > 0 && enabled_hosts[0].equals("all")) {
            this.do_polling = true;
        } else {
            for (int i = 0; i < enabled_hosts.length; ++i) {
                if (!this.name.equals(enabled_hosts[i])) continue;
                this.do_polling = true;
            }
        }
    }

    public void startServer(Component parent, String servname) {
        try {
            this.startServer(servname);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (DevFailed)e);
        }
    }

    void readStdErrorFile(Frame parent, String servname) {
        try {
            String logStr = this.readLogFile(servname);
            PopupText dialog = new PopupText(parent, true);
            dialog.show(logStr, 700, 500);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (DevFailed)e);
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (Exception)e);
            e.printStackTrace();
        }
    }

    void updateServersList(JFrame parent) {
        try {
            this.command_inout("UpdateServersInfo");
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, (String)"", (DevFailed)e);
        }
    }

    void updateData() {
        this.thread.updateData();
    }

    void stopThread() {
        this.thread.stop_it = true;
        this.thread.updateData();
    }

    String[] getPath() {
        String[] path = new String[]{""};
        try {
            DbDatum datum = this.get_property("StartDsPath");
            if (!datum.is_empty()) {
                path = datum.extractStringArray();
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
        return path;
    }

    String getFamily() {
        String family = "";
        try {
            DbDatum datum = this.get_property("HostCollection");
            if (!datum.is_empty()) {
                family = datum.extractString();
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
        return family;
    }

    public String hostStatus() {
        String str = this.name + ":";
        try {
            if (this.state == 1) {
                str = str + "     is faulty\n";
            } else {
                DeviceAttribute att = this.read_attribute("Servers");
                if (att.hasFailed()) {
                    str = str + "     " + att.getErrStack()[0].desc + "\n";
                } else {
                    str = str + "\n";
                    Vector<String> running = new Vector<String>();
                    Vector<String> moving = new Vector<String>();
                    Vector<String> stopped = new Vector<String>();
                    String[] list = att.extractStringArray();
                    for (int i = 0; i < list.length; ++i) {
                        StringTokenizer stk = new StringTokenizer(list[i]);
                        String name = stk.nextToken();
                        String st = stk.nextToken();
                        String str_ctrl = stk.nextToken();
                        if (!str_ctrl.equals("1")) continue;
                        if (st.equals("FAULT")) {
                            stopped.add(name);
                            continue;
                        }
                        if (st.equals("MOVING")) {
                            moving.add(name);
                            continue;
                        }
                        running.add(name);
                    }
                    if (stopped.size() > 0) {
                        str = str + "     " + stopped.size() + "  servers stopped\n";
                    }
                    if (moving.size() > 0) {
                        str = str + "     " + moving.size() + " servers moving\n";
                    }
                    if (running.size() > 0) {
                        str = str + "     " + running.size() + " servers running\n";
                    }
                }
            }
        }
        catch (DevFailed e) {
            str = str + "     " + e.errors[0].desc;
        }
        return str;
    }

    public String toString() {
        if (this.usage == null || this.usage.length() == 0) {
            return this.name;
        }
        return this.name + "  ( " + this.usage + " )";
    }
}

