/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.LevelTree;
import admin.astor.ListDialog;
import admin.astor.ServerCmdThread;
import admin.astor.ServerPopupMenu;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChange;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.Timer;

public class HostInfoDialog
extends JDialog
implements AstorDefs,
TangoConst {
    public TangoHost host;
    public String name;
    private Astor astor;
    private UpdateThread thread;
    private Color bg = null;
    private String attribute = "Servers";
    private static final int NO_CHANGE = 0;
    private static final int LIST_CHANGED = 1;
    private static final int STATE_CHANGED = 2;
    private LevelTree[] trees = null;
    private ServerPopupMenu notifd_menu;
    private JPanel levelsPanel = null;
    private JPanel[] treePanels;
    private JPanel notifdPanel;
    private JButton StartAllBtn;
    private JPanel btnPanel;
    private JButton cancelBtn;
    private JPanel centerPanel;
    private JRadioButton displayAllBtn;
    private JPanel jPanel1;
    private JButton startNewBtn;
    private JButton stopAllBtn;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private static String[] filters = new String[0];
    private ServerEventListener server_listener = null;

    public HostInfoDialog(Astor parent, TangoHost host) {
        super((Frame)parent, false);
        this.astor = parent;
        this.host = host;
        this.name = host.getName();
        this.initComponents();
        this.setTitle((Object)((Object)host) + "  Control");
        this.displayAllBtn.setSelected(true);
        this.thread = new UpdateThread();
        this.thread.start();
        this.bg = this.titlePanel.getBackground();
        this.titleLabel.setText("Controlled Servers on " + this.name);
        this.notifd_menu = new ServerPopupMenu(this.astor, this, host, 2);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    void updatePanel() {
        if (this.trees == null) {
            int nb_levels = AstorUtil.getStarterNbStartupLevels();
            ++nb_levels;
            this.levelsPanel = new JPanel();
            this.levelsPanel.setLayout(new GridBagLayout());
            this.centerPanel.add((Component)this.levelsPanel, "Center");
            if (this.host.check_notifd) {
                this.notifdPanel = new JPanel();
                this.host.notifd_label = new JLabel("Event Notify Daemon");
                this.host.notifd_label.setFont(new Font("Dialog", 1, 12));
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.gridwidth = nb_levels;
                gbc.fill = 2;
                this.notifdPanel.add((Component)this.host.notifd_label, gbc);
                this.levelsPanel.add((Component)this.notifdPanel, gbc);
                this.host.notifd_label.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent evt) {
                        HostInfoDialog.this.serverBtnMouseClicked(evt);
                    }
                });
            }
            this.treePanels = new JPanel[nb_levels];
            this.trees = new LevelTree[nb_levels];
            for (int i = 0; i < nb_levels; ++i) {
                this.trees[i] = new LevelTree(this.astor, this, this.host, i);
                this.treePanels[i] = new JPanel();
                this.treePanels[i].add(this.trees[i]);
            }
        } else {
            for (LevelTree tree : this.trees) {
                tree.checkUpdate();
            }
        }
        this.checkAciveLevels();
        this.updateHostState();
        this.pack();
    }

    private void checkAciveLevels() {
        this.levelsPanel.removeAll();
        Vector<JPanel> v = new Vector<JPanel>();
        for (int i = 1; i < this.trees.length; ++i) {
            if (this.trees[i].getNbServers() <= 0) continue;
            v.add(this.treePanels[i]);
        }
        if (this.trees[0].getNbServers() > 0) {
            v.add(this.treePanels[0]);
        }
        int x = 0;
        int y = 1;
        int x_size = v.size() / 2 - 1;
        if (x_size < 2) {
            x_size = 2;
        }
        for (int i = 0; i < v.size(); ++i) {
            JPanel panel = (JPanel)v.get(i);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.insets = new Insets(5, 10, 0, 0);
            gbc.fill = 2;
            gbc.fill = 3;
            gbc.anchor = 17;
            this.levelsPanel.add((Component)panel, gbc);
            if (i != x_size) continue;
            x = 0;
            y += 2;
        }
        if (this.host.check_notifd) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = x_size + 1;
            gbc.fill = 2;
            this.levelsPanel.add((Component)this.notifdPanel, gbc);
        }
    }

    Color getBackgroundColor() {
        return this.startNewBtn.getBackground();
    }

    void updateHostState() {
        if (this.host.state == 4) {
            String str_state = ApiUtil.stateName((DevState)DevState.MOVING);
            this.titlePanel.setBackground(ATKConstant.getColor4State((String)str_state));
        } else if (this.host.state == 2) {
            String str_state = ApiUtil.stateName((DevState)DevState.ALARM);
            this.titlePanel.setBackground(ATKConstant.getColor4State((String)str_state));
        } else {
            this.titlePanel.setBackground(this.bg);
        }
        if (this.host.check_notifd) {
            this.host.notifd_label.setIcon(AstorUtil.state_icons[this.host.notifyd_state]);
        }
    }

    private void initComponents() {
        this.btnPanel = new JPanel();
        this.cancelBtn = new JButton();
        this.centerPanel = new JPanel();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.startNewBtn = new JButton();
        this.StartAllBtn = new JButton();
        this.stopAllBtn = new JButton();
        this.displayAllBtn = new JRadioButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                HostInfoDialog.this.closeDialog(evt);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.btnPanel.add(this.cancelBtn);
        this.getContentPane().add((Component)this.btnPanel, "South");
        this.centerPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.titlePanel.add(this.titleLabel);
        this.centerPanel.add((Component)this.titlePanel, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.startNewBtn.setText("Start New");
        this.startNewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.startNewBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.startNewBtn);
        this.StartAllBtn.setText("Start All");
        this.StartAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.StartAllBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.StartAllBtn);
        this.stopAllBtn.setText("Stop All");
        this.stopAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.stopAllBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.stopAllBtn);
        this.displayAllBtn.setText("Display All");
        this.displayAllBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.displayAllBtn.setMargin(new Insets(0, 0, 0, 0));
        this.displayAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HostInfoDialog.this.displayAllBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.displayAllBtn);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.pack();
    }

    private void serverBtnMouseClicked(MouseEvent evt) {
        this.notifd_menu.showMenu(evt, this.host.state);
    }

    private void displayAllBtnActionPerformed(ActionEvent evt) {
        boolean b = this.displayAllBtn.getSelectedObjects() != null;
        for (LevelTree tree : this.trees) {
            if (b) {
                if (tree.getLevelRow() == 0) continue;
                tree.expandTree();
                continue;
            }
            tree.collapseTree();
        }
    }

    private void stopAllBtnActionPerformed(ActionEvent evt) {
        Vector<Integer> used = new Vector<Integer>();
        for (int i = this.trees.length - 1; i >= 0; --i) {
            int level = this.trees[i].getLevelRow();
            if (level == 0 || this.trees[i].getNbServers() <= 0 || !this.trees[i].hasRunningServer()) continue;
            used.add(level);
        }
        new ServerCmdThread((Component)this, this.host, 1, used).start();
    }

    private void StartAllBtnActionPerformed(ActionEvent evt) {
        Vector<Integer> used = new Vector<Integer>();
        for (LevelTree tree : this.trees) {
            int level = tree.getLevelRow();
            if (level == 0 || tree.getNbServers() <= 0 || tree.getState() == DevState.ON) continue;
            used.add(level);
        }
        new ServerCmdThread((Component)this, this.host, 0, used).start();
    }

    private void startNewBtnActionPerformed(ActionEvent evt) {
        ListDialog jlist = new ListDialog(this);
        Point p = this.getLocationOnScreen();
        p.translate(50, 50);
        jlist.setLocation(p);
        jlist.showDialog();
        String servname = jlist.getSelectedItem();
        if (servname != null) {
            try {
                this.host.registerServer(servname);
                this.host.startOneServer(servname);
                TangoServer ts = new TangoServer(servname, DevState.OFF);
                ts.startupLevel(this, this.host.getName(), p);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.astor, null, (DevFailed)e);
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    void doClose() {
        if (this.astor.getWidth() == 0) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    void fireNewTreeSelection(LevelTree tree) {
        for (LevelTree tree1 : this.trees) {
            if (tree1 == tree) continue;
            tree1.clearSelection();
        }
    }

    void stopLevel(int level) {
        Vector<Integer> v = new Vector<Integer>();
        v.add(level);
        new ServerCmdThread((Component)this, this.host, 1, v).start();
    }

    void startLevel(int level) {
        Vector<Integer> v = new Vector<Integer>();
        v.add(level);
        new ServerCmdThread((Component)this, this.host, 0, v).start();
    }

    private void manageServersAttribute(DeviceAttribute att) {
        Vector<Server> servers = new Vector<Server>();
        try {
            if (!att.hasFailed()) {
                String[] list;
                for (String item : list = att.extractStringArray()) {
                    servers.add(new Server(item));
                }
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
        switch (this.updateHost(servers)) {
            case 1: {
                this.updatePanel();
                break;
            }
            case 0: {
                return;
            }
        }
        for (LevelTree tree : this.trees) {
            tree.repaint();
        }
    }

    public synchronized int updateHost(Vector new_servers) {
        boolean state_changed = false;
        boolean list_changed = false;
        for (Object o : new_servers) {
            Server new_serv = (Server)o;
            TangoServer server = this.host.getServer(new_serv.name);
            if (server == null) {
                try {
                    server = new TangoServer(new_serv.name, new_serv.state);
                }
                catch (DevFailed e) {
                    Except.print_exception((Exception)((Object)e));
                }
                this.host.addServer(server);
                list_changed = true;
            }
            if (new_serv.state != server.getState()) {
                server.setState(new_serv.state);
                state_changed = true;
            }
            if (!(new_serv.controlled != server.controlled | new_serv.level != server.startup_level)) continue;
            server.controlled = new_serv.controlled;
            server.startup_level = new_serv.level;
            list_changed = true;
        }
        for (int i = 0; i < this.host.nbServers(); ++i) {
            TangoServer server = this.host.getServer(i);
            boolean found = false;
            for (int j = 0; !found && j < new_servers.size(); ++j) {
                Server new_serv = (Server)new_servers.get(j);
                found = new_serv.name.equals(server.getName());
            }
            if (found) continue;
            this.host.removeServer(server.getName());
            list_changed = true;
        }
        if (list_changed) {
            return 1;
        }
        if (state_changed) {
            return 2;
        }
        return 0;
    }

    private DevState string2state(String str) {
        for (int i = 0; i < Tango_DevStateName.length; ++i) {
            if (!str.equals(Tango_DevStateName[i])) continue;
            return DevState.from_int((int)i);
        }
        return DevState.UNKNOWN;
    }

    void setSelection(String servname) {
        for (LevelTree tree : this.trees) {
            TangoServer server = tree.getServer(servname);
            if (server != null) {
                tree.expandTree();
                tree.setSelection(server);
                continue;
            }
            tree.resetSelection();
        }
    }

    void updateData() {
        this.updatePanel();
    }

    private void subscribeChangeEvent() {
        try {
            if (this.host.supplier == null) {
                this.host.supplier = new TangoEventsAdapter((DeviceProxy)this.host);
            }
        }
        catch (DevFailed e) {
            this.host.use_events = false;
            System.out.println("subscribeChangeServerEvent() for " + this.host.name() + " FAILED !");
            Except.print_exception((Exception)((Object)e));
            return;
        }
        catch (Exception e) {
            this.host.use_events = false;
            System.out.println("subscribeChangeServerEvent() for " + this.host.name() + " FAILED !");
            System.out.println(e);
            return;
        }
        try {
            this.server_listener = new ServerEventListener();
            this.host.supplier.addTangoChangeListener((ITangoChangeListener)this.server_listener, this.attribute, filters);
            System.out.println("subscribeChangeServerEvent() for " + this.host.name() + "/" + this.attribute + " OK!");
        }
        catch (DevFailed e) {
            this.host.use_events = false;
            System.out.println("subscribeChangeServerEvent() for " + this.host.name() + " FAILED !");
            Except.print_exception((Exception)((Object)e));
        }
        catch (Exception e) {
            this.host.use_events = false;
            System.out.println("subscribeChangeServerEvent() for " + this.host.name() + " FAILED !");
            System.out.println(e);
        }
    }

    public void unsubscribeServersEvent() {
        if (this.host.supplier != null && this.server_listener != null) {
            try {
                this.host.supplier.removeTangoChangeListener((ITangoChangeListener)this.server_listener, this.attribute);
                System.out.println("unsubscribe event for " + this.host.getName() + "/" + this.attribute);
            }
            catch (DevFailed e) {
                System.out.println("Failed to unsubscribe event for " + this.attribute);
                Except.print_exception((Exception)((Object)e));
            }
        }
    }

    class Blink {
        private JComponent obj;
        private int cnt;
        private Timer timer;
        private Color color;
        private long t0 = 0L;
        private int duration;
        private String text = null;

        Blink(JComponent obj) {
            this.obj = obj;
            this.cnt = 0;
            this.color = obj.getBackground();
        }

        Blink(JComponent obj, int duration) {
            this(obj);
            this.duration = duration;
            if (obj instanceof JLabel) {
                this.text = ((JLabel)obj).getText();
            } else {
                this.color = obj.getBackground();
            }
            this.t0 = System.currentTimeMillis();
        }

        void blinkPerformer(ActionEvent evt) {
            long t1;
            ++this.cnt;
            if (this.cnt % 2 == 0) {
                if (this.obj instanceof JLabel) {
                    ((JLabel)this.obj).setText("-> " + this.text);
                } else {
                    this.obj.setBackground(this.color);
                }
            } else if (this.obj instanceof JLabel) {
                ((JLabel)this.obj).setText(this.text);
            } else {
                this.obj.setBackground(Color.lightGray);
            }
            if (this.duration != 0 && (t1 = System.currentTimeMillis()) - this.t0 >= (long)(this.duration * 1000)) {
                this.timer.stop();
                if (this.obj instanceof JLabel) {
                    ((JLabel)this.obj).setText(this.text);
                } else {
                    this.obj.setBackground(this.color);
                }
            }
        }

        private void start() {
            ActionListener taskPerformer = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Blink.this.blinkPerformer(evt);
                }
            };
            this.timer = new Timer(200, taskPerformer);
            this.timer.start();
        }
    }

    class ServerEventListener
    implements ITangoChangeListener {
        ServerEventListener() {
        }

        public void change(TangoChangeEvent event) {
            System.out.println(" change(TangoChangeEvent event)");
            TangoChange tc = (TangoChange)event.getSource();
            String devname = tc.getEventSupplier().name();
            try {
                DeviceAttribute att = event.getValue();
                HostInfoDialog.this.manageServersAttribute(att);
            }
            catch (DevFailed e) {
                if (e.errors[0].reason.equals("API_EventTimeout")) {
                    System.out.println("HostStataThread.ServerEventListener" + devname + " : API_EventTimeout");
                } else {
                    Except.print_exception((Exception)((Object)e));
                }
            }
            catch (Exception e) {
                System.out.println("AstorEvent." + devname);
                System.out.println(e);
                System.out.println("HostStateThread.ServerEventListener : could not extract data!");
            }
        }
    }

    class UpdateThread
    extends Thread {
        private int readInfoPeriod = 1000;
        private boolean stop_it = false;

        public void run() {
            if (HostInfoDialog.this.host.use_events) {
                HostInfoDialog.this.subscribeChangeEvent();
            }
            while (!this.stop_it) {
                long t0 = System.currentTimeMillis();
                if (!HostInfoDialog.this.host.use_events && HostInfoDialog.this.host.do_polling) {
                    this.manageSynchronous();
                }
                this.wait_next_loop(t0);
            }
        }

        public synchronized void wait_next_loop(long t0) {
            try {
                long t1 = System.currentTimeMillis();
                long time_to_sleep = (long)this.readInfoPeriod - (t1 - t0);
                if (time_to_sleep <= 0L) {
                    time_to_sleep = 100L;
                }
                this.wait(time_to_sleep);
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }

        private void manageSynchronous() {
            try {
                DeviceAttribute att = HostInfoDialog.this.host.read_attribute(HostInfoDialog.this.attribute);
                HostInfoDialog.this.manageServersAttribute(att);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
    }

    class Server {
        String name;
        DevState state;
        boolean controlled = false;
        int level = 0;

        public Server(String line) {
            StringTokenizer stk = new StringTokenizer(line);
            Vector<String> v = new Vector<String>();
            while (stk.hasMoreTokens()) {
                v.add(stk.nextToken());
            }
            if (v.size() > 0) {
                this.name = (String)v.get(0);
            }
            if (v.size() > 1) {
                this.state = HostInfoDialog.this.string2state((String)v.get(1));
            }
            if (v.size() > 2) {
                this.controlled = v.get(2).equals("1");
            }
            if (v.size() > 3) {
                String s = (String)v.get(3);
                try {
                    this.level = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this.name + " -> " + ApiUtil.stateName((DevState)this.state) + "\t- " + (this.controlled ? "" : "not ") + "Controlled \tlevel " + this.level;
        }
    }
}

