/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GetTextDialog
extends JDialog {
    private int retVal = 0;
    private JButton cancelBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JButton okBtn;
    private JTextArea textArea;
    private JLabel titleLabel;

    public GetTextDialog(JDialog parent, String title, String tip, String[] lines) {
        super((Dialog)parent, true);
        this.initComponents();
        this.initialize(title, tip, lines);
    }

    public GetTextDialog(JFrame parent, String title, String tip, String[] lines) {
        super((Frame)parent, true);
        this.initComponents();
        this.initialize(title, tip, lines);
    }

    private void initialize(String title, String tip, String[] lines) {
        this.titleLabel.setText(title);
        this.textArea.setToolTipText(tip);
        if (lines != null) {
            String text = "";
            for (int i = 0; i < lines.length; ++i) {
                text = text + lines[i] + "\n";
            }
            text.trim();
            this.textArea.setText(text);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GetTextDialog.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetTextDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetTextDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jScrollPane1.setPreferredSize(new Dimension(500, 300));
        this.textArea.setColumns(60);
        this.textArea.setFont(new Font("Courier", 1, 14));
        this.textArea.setRows(5);
        this.jScrollPane1.setViewportView(this.textArea);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public String getText() {
        return this.textArea.getText().trim();
    }

    public String[] getTextLines() {
        String str = this.getText();
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(str, "\n");
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        String[] lines = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            lines[i] = (String)v.get(i);
        }
        return lines;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }
}

