/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import app_util.PopupError;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AttMemoDialog
extends JDialog {
    private JDialog parent;
    private DbServer server;
    private boolean from_appli = true;
    private Memorized[] memorized;
    private JLabel[] attLbl;
    private JTextField[] attVal;
    private static final String unknown = " ? ";
    private JLabel titleLabel;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JButton okBtn;
    private JPanel valuePanel;
    private JButton cancelBtn;

    public AttMemoDialog(JDialog parent, DbServer server) throws DevFailed {
        super((Dialog)parent, true);
        this.parent = parent;
        this.server = server;
        this.initComponents();
        this.buildMemorizedPanel();
        this.titleLabel.setText("Memorized attributes found for " + server.name());
        this.pack();
        if (parent.getWidth() == 0) {
            this.from_appli = false;
        }
        if (this.from_appli) {
            AstorUtil.centerDialog((JDialog)this, parent);
        }
    }

    private void buildMemorizedPanel() throws DevFailed {
        this.readAttributes();
        this.attLbl = new JLabel[this.memorized.length];
        this.attVal = new JTextField[this.memorized.length];
        for (int i = 0; i < this.memorized.length; ++i) {
            GridBagConstraints gbc = new GridBagConstraints();
            int x = 0;
            int y = i + 1;
            this.attLbl[i] = new JLabel(this.memorized[i].attname);
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.fill = 2;
            this.valuePanel.add((Component)this.attLbl[i], gbc);
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.fill = 2;
            this.valuePanel.add((Component)new JLabel("  :    "), gbc);
            this.attVal[i] = new JTextField(this.memorized[i].value);
            this.attVal[i].setColumns(15);
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.fill = 2;
            this.valuePanel.add((Component)this.attVal[i], gbc);
            gbc.gridx = x++;
            gbc.gridy = y;
            gbc.fill = 2;
            this.valuePanel.add((Component)new JLabel("     " + this.memorized[i].min + " < .... < " + this.memorized[i].max), gbc);
        }
    }

    private void readAttributes() throws DevFailed {
        DeviceProxy[] dev = this.getDevices();
        Vector<String> v = new Vector<String>();
        for (int d = 0; d < dev.length; ++d) {
            String devname = dev[d].name();
            DeviceData argin = new DeviceData();
            String[] args = new String[]{devname, "*"};
            argin.insert(args);
            DeviceData argout = ApiUtil.get_db_obj().command_inout("DbGetDeviceAttributeList", argin);
            String[] attlist = argout.extractStringArray();
            for (int i = 0; i < attlist.length; ++i) {
                DbAttribute db_att = dev[d].get_attribute_property(attlist[i]);
                String[] proplist = db_att.get_property_list();
                for (int j = 0; j < proplist.length; ++j) {
                    if (!proplist[j].equals("__value")) continue;
                    String min = unknown;
                    if (!db_att.is_empty("min_value")) {
                        min = db_att.get_value("min_value")[0];
                    }
                    String max = unknown;
                    if (!db_att.is_empty("max_value")) {
                        max = db_att.get_value("max_value")[0];
                    }
                    v.add(devname + "/" + attlist[i]);
                    v.add(db_att.get_string_value(j));
                    v.add(min);
                    v.add(max);
                }
            }
        }
        this.memorized = new Memorized[v.size() / 4];
        for (int i = 0; i < v.size(); i += 4) {
            this.memorized[i / 4] = new Memorized((String)v.elementAt(i), (String)v.elementAt(i + 1), (String)v.elementAt(i + 2), (String)v.elementAt(i + 3));
        }
    }

    private DeviceProxy[] getDevices() throws DevFailed {
        Vector<String> v = new Vector<String>();
        String[] classes = this.server.get_class_list();
        for (int c = 0; c < classes.length; ++c) {
            String[] devices = this.server.get_device_name(classes[c]);
            for (int d = 0; d < devices.length; ++d) {
                v.add(devices[d]);
            }
        }
        DeviceProxy[] dev = new DeviceProxy[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            dev[i] = new DeviceProxy((String)v.elementAt(i));
        }
        return dev;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.valuePanel = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AttMemoDialog.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttMemoDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttMemoDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.valuePanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.valuePanel, "Center");
        this.pack();
    }

    private boolean writeValues() {
        String message = "";
        for (int i = 0; i < this.attVal.length; ++i) {
            double val;
            String val_str = this.attVal[i].getText();
            Memorized memo = this.memorized[i];
            if (val_str.equals(memo.value)) continue;
            try {
                val = Double.parseDouble(val_str);
            }
            catch (NumberFormatException e) {
                PopupError.show((Component)this.parent, val_str + " is not a number !");
                return false;
            }
            if (!memo.min.equals(unknown)) {
                double min;
                try {
                    min = Double.parseDouble(memo.min);
                }
                catch (NumberFormatException e) {
                    PopupError.show((Component)this.parent, memo.min + " is not a number !");
                    return false;
                }
                if (val < min) {
                    PopupError.show((Component)this.parent, "Incorrect value:\n" + val_str + " is less than " + memo.min);
                    return false;
                }
            }
            if (!memo.max.equals(unknown)) {
                double max;
                try {
                    max = Double.parseDouble(memo.max);
                }
                catch (NumberFormatException e) {
                    PopupError.show((Component)this.parent, memo.max + " is not a number !");
                    return false;
                }
                if (val > max) {
                    PopupError.show((Component)this.parent, "Incorrect value:\n" + val_str + " is greater than " + memo.max);
                    return false;
                }
            }
            try {
                DbDatum data = new DbDatum("__value");
                data.insert(val_str);
                AttributeProxy att = new AttributeProxy(this.attLbl[i].getText());
                att.put_property(data);
                memo.value = val_str;
                message = message + this.attLbl[i].getText() + "  set to  " + val_str + "\n";
                continue;
            }
            catch (DevFailed e) {
                PopupError.show((Component)this.parent, e);
                return false;
            }
        }
        if (message.length() > 0) {
            PopupMessage.show((Component)this.parent, message);
        }
        return true;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        if (this.writeValues()) {
            this.doClose();
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (!this.from_appli) {
            System.exit(0);
        }
    }

    public void showDialog() {
        if (this.memorized.length == 0) {
            PopupError.show((Component)this.parent, "No memorized attribute found for " + this.server.name());
        } else {
            this.setVisible(true);
        }
    }

    public static void main(String[] args) {
        try {
            AttMemoDialog d = new AttMemoDialog(new JDialog(), new DbServer("PowerSupply/pv"));
            d.showDialog();
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
    }

    class Memorized {
        String attname;
        String value;
        String min;
        String max;

        Memorized(String attname, String value, String min, String max) {
            this.attname = attname;
            this.value = value;
            this.min = min;
            this.max = max;
        }
    }
}

