/*
 * Decompiled with CFR 0.152.
 */
package app_util;

import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class PopupTable
extends JDialog {
    private DataTableModel model;
    private static String[] col_names;
    private String[][] data;
    private Window parent;
    private boolean from_appli = true;
    private boolean sort_available = true;
    private JTable my_table;
    private JScrollPane scrollPane;
    private JPanel jPanel1;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel titleLabel;

    public PopupTable(JFrame parent, String filename) throws FileNotFoundException, SecurityException, IOException, DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        this.readDataFile(filename);
        this.buildObject(filename, col_names, this.data);
        if (parent.getWidth() == 0) {
            this.from_appli = false;
        }
    }

    public PopupTable(JFrame parent, String title, String filename) throws FileNotFoundException, SecurityException, IOException, DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        this.readDataFile(filename);
        this.buildObject(title, col_names, this.data);
        if (parent.getWidth() == 0) {
            this.from_appli = false;
        }
    }

    public PopupTable(JDialog parent, String title, String[] col, String[][] array) throws DevFailed {
        super((Dialog)parent, false);
        this.parent = parent;
        this.buildObject(title, col, array);
    }

    public PopupTable(JFrame parent, String title, String[] col, String[][] array) throws DevFailed {
        super((Frame)parent, false);
        this.parent = parent;
        this.buildObject(title, col, array);
        if (parent.getWidth() == 0) {
            this.from_appli = false;
        }
    }

    private void readDataFile(String filename) throws FileNotFoundException, SecurityException, IOException, DevFailed {
        FileInputStream fid = new FileInputStream(filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        String str = new String(inStr);
        fid.close();
        Vector<String> v = new Vector<String>();
        StringTokenizer stk = new StringTokenizer(str, "\n");
        while (stk.hasMoreTokens()) {
            v.add(stk.nextToken());
        }
        System.out.println(v.size() + " lines");
        this.data = new String[v.size() - 1][];
        for (int i = 0; i < v.size(); ++i) {
            int j;
            String line = (String)v.elementAt(i);
            stk = new StringTokenizer(line, "\t");
            if (i == 0) {
                col_names = new String[stk.countTokens()];
                j = 0;
                while (stk.hasMoreTokens()) {
                    PopupTable.col_names[j] = stk.nextToken();
                    ++j;
                }
                continue;
            }
            this.data[i - 1] = new String[stk.countTokens()];
            j = 0;
            while (stk.hasMoreTokens()) {
                this.data[i - 1][j] = stk.nextToken();
                ++j;
            }
        }
    }

    private void buildObject(String title, String[] col, String[][] array) throws DevFailed {
        col_names = col;
        this.initComponents();
        this.data = array;
        this.initMyComponents();
        this.titleLabel.setText(title);
        if (this.parent.getWidth() > 0) {
            Point p = this.parent.getLocationOnScreen();
            p.x += 10;
            p.y += 10;
            this.setLocation(p);
        }
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PopupTable.this.closeDialog(evt);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PopupTable.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void initMyComponents() throws DevFailed {
        try {
            this.model = new DataTableModel();
            JTable table = new JTable(this.model);
            table.setRowSelectionAllowed(true);
            table.setColumnSelectionAllowed(true);
            table.setDragEnabled(true);
            table.setSelectionMode(0);
            table.getTableHeader().setFont(new Font("Dialog", 1, 14));
            table.getTableHeader().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    PopupTable.this.tableActionPerformed(evt);
                }
            });
            this.scrollPane = new JScrollPane(table);
            this.scrollPane.setPreferredSize(new Dimension(650, 450));
            this.getContentPane().add((Component)this.scrollPane, "Center");
            this.my_table = table;
        }
        catch (Exception e) {
            e.printStackTrace();
            Except.throw_exception((String)"INIT_ERROR", (String)e.toString(), (String)"PopupTable.initMyComponents()");
        }
        this.model.fireTableDataChanged();
    }

    public void setSortAvailable(boolean b) {
        this.sort_available = b;
    }

    private void tableActionPerformed(MouseEvent evt) {
        int column = this.my_table.getTableHeader().columnAtPoint(new Point(evt.getX(), evt.getY()));
        if (this.sort_available) {
            new UsedData().sort(column);
        }
        this.model.fireTableDataChanged();
    }

    public void setColumnWidth(int[] width) {
        Enumeration<TableColumn> cenum = this.my_table.getColumnModel().getColumns();
        int sp_width = 0;
        int i = 0;
        while (cenum.hasMoreElements()) {
            TableColumn tc = cenum.nextElement();
            tc.setPreferredWidth(width[i]);
            sp_width += width[i];
            ++i;
        }
        this.scrollPane.setPreferredSize(new Dimension(sp_width, 450));
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (!this.from_appli) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("File's name to find data ?");
            System.exit(0);
        }
        try {
            new PopupTable(new JFrame(), args[0]).setVisible(true);
        }
        catch (Exception e) {
            PopupError.show((Component)new JFrame(), e);
            e.printStackTrace();
            System.exit(0);
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return PopupTable.this.data[0].length;
        }

        public int getRowCount() {
            return PopupTable.this.data.length;
        }

        public String getColumnName(int aCol) {
            if (aCol >= this.getColumnCount()) {
                return col_names[this.getColumnCount() - 1];
            }
            return col_names[aCol];
        }

        public Object getValueAt(int row, int col) {
            return PopupTable.this.data[row][col];
        }
    }

    public class ResultTableRowRenderer
    extends DefaultTableCellRenderer {
        private final Color _scolor = new Color(204, 204, 255);
        private final Color _color = new Color(230, 230, 230);

        ResultTableRowRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            String col_header = (String)table.getColumnModel().getColumn(col).getHeaderValue();
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        }
    }

    class UsedData
    extends Vector {
        private int column;

        UsedData() {
            for (int i = 0; i < PopupTable.this.data.length; ++i) {
                this.add(PopupTable.this.data[i]);
            }
        }

        void sort(int column) {
            this.column = column;
            MyCompare compare = new MyCompare();
            Collections.sort(this, compare);
            for (int i = 0; i < this.size(); ++i) {
                ((PopupTable)PopupTable.this).data[i] = (String[])this.elementAt(i);
            }
        }

        class MyCompare
        implements Comparator {
            MyCompare() {
            }

            public int compare(Object o1, Object o2) {
                String[] a1 = (String[])o1;
                String[] a2 = (String[])o2;
                String s1 = a1[UsedData.this.column];
                String s2 = a2[UsedData.this.column];
                try {
                    double d1 = Double.parseDouble(s1);
                    double d2 = Double.parseDouble(s2);
                    return d1 > d2 ? 1 : 0;
                }
                catch (NumberFormatException e) {
                    return s1.compareToIgnoreCase(s2) > 0 ? 1 : 0;
                }
            }
        }
    }
}

