/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.DevPollStatus;
import admin.astor.tools.PolledElement;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class PollingProfiler
extends JDialog
implements IJLChartListener,
ComponentListener {
    private JLChart chart = new JLChart();
    private JLAxis y_axis;
    private JLAxis x_axis;
    private JLDataView[] data = null;
    private long now;
    private String[] devnames;
    private DevPollStatus poll_status;
    private Component parent = null;
    private Timer timer = null;
    private int timer_period = 2;
    private boolean update_chart = true;
    private JLabel late_label;
    private JLabel early_label;
    private PollingInfo poll_info;
    private String title;
    private int display_mode = 1;
    private JCheckBoxMenuItem[] check_box;
    private static final int HISTORY = 0;
    private static final int POLL_DRIFT = 1;
    private static final int DURATION = 2;
    private static final int NB_CHECK_BOX = 3;
    private JRadioButton autoBtn;
    private JButton cancelBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel titleLabel;
    private JButton updateBtn;

    public PollingProfiler(JDialog parent, String devname) {
        super((Dialog)parent, false);
        this.parent = parent;
        this.realConstructor(new String[]{devname});
    }

    public PollingProfiler(JFrame parent, String devname) {
        super((Frame)parent, false);
        this.parent = parent;
        this.realConstructor(new String[]{devname});
    }

    public PollingProfiler(JDialog parent, String[] devnames) {
        super((Dialog)parent, false);
        this.parent = parent;
        this.realConstructor(devnames);
    }

    public PollingProfiler(JFrame parent, String[] devnames) {
        super((Frame)parent, false);
        this.parent = parent;
        this.realConstructor(devnames);
    }

    private void realConstructor(String[] devnames) {
        this.devnames = devnames;
        this.initComponents();
        this.initOwnComponents();
        this.buildPopupMenu();
        this.customizeAxis();
        this.updateData();
        this.titleLabel.setVisible(false);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void buildPopupMenu() {
        this.chart.addMenuItem(new JMenuItem("-------------------------"));
        this.check_box = new JCheckBoxMenuItem[3];
        this.check_box[0] = new JCheckBoxMenuItem("History");
        this.check_box[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.menuActionPerformed(evt);
            }
        });
        this.chart.addMenuItem((JMenuItem)this.check_box[0]);
        this.check_box[1] = new JCheckBoxMenuItem("Polling Drift");
        this.check_box[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.menuActionPerformed(evt);
            }
        });
        this.chart.addMenuItem((JMenuItem)this.check_box[1]);
        this.check_box[2] = new JCheckBoxMenuItem("Duration");
        this.check_box[2].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.menuActionPerformed(evt);
            }
        });
        this.chart.addMenuItem((JMenuItem)this.check_box[2]);
        JMenuItem jmi = new JMenuItem("Polling Info");
        jmi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.menuActionPerformed(evt);
            }
        });
        this.chart.addMenuItem(jmi);
        this.check_box[this.display_mode].setSelected(true);
    }

    private void menuActionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        int cmdidx = 0;
        if (obj instanceof JCheckBoxMenuItem) {
            for (int i = 0; i < this.check_box.length; ++i) {
                if (this.check_box[i] == obj) {
                    cmdidx = i;
                    this.check_box[i].setSelected(true);
                    continue;
                }
                this.check_box[i].setSelected(false);
            }
            this.display_mode = cmdidx;
            this.customizeAxis();
            this.updateCurves();
            this.manageLabels();
        } else {
            this.poll_info.setVisible(true);
        }
    }

    private void customizeAxis() {
        this.x_axis.setPosition(4);
        if (this.display_mode == 0) {
            this.chart.setHeader(this.title + " (History)");
            this.x_axis.setAutoScale(false);
            this.x_axis.setName("Time");
            this.x_axis.setAnnotation(1);
            this.x_axis.setLabelFormat(0);
            this.y_axis.setAutoScale(false);
            this.y_axis.setName("T0");
            this.late_label.setVisible(false);
            this.early_label.setVisible(false);
        } else {
            this.x_axis.setAutoScale(false);
            this.x_axis.setName("Attributes");
            this.x_axis.setAnnotation(2);
            this.x_axis.setLabelFormat(3);
            if (this.display_mode == 1) {
                this.chart.setHeader(this.title + " (Drift)");
                this.y_axis.setName("Polling Drift (ms)");
                this.late_label.setVisible(true);
                this.early_label.setVisible(true);
            } else if (this.display_mode == 2) {
                this.chart.setHeader(this.title + " (Duration)");
                this.y_axis.setName("Duration (ms)");
                this.late_label.setVisible(false);
                this.early_label.setVisible(false);
                this.y_axis.setAutoScale(true);
            }
        }
    }

    private void manageLabels() {
        switch (this.display_mode) {
            case 0: {
                this.late_label.setVisible(false);
                this.early_label.setVisible(false);
                break;
            }
            case 1: {
                int w = this.early_label.getPreferredSize().width;
                int h = this.early_label.getPreferredSize().height;
                int h_chart = this.chart.getHeight();
                this.early_label.setBounds(24, h_chart - 20, w, h);
                this.late_label.setVisible(true);
                this.early_label.setVisible(true);
                break;
            }
            case 2: {
                this.late_label.setVisible(false);
                this.early_label.setVisible(false);
            }
        }
    }

    private void initOwnComponents() {
        this.y_axis = this.chart.getY2Axis();
        this.x_axis = this.chart.getXAxis();
        this.chart.setBackground(Color.white);
        this.chart.setChartBackground(Color.lightGray);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.setLabelVisible(true);
        this.chart.setLabelFont(new Font("Dialog", 1, 12));
        this.x_axis.setGridVisible(true);
        this.chart.setPreferredSize(new Dimension(850, 400));
        this.chart.setJLChartListener((IJLChartListener)this);
        this.chart.setLabelPlacement(2);
        this.getContentPane().add((Component)this.chart, "Center");
        this.chart.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                PollingProfiler.this.myMouseReleased(evt);
            }
        });
        this.title = "Polling on:  ";
        if (this.devnames.length == 1) {
            this.title = this.title + this.devnames[0];
        } else {
            try {
                String adm = new DeviceProxy(this.devnames[0]).adm_name();
                this.title = this.title + adm.substring(adm.indexOf(47) + 1);
            }
            catch (DevFailed e) {
                this.title = this.title + this.devnames[0];
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
        this.chart.setHeader(this.title);
        this.late_label = new JLabel("Polling Late");
        this.late_label.setFont(new Font("Dialog", 1, 14));
        this.late_label.setIcon(new ImageIcon(this.getClass().getResource("/app_util/img/up.gif")));
        this.late_label.setVisible(false);
        this.chart.add((Component)this.late_label);
        int w = this.late_label.getPreferredSize().width;
        int h = this.late_label.getPreferredSize().height;
        this.late_label.setBounds(24, 10, w, h);
        this.early_label = new JLabel("Polling Early");
        this.early_label.setFont(new Font("Dialog", 1, 14));
        this.early_label.setIcon(new ImageIcon(this.getClass().getResource("/app_util/img/down.gif")));
        this.early_label.setVisible(false);
        this.chart.add((Component)this.early_label);
        this.poll_info = new PollingInfo(this);
        this.chart.addComponentListener((ComponentListener)this);
    }

    private void myMouseReleased(MouseEvent evt) {
        if ((evt.getModifiers() & 0x10) != 0) {
            this.update_chart = true;
            this.doRepaint();
        }
    }

    private void updateData() {
        this.now = System.currentTimeMillis();
        try {
            this.poll_status = new DevPollStatus(this.devnames);
            this.updateCurves();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void manageDataViews(int nb) {
        if (this.data != null && nb != this.data.length) {
            for (JLDataView datum : this.data) {
                datum.reset();
                this.y_axis.removeDataView(datum);
            }
            this.data = null;
            this.initOwnComponents();
        }
        if (this.data != null) {
            for (JLDataView datum : this.data) {
                datum.reset();
            }
        } else {
            this.data = new JLDataView[nb];
            AstorUtil util = AstorUtil.getInstance();
            util.initColors(nb);
            for (int i = 0; i < nb; ++i) {
                this.data[i] = new JLDataView();
                this.data[i].setColor(util.getNewColor());
                this.data[i].setName(this.poll_status.polledElementAt((int)i).name);
                this.data[i].setLabelVisible(true);
                this.y_axis.addDataView(this.data[i]);
            }
        }
        if (this.display_mode == 0) {
            for (int i = 0; i < nb; ++i) {
                this.data[i].setViewType(0);
            }
        } else {
            for (int i = 0; i < nb; ++i) {
                this.data[i].setViewType(1);
                this.data[i].setFillMethod(1);
                this.data[i].setFill(true);
                this.data[i].setFillStyle(1);
                this.data[i].setFillColor(this.data[i].getColor());
            }
        }
    }

    private void updateCurves() {
        int nb = this.poll_status.size();
        if (nb == 0) {
            return;
        }
        this.manageDataViews(nb);
        double xmin = this.now;
        double y_min = 0.0;
        double y_max = 0.0;
        block10: for (int i = 0; i < nb; ++i) {
            PolledElement pe = this.poll_status.polledElementAt(i);
            switch (this.display_mode) {
                case 0: {
                    double x = this.now - (long)pe.last_update;
                    double y = 1.0 + 0.1 * (double)i;
                    this.data[i].add(x, 0.0);
                    this.data[i].add(x, y);
                    this.data[i].add(x - pe.reading_time, y);
                    this.data[i].add(x - pe.reading_time, 0.0);
                    if (x < xmin) {
                        xmin = x;
                    }
                    for (int real_period : pe.real_periods) {
                        this.data[i].add(x -= (double)real_period, 0.0);
                        this.data[i].add(x, y);
                        this.data[i].add(x - pe.reading_time, y);
                        this.data[i].add(x - pe.reading_time, 0.0);
                        if (!(x < xmin)) continue;
                        xmin = x;
                    }
                    continue block10;
                }
                case 1: {
                    double y = pe.polled ? (double)(pe.real_periods[0] - pe.period) : 0.0;
                    this.data[i].add((double)i, y);
                    if (y > y_max) {
                        y_max = y;
                    }
                    if (!(y < y_min)) continue block10;
                    y_min = y;
                    continue block10;
                }
                case 2: {
                    double y = pe.polled ? pe.reading_time : 0.0;
                    this.data[i].add((double)i, y);
                }
            }
        }
        switch (this.display_mode) {
            case 0: {
                this.x_axis.setMinimum(xmin -= 1000.0);
                this.x_axis.setMaximum((double)this.now);
                this.y_axis.setMinimum(0.0);
                this.y_axis.setMaximum(0.1 * (double)nb + 1.5);
                break;
            }
            case 1: {
                this.x_axis.setMinimum(-0.05);
                this.x_axis.setMaximum((double)nb - 0.5);
                if (y_max < 10.0 && y_min > -10.0) {
                    this.y_axis.setAutoScale(false);
                    this.y_axis.setMinimum(-10.0);
                    this.y_axis.setMaximum(10.0);
                    break;
                }
                this.y_axis.setAutoScale(true);
                break;
            }
            case 2: {
                this.x_axis.setMinimum(-0.05);
                this.x_axis.setMaximum((double)nb - 0.5);
            }
        }
        this.poll_info.display();
        this.doRepaint();
    }

    private void doRepaint() {
        if (this.update_chart) {
            this.chart.repaint();
        }
    }

    public String[] clickOnChart(JLChartEvent event) {
        String[] retVal;
        this.update_chart = false;
        JLDataView dv = event.getDataView();
        PolledElement pe = null;
        for (int i = 0; pe == null && i < this.poll_status.size(); ++i) {
            if (!dv.getName().equals(this.poll_status.polledElementAt((int)i).name)) continue;
            pe = this.poll_status.polledElementAt(i);
        }
        int idx = event.getDataViewIndex();
        DataList dl = dv.getData();
        for (int i = 0; i < idx; ++i) {
            dl = dl.next;
        }
        if (pe == null) {
            return new String[0];
        }
        String[] s1 = pe.getInfo();
        int nblines = s1.length;
        if (this.display_mode == 0) {
            retVal = new String[nblines + 2];
            System.arraycopy(s1, 0, retVal, 0, nblines);
            retVal[nblines] = "";
            retVal[nblines + 1] = "T0 - " + (int)((double)this.now - dl.x) + " ms";
        } else {
            retVal = s1;
        }
        return retVal;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.autoBtn = new JRadioButton();
        this.updateBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PollingProfiler.this.closeDialog(evt);
            }
        });
        this.autoBtn.setText("Auto Update");
        this.autoBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.autoBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.autoBtn);
        this.updateBtn.setText("Update");
        this.updateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.updateBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.updateBtn);
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PollingProfiler.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void autoBtnActionPerformed(ActionEvent evt) {
        if (this.autoBtn.getSelectedObjects() != null) {
            String strval = "" + this.timer_period;
            if ((strval = (String)JOptionPane.showInputDialog(this, "Reading period (seconds)  ?", "Reading period", 1, null, null, strval)) == null) {
                this.autoBtn.setSelected(false);
                return;
            }
            try {
                this.timer_period = Integer.parseInt(strval);
            }
            catch (NumberFormatException e) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)e);
                ErrorPane.showErrorMessage((Component)this, null, (Exception)e);
                this.autoBtn.setSelected(false);
                return;
            }
            this.updateData();
            if (this.timer == null) {
                ActionListener taskPerformer = new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        PollingProfiler.this.updateData();
                    }
                };
                this.timer = new Timer(1000 * this.timer_period, taskPerformer);
            } else {
                this.timer.setDelay(1000 * this.timer_period);
            }
            this.timer.start();
            this.updateBtn.setEnabled(false);
        } else if (this.timer != null) {
            this.timer.stop();
            this.updateBtn.setEnabled(true);
        }
    }

    private void updateBtnActionPerformed(ActionEvent evt) {
        this.updateData();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.parent != null && this.parent.isVisible()) {
            this.setVisible(false);
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public void componentMoved(ComponentEvent evt) {
        this.manageLabels();
    }

    public void componentShown(ComponentEvent evt) {
        this.manageLabels();
    }

    public void componentResized(ComponentEvent evt) {
        this.manageLabels();
    }

    public void componentHidden(ComponentEvent evt) {
    }

    static int getNbFields(String[] args) {
        if (args.length == 0) {
            return 0;
        }
        StringTokenizer stk = new StringTokenizer(args[0], "/");
        int nb = 0;
        nb = 0;
        while (stk.hasMoreTokens()) {
            stk.nextToken();
            ++nb;
        }
        return nb;
    }

    static String[] getDeviceNames(String servname) throws DevFailed {
        DeviceData argout = new DeviceProxy("dserver/" + servname).command_inout("QueryDevice");
        String[] devnames = argout.extractStringArray();
        for (int i = 0; i < devnames.length; ++i) {
            devnames[i] = devnames[i].substring(devnames[i].indexOf("::") + 2);
            System.out.println(devnames[i]);
        }
        return devnames;
    }

    public static void main(String[] args) {
        try {
            switch (PollingProfiler.getNbFields(args)) {
                case 3: {
                    new PollingProfiler(new JDialog(), args[0]).setVisible(true);
                    break;
                }
                case 2: {
                    String[] devnames = PollingProfiler.getDeviceNames(args[0]);
                    new PollingProfiler(new JDialog(), devnames).setVisible(true);
                    break;
                }
                default: {
                    Except.throw_exception((String)"BAD_ARGUMENT", (String)"Server or Device name  ?", (String)"PollingProfiler.main()");
                    break;
                }
            }
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
    }

    public class PollingInfo
    extends JDialog {
        private JTextArea textArea;

        public PollingInfo(JDialog parent) {
            super((Dialog)parent, false);
            JScrollPane jsp = new JScrollPane();
            this.textArea = new JTextArea();
            this.textArea.setFont(new Font("Dialog", 1, 14));
            this.textArea.setEditable(false);
            jsp.setViewportView(this.textArea);
            jsp.setPreferredSize(new Dimension(500, 250));
            this.getContentPane().add((Component)jsp, "Center");
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        private void setText(String text) {
            this.textArea.setText(text);
        }

        private String formatValue(double val, int nb_dec) {
            String str = "" + val;
            int idx = str.indexOf(46);
            if (idx > 0 && str.substring(idx + 1).length() > nb_dec) {
                str = str.substring(0, nb_dec + idx + 1);
            }
            return str;
        }

        private void display() {
            int nb_polled = PollingProfiler.this.poll_status.polledCount();
            int nb_triggered = PollingProfiler.this.poll_status.triggeredCount();
            StringBuffer sb = new StringBuffer("  ");
            if (nb_triggered == 0) {
                sb.append(nb_polled + " polled attributes.\n\n");
            } else if (nb_polled == 0) {
                sb.append(nb_triggered + " triggered attributes.\n\n");
            } else {
                sb.append(nb_polled + " polled attributes  and  ");
                sb.append(nb_triggered + " triggered attributes.\n\n");
            }
            boolean drift_available = false;
            int late_drift = 0;
            int early_drift = 0;
            String late_drift_name = null;
            String early_drift_name = null;
            double sum_duration = 0.0;
            double max_duration = 0.0;
            String max_duration_name = null;
            int last_update_max = 0;
            String last_update_max_str = "";
            String last_update_max_name = null;
            for (int i = 0; i < PollingProfiler.this.poll_status.size(); ++i) {
                PolledElement pe = PollingProfiler.this.poll_status.polledElementAt(i);
                if (pe.polled) {
                    int drift = pe.real_periods[0] - pe.period;
                    if (drift > 0) {
                        if (drift > late_drift) {
                            late_drift = drift;
                            late_drift_name = pe.name;
                        }
                    } else if (drift < early_drift) {
                        early_drift = drift;
                        early_drift_name = pe.name;
                    }
                    drift_available = true;
                }
                if (pe.reading_time > max_duration) {
                    max_duration = pe.reading_time;
                    max_duration_name = pe.name;
                }
                sum_duration += pe.reading_time;
                if (pe.last_update <= last_update_max) continue;
                last_update_max = pe.last_update;
                last_update_max_str = pe.last_update_str;
                last_update_max_name = pe.name;
            }
            if (drift_available) {
                sb.append("Drift maxi :\n");
                sb.append("    - Late : " + late_drift + " ms ");
                if (late_drift_name != null) {
                    sb.append("\ton " + late_drift_name);
                }
                sb.append("\n");
                sb.append("    - Early: " + early_drift + " ms ");
                if (early_drift_name != null) {
                    sb.append("\ton " + early_drift_name);
                }
                sb.append("\n");
            }
            sb.append("\n");
            sb.append("Duration :\n");
            sb.append("    Maxi : " + this.formatValue(max_duration, 2) + " ms");
            if (max_duration_name != null) {
                sb.append("\ton " + max_duration_name);
            }
            sb.append("\n");
            sb.append("    Total: " + this.formatValue(sum_duration, 2) + " ms \n");
            if (last_update_max_name != null) {
                sb.append("\n");
                sb.append("Last update max\ton " + last_update_max_name);
                sb.append("\n    since " + last_update_max_str);
            }
            this.textArea.setText(sb.toString());
        }
    }
}

