/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.RemoteLoginThread;
import admin.astor.TangoServer;
import admin.astor.tools.DeviceHierarchyDialog;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceHierarchy
extends JTree
implements AstorDefs {
    private static ImageIcon root_icon;
    private boolean running = true;
    private Device[] devices = null;
    private String rootname = null;
    private DefaultMutableTreeNode root;
    private DeviceHierarchyPopupMenu menu;
    private JDialog parent;
    private static final Color background;
    private static final int ROOT_OPTION = 0;
    private static final int TEST_DEVICE = 1;
    private static final int HOST_PANEL = 2;
    private static final int REM_LOGIN = 3;
    private static final int OFFSET = 2;
    private static String[] menuLabels;
    private boolean refresh = false;

    public DeviceHierarchy(JDialog parent, String name) throws DevFailed {
        this.parent = parent;
        this.setBackground(background);
        this.initNames(name);
        this.buildTree();
        this.menu = new DeviceHierarchyPopupMenu(this);
        this.expandChildren(this.root);
        this.setSelectionPath(null);
    }

    private void initNames(String name) throws DevFailed {
        StringTokenizer stk = new StringTokenizer(name, "/");
        Vector<String> v = new Vector<String>();
        while (stk.hasMoreTokens()) {
            v.add(stk.nextToken());
        }
        String[] devnames = new String[]{};
        switch (v.size()) {
            case 2: {
                this.rootname = v.get(0) + "/" + v.get(1);
                devnames = new TangoServer("dserver/" + this.rootname).queryDeviceFromDb();
                break;
            }
            case 3: {
                this.rootname = "Device";
                devnames = new String[]{v.get(0) + "/" + v.get(1) + "/" + v.get(2)};
                break;
            }
            default: {
                Except.throw_exception((String)"BAD_PARAMETER", (String)"Bad device or server name", (String)"DeviceHierarchy.initNames()");
            }
        }
        this.devices = new Device[devnames.length];
        for (int i = 0; i < devnames.length; ++i) {
            this.devices[i] = new Device(devnames[i]);
        }
        new Refresher().start();
    }

    private void buildTree() {
        this.root = new DefaultMutableTreeNode(this.rootname);
        this.createDeviceNodes();
        this.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.setModel(treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer renderer = new TangoRenderer();
        this.setCellRenderer(renderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
            }

            public void treeExpanded(TreeExpansionEvent e) {
                DeviceHierarchy.this.expandedPerfomed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                DeviceHierarchy.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        if (evt.getClickCount() != 2 || (mask & 0x10) == 0) {
            if ((mask & 0x10) != 0) {
                this.deviceInfo();
            } else if ((mask & 4) != 0) {
                if (node == this.root) {
                    this.menu.showMenu(evt, (String)o);
                } else if (o instanceof Device) {
                    this.menu.showMenu(evt, (Device)o);
                }
            }
        }
    }

    public void expandedPerfomed(TreeExpansionEvent evt) {
    }

    private void createDeviceNodes(DefaultMutableTreeNode parent_node, Device device) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(device);
        parent_node.add(node);
        for (int i = 0; i < device.size(); ++i) {
            this.createDeviceNodes(node, device.getDevice(i));
        }
    }

    private void createDeviceNodes() {
        for (Device device : this.devices) {
            this.createDeviceNodes(this.root, device);
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private void expandChildren(DefaultMutableTreeNode node) {
        boolean level_done = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                if (level_done) continue;
                this.expandNode(child);
                level_done = true;
                continue;
            }
            this.expandChildren(child);
        }
    }

    private void expandNode(DefaultMutableTreeNode node) {
        Vector<DefaultMutableTreeNode> v = new Vector<DefaultMutableTreeNode>();
        v.add(node);
        while (node != this.root) {
            node = (DefaultMutableTreeNode)node.getParent();
            v.insertElementAt(node, 0);
        }
        Object[] tn = new DefaultMutableTreeNode[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            tn[i] = (TreeNode)v.get(i);
        }
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
    }

    private void testDevice() {
        Object obj = this.getSelectedObject();
        if (obj instanceof Device) {
            AstorUtil.testDevice(this.parent, ((Device)obj).name);
        }
    }

    private void deviceInfo() {
        Object obj = this.getSelectedObject();
        if (obj instanceof Device) {
            try {
                String info = ((Device)obj).getInfo();
                ((DeviceHierarchyDialog)this.parent).setText(info);
            }
            catch (DevFailed e) {
                ((DeviceHierarchyDialog)this.parent).setText(Except.str_exception((Exception)((Object)e)));
            }
        }
    }

    private void remoteShell() {
        Object obj = this.getSelectedObject();
        if (obj instanceof Device) {
            try {
                String hostname = ((Device)obj).getHost();
                new RemoteLoginThread(hostname, this.parent).start();
            }
            catch (DevFailed e) {
                ((DeviceHierarchyDialog)this.parent).setText(Except.str_exception((Exception)((Object)e)));
            }
        }
    }

    private void hostPanel() {
        Object obj = this.getSelectedObject();
        if (obj instanceof Device) {
            // empty if block
        }
    }

    void stopThread() {
        this.running = false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Device dev : this.devices) {
            sb.append(dev.toFullString());
            for (int i = 0; i < dev.size(); ++i) {
                sb.append(dev.getDevice(i).toFullString());
            }
        }
        return sb.toString();
    }

    static {
        background = new Color(240, 240, 240);
        menuLabels = new String[]{"Root Options", "Test Device", "Host Panel", "Remote Login"};
    }

    private class Refresher
    extends Thread {
        private Refresher() {
        }

        public void run() {
            while (DeviceHierarchy.this.running) {
                if (DeviceHierarchy.this.refresh) {
                    DeviceHierarchy.this.refresh = false;
                    DeviceHierarchy.this.repaint();
                }
                try {
                    Refresher.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class Device
    extends Vector {
        String name;
        DeviceProxy dev;
        short state = 0;

        private Device(String name) throws DevFailed {
            this.name = name;
            this.dev = new DeviceProxy(name);
            DbDatum datum = this.dev.get_property("__Dependency__");
            if (!datum.is_empty()) {
                String[] dependencies;
                for (String dependency : dependencies = datum.extractStringArray()) {
                    this.add(new Device(dependency));
                }
            }
            new StateManager().start();
        }

        private Device getDevice(int i) {
            return (Device)this.get(i);
        }

        private String toFullString() {
            StringBuffer sb = new StringBuffer(this.name);
            sb.append('\n');
            for (int i = 0; i < this.size(); ++i) {
                Device d = this.getDevice(i);
                sb.append('\t').append(d.name).append('\n');
            }
            sb.append("------------------------------------------------");
            return sb.toString();
        }

        private String getHost() throws DevFailed {
            DeviceInfo info = this.dev.get_info();
            return info.hostname;
        }

        private String getInfo() throws DevFailed {
            StringBuffer sb = new StringBuffer(this.dev.get_info().toString());
            sb.append("\n========================================================\n");
            try {
                String s = this.dev.status();
                sb.append(s);
            }
            catch (DevFailed e) {
                sb.append(Except.str_exception((Exception)((Object)e)));
            }
            return sb.toString();
        }

        public String toString() {
            return this.name;
        }

        private class StateManager
        extends Thread {
            private StateManager() {
            }

            public void run() {
                while (DeviceHierarchy.this.running) {
                    short previous = Device.this.state;
                    try {
                        Device.this.dev.ping();
                        Device.this.state = (short)3;
                    }
                    catch (DevFailed e) {
                        Device.this.state = 1;
                    }
                    if (Device.this.state != previous) {
                        DeviceHierarchy.this.refresh = true;
                    }
                    try {
                        StateManager.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private class DeviceHierarchyPopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private DeviceHierarchyPopupMenu(JTree tree) {
            this.tree = tree;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        DeviceHierarchyPopupMenu.this.hostActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        public void showMenu(MouseEvent evt, String name) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(name);
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(2).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        public void showMenu(MouseEvent evt, Device collec) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(collec.toString());
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(5).setVisible(true);
            this.getComponent(4).setVisible(false);
            this.getComponent(3).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        private void hostActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int cmdidx = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                cmdidx = i;
            }
            switch (cmdidx) {
                case 0: {
                    break;
                }
                case 3: {
                    DeviceHierarchy.this.remoteShell();
                    break;
                }
                case 2: {
                    DeviceHierarchy.this.hostPanel();
                    break;
                }
                case 1: {
                    DeviceHierarchy.this.testDevice();
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int COLLEC = 1;
        private final int LEAF = 2;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            root_icon = utils.getIcon("network5.gif");
            this.fonts = new Font[3];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
        }

        Cursor getNodeCursor(String filename) {
            URL url = this.getClass().getResource("/app_util/img/" + filename);
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), filename);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(root_icon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof Device) {
                    this.setFont(this.fonts[1]);
                    Device device = (Device)node.getUserObject();
                    this.setIcon(AstorUtil.state_icons[device.state]);
                }
            }
            return this;
        }
    }
}

