/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.AstorTree;
import admin.astor.access.AccessProxy;
import admin.astor.access.EditDialog;
import admin.astor.access.EditTreeItem;
import admin.astor.access.TangoAccess;
import admin.astor.access.UsersTreePopupMenu;
import admin.astor.access.Utils;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UsersTree
extends JTree
implements TangoConst {
    static final int USER_NODE = -2;
    static final int COLLECTION = -1;
    static final int ADDRESS = 0;
    static final int DEVICE = 1;
    static final String[] collecStr = new String[]{"Allowed Addresses", "Devices"};
    static final int WRITE = 0;
    static final int READ = 1;
    static final String[] rightsStr = new String[]{"write", "read"};
    private static final String img_path = "/app_util/img/";
    static ImageIcon tango_icon;
    static ImageIcon all_users_icon;
    static ImageIcon user_icon;
    static ImageIcon add_icon;
    static ImageIcon dev_icon;
    static ImageIcon write_icon;
    static ImageIcon read_icon;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private UsersTreePopupMenu menu;
    private JFrame parent;
    private AccessProxy access_dev;
    CopiedAddresses copied_addresses = new CopiedAddresses();
    CopiedDevices copied_devices = new CopiedDevices();
    private static final Color background;
    private boolean manage_expand = true;
    EditTreeItem edit_item;

    public UsersTree(JFrame parent, AccessProxy access_dev) throws DevFailed {
        this.parent = parent;
        this.access_dev = access_dev;
        this.setBackground(background);
        this.buildTree();
        this.menu = new UsersTreePopupMenu(this);
    }

    private void buildTree() throws DevFailed {
        String str_root = "Tango Control Access";
        try {
            str_root = "Access to  " + ApiUtil.get_db_obj().get_tango_host();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        this.root = new DefaultMutableTreeNode(str_root);
        this.createUserNodes();
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
            }

            public void treeExpanded(TreeExpansionEvent e) {
                UsersTree.this.expandedPerfomed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                UsersTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.access_dev.getAccessControl() == 0) {
            return;
        }
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        if (evt.getClickCount() == 2 && (mask & 0x10) != 0) {
            if (o instanceof AccessAddress || o instanceof AccessDevice) {
                this.editItem();
            }
        } else if ((mask & 4) != 0) {
            if (node == this.root) {
                this.menu.showMenu(evt, (String)o);
            } else if (o instanceof AccessAddress) {
                this.menu.showMenu(evt, 0, o);
            } else if (o instanceof AccessDevice) {
                this.menu.showMenu(evt, 1, o);
            } else if (o instanceof AccessUser) {
                this.menu.showMenu(evt, -2, o);
            } else if (o instanceof String) {
                this.menu.showMenu(evt, -1, o);
            }
        }
    }

    public void expandedPerfomed(TreeExpansionEvent evt) {
        if (!this.manage_expand) {
            return;
        }
        TreePath tp = evt.getPath();
        Object[] path = tp.getPath();
        if (path.length < 2) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getPathComponent(path.length - 1);
        switch (path.length) {
            case 2: {
                this.expendUserNode(node.toString());
                break;
            }
            case 3: {
                if (node.toString().equals(collecStr[0])) {
                    this.createAddressNodes(node);
                    break;
                }
                this.createDeviceNodes(node);
            }
        }
    }

    private void createDeviceNodes(DefaultMutableTreeNode node) {
        try {
            Object obj = ((DefaultMutableTreeNode)node.getParent()).getUserObject();
            String user = ((AccessUser)obj).getName();
            AccessDevice[] devices = this.getDevices(user);
            for (int i = 0; i < devices.length; ++i) {
                DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(devices[i]);
                this.treeModel.insertNodeInto(d_node, node, i);
            }
            this.removePreviousNode(node, devices.length);
        }
        catch (DevFailed e) {
            this.removePreviousNode(node, 0);
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Cannot read devices", (DevFailed)e);
        }
    }

    private void createAddressNodes(DefaultMutableTreeNode node) {
        try {
            Object obj = ((DefaultMutableTreeNode)node.getParent()).getUserObject();
            String user = ((AccessUser)obj).getName();
            AccessAddress[] addresses = this.getAddresses(user);
            if (!this.createChildNodes(node, addresses)) {
                return;
            }
            for (int i = 0; i < addresses.length; ++i) {
                DefaultMutableTreeNode a_node = new DefaultMutableTreeNode(addresses[i]);
                this.treeModel.insertNodeInto(a_node, node, i);
            }
            this.removePreviousNode(node, addresses.length);
        }
        catch (DevFailed e) {
            this.removePreviousNode(node, 0);
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Cannot read addresses", (DevFailed)e);
        }
    }

    private void createUserNode(String name) {
        DefaultMutableTreeNode u_node = new DefaultMutableTreeNode(new AccessUser(name));
        DefaultMutableTreeNode a_node = new DefaultMutableTreeNode(collecStr[0]);
        DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(collecStr[1]);
        a_node.add(new DefaultMutableTreeNode(new Dummy()));
        d_node.add(new DefaultMutableTreeNode(new Dummy()));
        u_node.add(a_node);
        u_node.add(d_node);
        this.root.add(u_node);
    }

    private void createUserNodes() throws DevFailed {
        String[] users = this.access_dev.getUsers();
        int ratio = 80 / users.length;
        for (int i = 0; i < users.length; ++i) {
            TangoAccess.increaseSplashProgress(ratio, "building tree for " + users[i]);
            this.createUserNode(users[i]);
        }
    }

    private boolean createChildNodes(DefaultMutableTreeNode node, AccessAddress[] address) {
        boolean create = false;
        if (node.getChildCount() != address.length) {
            create = true;
        } else {
            for (int i = 0; i < address.length; ++i) {
                if (node.getChildAt(i).toString().equals(address[i].toString())) continue;
                create = true;
            }
        }
        return create;
    }

    private void removePreviousNode(DefaultMutableTreeNode node, int offset) {
        while (node.getChildCount() > offset) {
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)node.getChildAt(offset);
            this.treeModel.removeNodeFromParent(leaf);
        }
    }

    private AccessDevice[] getDevices(String user) throws DevFailed {
        String[] result = this.access_dev.getDevicesByUser(user);
        AccessDevice[] ret = new AccessDevice[result.length / 2];
        for (int i = 0; i < result.length / 2; ++i) {
            ret[i] = new AccessDevice(result[2 * i], result[2 * i + 1]);
        }
        return ret;
    }

    private AccessAddress[] getAddresses(String user) throws DevFailed {
        String[] result = this.access_dev.getAddressesByUser(user);
        AccessAddress[] ret = new AccessAddress[result.length];
        for (int i = 0; i < result.length; ++i) {
            ret[i] = new AccessAddress(result[i]);
        }
        return ret;
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    void addUser() {
        EditDialog dlg = new EditDialog(this.parent);
        if (dlg.showDialog() != 0) {
            return;
        }
        String[] str = dlg.getInputs();
        String user = str[0];
        String address = str[1];
        String devname = "*/*/*";
        TreePath tp = null;
        boolean already_exists = false;
        if (this.userExists(user)) {
            this.expendUserNode(user);
            PopupError.show((Component)this.parent, "User  " + user + "  Already exists !");
        } else {
            try {
                this.access_dev.addAddress(user, address);
                this.access_dev.addDevice(user, devname, rightsStr[0]);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
                return;
            }
            Object[] path = new TreeNode[4];
            DefaultMutableTreeNode new_user_node = new DefaultMutableTreeNode(new AccessUser(user));
            DefaultMutableTreeNode new_str_add_node = new DefaultMutableTreeNode(collecStr[0]);
            DefaultMutableTreeNode new_str_dev_node = new DefaultMutableTreeNode(collecStr[1]);
            DefaultMutableTreeNode new_add_node = new DefaultMutableTreeNode(new AccessAddress(address));
            DefaultMutableTreeNode new_dev_node = new DefaultMutableTreeNode(new AccessDevice(devname, 0));
            this.treeModel.insertNodeInto(new_user_node, this.root, this.root.getChildCount());
            this.treeModel.insertNodeInto(new_str_add_node, new_user_node, 0);
            this.treeModel.insertNodeInto(new_str_dev_node, new_user_node, 1);
            this.treeModel.insertNodeInto(new_add_node, new_str_add_node, 0);
            this.treeModel.insertNodeInto(new_dev_node, new_str_dev_node, 0);
            path[0] = this.root;
            path[1] = new_user_node;
            path[2] = new_str_add_node;
            path[3] = new_add_node;
            tp = new TreePath(path);
            this.setSelectionPath(tp);
            path[2] = new_str_dev_node;
            path[3] = new_dev_node;
            tp = new TreePath(path);
            this.setSelectionPath(tp);
        }
        this.scrollPathToVisible(tp);
    }

    void addItem() {
        DefaultMutableTreeNode new_node;
        int obj_type;
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object o = node.getUserObject();
        if (o.toString().equals(collecStr[0])) {
            obj_type = 0;
        } else if (o.toString().equals(collecStr[1])) {
            obj_type = 1;
        } else {
            return;
        }
        Object[] path = new DefaultMutableTreeNode[4];
        path[0] = this.root;
        path[1] = node.getParent();
        path[2] = node;
        DefaultMutableTreeNode dummy_node = null;
        if (node.getChildCount() > 0) {
            path[3] = node.getChildAt(0);
        } else {
            dummy_node = new DefaultMutableTreeNode(new Dummy());
            this.treeModel.insertNodeInto(dummy_node, node, node.getChildCount());
            path[3] = dummy_node;
            this.manage_expand = false;
        }
        TreePath tp = new TreePath(path);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
        switch (obj_type) {
            case 0: {
                new_node = new DefaultMutableTreeNode(new AccessAddress("*.*.*.*"));
                this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                path[3] = new_node;
                tp = new TreePath(path);
                this.setSelectionPath(tp);
                this.scrollPathToVisible(tp);
                break;
            }
            case 1: {
                new_node = new DefaultMutableTreeNode(new AccessDevice("*/*/*", 0));
                this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                path[3] = new_node;
                tp = new TreePath(path);
                this.setSelectionPath(tp);
                this.scrollPathToVisible(tp);
                break;
            }
            default: {
                return;
            }
        }
        if (dummy_node != null) {
            this.treeModel.removeNodeFromParent(dummy_node);
        }
        this.manage_expand = true;
        if (!this.editItem()) {
            this.treeModel.removeNodeFromParent(new_node);
        }
    }

    boolean editItem() {
        String value;
        int obj_type;
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return true;
        }
        Object o = node.getUserObject();
        if (o instanceof AccessDevice) {
            obj_type = 1;
            value = ((AccessDevice)o).name;
        } else if (o instanceof AccessAddress) {
            obj_type = 0;
            value = ((AccessAddress)o).name;
        } else {
            return false;
        }
        this.edit_item = new EditTreeItem((Frame)this.parent, this, value, obj_type);
        if (this.edit_item.showDlg()) {
            String user = node.getParent().getParent().toString();
            String new_name = this.edit_item.getInputs();
            try {
                switch (obj_type) {
                    case 0: {
                        AccessAddress add = (AccessAddress)o;
                        this.access_dev.removeAddress(user, add.name);
                        this.access_dev.addAddress(user, new_name);
                        add.setName(new_name);
                        this.rebuildNode(node, add);
                        break;
                    }
                    case 1: {
                        AccessDevice dev = (AccessDevice)o;
                        this.access_dev.removeDevice(user, dev.name, rightsStr[dev.right]);
                        this.access_dev.addDevice(user, new_name, rightsStr[dev.right]);
                        dev.name = new_name;
                        this.rebuildNode(node, dev);
                    }
                }
                return true;
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
            }
        }
        return false;
    }

    private void rebuildNode(DefaultMutableTreeNode node, Object obj) {
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode(obj);
        int idx = parent_node.getIndex(node);
        this.treeModel.insertNodeInto(new_node, parent_node, idx);
        this.treeModel.removeNodeFromParent(node);
    }

    private boolean isAllUsersNode(DefaultMutableTreeNode node) {
        Object o = node.getUserObject();
        if (o instanceof AccessUser) {
            String user = ((AccessUser)o).getName();
            return user.equals("*");
        }
        return false;
    }

    private boolean isLastOneForAllUsers(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode collec_node = (DefaultMutableTreeNode)node.getParent();
        DefaultMutableTreeNode user_node = (DefaultMutableTreeNode)collec_node.getParent();
        if (this.isAllUsersNode(user_node)) {
            return collec_node.getChildCount() == 1;
        }
        return false;
    }

    void removeItem() {
        int obj_type;
        String message;
        String user;
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        if (o instanceof AccessDevice) {
            if (this.isLastOneForAllUsers(node)) {
                PopupError.show((Component)this.parent, "Cannot remove last device for all users");
                return;
            }
            user = node.getParent().getParent().toString();
            message = "Are you sure to want to remove :  " + o;
            obj_type = 1;
        } else if (o instanceof AccessAddress) {
            if (this.isLastOneForAllUsers(node)) {
                PopupError.show((Component)this.parent, "Cannot remove last address for all users");
                return;
            }
            user = node.getParent().getParent().toString();
            message = "Are you sure to want to remove :  " + o;
            obj_type = 0;
        } else if (o instanceof AccessUser) {
            if (this.isAllUsersNode(node)) {
                PopupError.show((Component)this.parent, "Cannot remove rights for all users");
                return;
            }
            user = ((AccessUser)o).getName();
            obj_type = -2;
            message = "Are you sure to want to remove all records for " + o;
        } else {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, message, "Confirm Dialog", 0) != 0) {
            return;
        }
        try {
            switch (obj_type) {
                case 0: {
                    AccessAddress add = (AccessAddress)o;
                    this.access_dev.removeAddress(user, add.name);
                    break;
                }
                case 1: {
                    AccessDevice dev = (AccessDevice)o;
                    this.access_dev.removeDevice(user, dev.name, rightsStr[dev.right]);
                    break;
                }
                case -2: {
                    this.access_dev.removeUser(user);
                }
            }
            this.treeModel.removeNodeFromParent(node);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
        }
    }

    private String[] getDefinedUsers() {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            v.add(this.root.getChildAt(i).toString());
        }
        String[] str = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            str[i] = (String)v.get(i);
        }
        return str;
    }

    private void expendUserNode(String name) {
        TreePath tp;
        DefaultMutableTreeNode user_node = this.getUserNode(name);
        Object[] path = new TreeNode[4];
        path[0] = this.root;
        path[1] = user_node;
        DefaultMutableTreeNode collec_node = (DefaultMutableTreeNode)user_node.getChildAt(0);
        if (collec_node.getChildCount() > 0) {
            path[2] = collec_node;
            path[3] = collec_node.getChildAt(0);
            tp = new TreePath(path);
            this.setSelectionPath(tp);
        }
        if ((collec_node = (DefaultMutableTreeNode)user_node.getChildAt(1)).getChildCount() > 0) {
            path[2] = collec_node;
            path[3] = collec_node.getChildAt(0);
            tp = new TreePath(path);
            this.setSelectionPath(tp);
        }
        path = new TreeNode[]{this.root, user_node};
        tp = new TreePath(path);
        this.setSelectionPath(tp);
    }

    private DefaultMutableTreeNode getUserNode(String name) {
        Vector v = new Vector();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            Object o = node.getUserObject();
            if (!((AccessUser)o).toString().equals(name)) continue;
            return node;
        }
        return new DefaultMutableTreeNode(name);
    }

    private boolean userExists(String name) {
        String[] users;
        for (String user : users = this.getDefinedUsers()) {
            if (!user.equals(name)) continue;
            return true;
        }
        return false;
    }

    void cloneUser() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        if (o instanceof AccessUser) {
            String src_user = ((AccessUser)o).getName();
            String new_user = "";
            boolean ok = false;
            while (!ok) {
                new_user = (String)JOptionPane.showInputDialog(this.parent, "New User name  ?", "Clone " + src_user + "  ?", 1, null, null, new_user);
                if (new_user == null || new_user.length() == 0) {
                    return;
                }
                if (this.userExists(new_user)) {
                    this.expendUserNode(new_user);
                    PopupError.show((Component)this.parent, "User already exists !");
                    continue;
                }
                ok = true;
            }
            try {
                this.access_dev.cloneUser(src_user, new_user);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
                return;
            }
            DefaultMutableTreeNode u_node = new DefaultMutableTreeNode(new AccessUser(new_user));
            DefaultMutableTreeNode a_node = new DefaultMutableTreeNode(collecStr[0]);
            DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(collecStr[1]);
            this.treeModel.insertNodeInto(a_node, u_node, 0);
            this.treeModel.insertNodeInto(d_node, u_node, 1);
            this.treeModel.insertNodeInto(u_node, this.root, this.root.getChildCount());
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(new Dummy()), a_node, 0);
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(new Dummy()), d_node, 0);
            Object[] path = new DefaultMutableTreeNode[]{this.root, u_node, a_node};
            TreePath tp = new TreePath(path);
            this.setSelectionPath(tp);
            this.scrollPathToVisible(tp);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void pasteItem() {
        int obj_type;
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        if (!(o instanceof String)) return;
        if (o.toString().equals(collecStr[1])) {
            obj_type = 1;
        } else {
            if (!o.toString().equals(collecStr[0])) return;
            obj_type = 0;
        }
        String user = node.getParent().toString();
        try {
            DefaultMutableTreeNode new_node = null;
            switch (obj_type) {
                case 0: {
                    String address = this.copied_addresses.addressAt((int)0).name;
                    this.access_dev.addAddress(user, address);
                    new_node = new DefaultMutableTreeNode(new AccessAddress(address));
                    this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                    break;
                }
                case 1: {
                    String devname = this.copied_devices.deviceAt((int)0).name;
                    int right = this.copied_devices.deviceAt((int)0).right;
                    this.access_dev.addDevice(user, devname, rightsStr[right]);
                    new_node = new DefaultMutableTreeNode(new AccessDevice(devname, right));
                    this.treeModel.insertNodeInto(new_node, node, node.getChildCount());
                }
            }
            Object[] path = new DefaultMutableTreeNode[]{this.root, node.getParent(), node, new_node};
            TreePath tp = new TreePath(path);
            this.setSelectionPath(tp);
            this.scrollPathToVisible(tp);
            return;
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
        }
    }

    void copyItem() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        int obj_type = o instanceof AccessDevice ? 1 : 0;
        switch (obj_type) {
            case 0: {
                this.copied_addresses.clear();
                this.copied_addresses.add(o);
                break;
            }
            case 1: {
                this.copied_devices.clear();
                this.copied_devices.add(o);
            }
        }
    }

    void toggleRight() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Object o = node.getUserObject();
        node = (DefaultMutableTreeNode)node.getParent().getParent();
        Object uo = node.getUserObject();
        String user = ((AccessUser)uo).getName();
        try {
            AccessDevice dev = (AccessDevice)o;
            int new_right = dev.right == 1 ? 0 : 1;
            this.access_dev.removeDevice(user, dev.name, rightsStr[dev.right]);
            this.access_dev.addDevice(user, dev.name, rightsStr[new_right]);
            dev.right = new_right;
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, (String)"Error during Database access", (DevFailed)e);
        }
    }

    static {
        background = AstorTree.background;
    }

    class CopiedAddresses
    extends Vector {
        CopiedAddresses() {
        }

        AccessAddress addressAt(int i) {
            return (AccessAddress)this.get(i);
        }
    }

    class CopiedDevices
    extends Vector {
        CopiedDevices() {
        }

        AccessDevice deviceAt(int i) {
            return (AccessDevice)this.get(i);
        }
    }

    private class Dummy {
        private Dummy() {
        }

        public String toString() {
            return "";
        }
    }

    class AccessDevice {
        String name;
        int right = 1;

        private AccessDevice(String add, String r) {
            this.name = add;
            for (int i = 0; i < rightsStr.length; ++i) {
                if (!rightsStr[i].equals(r)) continue;
                this.right = i;
            }
        }

        private AccessDevice(String add, int r) {
            this.name = add;
            this.right = r;
        }

        public String toString() {
            return this.name;
        }
    }

    class AccessAddress {
        String name;
        private String hostname = null;

        private AccessAddress(String add) {
            this.name = add;
            this.checkHostname(add);
        }

        private void checkHostname(String add) {
            StringTokenizer stk = new StringTokenizer(add, ".");
            Vector<String> v = new Vector<String>();
            while (stk.hasMoreTokens()) {
                v.add(stk.nextToken());
            }
            byte[] bytes = new byte[4];
            for (int i = 0; i < 4 && i < v.size(); ++i) {
                try {
                    bytes[i] = (byte)Integer.parseInt((String)v.get(i));
                    continue;
                }
                catch (NumberFormatException e) {
                    this.hostname = null;
                    return;
                }
            }
            try {
                InetAddress iadd = InetAddress.getByAddress(bytes);
                this.hostname = iadd.getHostName();
                int pos = this.hostname.indexOf(46);
                if (pos > 0) {
                    this.hostname = this.hostname.substring(0, pos);
                }
            }
            catch (Exception e) {
                this.hostname = null;
            }
        }

        private void setName(String add) {
            this.name = add;
            this.checkHostname(add);
        }

        public String toString() {
            if (this.hostname == null) {
                return this.name;
            }
            return this.name + "  (" + this.hostname + ")";
        }
    }

    class AccessUser {
        private String name;

        private AccessUser(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name.equals("*") ? "All Users" : this.name;
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int ALL_USERS = 1;
        private final int USER = 2;
        private final int COLLEC = 3;
        private final int LEAF = 4;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            tango_icon = utils.getIcon("network5.gif");
            all_users_icon = utils.getIcon("user.gif");
            user_icon = utils.getIcon("user-2.gif");
            add_icon = utils.getIcon("server.gif");
            dev_icon = utils.getIcon("device.gif");
            write_icon = utils.getIcon("greenbal.gif");
            read_icon = utils.getIcon("redball.gif");
            this.fonts = new Font[5];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 16);
            this.fonts[2] = new Font("Dialog", 1, 12);
            this.fonts[3] = new Font("Dialog", 1, 12);
            this.fonts[4] = new Font("Monospaced", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(tango_icon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof AccessUser) {
                    String user = ((AccessUser)node.getUserObject()).getName();
                    if (user.equals("*")) {
                        this.setFont(this.fonts[1]);
                        this.setIcon(all_users_icon);
                    } else {
                        this.setFont(this.fonts[2]);
                        this.setIcon(user_icon);
                    }
                } else if (node.getUserObject() instanceof String) {
                    this.setFont(this.fonts[3]);
                    if (obj.toString().equals(collecStr[0])) {
                        this.setIcon(add_icon);
                    } else {
                        this.setIcon(dev_icon);
                    }
                } else if (node.getUserObject() instanceof AccessAddress) {
                    this.setFont(this.fonts[4]);
                    this.setIcon(add_icon);
                } else if (node.getUserObject() instanceof AccessDevice) {
                    this.setFont(this.fonts[4]);
                    AccessDevice dev = (AccessDevice)node.getUserObject();
                    if (dev.right == 0) {
                        this.setIcon(write_icon);
                    } else {
                        this.setIcon(read_icon);
                    }
                }
            }
            return this;
        }
    }
}

