/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.AccessProxy;
import admin.astor.access.AllowedCmdTree;
import admin.astor.access.EditDialog;
import admin.astor.access.UsersTree;
import admin.astor.access.Utils;
import app_util.PopupMessage;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class TangoAccess
extends JFrame {
    private static String revNumber = "Release 1.0  -  Fri Sep 12 13:53:31 CEST 2008";
    String access_devname;
    private UsersTree users_tree = null;
    private AllowedCmdTree cmd_tree = null;
    private AccessProxy access_dev;
    private EditDialog check_dlg = null;
    private JFrame parent;
    private static Splash splash;
    private static int splash_progress;
    private static final Dimension pane_size;
    private JMenu actionMenu;
    private JMenuItem checkAccessBtn;
    private JPanel cmdClassPanel;
    private JMenuItem exitBtn;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem principleItem;
    private JRadioButtonMenuItem registerItem;
    private JTabbedPane tabbedPane;
    private JPanel usersPanel;

    public TangoAccess(JFrame parent) throws DevFailed {
        this.parent = parent;
        try {
            this.startSplash();
            TangoAccess.increaseSplashProgress(5, "Reading database");
            this.getTangoService();
            this.initComponents();
            this.initOwnComponents();
            TangoAccess.increaseSplashProgress(5, "Finalize GUI");
            ImageIcon icon = Utils.getInstance().getIcon("tango_icon.jpg");
            this.setIconImage(icon.getImage());
            this.setTitle("Tango Access Control Manager");
            this.pack();
            if (parent.getWidth() > 0) {
                Point p = parent.getLocationOnScreen();
                p.x += 100;
                p.y += 100;
                this.setLocation(p);
            } else {
                ATKGraphicsUtils.centerFrameOnScreen((Frame)this);
            }
            TangoAccess.stopSplash();
        }
        catch (DevFailed e) {
            TangoAccess.stopSplash();
            throw e;
        }
    }

    private void getTangoService() throws DevFailed {
        String[] services = ApiUtil.get_db_obj().getServices("AccessControl", "tango");
        if (services.length == 0) {
            Except.throw_communication_failed((String)"Service_DoesNotExist", (String)"There is no AccessControl service defined !", (String)"TangoAccess.TangoAccess()");
        }
        this.access_devname = services[0];
    }

    private void startSplash() {
        String title = "TangoAccess";
        JSmoothProgressBar myBar = new JSmoothProgressBar();
        myBar.setStringPainted(true);
        myBar.setBackground(Color.gray);
        myBar.setProgressBarColors(Color.yellow, Color.yellow, Color.yellow);
        ImageIcon icon = Utils.getInstance().getIcon("tango.jpg");
        splash = new Splash(icon, Color.yellow, myBar);
        splash.setTitle(title);
        splash.setMessage("Starting....");
        splash.setVisible(true);
    }

    static void stopSplash() {
        splash.progress(100);
        splash.setVisible(false);
    }

    static void increaseSplashProgress(int i, String message) {
        if ((splash_progress += i) > 99) {
            splash_progress = 99;
        }
        splash.progress(splash_progress);
        splash.setMessage(message);
    }

    private void initOwnComponents() throws DevFailed {
        this.fileMenu.setMnemonic('F');
        this.checkAccessBtn.setMnemonic('T');
        this.checkAccessBtn.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.exitBtn.setMnemonic('E');
        this.exitBtn.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.actionMenu.setMnemonic('A');
        this.registerItem.setMnemonic('R');
        this.helpMenu.setMnemonic('H');
        this.principleItem.setMnemonic('P');
        this.principleItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.access_dev = new AccessProxy(this.access_devname);
        if (this.access_dev.getAccessControl() == 0) {
            this.checkAccessBtn.setEnabled(false);
            this.actionMenu.setEnabled(false);
        }
        this.tabbedPane.setTitleAt(0, "Users");
        this.tabbedPane.setTitleAt(1, "Allowed Cmd");
        this.users_tree = new UsersTree(this, this.access_dev);
        JScrollPane scrowllPane = new JScrollPane();
        scrowllPane.setViewportView(this.users_tree);
        this.usersPanel.add((Component)scrowllPane, "Center");
        this.cmd_tree = new AllowedCmdTree(this, this.access_dev);
        scrowllPane = new JScrollPane();
        scrowllPane.setViewportView(this.cmd_tree);
        this.cmdClassPanel.add((Component)scrowllPane, "Center");
        JLabel lbl = new JLabel("Devices: ");
        JPanel panel = new JPanel();
        panel.add(lbl);
        lbl = new JLabel("Read/Write");
        lbl.setIcon(Utils.getInstance().getIcon("greenbal.gif"));
        panel.add(lbl);
        lbl = new JLabel("Read Only");
        lbl.setIcon(Utils.getInstance().getIcon("redball.gif"));
        panel.add(lbl);
        this.usersPanel.add((Component)panel, "South");
        this.tabbedPane.setPreferredSize(pane_size);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.usersPanel = new JPanel();
        this.cmdClassPanel = new JPanel();
        JMenuBar jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.checkAccessBtn = new JMenuItem();
        this.exitBtn = new JMenuItem();
        this.actionMenu = new JMenu();
        this.registerItem = new JRadioButtonMenuItem();
        this.helpMenu = new JMenu();
        this.principleItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TangoAccess.this.exitForm(evt);
            }
        });
        this.usersPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("tab1", this.usersPanel);
        this.cmdClassPanel.setLayout(new BorderLayout());
        this.tabbedPane.addTab("tab2", this.cmdClassPanel);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.fileMenu.setText("File");
        this.checkAccessBtn.setText("Test Tango Acces");
        this.checkAccessBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.checkAccessBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.checkAccessBtn);
        this.exitBtn.setText("Exit");
        this.exitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.exitBtnActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitBtn);
        jMenuBar1.add(this.fileMenu);
        this.actionMenu.setText("Action");
        this.actionMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TangoAccess.this.actionMenuItemStateChanged(evt);
            }
        });
        this.registerItem.setText("Register Service");
        this.registerItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.registerItemActionPerformed(evt);
            }
        });
        this.actionMenu.add(this.registerItem);
        jMenuBar1.add(this.actionMenu);
        this.helpMenu.setText("help");
        this.principleItem.setText("On Principle");
        this.principleItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TangoAccess.this.principleItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.principleItem);
        jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void actionMenuItemStateChanged(ItemEvent evt) {
        if (!this.actionMenu.isSelected()) {
            return;
        }
        try {
            String[] services = ApiUtil.get_db_obj().getServices("AccessControl", "tango");
            this.registerItem.setSelected(services.length != 0);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)e);
        }
    }

    private void registerItemActionPerformed(ActionEvent evt) {
        try {
            boolean b = this.registerItem.getSelectedObjects() != null;
            this.access_dev.registerService(b);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot start TangoAccess class", (DevFailed)e);
        }
    }

    private void checkAccessBtnActionPerformed(ActionEvent evt) {
        if (this.check_dlg == null) {
            this.check_dlg = new EditDialog(this, this.access_dev);
            this.check_dlg.showDialog();
        } else {
            this.check_dlg.setVisible(true);
        }
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void principleItemActionPerformed(ActionEvent evt) {
        PopupMessage.show((Component)this, "This access management is necessary only if the\n    \"AccessControl/tango\"\n    Tango service has been installed.\n\nBy default all devices are forbiden for all users.\nAnd the rights will be opened for [user, address, device].\n\nThis tool is able to define WRITE access \n    on devices for a TANGO control system\n\nYou can define for a specified user:\n    - Allowed addresses to write devices\n    - Set devices acces to  READ_WRITE or READ_ONLY");
    }

    private void doClose() {
        if (this.parent.getWidth() > 0) {
            this.setVisible(false);
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        try {
            new TangoAccess(new JFrame()).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), (String)"Cannot start TangoAccess class", (DevFailed)e);
            System.exit(0);
        }
        catch (InternalError e) {
            System.out.println(e);
        }
        catch (HeadlessException e) {
            System.out.println(e);
        }
    }

    static {
        splash_progress = 5;
        pane_size = new Dimension(350, 500);
    }
}

