/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.AccessProxy;
import admin.astor.access.UsersTree;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditDialog
extends JDialog {
    private int retVal = 0;
    static final int CHECK_ACCESS = 0;
    static final int EDIT_USER = 1;
    private int mode = 1;
    private static String[] titles;
    private static final String[] check_titles;
    private static final String[] edit_titles;
    static final int USER = 0;
    static final int ADDRESS = 1;
    static final int DEVICE = 2;
    private AccessProxy access_dev;
    private JTextField[] textFields;
    private JLabel check_result;
    private JLabel[] labels;
    private JButton cancelBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton okBtn;
    private JLabel titleLabel;

    public EditDialog(JFrame parent) {
        super((Frame)parent, true);
        this.mode = 1;
        titles = edit_titles;
        this.initComponents();
        this.initOwnComponents(titles);
        this.labels[2].setVisible(false);
        this.textFields[2].setVisible(false);
        this.titleLabel.setText("");
        this.pack();
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - this.getWidth()) / 2;
        p.y += (parent.getHeight() - this.getHeight()) / 2;
        if (p.y <= 0) {
            p.y = 20;
        }
        if (p.x <= 0) {
            p.x = 20;
        }
        this.setLocation(p);
    }

    public EditDialog(JFrame parent, AccessProxy access_dev) {
        super((Frame)parent, true);
        this.mode = 0;
        titles = check_titles;
        this.access_dev = access_dev;
        this.initComponents();
        this.initOwnComponents(titles);
        this.titleLabel.setText("");
        this.pack();
        Point p = parent.getLocationOnScreen();
        p.x += (parent.getWidth() - this.getWidth()) / 2;
        p.y += (parent.getHeight() - this.getHeight()) / 2;
        if (p.y <= 0) {
            p.y = 20;
        }
        if (p.x <= 0) {
            p.x = 20;
        }
        this.setLocation(p);
    }

    private void initOwnComponents(String[] titles) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.textFields = new JTextField[titles.length];
        this.labels = new JLabel[titles.length];
        for (int i = 0; i < titles.length; ++i) {
            this.labels[i] = new JLabel(titles[i] + ":  ");
            gbc.gridx = 0;
            gbc.gridy = i;
            gbc.fill = 2;
            this.jPanel3.add((Component)this.labels[i], gbc);
            this.textFields[i] = new JTextField();
            this.textFields[i].setColumns(20);
            this.textFields[i].addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent evt) {
                    EditDialog.this.textKeyPressed(evt);
                }
            });
            gbc.gridx = 1;
            gbc.gridy = i;
            gbc.fill = 2;
            this.jPanel3.add((Component)this.textFields[i], gbc);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditDialog.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel3.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.pack();
    }

    private boolean checkInputs() {
        String user = this.textFields[0].getText().trim().toLowerCase();
        String add = this.textFields[1].getText().trim();
        String dev = this.textFields[2].getText().trim().toLowerCase();
        if (user.length() == 0 || add.length() == 0 || this.mode == 0 && dev.length() == 0) {
            PopupError.show((Component)this, "Please fill all fields !");
            return false;
        }
        this.textFields[0].setText(user);
        this.textFields[2].setText(dev);
        this.textFields[1].setText(add);
        try {
            InetAddress iadd = InetAddress.getByName(add);
            add = iadd.getHostAddress();
            this.textFields[1].setText(add);
        }
        catch (Exception e) {
            // empty catch block
        }
        Vector<String> v = new Vector<String>();
        if (this.mode == 0) {
            StringTokenizer stk = new StringTokenizer(dev, "/");
            while (stk.hasMoreTokens()) {
                v.add(stk.nextToken());
            }
            if (v.size() > 3) {
                PopupError.show((Component)this, "Incorrect device name  (too many members)");
                return false;
            }
            if (v.size() < 3) {
                PopupError.show((Component)this, "Incorrect device name  (not enough members)");
                return false;
            }
        }
        StringTokenizer stk1 = new StringTokenizer(add, ".");
        v.clear();
        while (stk1.hasMoreTokens()) {
            v.add(stk1.nextToken());
        }
        if (v.size() > 4) {
            PopupError.show((Component)this, "Incorrect IP address  (Too many members)");
            return false;
        }
        if (v.size() < 4) {
            PopupError.show((Component)this, "Incorrect IP address  (not enougth members)");
            return false;
        }
        add = v.get(0) + "." + v.get(1) + "." + v.get(2) + "." + v.get(3);
        this.textFields[1].setText(add);
        for (int i = 0; i < v.size(); ++i) {
            try {
                Short.parseShort((String)v.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                if (v.get(i).equals("*")) continue;
                PopupError.show((Component)this, "Incorrect IP address  (member #" + (i + 1) + " (" + v.get(i) + ") is not a number)");
                return false;
            }
        }
        return true;
    }

    private void checkAccess() {
        try {
            String result = this.access_dev.getAccess(this.getInputs());
            this.check_result.setText(result);
            if (result.equals("read")) {
                this.check_result.setIcon(UsersTree.read_icon);
            } else {
                this.check_result.setIcon(UsersTree.write_icon);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot check TANGO Access", (DevFailed)e);
        }
    }

    private void textKeyPressed(KeyEvent evt) {
        char c = evt.getKeyChar();
        switch (c) {
            case '\u001b': {
                this.retVal = 2;
                this.doClose();
                break;
            }
            case '\n': {
                switch (this.mode) {
                    case 1: {
                        if (!this.checkInputs()) break;
                        this.retVal = 0;
                        this.doClose();
                        break;
                    }
                    case 0: {
                        if (!this.checkInputs()) break;
                        this.checkAccess();
                    }
                }
                break;
            }
            default: {
                if (this.mode != 0) break;
                this.check_result.setText("...");
                this.check_result.setIcon(null);
            }
        }
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        if (this.checkInputs()) {
            this.retVal = 0;
            if (this.mode == 1) {
                this.doClose();
            } else {
                this.checkAccess();
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public String[] getInputs() {
        String[] val = new String[this.textFields.length];
        for (int i = 0; i < this.textFields.length; ++i) {
            val[i] = this.textFields[i].getText().trim();
        }
        return val;
    }

    public int showDialog() {
        if (this.mode == 0) {
            try {
                this.textFields[0].setText(System.getProperty("user.name").toLowerCase());
                this.textFields[1].setText(InetAddress.getLocalHost().getHostAddress());
                this.okBtn.setText("Check");
                GridBagConstraints gbc = new GridBagConstraints();
                this.check_result = new JLabel("...");
                gbc.gridx = 1;
                gbc.gridy = titles.length;
                gbc.fill = 2;
                this.jPanel3.add((Component)this.check_result, gbc);
                this.pack();
            }
            catch (UnknownHostException e) {
                PopupError.show((Component)this, e);
            }
        }
        this.setVisible(true);
        return this.retVal;
    }

    static {
        check_titles = new String[]{"User Name", "IP Address", "Device"};
        edit_titles = new String[]{"User Name", "Allowed Address", "Device"};
    }
}

