/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.ServerInfo;
import admin.astor.TangoHost;
import fr.esrf.TangoApi.DbServInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ServersTree
extends JScrollPane
implements AstorDefs {
    private Astor parent;
    public JTree tree;
    public TangoHost[] hosts;
    private DefaultTreeModel treeModel;
    private DbServInfo selection;

    public ServersTree(Astor parent, String title, Vector servnames, Vector servers_info) {
        this.parent = parent;
        this.initComponent(title, servnames, servers_info);
    }

    private void initComponent(String title, Vector servnames, Vector servers_info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(title);
        this.createNodes(root, servnames, servers_info);
        this.tree = new JTree(root);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(root);
        this.tree.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new TangoRenderer());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ServersTree.this.serverSelectionPerformed(e);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ServersTree.this.treeMouseClicked(evt);
            }
        });
        this.add(this.tree);
        this.setPreferredSize(new Dimension(280, 400));
        this.setViewportView(this.tree);
        this.setVisible(true);
    }

    public void serverSelectionPerformed(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        if (node.isLeaf() && obj instanceof DbServInfo) {
            this.selection = (DbServInfo)obj;
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.tree.getRowForLocation(evt.getX(), evt.getY()) < 1) {
            return;
        }
        TreePath path = this.tree.getPathForLocation(evt.getX(), evt.getY());
        int mask = evt.getModifiers();
        if (evt.getClickCount() == 2 && (mask & 0x10) != 0 && this.selection != null && path.getPathCount() - 2 == 1) {
            this.parent.tree.displayHostInfo();
        }
    }

    private void createNodes(DefaultMutableTreeNode root, Vector servnames, Vector servers_info) {
        int i;
        DefaultMutableTreeNode[] collection = new DefaultMutableTreeNode[servnames.size()];
        for (i = 0; i < servnames.size(); ++i) {
            collection[i] = new DefaultMutableTreeNode(servnames.elementAt(i));
            root.add(collection[i]);
        }
        for (i = 0; i < servnames.size(); ++i) {
            for (int inf = 0; inf < servers_info.size(); ++inf) {
                DbServInfo[] servinfo;
                for (DbServInfo info : servinfo = (DbServInfo[])servers_info.elementAt(inf)) {
                    String sname = (String)servnames.elementAt(i);
                    if (info.name.indexOf(sname) < 0) continue;
                    ServerInfo s = new ServerInfo(info);
                    DefaultMutableTreeNode instance = new DefaultMutableTreeNode((Object)s);
                    collection[i].add(instance);
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon tangoIcon;
        String tango_host = AstorUtil.getTangoHost();
        ImageIcon serv_icon;
        ImageIcon inst_icon;
        Font[] fonts;
        private final int TITLE = 0;
        private final int LEAF = 1;

        public TangoRenderer() {
            this.tangoIcon = new ImageIcon(this.getClass().getResource("/app_util/img/network5.gif"));
            this.serv_icon = new ImageIcon(this.getClass().getResource("/app_util/img/server.gif"));
            this.inst_icon = new ImageIcon(this.getClass().getResource("/app_util/img/device.gif"));
            this.fonts = new Font[2];
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(Color.white);
            if (row == 0) {
                this.setBackgroundSelectionColor(Color.white);
                this.setIcon(this.tangoIcon);
                this.setFont(this.fonts[0]);
                this.setToolTipText(this.tango_host);
            } else if (leaf) {
                this.setBackgroundSelectionColor(Color.lightGray);
                this.setIcon(this.inst_icon);
                this.setFont(this.fonts[1]);
                this.setToolTipText("Double click to popup host panel.");
            } else {
                this.setBackgroundSelectionColor(Color.white);
                this.setIcon(this.serv_icon);
                this.setFont(this.fonts[1]);
                this.setToolTipText("Server");
            }
            return this;
        }
    }
}

