/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.DbPollPanel;
import admin.astor.HostInfoDialog;
import admin.astor.LevelTree;
import admin.astor.ManagePollingDialog;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import admin.astor.tools.DeviceHierarchyDialog;
import admin.astor.tools.PollingProfiler;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ServerPopupMenu
extends JPopupMenu
implements AstorDefs {
    private TangoHost host;
    private TangoServer server;
    private LevelTree tree;
    private JFrame frame;
    private HostInfoDialog parent;
    private int mode;
    static final int SERVERS = 0;
    static final int LEVELS = 1;
    static final int NOTIFD = 2;
    private static String[] pMenuLabels;
    private static String[] serverMenuLabels;
    private static String[] levelMenuLabels;
    private static String[] notifdMenuLabels;
    private static final int OFFSET = 2;
    private static final int START_STOP = 0;
    private static final int RESTART = 1;
    private static final int STARTUP_LEVEL = 2;
    private static final int POLLING_MANAGER = 3;
    private static final int POLLING_PROFILER = 4;
    private static final int POOL_THREAD_MAN = 5;
    private static final int CONFIGURE = 6;
    private static final int DB_ATTRIBUTES = 7;
    private static final int SERVER_INFO = 8;
    private static final int CLASS_INFO = 9;
    private static final int DEPENDENCY = 10;
    private static final int TEST_DEVICE = 11;
    private static final int CHECK_STATES = 12;
    private static final int STD_ERROR = 13;
    private static final int START = 0;
    private static final int STOP = 1;
    private static final int EXPAND = 2;
    private static final boolean TANGO_7 = false;
    private Point location;

    public ServerPopupMenu(JFrame frame, HostInfoDialog parent, TangoHost host, int mode) {
        this.frame = frame;
        this.parent = parent;
        this.host = host;
        this.mode = mode;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        JLabel title = new JLabel("Server Control :");
        title.setFont(new Font("Dialog", 1, 16));
        this.add(title);
        this.add(new JPopupMenu.Separator());
        switch (this.mode) {
            case 0: {
                pMenuLabels = serverMenuLabels;
                break;
            }
            case 1: {
                pMenuLabels = levelMenuLabels;
                break;
            }
            default: {
                title.setText("Event Notify Daemon");
                pMenuLabels = notifdMenuLabels;
            }
        }
        for (String lbl : pMenuLabels) {
            JMenuItem btn = new JMenuItem(lbl);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ServerPopupMenu.this.cmdActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    public void showMenu(MouseEvent evt, JTree tree, TangoServer server) {
        boolean running;
        TreePath selectedPath = tree.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        tree.setSelectionPath(selectedPath);
        String name = server.getName();
        JLabel lbl = (JLabel)this.getComponent(0);
        lbl.setText("  " + name + "  :");
        this.server = server;
        JMenuItem mi = (JMenuItem)this.getComponent(2);
        boolean bl = running = server.getState() == DevState.ON;
        if (running || server.getState() == DevState.MOVING) {
            mi.setText("Kill  Server");
        } else {
            mi.setText("Start Server");
        }
        this.getComponent(3).setEnabled(running);
        this.getComponent(6).setEnabled(running);
        this.getComponent(13).setEnabled(running);
        this.getComponent(14).setEnabled(running);
        this.getComponent(8).setEnabled(running);
        this.getComponent(9).setVisible(!running);
        this.getComponent(7).setVisible(false);
        this.getComponent(12).setVisible(false);
        this.location = tree.getLocationOnScreen();
        this.show(tree, evt.getX(), evt.getY());
    }

    public void showMenu(MouseEvent evt, LevelTree tree, boolean expanded) {
        this.tree = tree;
        JLabel lbl = (JLabel)this.getComponent(0);
        lbl.setText("  " + tree + "  :");
        JMenuItem mi = (JMenuItem)this.getComponent(4);
        mi.setText(expanded ? "Collapse Tree" : levelMenuLabels[2]);
        this.location = tree.getLocationOnScreen();
        this.show(tree, evt.getX(), evt.getY());
    }

    public void showMenu(MouseEvent evt, int state) {
        JLabel lbl = (JLabel)evt.getSource();
        boolean running = this.host.notifyd_state == 3;
        this.getComponent(2).setEnabled(!running);
        this.location = lbl.getLocationOnScreen();
        this.show(lbl, evt.getX(), evt.getY());
    }

    private void cmdActionPerformed(ActionEvent evt) {
        switch (this.mode) {
            case 0: {
                this.serverCmdActionPerformed(evt);
                break;
            }
            case 1: {
                this.levelCmdActionPerformed(evt);
                break;
            }
            case 2: {
                this.notifdCmdActionPerformed(evt);
            }
        }
    }

    private void notifdCmdActionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        int cmdidx = -1;
        for (int i = 0; i < notifdMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != obj) continue;
            cmdidx = i;
        }
        switch (cmdidx) {
            case 0: {
                this.host.startServer(this.parent, "notify_daemon/" + this.host.getName());
            }
        }
    }

    private void levelCmdActionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        int cmdidx = -1;
        for (int i = 0; i < levelMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != obj) continue;
            cmdidx = i;
        }
        switch (cmdidx) {
            case 0: {
                this.parent.startLevel(this.tree.getLevelRow());
                break;
            }
            case 1: {
                this.parent.stopLevel(this.tree.getLevelRow());
                break;
            }
            case 2: {
                this.tree.toggleExpandCollapse();
            }
        }
    }

    private void serverCmdActionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        int cmdidx = -1;
        for (int i = 0; i < serverMenuLabels.length; ++i) {
            if (this.getComponent(2 + i) != obj) continue;
            cmdidx = i;
        }
        switch (cmdidx) {
            case 2: {
                if (!this.server.startupLevel(this.parent, this.host.getName(), this.location)) break;
                this.parent.updateData();
                break;
            }
            case 3: {
                if (this.server.getState() == DevState.ON) {
                    new ManagePollingDialog(this.parent, this.server).setVisible(true);
                    break;
                }
                try {
                    new DbPollPanel(this.parent, this.server.getName()).setVisible(true);
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
                }
                break;
            }
            case 5: {
                this.server.poolThreadManager(this.parent, this.host);
                break;
            }
            case 4: {
                this.startPollingProfiler();
                break;
            }
            case 11: {
                this.server.testDevice(this.parent, this.location);
                break;
            }
            case 12: {
                this.server.checkStates(this.parent, this.location);
                break;
            }
            case 6: {
                this.server.configureWithWizard(this.parent);
                break;
            }
            case 8: {
                this.server.displayServerInfo(this.parent);
                break;
            }
            case 7: {
                this.server.manageMemorizedAttributes(this.parent);
                break;
            }
            case 9: {
                this.server.displayClassInfo(this.frame);
                break;
            }
            case 10: {
                try {
                    new DeviceHierarchyDialog(this.parent, this.server.getName()).setVisible(true);
                }
                catch (DevFailed e) {
                    ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
                }
                break;
            }
            case 13: {
                System.out.println("readStdErrorFile for " + this.server);
                if (this.server != null) {
                    this.host.readStdErrorFile(this.frame, this.server.getName());
                    break;
                }
                this.host.readStdErrorFile(this.frame, "notify_daemon/" + this.host.getName());
                break;
            }
            case 1: {
                this.server.restart(this.parent, this.host, true);
                break;
            }
            case 0: {
                if (this.server.getState() == DevState.ON || this.server.getState() == DevState.MOVING) {
                    try {
                        if (JOptionPane.showConfirmDialog(this.parent, "Are you sure to want to kill " + this.server.getName(), "Confirm Dialog", 0) != 0) {
                            return;
                        }
                        this.host.stopServer(this.server.getName());
                    }
                    catch (DevFailed e) {
                        if (e.errors[0].reason.equals("SERVER_NOT_RESPONDING")) {
                            try {
                                if (JOptionPane.showConfirmDialog(this.parent, e.errors[0].desc + "\n" + "Do you even want to kill it ?", "Confirm Dialog", 0) != 0) {
                                    return;
                                }
                                this.host.hardKillServer(this.server.getName());
                            }
                            catch (DevFailed e2) {
                                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e2);
                            }
                            break;
                        }
                        ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
                    }
                    break;
                }
                this.host.startServer(this.parent, this.server.getName());
            }
        }
    }

    private void startPollingProfiler() {
        try {
            String[] devnames = this.server.queryDevice();
            new PollingProfiler((JDialog)this.parent, devnames).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
    }

    static {
        serverMenuLabels = new String[]{"Start server", "Restart server", "Set startup level", "Polling Manager", "Polling Profiler", "Pool Threads Manager", "Configure (Wizard)", "DB Attribute Properties", "Server Info", "Class  Info", "Device Dependency", "Test   Device", "Check  States", "Standard Error"};
        levelMenuLabels = new String[]{"Start servers", "Stop  servers", "Expand Tree"};
        notifdMenuLabels = new String[]{"Start daemon"};
    }
}

