/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.HostInfoDialog;
import admin.astor.ServerPopupMenu;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import fr.esrf.Tango.DevState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class LevelTree
extends JTree
implements AstorDefs {
    private HostInfoDialog parent;
    private DefaultTreeModel treeModel;
    private ServerPopupMenu server_menu;
    private ServerPopupMenu level_menu;
    private TangoHost host;
    private Color bg;
    private Level level;
    private DefaultMutableTreeNode root;

    public LevelTree(JFrame frame, HostInfoDialog parent, TangoHost host, int level_row) {
        this.parent = parent;
        this.host = host;
        this.bg = parent.getBackgroundColor();
        this.setBackground(this.bg);
        this.server_menu = new ServerPopupMenu(frame, parent, host, 0);
        this.level_menu = new ServerPopupMenu(frame, parent, host, 1);
        this.level = new Level(level_row);
        this.initComponent();
        this.manageVisiblity();
    }

    public boolean hasRunningServer() {
        return this.level.hasRunningServer();
    }

    public DevState getState() {
        return this.level.getState();
    }

    public int getNbServers() {
        return this.level.size();
    }

    public void manageVisiblity() {
        this.setVisible(this.level.size() > 0);
    }

    public TangoServer getServer(String servname) {
        return this.level.getServer(servname);
    }

    public int getLevelRow() {
        return this.level.row;
    }

    private void initComponent() {
        this.root = new DefaultMutableTreeNode(this.level);
        for (int i = 0; i < this.level.size(); ++i) {
            this.root.add(new DefaultMutableTreeNode(this.level.getServer(i)));
        }
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LevelTree.this.treeMouseClicked(evt);
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent evt) {
                LevelTree.this.parent.pack();
            }

            public void treeExpanded(TreeExpansionEvent evt) {
                LevelTree.this.parent.pack();
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                LevelTree.this.selectionChanged(evt);
            }
        });
        if (this.level.row == 0) {
            this.collapseTree();
        }
    }

    public void selectionChanged(TreeSelectionEvent evt) {
    }

    public void checkUpdate() {
        this.level.updateServerList();
        this.manageVisiblity();
        for (int i = 0; i < this.level.size(); ++i) {
            TangoServer server = this.level.getServer(i);
            DefaultMutableTreeNode node = this.root;
            int nb = this.root.getChildCount();
            boolean found = false;
            for (int j = 0; !found && j < nb; ++j) {
                TangoServer ts = (TangoServer)(node = node.getNextNode()).getUserObject();
                found = ts == server;
            }
            if (found) continue;
            node = new DefaultMutableTreeNode(server);
            this.treeModel.insertNodeInto(node, this.root, i);
            this.setSelectionPath(new TreePath(node.getPath()));
            this.expandRow(i);
        }
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            TangoServer server = (TangoServer)node.getUserObject();
            boolean found = false;
            for (int j = 0; !found && j < this.level.size(); ++j) {
                found = server == this.level.getServer(j);
            }
            if (found) continue;
            this.treeModel.removeNodeFromParent(node);
            --i;
        }
    }

    public void resetSelection() {
        this.manageVisiblity();
        this.setSelectionPath(new TreePath(this.root.getPath()));
    }

    public void setSelection(TangoServer server) {
        this.manageVisiblity();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            TangoServer ts = (TangoServer)node.getUserObject();
            if (ts != server) continue;
            this.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    void expandTree() {
        this.expandRow(0);
    }

    void collapseTree() {
        this.collapseRow(0);
    }

    void toggleExpandCollapse() {
        if (this.isExpanded(0)) {
            this.collapseTree();
        } else {
            this.expandTree();
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) < 0) {
            return;
        }
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object uo = node.getUserObject();
        int mask = evt.getModifiers();
        this.parent.fireNewTreeSelection(this);
        if (evt.getClickCount() == 2) {
            if ((mask & 0x10) != 0) {
                // empty if block
            }
        } else if ((mask & 4) != 0) {
            if (uo instanceof TangoServer) {
                this.server_menu.showMenu(evt, (JTree)this, (TangoServer)uo);
            } else {
                this.level_menu.showMenu(evt, this, this.isExpanded(0));
            }
        }
    }

    public String toString() {
        return this.level.toString();
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts = new Font[3];

        public TangoRenderer() {
            this.fonts[0] = new Font("Dialog", 1, 16);
            this.fonts[1] = new Font("Dialog", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(LevelTree.this.bg);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            Object uo = node.getUserObject();
            this.setFont(this.fonts[node.getLevel()]);
            if (row == 0) {
                this.setIcon(this.getStateIcon(LevelTree.this.level.getState()));
                this.setBackgroundSelectionColor(LevelTree.this.bg);
            } else if (uo instanceof TangoServer) {
                TangoServer server = (TangoServer)uo;
                this.setIcon(this.getStateIcon(server.getState()));
                this.setBackgroundSelectionColor(Color.lightGray);
            }
            return this;
        }

        private ImageIcon getStateIcon(DevState state) {
            int idx = state == DevState.MOVING ? 4 : (state == DevState.ON ? 3 : (state == DevState.ALARM ? 2 : 1));
            return AstorUtil.state_icons[idx];
        }
    }

    class Level
    extends Vector {
        public int row;

        public Level(int row) {
            this.row = row;
            this.updateServerList();
        }

        private void updateServerList() {
            this.clear();
            for (int i = 0; i < LevelTree.this.host.nbServers(); ++i) {
                TangoServer server = LevelTree.this.host.getServer(i);
                if (server.startup_level != this.row) continue;
                this.add(server);
            }
            AstorUtil.getInstance().sort(this);
        }

        TangoServer getServer(int idx) {
            return (TangoServer)this.get(idx);
        }

        TangoServer getServer(String servname) {
            for (int i = 0; i < this.size(); ++i) {
                TangoServer server = this.getServer(i);
                if (!server.getName().equals(servname)) continue;
                return server;
            }
            return null;
        }

        boolean hasRunningServer() {
            for (int i = 0; i < this.size(); ++i) {
                TangoServer server = this.getServer(i);
                if (server.getState() != DevState.ON) continue;
                return true;
            }
            return false;
        }

        DevState getState() {
            boolean is_faulty = false;
            boolean is_alarm = false;
            boolean is_moving = false;
            for (int i = 0; i < this.size(); ++i) {
                TangoServer server = this.getServer(i);
                if (server.getState() == DevState.UNKNOWN) {
                    return DevState.UNKNOWN;
                }
                if (server.getState() == DevState.FAULT) {
                    is_faulty = true;
                    continue;
                }
                if (server.getState() == DevState.ALARM) {
                    is_alarm = true;
                    continue;
                }
                if (server.getState() != DevState.MOVING) continue;
                is_moving = true;
            }
            if (is_faulty) {
                return DevState.FAULT;
            }
            if (is_moving) {
                return DevState.MOVING;
            }
            if (is_alarm) {
                return DevState.ALARM;
            }
            return DevState.ON;
        }

        public String toString() {
            String str = this.row != 0 ? "Level " + this.row : "Not Controlled";
            return str;
        }
    }
}

