/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.io.IOException;
import java.util.Vector;

public class AstorCmdLine {
    private int action = -1;
    private TangoHost[] hosts = null;
    private AstorUtil util;
    private static final int NOT_INITIALIZED = -1;
    private static final int START_SERVERS = 0;
    private static final int STOP_SERVERS = 1;
    private static final String[] known_actions = new String[]{"start", "stop"};
    static final int REMOVE_POLLING = 0;
    static final int REMOVE_POLLING_FORCED = 1;
    private static final String PollAttProp = "polled_attr";
    private int doWhat;

    public AstorCmdLine(String[] args) throws DevFailed, Exception {
        this.util = AstorUtil.getInstance();
        this.manageArgs(args);
        this.doAction();
    }

    private void doAction() {
        int nb_levels = AstorUtil.getStarterNbStartupLevels();
        switch (this.action) {
            case 0: {
                for (int level = 1; level <= nb_levels; ++level) {
                    this.doAction(level);
                }
                break;
            }
            case 1: {
                for (int level = nb_levels; level >= 1; --level) {
                    this.doAction(level);
                }
                break;
            }
        }
    }

    private void doAction(int level) {
        if (!this.getConfirm(level)) {
            System.out.println("Skip level " + level);
            return;
        }
        for (int h = 0; h < this.hosts.length; ++h) {
            try {
                switch (this.action) {
                    case 1: {
                        if (this.hosts[h].getName().startsWith("crate")) break;
                        this.hosts[h].stopServers(level);
                        break;
                    }
                    case 0: {
                        if (this.hosts[h].getName().startsWith("crate")) break;
                        this.hosts[h].startServers(level);
                    }
                }
                System.out.println("\tdone on " + this.hosts[h].getName());
                continue;
            }
            catch (DevFailed e) {
                System.out.println("\tfailed on " + this.hosts[h].getName());
                System.out.println(e.errors[0].desc);
            }
        }
    }

    private boolean getConfirm(int level) {
        String resp;
        System.out.println("\n");
        do {
            System.out.print(known_actions[this.action] + " all TANGO ds for level " + level + " ?  (y/n) ");
            byte[] b = new byte[80];
            try {
                System.in.read(b);
                resp = new String(b).toLowerCase().trim();
            }
            catch (IOException e) {
                resp = "no";
            }
        } while (!resp.startsWith("n") && !resp.startsWith("y"));
        return resp.startsWith("y");
    }

    private void manageArgs(String[] args) throws DevFailed, Exception {
        if (args.length < 3) {
            this.displaySyntax();
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h")) {
                String s;
                if ((s = args[++i]).toLowerCase().equals("all")) {
                    this.hosts = this.util.getTangoHostList();
                    continue;
                }
                this.hosts = new TangoHost[1];
                this.hosts[0] = new TangoHost(s);
                continue;
            }
            for (int j = 0; j < known_actions.length; ++j) {
                if (!args[i].equals(known_actions[j])) continue;
                this.action = j;
            }
        }
        if (this.action == -1 || this.hosts == null) {
            this.displaySyntax();
            throw new Exception("Astor Exception");
        }
    }

    private void displaySyntax() {
        System.out.println("Syntax:");
        System.out.println("astor <action> <-h hostname>");
        System.out.println();
        System.out.println("Actions:");
        System.out.println("\tstart: will start all servers");
        System.out.println("\tstop : will stop  all servers");
        System.out.println();
        System.out.println("hostname: host to do it \n");
        System.out.println("i.e.: astor start -h alpha    (starts all servers on host alpha)");
        System.out.println("or    astor start -h all      (starts all servers on all controled hosts)");
    }

    public AstorCmdLine(int doWhat, String servname) {
        boolean forced = true;
        try {
            switch (doWhat) {
                case 0: {
                    forced = false;
                }
                case 1: {
                    DeviceProxy[] devices = this.getDeviceList(servname);
                    if (devices.length == 0) {
                        Except.throw_exception((String)"NO_DEVICES", (String)("No device found for " + servname), (String)("DbPollPanel.CmdLineSolution(" + servname + ")"));
                    }
                    System.out.println("Polled Attributes For " + servname);
                    this.displayAndConfirm(devices, forced);
                }
            }
        }
        catch (Exception e) {
            Except.print_exception((Exception)e);
        }
    }

    private void displayAndConfirm(DeviceProxy[] devices, boolean forced) throws DevFailed, IOException {
        byte[] b = new byte[80];
        for (int dev = 0; dev < devices.length; ++dev) {
            System.out.println(devices[dev].name());
            PolledAttr[] attlist = this.getPolledAttributes(devices[dev]);
            boolean[] remove_it = new boolean[attlist.length];
            for (int a = 0; a < attlist.length; ++a) {
                remove_it[a] = forced;
                if (forced) continue;
                System.out.print("   - " + attlist[a]);
                System.out.print("  -  Remove polling (y/n) ? ");
                System.in.read(b);
                remove_it[a] = b[0] == 121 || b[0] == 89;
            }
            this.removePolling(devices[dev], attlist, remove_it);
        }
    }

    private void removePolling(DeviceProxy dev, PolledAttr[] attr, boolean[] remove_it) throws DevFailed {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < attr.length; ++i) {
            if (remove_it[i]) continue;
            v.add(attr[i].name);
            v.add(attr[i].period);
        }
        String[] str = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            str[i] = (String)v.get(i);
        }
        DbDatum argin = new DbDatum(PollAttProp);
        argin.insert(str);
        dev.put_property(new DbDatum[]{argin});
        for (int i = 0; i < attr.length; ++i) {
            if (!remove_it[i]) continue;
            System.out.println(attr[i].name + " ..... Polling Removed");
        }
    }

    private DeviceProxy[] getDeviceList(String servname) throws DevFailed {
        String[] classes;
        Vector<String> v = new Vector<String>();
        DbServer serv = new DbServer(servname);
        for (String classname : classes = serv.get_class_list()) {
            String[] devnames;
            for (String dn : devnames = serv.get_device_name(classname)) {
                v.add(dn);
            }
        }
        DeviceProxy[] dp = new DeviceProxy[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            dp[i] = new DeviceProxy((String)v.get(i));
        }
        return dp;
    }

    public PolledAttr[] getPolledAttributes(DeviceProxy dev) throws DevFailed {
        DbDatum argout = dev.get_property(PollAttProp);
        String[] data = argout.extractStringArray();
        if (data == null) {
            return new PolledAttr[0];
        }
        Vector<PolledAttr> v = new Vector<PolledAttr>();
        for (int i = 0; i < data.length; i += 2) {
            v.add(new PolledAttr(data[i], data[i + 1]));
        }
        PolledAttr[] pa = new PolledAttr[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            pa[i] = (PolledAttr)v.get(i);
        }
        return pa;
    }

    class PolledAttr {
        String name;
        String period;

        public PolledAttr(String name, String period) {
            this.name = name;
            this.period = period;
        }

        public String toString() {
            return this.name + "   (" + this.period + " ms)";
        }
    }
}

