//=============================================================================
//
// file :        TangoTest.h
//
// description : Include for the TangoTest class.
//
// project :	TANGO Device Server for testing generic clients
//
// $Author: taurel $N.Leclecq - SOLEIL
//
// $Revision: 1.11 $1.0  
//
// $Log: TangoTest.h,v $
// Revision 1.11  2008/04/14 05:20:36  taurel
// - Add a forward declaration. Without, it does not compile with gcc 4.1
//
// Revision 1.10  2008/02/20 16:00:34  pierrejoseph
// Add a property (UShort_image_ro_size) which determines the size of the ushort_image_ro attribute.
//
// Revision 1.9  2007/12/11 19:07:52  nleclercq
// added a "no_value" and a "throw_exception" attribute
//
// Revision 1.8  2007/12/04 11:30:40  nleclercq
// Added string spectrum and image attributes
//
// Revision 1.7  2006/08/22 08:28:16  jensmeyer
// Corrections to support gcc version 4.1.1
//
// Revision 1.6  2006/03/20 15:21:51  jensmeyer
// Added some castings for porting to VC8
//
// Revision 1.5  2006/02/08 16:14:28  nleclercq
// Minor modifs in RW spectrum and image attributes
//
// Revision 1.2  2005/01/14 13:45:08  taurel
// - Ported to Tango V5
//
// Revision 1.1.1.1  2004/05/07 12:43:45  taurel
// Initial import
//
//
// copyleft :    European Synchrotron Radiation Facility
//               BP 220, Grenoble 38043
//               FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================
#ifndef _TANGOTEST_H
#define _TANGOTEST_H
 

#include <tango.h>
//using namespace Tango;

/**
 * @author  $Author: taurel $
 * @version $Revision: 1.11 $ $
 */

//	Add your own constants definitions here.
//-----------------------------------------------

namespace TangoTest_ns
{

/**
 * Class Description:
 * A device to test generic clients. It offers a "echo" like command for
 *	each TANGO data type (i.e. each command returns an exact copy of <argin>).
 */

/*
 *	Device States Description:
*  Tango::RUNNING :  This state allows all the commands to be sent
*  Tango::FAULT :    This state disables all commands
 */

class DataGenerator;


class TangoTest: public Tango::Device_3Impl
{
  friend class DataGenerator;

public :
  //  Add your own data members here
  //-----------------------------------------


  //  Here is the Start of the automatic code generation part
  //------------------------------------------------------------- 
/**
 *  @name attributes
 *  Attributs member data.
 */
//@{
		Tango::DevShort	*attr_short_scalar_ro_read;
		Tango::DevShort	*attr_short_scalar_read;
		Tango::DevShort	attr_short_scalar_write;
		Tango::DevShort	attr_short_scalar_w_write;
		Tango::DevShort	*attr_short_scalar_rww_read;
		Tango::DevLong	*attr_long_scalar_read;
		Tango::DevLong	attr_long_scalar_write;
		Tango::DevLong	attr_long_scalar_w_write;
		Tango::DevLong	*attr_long_scalar_rww_read;
		Tango::DevDouble	*attr_double_scalar_read;
		Tango::DevDouble	attr_double_scalar_write;
		Tango::DevDouble	attr_double_scalar_w_write;
		Tango::DevDouble	*attr_double_scalar_rww_read;
		Tango::DevString	*attr_string_scalar_read;
		Tango::DevString	attr_string_scalar_write;
		Tango::DevBoolean	*attr_boolean_scalar_read;
		Tango::DevBoolean	attr_boolean_scalar_write;
		Tango::DevFloat	*attr_float_scalar_read;
		Tango::DevFloat	attr_float_scalar_write;
		Tango::DevUChar	*attr_uchar_scalar_read;
		Tango::DevUChar	attr_uchar_scalar_write;
		Tango::DevUShort	*attr_ushort_scalar_read;
		Tango::DevUShort	attr_ushort_scalar_write;
		Tango::DevDouble	attr_ampli_write;
		Tango::DevLong	*attr_no_value_read;
		Tango::DevLong	*attr_throw_exception_read;
		Tango::DevShort	*attr_short_spectrum_read;
		Tango::DevShort	attr_short_spectrum_write;
		Tango::DevLong	*attr_long_spectrum_read;
		Tango::DevLong	attr_long_spectrum_write;
		Tango::DevDouble	*attr_double_spectrum_read;
		Tango::DevDouble	attr_double_spectrum_write;
		Tango::DevBoolean	*attr_boolean_spectrum_read;
		Tango::DevBoolean	attr_boolean_spectrum_write;
		Tango::DevUChar	*attr_uchar_spectrum_read;
		Tango::DevUChar	attr_uchar_spectrum_write;
		Tango::DevUShort	*attr_ushort_spectrum_read;
		Tango::DevUShort	attr_ushort_spectrum_write;
		Tango::DevFloat	*attr_float_spectrum_read;
		Tango::DevFloat	attr_float_spectrum_write;
		Tango::DevDouble	*attr_wave_read;
		Tango::DevShort	*attr_short_spectrum_ro_read;
		Tango::DevFloat	*attr_float_spectrum_ro_read;
		Tango::DevLong	*attr_long_spectrum_ro_read;
		Tango::DevDouble	*attr_double_spectrum_ro_read;
		Tango::DevBoolean	*attr_boolean_spectrum_ro_read;
		Tango::DevUChar	*attr_uchar_spectrum_ro_read;
		Tango::DevUShort	*attr_ushort_spectrum_ro_read;
		Tango::DevString	*attr_string_spectrum_read;
		Tango::DevString	attr_string_spectrum_write;
		Tango::DevString	*attr_string_spectrum_ro_read;
		Tango::DevUChar	*attr_uchar_image_ro_read;
		Tango::DevUShort	*attr_ushort_image_ro_read;
		Tango::DevFloat	*attr_float_image_ro_read;
		Tango::DevShort	*attr_short_image_ro_read;
		Tango::DevLong	*attr_long_image_ro_read;
		Tango::DevDouble	*attr_double_image_ro_read;
		Tango::DevBoolean	*attr_boolean_image_ro_read;
		Tango::DevBoolean	*attr_boolean_image_read;
		Tango::DevBoolean	attr_boolean_image_write;
		Tango::DevUChar	*attr_uchar_image_read;
		Tango::DevUChar	attr_uchar_image_write;
		Tango::DevShort	*attr_short_image_read;
		Tango::DevShort	attr_short_image_write;
		Tango::DevUShort	*attr_ushort_image_read;
		Tango::DevUShort	attr_ushort_image_write;
		Tango::DevLong	*attr_long_image_read;
		Tango::DevLong	attr_long_image_write;
		Tango::DevFloat	*attr_float_image_read;
		Tango::DevFloat	attr_float_image_write;
		Tango::DevDouble	*attr_double_image_read;
		Tango::DevDouble	attr_double_image_write;
		Tango::DevString	*attr_string_image_read;
		Tango::DevString	attr_string_image_write;
		Tango::DevString	*attr_string_image_ro_read;
//@}

/**
 *  @name Device properties
 *  Device properties member data.
 */
//@{
/**
 *	Multi-threaded implementation (true/false
 */
	Tango::DevShort	mthreaded_impl;
/**
 *	Data generation period (in ms
 */
	Tango::DevLong	sleep_period;
/**
 *	Size of the ushort_image_ro attribute
 */
	Tango::DevLong	uShort_image_ro_size;
//@}

/**@name Constructors
 * Miscellaneous constructors */
//@{
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	TangoTest(Tango::DeviceClass *cl,string &s);
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device Name
 */
	TangoTest(Tango::DeviceClass *cl,const char *s);
/**
 * Constructs a newly allocated Command object.
 *
 *	@param cl	Class.
 *	@param s 	Device name
 *	@param d	Device description.
 */
	TangoTest(Tango::DeviceClass *cl,const char *s,const char *d);
//@}

/**@name Destructor
 * Only one desctructor is defined for this class */
//@{
/**
 * The object desctructor.
 */	
	~TangoTest();
//@}

	
/**@name Miscellaneous methods */
//@{
/**
 *	Initialize the device
 */
	virtual void init_device();
/**
 *	Initialize the device
 */
	virtual void delete_device();
/**
 *	Always executed method befor execution command method.
 */
	virtual void always_executed_hook();

//@}

/**
 * @name TangoTest methods prototypes
 */

//@{
/**
 *	Hardware acquisition for attributes.
 */
	virtual void read_attr_hardware(vector<long> &attr_list);
/**
 *	Extract real attribute values for short_scalar_ro acquisition result.
 */
	virtual void read_short_scalar_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for short_scalar acquisition result.
 */
	virtual void read_short_scalar(Tango::Attribute &attr);
/**
 *	Write short_scalar attribute values to hardware.
 */
	virtual void write_short_scalar(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for short_scalar_w acquisition result.
 */
	virtual void read_short_scalar_w(Tango::Attribute &attr);
/**
 *	Write short_scalar_w attribute values to hardware.
 */
	virtual void write_short_scalar_w(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for short_scalar_rww acquisition result.
 */
	virtual void read_short_scalar_rww(Tango::Attribute &attr);
/**
 *	Extract real attribute values for long_scalar acquisition result.
 */
	virtual void read_long_scalar(Tango::Attribute &attr);
/**
 *	Write long_scalar attribute values to hardware.
 */
	virtual void write_long_scalar(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for long_scalar_w acquisition result.
 */
	virtual void read_long_scalar_w(Tango::Attribute &attr);
/**
 *	Write long_scalar_w attribute values to hardware.
 */
	virtual void write_long_scalar_w(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for long_scalar_rww acquisition result.
 */
	virtual void read_long_scalar_rww(Tango::Attribute &attr);
/**
 *	Extract real attribute values for double_scalar acquisition result.
 */
	virtual void read_double_scalar(Tango::Attribute &attr);
/**
 *	Write double_scalar attribute values to hardware.
 */
	virtual void write_double_scalar(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for double_scalar_w acquisition result.
 */
	virtual void read_double_scalar_w(Tango::Attribute &attr);
/**
 *	Write double_scalar_w attribute values to hardware.
 */
	virtual void write_double_scalar_w(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for double_scalar_rww acquisition result.
 */
	virtual void read_double_scalar_rww(Tango::Attribute &attr);
/**
 *	Extract real attribute values for string_scalar acquisition result.
 */
	virtual void read_string_scalar(Tango::Attribute &attr);
/**
 *	Write string_scalar attribute values to hardware.
 */
	virtual void write_string_scalar(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for boolean_scalar acquisition result.
 */
	virtual void read_boolean_scalar(Tango::Attribute &attr);
/**
 *	Write boolean_scalar attribute values to hardware.
 */
	virtual void write_boolean_scalar(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for float_scalar acquisition result.
 */
	virtual void read_float_scalar(Tango::Attribute &attr);
/**
 *	Write float_scalar attribute values to hardware.
 */
	virtual void write_float_scalar(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for uchar_scalar acquisition result.
 */
	virtual void read_uchar_scalar(Tango::Attribute &attr);
/**
 *	Write uchar_scalar attribute values to hardware.
 */
	virtual void write_uchar_scalar(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for ushort_scalar acquisition result.
 */
	virtual void read_ushort_scalar(Tango::Attribute &attr);
/**
 *	Write ushort_scalar attribute values to hardware.
 */
	virtual void write_ushort_scalar(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for ampli acquisition result.
 */
	virtual void read_ampli(Tango::Attribute &attr);
/**
 *	Write ampli attribute values to hardware.
 */
	virtual void write_ampli(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for no_value acquisition result.
 */
	virtual void read_no_value(Tango::Attribute &attr);
/**
 *	Extract real attribute values for throw_exception acquisition result.
 */
	virtual void read_throw_exception(Tango::Attribute &attr);
/**
 *	Extract real attribute values for short_spectrum acquisition result.
 */
	virtual void read_short_spectrum(Tango::Attribute &attr);
/**
 *	Write short_spectrum attribute values to hardware.
 */
	virtual void write_short_spectrum(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for long_spectrum acquisition result.
 */
	virtual void read_long_spectrum(Tango::Attribute &attr);
/**
 *	Write long_spectrum attribute values to hardware.
 */
	virtual void write_long_spectrum(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for double_spectrum acquisition result.
 */
	virtual void read_double_spectrum(Tango::Attribute &attr);
/**
 *	Write double_spectrum attribute values to hardware.
 */
	virtual void write_double_spectrum(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for boolean_spectrum acquisition result.
 */
	virtual void read_boolean_spectrum(Tango::Attribute &attr);
/**
 *	Write boolean_spectrum attribute values to hardware.
 */
	virtual void write_boolean_spectrum(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for uchar_spectrum acquisition result.
 */
	virtual void read_uchar_spectrum(Tango::Attribute &attr);
/**
 *	Write uchar_spectrum attribute values to hardware.
 */
	virtual void write_uchar_spectrum(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for ushort_spectrum acquisition result.
 */
	virtual void read_ushort_spectrum(Tango::Attribute &attr);
/**
 *	Write ushort_spectrum attribute values to hardware.
 */
	virtual void write_ushort_spectrum(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for float_spectrum acquisition result.
 */
	virtual void read_float_spectrum(Tango::Attribute &attr);
/**
 *	Write float_spectrum attribute values to hardware.
 */
	virtual void write_float_spectrum(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for wave acquisition result.
 */
	virtual void read_wave(Tango::Attribute &attr);
/**
 *	Extract real attribute values for short_spectrum_ro acquisition result.
 */
	virtual void read_short_spectrum_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for float_spectrum_ro acquisition result.
 */
	virtual void read_float_spectrum_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for long_spectrum_ro acquisition result.
 */
	virtual void read_long_spectrum_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for double_spectrum_ro acquisition result.
 */
	virtual void read_double_spectrum_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for boolean_spectrum_ro acquisition result.
 */
	virtual void read_boolean_spectrum_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for uchar_spectrum_ro acquisition result.
 */
	virtual void read_uchar_spectrum_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for ushort_spectrum_ro acquisition result.
 */
	virtual void read_ushort_spectrum_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for string_spectrum acquisition result.
 */
	virtual void read_string_spectrum(Tango::Attribute &attr);
/**
 *	Write string_spectrum attribute values to hardware.
 */
	virtual void write_string_spectrum(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for string_spectrum_ro acquisition result.
 */
	virtual void read_string_spectrum_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for uchar_image_ro acquisition result.
 */
	virtual void read_uchar_image_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for ushort_image_ro acquisition result.
 */
	virtual void read_ushort_image_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for float_image_ro acquisition result.
 */
	virtual void read_float_image_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for short_image_ro acquisition result.
 */
	virtual void read_short_image_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for long_image_ro acquisition result.
 */
	virtual void read_long_image_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for double_image_ro acquisition result.
 */
	virtual void read_double_image_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for boolean_image_ro acquisition result.
 */
	virtual void read_boolean_image_ro(Tango::Attribute &attr);
/**
 *	Extract real attribute values for boolean_image acquisition result.
 */
	virtual void read_boolean_image(Tango::Attribute &attr);
/**
 *	Write boolean_image attribute values to hardware.
 */
	virtual void write_boolean_image(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for uchar_image acquisition result.
 */
	virtual void read_uchar_image(Tango::Attribute &attr);
/**
 *	Write uchar_image attribute values to hardware.
 */
	virtual void write_uchar_image(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for short_image acquisition result.
 */
	virtual void read_short_image(Tango::Attribute &attr);
/**
 *	Write short_image attribute values to hardware.
 */
	virtual void write_short_image(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for ushort_image acquisition result.
 */
	virtual void read_ushort_image(Tango::Attribute &attr);
/**
 *	Write ushort_image attribute values to hardware.
 */
	virtual void write_ushort_image(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for long_image acquisition result.
 */
	virtual void read_long_image(Tango::Attribute &attr);
/**
 *	Write long_image attribute values to hardware.
 */
	virtual void write_long_image(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for float_image acquisition result.
 */
	virtual void read_float_image(Tango::Attribute &attr);
/**
 *	Write float_image attribute values to hardware.
 */
	virtual void write_float_image(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for double_image acquisition result.
 */
	virtual void read_double_image(Tango::Attribute &attr);
/**
 *	Write double_image attribute values to hardware.
 */
	virtual void write_double_image(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for string_image acquisition result.
 */
	virtual void read_string_image(Tango::Attribute &attr);
/**
 *	Write string_image attribute values to hardware.
 */
	virtual void write_string_image(Tango::WAttribute &attr);
/**
 *	Extract real attribute values for string_image_ro acquisition result.
 */
	virtual void read_string_image_ro(Tango::Attribute &attr);
/**
 *	Read/Write allowed for short_scalar_ro attribute.
 */
	virtual bool is_short_scalar_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for short_scalar attribute.
 */
	virtual bool is_short_scalar_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for short_scalar_w attribute.
 */
	virtual bool is_short_scalar_w_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for short_scalar_rww attribute.
 */
	virtual bool is_short_scalar_rww_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for long_scalar attribute.
 */
	virtual bool is_long_scalar_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for long_scalar_w attribute.
 */
	virtual bool is_long_scalar_w_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for long_scalar_rww attribute.
 */
	virtual bool is_long_scalar_rww_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for double_scalar attribute.
 */
	virtual bool is_double_scalar_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for double_scalar_w attribute.
 */
	virtual bool is_double_scalar_w_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for double_scalar_rww attribute.
 */
	virtual bool is_double_scalar_rww_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for string_scalar attribute.
 */
	virtual bool is_string_scalar_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for boolean_scalar attribute.
 */
	virtual bool is_boolean_scalar_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for float_scalar attribute.
 */
	virtual bool is_float_scalar_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for uchar_scalar attribute.
 */
	virtual bool is_uchar_scalar_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for ushort_scalar attribute.
 */
	virtual bool is_ushort_scalar_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for ampli attribute.
 */
	virtual bool is_ampli_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for no_value attribute.
 */
	virtual bool is_no_value_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for throw_exception attribute.
 */
	virtual bool is_throw_exception_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for short_spectrum attribute.
 */
	virtual bool is_short_spectrum_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for long_spectrum attribute.
 */
	virtual bool is_long_spectrum_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for double_spectrum attribute.
 */
	virtual bool is_double_spectrum_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for boolean_spectrum attribute.
 */
	virtual bool is_boolean_spectrum_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for uchar_spectrum attribute.
 */
	virtual bool is_uchar_spectrum_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for ushort_spectrum attribute.
 */
	virtual bool is_ushort_spectrum_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for float_spectrum attribute.
 */
	virtual bool is_float_spectrum_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for wave attribute.
 */
	virtual bool is_wave_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for short_spectrum_ro attribute.
 */
	virtual bool is_short_spectrum_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for float_spectrum_ro attribute.
 */
	virtual bool is_float_spectrum_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for long_spectrum_ro attribute.
 */
	virtual bool is_long_spectrum_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for double_spectrum_ro attribute.
 */
	virtual bool is_double_spectrum_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for boolean_spectrum_ro attribute.
 */
	virtual bool is_boolean_spectrum_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for uchar_spectrum_ro attribute.
 */
	virtual bool is_uchar_spectrum_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for ushort_spectrum_ro attribute.
 */
	virtual bool is_ushort_spectrum_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for string_spectrum attribute.
 */
	virtual bool is_string_spectrum_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for string_spectrum_ro attribute.
 */
	virtual bool is_string_spectrum_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for uchar_image_ro attribute.
 */
	virtual bool is_uchar_image_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for ushort_image_ro attribute.
 */
	virtual bool is_ushort_image_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for float_image_ro attribute.
 */
	virtual bool is_float_image_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for short_image_ro attribute.
 */
	virtual bool is_short_image_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for long_image_ro attribute.
 */
	virtual bool is_long_image_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for double_image_ro attribute.
 */
	virtual bool is_double_image_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for boolean_image_ro attribute.
 */
	virtual bool is_boolean_image_ro_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for boolean_image attribute.
 */
	virtual bool is_boolean_image_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for uchar_image attribute.
 */
	virtual bool is_uchar_image_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for short_image attribute.
 */
	virtual bool is_short_image_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for ushort_image attribute.
 */
	virtual bool is_ushort_image_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for long_image attribute.
 */
	virtual bool is_long_image_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for float_image attribute.
 */
	virtual bool is_float_image_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for double_image attribute.
 */
	virtual bool is_double_image_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for string_image attribute.
 */
	virtual bool is_string_image_allowed(Tango::AttReqType type);
/**
 *	Read/Write allowed for string_image_ro attribute.
 */
	virtual bool is_string_image_ro_allowed(Tango::AttReqType type);
/**
 *	Execution allowed for DevVoid command.
 */
	virtual bool is_DevVoid_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevBoolean command.
 */
	virtual bool is_DevBoolean_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevShort command.
 */
	virtual bool is_DevShort_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevUShort command.
 */
	virtual bool is_DevUShort_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevLong command.
 */
	virtual bool is_DevLong_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevULong command.
 */
	virtual bool is_DevULong_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevFloat command.
 */
	virtual bool is_DevFloat_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevDouble command.
 */
	virtual bool is_DevDouble_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevString command.
 */
	virtual bool is_DevString_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevVarCharArray command.
 */
	virtual bool is_DevVarCharArray_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevVarShortArray command.
 */
	virtual bool is_DevVarShortArray_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevVarUShortArray command.
 */
	virtual bool is_DevVarUShortArray_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevVarLongArray command.
 */
	virtual bool is_DevVarLongArray_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevVarULongArray command.
 */
	virtual bool is_DevVarULongArray_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevVarFloatArray command.
 */
	virtual bool is_DevVarFloatArray_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevVarDoubleArray command.
 */
	virtual bool is_DevVarDoubleArray_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevVarStringArray command.
 */
	virtual bool is_DevVarStringArray_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevVarLongStringArray command.
 */
	virtual bool is_DevVarLongStringArray_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for DevVarDoubleStringArray command.
 */
	virtual bool is_DevVarDoubleStringArray_allowed(const CORBA::Any &any);
/**
 *	Execution allowed for SwitchStates command.
 */
	virtual bool is_SwitchStates_allowed(const CORBA::Any &any);
/**
 * A DevVoid comand example
 *	@exception DevFailed
 */
	void	dev_void();
/**
 * A DevBoolean comand example
 *	@param	argin	Any boolean value
 *	@return	Echo of the argin value
 *	@exception DevFailed
 */
	Tango::DevBoolean	dev_boolean(Tango::DevBoolean);
/**
 * A DevShort command example
 *	@param	argin	Any DevShort value
 *	@return	Echo of the argin value
 *	@exception DevFailed
 */
	Tango::DevShort	dev_short(Tango::DevShort);
/**
 * A DevUShort command example
 *	@param	argin	Any DevUShort value
 *	@return	Echo of the argin value
 *	@exception DevFailed
 */
	Tango::DevUShort	dev_ushort(Tango::DevUShort);
/**
 * A DevLong command example
 *	@param	argin	Any DevLong value
 *	@return	Echo of the argin value
 *	@exception DevFailed
 */
	Tango::DevLong	dev_long(Tango::DevLong);
/**
 * A DevULong command example
 *	@param	argin	Any DevULong
 *	@return	Echo of the argin value
 *	@exception DevFailed
 */
	Tango::DevULong	dev_ulong(Tango::DevULong);
/**
 * A DevFloat command example
 *	@param	argin	Any DevFloat value
 *	@return	Echo of the argin value
 *	@exception DevFailed
 */
	Tango::DevFloat	dev_float(Tango::DevFloat);
/**
 * A DevDouble command example
 *	@param	argin	Any DevDouble value
 *	@return	Echo of the argin value
 *	@exception DevFailed
 */
	Tango::DevDouble	dev_double(Tango::DevDouble);
/**
 * none
 *	@param	argin	-
 *	@return	-
 *	@exception DevFailed
 */
	Tango::DevString	dev_string(Tango::DevString);
/**
 * none
 *	@param	argin	-
 *	@return	-
 *	@exception DevFailed
 */
	Tango::DevVarCharArray	*dev_var_char_array(const Tango::DevVarCharArray *);
/**
 * none
 *	@param	argin	-
 *	@return	-
 *	@exception DevFailed
 */
	Tango::DevVarShortArray	*dev_var_short_array(const Tango::DevVarShortArray *);
/**
 * none
 *	@param	argin	-
 *	@return	-
 *	@exception DevFailed
 */
	Tango::DevVarUShortArray	*dev_var_ushort_array(const Tango::DevVarUShortArray *);
/**
 * none
 *	@param	argin	-
 *	@return	-
 *	@exception DevFailed
 */
	Tango::DevVarLongArray	*dev_var_long_array(const Tango::DevVarLongArray *);
/**
 * none
 *	@param	argin	-
 *	@return	-
 *	@exception DevFailed
 */
	Tango::DevVarULongArray	*dev_var_ulong_array(const Tango::DevVarULongArray *);
/**
 * none
 *	@param	argin	-
 *	@return	-
 *	@exception DevFailed
 */
	Tango::DevVarFloatArray	*dev_var_float_array(const Tango::DevVarFloatArray *);
/**
 * none
 *	@param	argin	-
 *	@return	-
 *	@exception DevFailed
 */
	Tango::DevVarDoubleArray	*dev_var_double_array(const Tango::DevVarDoubleArray *);
/**
 * none
 *	@param	argin	-
 *	@return	-
 *	@exception DevFailed
 */
	Tango::DevVarStringArray	*dev_var_string_array(const Tango::DevVarStringArray *);
/**
 * none
 *	@param	argin	-
 *	@return	-
 *	@exception DevFailed
 */
	Tango::DevVarLongStringArray	*dev_var_long_string_array(const Tango::DevVarLongStringArray *);
/**
 * none
 *	@param	argin	-
 *	@return	-
 *	@exception DevFailed
 */
	Tango::DevVarDoubleStringArray	*dev_var_double_string_array(const Tango::DevVarDoubleStringArray *);
/**
 * This command changes the device state from RUNNING to FAULT or from FAULT to RUNNING
 *	@exception DevFailed
 */
	void	switch_states();

/**
 *	Read the device properties from database
 */
	 void get_device_property();
//@}

	//	Here is the end of the automatic code generation part
	//-------------------------------------------------------------	

/**
 *	Generates dummy attribute values 
 */
  void gen_data (void);

protected : 
  //  Add your own data members here
  //-----------------------------------------
  //- A mutex to protect the device against race conditions
  omni_mutex lock;
  // The data generator (thread)
  DataGenerator* data_gen;

  long dimShortSpectrum;
  long dimLongSpectrum;
  long dimUcharSpectrum;
  long dimUshortSpectrum;
  long dimDoubleSpectrum;
  long dimFloatSpectrum;
  long dimBooleanSpectrum;
  long dimStringSpectrum;

  long dimXShortImage;
  long dimXLongImage;
  long dimXFloatImage;
  long dimXUcharImage;
  long dimXUshortImage;
  long dimXDoubleImage;
  long dimXBooleanImage;
  long dimXStringImage;

  long dimYShortImage;
  long dimYLongImage;
  long dimYFloatImage;
  long dimYUcharImage;
  long dimYUshortImage;
  long dimYDoubleImage;
  long dimYBooleanImage;
  long dimYStringImage;


};

}	// namespace

#endif	// _TANGOTEST_H
