//=============================================================================
//
// file :         StarterClass.h
//
// description :  Include for the StarterClass root class.
//                This class is represents the singleton class for
//                the Starter device class.
//                It contains all properties and methods which the 
//                Starter requires only once e.g. the commands.
//			
// project :      TANGO Device Server
//
// $Author: pascal_verdier $
//
// $Revision: 3.11 $
//
// $Log: StarterClass.h,v $
// Revision 3.11  2008/02/29 15:15:05  pascal_verdier
// Checking running processes by system call added.
//
// Revision 3.10  2006/06/05 07:20:36  pascal_verdier
// Server startup is now delayed (with timeout) in a startup level.
// New state MOVING added.
// At startup, starter loop until properties have been read.
//
// Revision 3.9  2006/04/24 07:06:28  pascal_verdier
// A thread is started for each level when at servers startup.
//
// Revision 3.8  2005/09/30 12:01:50  pascal_verdier
// RunningServers and StoppedServers spectrum attribute max_x set to 200.
//
// Revision 3.7  2005/09/16 09:24:23  pascal_verdier
// For backward compatibility, set UseEvents property to boolean was not a good idea.
//
// Revision 3.6  2005/09/13 14:36:10  pascal_verdier
// Pogo-4.4.0 compatibility.
//
// Revision 3.5  2005/04/21 07:18:48  pascal_verdier
// Add a little timeout for ping.
// Fix a bug for windows (SIGCHLD).
//
// Revision 3.4  2004/12/10 08:57:19  pascal_verdier
// Tango 5 compatibility (attribute management).
//
// Revision 3.3  2004/06/29 04:24:26  pascal_verdier
// First revision using events.
//
// Revision 3.2  2004/05/19 08:56:32  pascal_verdier
// Bug fixed on service mode.
// CreateProcess used under Windows.
//
// Revision 3.0.1.3  2004/02/27 09:53:02  pascal_verdier
// - The starter device is now warned by Database server when something change on a server.
// It replace the DbGetHostServersInfo polling.
// - HostState, ControlledRunningServers, ontrolledStoppedServers attributes added.
//
// Revision 3.0.1.2  2003/12/08 08:53:52  pascal_verdier
// Cluster (multi-host) control implemented.
// Control of notify daemon implemented but not tested.
//
// Revision 3.0.1.1  2003/09/18 12:02:50  pascal_verdier
// Problem on Windows service startup fixed.
//
// Revision 3.0  2003/06/17 12:06:36  pascal_verdier
// TANGO 3.x server.
// polling bugs fixed.
//
// Revision 2.0  2003/01/09 13:35:50  verdier
// TANGO 2.2
//
// Revision 1.22  2002/12/18 08:09:19  verdier
// omniORB compatibility
//
// Revision 1.6  2002/10/15 18:55:21  verdier
// The host state is now calculated during the State polled command.
//
// Revision 1.5  2002/02/27 15:19:32  verdier
// WinNt services implemented.
//
// Revision 1.4  2001/04/03 09:40:50  verdier
// WInNt version is running.
//
// Revision 1.3  2001/02/12 09:34:21  verdier
// SunOS and Linux OK.
//
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//             (c) - Pascal Verdier - ESRF
//=============================================================================

#ifndef _STARTERCLASS_H
#define _STARTERCLASS_H

#include <tango.h>
#include <Starter.h>


namespace Starter_ns
{
//=====================================
//	Define classes for attributes
//=====================================
class ServersAttrib: public Tango::SpectrumAttr
{
public:
	ServersAttrib():SpectrumAttr("Servers", Tango::DEV_STRING, Tango::READ, 1024) {};
	~ServersAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Starter *>(dev))->read_Servers(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Starter *>(dev))->is_Servers_allowed(ty);}
};

class StoppedServersAttrib: public Tango::SpectrumAttr
{
public:
	StoppedServersAttrib():SpectrumAttr("StoppedServers", Tango::DEV_STRING, Tango::READ, 200) {};
	~StoppedServersAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Starter *>(dev))->read_StoppedServers(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Starter *>(dev))->is_StoppedServers_allowed(ty);}
};

class RunningServersAttrib: public Tango::SpectrumAttr
{
public:
	RunningServersAttrib():SpectrumAttr("RunningServers", Tango::DEV_STRING, Tango::READ, 200) {};
	~RunningServersAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Starter *>(dev))->read_RunningServers(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Starter *>(dev))->is_RunningServers_allowed(ty);}
};

class HostStateAttrib: public Tango::Attr
{
public:
	HostStateAttrib():Attr("HostState", Tango::DEV_SHORT, Tango::READ) {};
	~HostStateAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Starter *>(dev))->read_HostState(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Starter *>(dev))->is_HostState_allowed(ty);}
};

class NotifdStateAttrib: public Tango::Attr
{
public:
	NotifdStateAttrib():Attr("NotifdState", Tango::DEV_STATE, Tango::READ) {};
	~NotifdStateAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<Starter *>(dev))->read_NotifdState(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<Starter *>(dev))->is_NotifdState_allowed(ty);}
};

//=========================================
//	Define classes for commands
//=========================================
class UpdateServersInfoCmd : public Tango::Command
{
public:
	UpdateServersInfoCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	UpdateServersInfoCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~UpdateServersInfoCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Starter *>(dev))->is_UpdateServersInfo_allowed(any);}
};



class NotifyDaemonStateCmd : public Tango::Command
{
public:
	NotifyDaemonStateCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	NotifyDaemonStateCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~NotifyDaemonStateCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Starter *>(dev))->is_NotifyDaemonState_allowed(any);}
};



class HardKillServerClass : public Tango::Command
{
public:
	HardKillServerClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	HardKillServerClass(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~HardKillServerClass() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Starter *>(dev))->is_HardKillServer_allowed(any);}
};



class DevReadLogCmd : public Tango::Command
{
public:
	DevReadLogCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevReadLogCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevReadLogCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Starter *>(dev))->is_DevReadLog_allowed(any);}
};



class DevStopCmd : public Tango::Command
{
public:
	DevStopCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevStopCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevStopCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Starter *>(dev))->is_DevStop_allowed(any);}
};



class DevStartCmd : public Tango::Command
{
public:
	DevStartCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevStartCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevStartCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Starter *>(dev))->is_DevStart_allowed(any);}
};



class DevGetStopServersCmd : public Tango::Command
{
public:
	DevGetStopServersCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevGetStopServersCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevGetStopServersCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Starter *>(dev))->is_DevGetStopServers_allowed(any);}
};



class DevGetRunningServersCmd : public Tango::Command
{
public:
	DevGetRunningServersCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevGetRunningServersCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevGetRunningServersCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Starter *>(dev))->is_DevGetRunningServers_allowed(any);}
};



class DevStopAllCmd : public Tango::Command
{
public:
	DevStopAllCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevStopAllCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevStopAllCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Starter *>(dev))->is_DevStopAll_allowed(any);}
};



class DevStartAllCmd : public Tango::Command
{
public:
	DevStartAllCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevStartAllCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevStartAllCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<Starter *>(dev))->is_DevStartAll_allowed(any);}
};



//
// The StarterClass singleton definition
//

class
#ifdef WIN32
	__declspec(dllexport)
#endif
	StarterClass : public Tango::DeviceClass
{
public:
//	properties member data
/**
 *	Period to read database for new info if not fired from Database server.
 */
	Tango::DevShort	readInfoDbPeriod;
/**
 *	Number of startup levels managed by starter.
 */
	Tango::DevShort	nbStartupLevels;
/**
 *	Timeout value in seconds to stop polling if no command has been received.
 */
	Tango::DevLong	cmdPollingTimeout;
/**
 *	Use events if not null.
 */
	Tango::DevShort	useEvents;
/**
 *	Timeout on device server startup in seconds.
 */
	Tango::DevLong	serverStartupTimeout;

//	add your own data members here
//------------------------------------

public:
	Tango::DbData	cl_prop;
	Tango::DbData	cl_def_prop;
	Tango::DbData	dev_def_prop;

//	Method prototypes
	static StarterClass *init(const char *);
	static StarterClass *instance();
	~StarterClass();
	Tango::DbDatum	get_class_property(string &);
	Tango::DbDatum	get_default_device_property(string &);
	Tango::DbDatum	get_default_class_property(string &);
	
protected:
	StarterClass(string &);
	static StarterClass *_instance;
	void command_factory();
	void get_class_property();
	void attribute_factory(vector<Tango::Attr *> &);
	void write_class_property();
	void set_default_property();

private:
	void device_factory(const Tango::DevVarStringArray *);
};


}	//	namespace Starter_ns

#endif // _STARTERCLASS_H
