/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.ITangoPeriodicListener;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class TangoPeriodic
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoPeriodic(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoPeriodicListener(ITangoPeriodicListener listener, boolean stateless) throws DevFailed {
        this.event_listeners.add(ITangoPeriodicListener.class, listener);
        this.event_identifier = this.subscribe_periodic_event(this.attr_name, this.filters, stateless);
    }

    public void removeTangoPeriodicListener(ITangoPeriodicListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoPeriodicListener.class, listener);
        if (this.event_listeners.getListenerCount() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    public void dispatch_event(final EventData event_data) {
        final TangoPeriodic tg = this;
        Runnable do_work_later = new Runnable(){

            public void run() {
                TangoPeriodicEvent periodic_event = new TangoPeriodicEvent(tg, event_data);
                TangoPeriodic.this.fireTangoPeriodicEvent(periodic_event);
            }
        };
        SwingUtilities.invokeLater(do_work_later);
    }

    private void fireTangoPeriodicEvent(TangoPeriodicEvent periodic_event) {
        Object[] listeners = this.event_listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ITangoPeriodicListener.class) continue;
            ((ITangoPeriodicListener)listeners[i + 1]).periodic(periodic_event);
        }
    }
}

