/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class TangoChange
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoChange(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoChangeListener(ITangoChangeListener listener, boolean stateless) throws DevFailed {
        this.event_listeners.add(ITangoChangeListener.class, listener);
        this.event_identifier = this.subscribe_change_event(this.attr_name, this.filters, stateless);
    }

    public void removeTangoChangeListener(ITangoChangeListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoChangeListener.class, listener);
        if (this.event_listeners.getListenerCount() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    public void dispatch_event(final EventData event_data) {
        final TangoChange tg = this;
        Runnable do_work_later = new Runnable(){

            public void run() {
                TangoChangeEvent change_event = new TangoChangeEvent(tg, event_data);
                TangoChange.this.fireTangoChangeEvent(change_event);
            }
        };
        SwingUtilities.invokeLater(do_work_later);
    }

    private void fireTangoChangeEvent(TangoChangeEvent change_event) {
        Object[] listeners = this.event_listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ITangoChangeListener.class) continue;
            ((ITangoChangeListener)listeners[i + 1]).change(change_event);
        }
    }
}

