/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.FileWriter;
import java.io.IOException;

public class JDLabel
extends JDRectangular {
    public static final int CENTER_ALIGNMENT = 0;
    public static final int LEFT_ALIGNMENT = 1;
    public static final int RIGHT_ALIGNMENT = 2;
    public static final int UP_ALIGNMENT = 1;
    public static final int DOWN_ALIGNMENT = 2;
    public static final int LEFT_TO_RIGHT = 0;
    public static final int BOTTOM_TO_TOP = 1;
    public static final int RIGHT_TO_LEFT = 2;
    public static final int TOP_TO_BOTTOM = 3;
    static final double NINETY_DEGREES = Math.toRadians(90.0);
    static final String textDefault = "";
    static final Font fontDefault = new Font("Dialog", 0, 14);
    static final int hAlignmentDefault = 0;
    static final int vAlignmentDefault = 0;
    static final int textOrientationDefault = 0;
    static BufferedImage img = new BufferedImage(10, 10, 1);
    private String theText;
    private Font theFont;
    private int hAlignment;
    private int vAlignment;
    private Dimension preferredSize = null;
    private int textOrientation;
    private int sTextOrientation;

    public JDLabel(String string, String string2, int n, int n2) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(0.0, 0.0));
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.theText = string2;
        this.lineWidth = 0;
        Dimension dimension = this.getMinSize();
        this.createSummit();
        this.computeSummitCoordinates(n, n2, dimension.width, dimension.height);
        this.updateShape();
        this.centerOrigin();
    }

    JDLabel(JDLabel jDLabel, int n, int n2) {
        this.cloneObject(jDLabel, n, n2);
        this.theText = new String(jDLabel.theText);
        this.theFont = new Font(jDLabel.theFont.getName(), jDLabel.theFont.getStyle(), jDLabel.theFont.getSize());
        this.textOrientation = jDLabel.textOrientation;
        this.hAlignment = jDLabel.hAlignment;
        this.vAlignment = jDLabel.vAlignment;
        this.updateShape();
    }

    JDLabel(JLXObject jLXObject, Font font, String string, int n, boolean bl) {
        this.initDefault();
        this.loadObject(jLXObject);
        double d = jLXObject.boundRect.getX();
        double d2 = jLXObject.boundRect.getY();
        double d3 = jLXObject.boundRect.getWidth();
        double d4 = jLXObject.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.theFont = font;
        this.theText = string;
        this.hAlignment = n;
        this.vAlignment = 1;
        if (bl) {
            Dimension dimension = this.getMinSize();
            this.computeSummitCoordinates((int)(d + (d3 - (double)dimension.width) / 2.0), (int)(d2 + (d4 - (double)dimension.height) / 2.0), dimension.width, dimension.height);
        } else {
            this.computeSummitCoordinates((int)d, (int)d2, (int)d3, (int)d4);
        }
        this.updateShape();
    }

    JDLabel(LXObject lXObject, String string) {
        this.initDefault();
        this.loadObject(lXObject);
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.theFont = lXObject.font;
        this.theText = string;
        this.hAlignment = 1;
        this.vAlignment = 1;
        this.lineWidth = 0;
        Dimension dimension = this.getMinSize();
        this.computeSummitCoordinates((int)lXObject.px, (int)lXObject.py, dimension.width, dimension.height);
        this.updateShape();
        double d = this.boundRect.getX();
        double d2 = this.boundRect.getY();
        double d3 = this.boundRect.getWidth();
        double d4 = this.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
    }

    void initDefault() {
        super.initDefault();
        this.theText = textDefault;
        this.theFont = fontDefault;
        this.hAlignment = 0;
        this.vAlignment = 0;
        this.textOrientation = 0;
    }

    public JDObject copy(int n, int n2) {
        return new JDLabel(this, n, n2);
    }

    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        int n;
        int n2;
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.prepareRendering(graphics2D);
        super.paint(jDrawEditor, graphics);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setFont(this.theFont);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        int n3 = (int)Math.ceil(graphics.getFont().getLineMetrics("ABC", fontRenderContext).getAscent());
        double d = 0.0;
        int n4 = this.boundRect.width;
        int n5 = this.boundRect.height;
        int n6 = 0;
        Dimension dimension = new Dimension(this.getMinSize());
        String[] stringArray = this.theText.split("\n");
        String[] stringArray2 = null;
        int n7 = 0;
        int n8 = 0;
        Rectangle2D rectangle2D = null;
        int n9 = stringArray.length;
        if (n4 < dimension.width || n5 < dimension.height) {
            boolean bl = false;
            n7 = 0;
            n2 = 0;
            while (n2 < n9 && !bl) {
                rectangle2D = graphics.getFont().getStringBounds(stringArray[n2], fontRenderContext);
                n = (int)Math.ceil(rectangle2D.getHeight());
                if (this.textOrientation == 0 || this.textOrientation == 2) {
                    bl = n7 + n > n5;
                } else {
                    boolean bl2 = bl = n7 + n > n4;
                }
                if (bl) continue;
                ++n2;
                n7 += n;
            }
            if (n2 > 0) {
                stringArray2 = new String[n2];
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    stringArray2[n2] = stringArray[n2];
                }
                if (this.textOrientation == 0 || this.textOrientation == 2) {
                    dimension.height = n7;
                    for (n2 = 0; n2 < stringArray2.length; ++n2) {
                        stringArray2[n2] = this.getSegmentString(this.theFont, fontRenderContext, stringArray2[n2], n4);
                    }
                } else {
                    dimension.width = n7;
                    for (n2 = 0; n2 < stringArray2.length; ++n2) {
                        stringArray2[n2] = this.getSegmentString(this.theFont, fontRenderContext, stringArray2[n2], n5);
                    }
                }
            }
        } else {
            stringArray2 = stringArray;
        }
        if (stringArray2 == null) {
            return;
        }
        n9 = stringArray2.length;
        n7 = 0;
        block0 : switch (this.textOrientation) {
            case 0: 
            case 2: {
                switch (this.vAlignment) {
                    case 0: {
                        n6 = (n5 - dimension.height) / 2;
                        break;
                    }
                    case 1: {
                        n6 = 2;
                        break;
                    }
                    case 2: {
                        n6 = n5 - dimension.height - 2;
                    }
                }
                break;
            }
            case 1: {
                d = -NINETY_DEGREES;
                switch (this.vAlignment) {
                    case 0: {
                        n8 = (n4 - dimension.width) / 2;
                        break;
                    }
                    case 1: {
                        n8 = 2;
                        break;
                    }
                    case 2: {
                        n8 = n4 - dimension.width - 2;
                    }
                }
                break;
            }
            case 3: {
                d = NINETY_DEGREES;
                switch (this.vAlignment) {
                    case 0: {
                        n8 = (n4 - dimension.width) / 2;
                        break block0;
                    }
                    case 1: {
                        n8 = 2;
                        break block0;
                    }
                    case 2: {
                        n8 = n4 - dimension.width - 2;
                    }
                }
            }
        }
        if (d != 0.0) {
            graphics2D.rotate(d);
        }
        graphics2D.setColor(this.foreground);
        block44: for (n2 = 0; n2 < n9; ++n2) {
            switch (this.textOrientation) {
                case 0: 
                case 2: {
                    rectangle2D = graphics.getFont().getStringBounds(stringArray2[n2], fontRenderContext);
                    int n10 = (int)Math.ceil(rectangle2D.getWidth());
                    n = (int)Math.ceil(rectangle2D.getHeight());
                    switch (this.hAlignment) {
                        case 0: {
                            n8 = this.ptsx[0] + (n4 - n10) / 2;
                            break;
                        }
                        case 1: {
                            n8 = this.ptsx[0] + 3;
                            break;
                        }
                        case 2: {
                            n8 = this.ptsx[0] + n4 - n10 - 3;
                        }
                    }
                    graphics2D.drawString(stringArray2[n2], n8, this.ptsy[0] + n6 + n7 + n3);
                    n7 += n;
                    continue block44;
                }
                case 1: {
                    rectangle2D = graphics.getFont().getStringBounds(stringArray2[n2], fontRenderContext);
                    int n10 = (int)Math.ceil(rectangle2D.getWidth());
                    n = (int)Math.ceil(rectangle2D.getHeight());
                    switch (this.hAlignment) {
                        case 0: {
                            n6 = -this.ptsy[3] + (n5 - n10) / 2;
                            break;
                        }
                        case 1: {
                            n6 = -this.ptsy[3] + 3;
                            break;
                        }
                        case 2: {
                            n6 = -this.ptsy[3] + n5 - n10 - 3;
                        }
                    }
                    graphics2D.drawString(stringArray2[n2], n6, this.ptsx[0] + n8 + n7 + n3);
                    n7 += n;
                    continue block44;
                }
                case 3: {
                    rectangle2D = graphics.getFont().getStringBounds(stringArray2[n2], fontRenderContext);
                    int n10 = (int)Math.ceil(rectangle2D.getWidth());
                    n = (int)Math.ceil(rectangle2D.getHeight());
                    switch (this.hAlignment) {
                        case 0: {
                            n6 = this.ptsy[0] + (n5 - n10) / 2;
                            break;
                        }
                        case 1: {
                            n6 = this.ptsy[0] + 3;
                            break;
                        }
                        case 2: {
                            n6 = this.ptsy[0] + n5 - n10 - 3;
                        }
                    }
                    graphics2D.drawString(stringArray2[n2], n6, -this.ptsx[1] + n8 + n7 + n3);
                    n7 += n;
                }
            }
        }
        if (d != 0.0) {
            graphics2D.rotate(-d);
        }
    }

    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        if (this.summit[0].x < this.summit[2].x) {
            if (this.summit[0].y < this.summit[6].y) {
                this.ptsx[0] = (int)this.summit[0].x;
                this.ptsy[0] = (int)this.summit[0].y;
                this.ptsx[1] = (int)this.summit[2].x + 1;
                this.ptsy[1] = (int)this.summit[2].y;
                this.ptsx[2] = (int)this.summit[4].x + 1;
                this.ptsy[2] = (int)this.summit[4].y + 1;
                this.ptsx[3] = (int)this.summit[6].x;
                this.ptsy[3] = (int)this.summit[6].y + 1;
            } else {
                this.ptsx[0] = (int)this.summit[6].x;
                this.ptsy[0] = (int)this.summit[6].y;
                this.ptsx[1] = (int)this.summit[4].x + 1;
                this.ptsy[1] = (int)this.summit[4].y;
                this.ptsx[2] = (int)this.summit[2].x + 1;
                this.ptsy[2] = (int)this.summit[2].y + 1;
                this.ptsx[3] = (int)this.summit[0].x;
                this.ptsy[3] = (int)this.summit[0].y + 1;
            }
        } else if (this.summit[0].y < this.summit[6].y) {
            this.ptsx[0] = (int)this.summit[2].x;
            this.ptsy[0] = (int)this.summit[2].y;
            this.ptsx[1] = (int)this.summit[0].x + 1;
            this.ptsy[1] = (int)this.summit[0].y;
            this.ptsx[2] = (int)this.summit[6].x + 1;
            this.ptsy[2] = (int)this.summit[6].y + 1;
            this.ptsx[3] = (int)this.summit[4].x;
            this.ptsy[3] = (int)this.summit[4].y + 1;
        } else {
            this.ptsx[0] = (int)this.summit[4].x;
            this.ptsy[0] = (int)this.summit[4].y;
            this.ptsx[1] = (int)this.summit[6].x + 1;
            this.ptsy[1] = (int)this.summit[6].y;
            this.ptsx[2] = (int)this.summit[0].x + 1;
            this.ptsy[2] = (int)this.summit[0].y + 1;
            this.ptsx[3] = (int)this.summit[2].x;
            this.ptsy[3] = (int)this.summit[2].y + 1;
        }
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
    }

    public void rotate90(double d, double d2) {
        super.rotate90(d, d2);
        ++this.textOrientation;
        if (this.textOrientation > 3) {
            this.textOrientation = 0;
        }
    }

    public void restoreTransform() {
        this.textOrientation = this.sTextOrientation;
        super.restoreTransform();
    }

    public void saveTransform() {
        this.sTextOrientation = this.textOrientation;
        super.saveTransform();
    }

    public void setFont(Font font) {
        this.setFont(font, false);
    }

    public void setFont(Font font, boolean bl) {
        this.theFont = font;
        this.updateLabel(bl);
    }

    public Font getFont() {
        return this.theFont;
    }

    public void setHorizontalAlignment(int n) {
        this.hAlignment = n;
    }

    public int getHorizontalAlignment() {
        return this.hAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.vAlignment = n;
    }

    public int setVerticalAlignment() {
        return this.vAlignment;
    }

    public void setOrientation(int n) {
        this.textOrientation = n;
        this.updateLabel(true);
    }

    public int getOrientation() {
        return this.textOrientation;
    }

    public void setText(String string) {
        this.setText(string, false);
    }

    public void setText(String string, boolean bl) {
        this.theText = string;
        this.updateLabel(bl);
    }

    public String getText() {
        return this.theText;
    }

    void saveObject(FileWriter fileWriter, int n) throws IOException {
        String string;
        String string2 = this.saveObjectHeader(fileWriter, n);
        if (this.theFont.getName() != fontDefault.getName() || this.theFont.getStyle() != fontDefault.getStyle() || this.theFont.getSize() != fontDefault.getSize()) {
            string = string2 + "font:\"" + this.theFont.getName() + "\"," + this.theFont.getStyle() + "," + this.theFont.getSize() + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (!this.theText.equals(textDefault)) {
            String[] stringArray = this.theText.split("\n");
            string = string2 + "text:";
            for (int i = 0; i < stringArray.length; ++i) {
                string = i == 0 ? string + "\"" + stringArray[i] + "\"" : string + string2 + "     \"" + stringArray[i] + "\"";
                string = i == stringArray.length - 1 ? string + "\n" : string + ",\n";
            }
            fileWriter.write(string, 0, string.length());
        }
        if (this.hAlignment != 0) {
            string = string2 + "hAlignment:" + this.hAlignment + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.vAlignment != 0) {
            string = string2 + "vAlignment:" + this.vAlignment + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.textOrientation != 0) {
            string = string2 + "textOrientation:" + this.textOrientation + "\n";
            fileWriter.write(string, 0, string.length());
        }
        this.closeObjectHeader(fileWriter, n);
    }

    JDLabel(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("text")) {
                this.theText = jDFileLoader.parseStringArray();
                continue;
            }
            if (string.equals("hAlignment")) {
                this.hAlignment = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("vAlignment")) {
                this.vAlignment = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("textOrientation")) {
                this.textOrientation = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("font")) {
                this.theFont = jDFileLoader.parseFont();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.updateShape();
    }

    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(3);
        this.fillUndoPattern(undoPattern);
        undoPattern.fName = this.theFont.getName();
        undoPattern.fStyle = this.theFont.getStyle();
        undoPattern.fSize = this.theFont.getSize();
        undoPattern.textOrientation = this.textOrientation;
        undoPattern.vAlignment = this.vAlignment;
        undoPattern.hAlignment = this.hAlignment;
        undoPattern.text = new String(this.theText);
        return undoPattern;
    }

    JDLabel(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.theFont = new Font(undoPattern.fName, undoPattern.fStyle, undoPattern.fSize);
        this.textOrientation = undoPattern.textOrientation;
        this.vAlignment = undoPattern.vAlignment;
        this.hAlignment = undoPattern.hAlignment;
        this.theText = undoPattern.text;
        this.updateShape();
    }

    private void computeSummitCoordinates(int n, int n2, int n3, int n4) {
        this.summit[0].x = n;
        this.summit[0].y = n2;
        this.summit[2].x = n + n3;
        this.summit[2].y = n2;
        this.summit[4].x = n + n3;
        this.summit[4].y = n2 + n4;
        this.summit[6].x = n;
        this.summit[6].y = n2 + n4;
        this.centerSummit();
    }

    private void updateLabel(boolean bl) {
        this.preferredSize = null;
        Dimension dimension = this.getMinSize();
        if (bl && (this.summit[2].x - this.summit[0].x <= (double)dimension.width || this.summit[6].y - this.summit[0].y <= (double)dimension.height)) {
            double d = this.summit[0].x + (double)dimension.width;
            double d2 = this.summit[0].y + (double)dimension.height;
            this.summit[2].x = d;
            this.summit[4].x = d;
            this.summit[4].y = d2;
            this.summit[6].y = d2;
            this.centerSummit();
            this.updateShape();
        }
    }

    private String getSegmentString(Font font, FontRenderContext fontRenderContext, String string, int n) {
        boolean bl = false;
        String string2 = textDefault;
        for (int i = string.length(); i > 0 && !bl; --i) {
            string2 = string.substring(0, i);
            Rectangle2D rectangle2D = font.getStringBounds(string2, fontRenderContext);
            int n2 = (int)Math.ceil(rectangle2D.getWidth());
            bl = n2 < n;
        }
        if (!bl) {
            return textDefault;
        }
        return string2;
    }

    private Dimension getMinSize() {
        if (this.preferredSize == null) {
            Graphics graphics = img.getGraphics();
            graphics.setFont(this.theFont);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            String[] stringArray = this.theText.split("\n");
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                Rectangle2D rectangle2D = graphics.getFont().getStringBounds(stringArray[i], fontRenderContext);
                int n3 = (int)Math.ceil(rectangle2D.getWidth());
                int n4 = (int)Math.ceil(rectangle2D.getHeight());
                if (n3 > n) {
                    n = n3;
                }
                n2 += n4;
            }
            graphics.dispose();
            this.preferredSize = this.textOrientation == 0 || this.textOrientation == 2 ? new Dimension(n + 6, n2 + 4) : new Dimension(n2 + 4, n + 6);
        }
        return this.preferredSize;
    }
}

