/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ButtonBar;
import fr.esrf.tangoatk.widget.util.IControlee;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HelpWindow
extends JFrame
implements IControlee {
    protected static HelpWindow instance;
    JSplitPane mainSplit;
    JTree topics;
    JEditorPane htmlView;
    HelpNode top;
    Map nodes;
    JButton back;
    JButton forward;
    List views;
    JTextField location;
    boolean noHistory = false;
    int currentView = 0;
    ButtonBar bb;

    protected HelpWindow() {
        this.initComponents();
    }

    public void ok() {
        this.setVisible(false);
    }

    public static HelpWindow getInstance() {
        if (instance == null) {
            instance = new HelpWindow();
        }
        return instance;
    }

    protected void initComponents() {
        this.bb = new ButtonBar();
        this.top = new HelpNode();
        this.nodes = new HashMap();
        this.views = new Vector();
        JLabel jLabel = new JLabel("Location: ");
        this.back = new JButton();
        this.forward = new JButton();
        this.location = new JTextField();
        this.location.setEditable(false);
        this.location.setBackground(Color.white);
        this.htmlView = new JEditorPane();
        this.setTitle("Help");
        this.bb.setControlee(this);
        this.htmlView.setEditable(false);
        this.back.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpWindow.this.goBack();
            }
        });
        this.forward.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpWindow.this.goForward();
            }
        });
        this.back.setToolTipText("Back");
        this.back.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/Back16.gif")));
        this.forward.setToolTipText("Forward");
        this.forward.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/Forward16.gif")));
        this.htmlView.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                        HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                        HTMLDocument hTMLDocument = (HTMLDocument)HelpWindow.this.htmlView.getDocument();
                        hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                    } else {
                        try {
                            HelpWindow.this.showUrl(hyperlinkEvent.getURL());
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                }
            }
        });
        this.topics = new JTree(this.top);
        this.topics.getSelectionModel().setSelectionMode(1);
        this.topics.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)HelpWindow.this.topics.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null || !(defaultMutableTreeNode instanceof HelpNode)) {
                    return;
                }
                HelpNode helpNode = (HelpNode)defaultMutableTreeNode;
                HelpWindow.this.showPage(helpNode.getUrl());
                if (HelpWindow.this.noHistory) {
                    HelpWindow.this.noHistory = false;
                    return;
                }
                HelpWindow.this.views.add(helpNode);
                ++HelpWindow.this.currentView;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.topics);
        JScrollPane jScrollPane2 = new JScrollPane(this.htmlView);
        this.mainSplit = new JSplitPane(1, jScrollPane, jScrollPane2);
        this.mainSplit.setDividerSize(9);
        this.mainSplit.setOneTouchExpandable(true);
        this.mainSplit.setDividerLocation(150);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 5, 0);
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.getContentPane().add((Component)this.location, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.getContentPane().add((Component)this.back, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(10, 0, 5, 10);
        this.getContentPane().add((Component)this.forward, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.gridwidth = 0;
        jScrollPane.setPreferredSize(new Dimension(150, 50));
        jScrollPane2.setPreferredSize(new Dimension(400, 300));
        this.getContentPane().add((Component)this.mainSplit, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.bb, gridBagConstraints);
        this.pack();
    }

    public void showUrl(URL uRL) {
        HelpNode helpNode;
        String string = uRL.toString();
        this.showPage(uRL);
        int n = string.indexOf(35);
        if (n != -1) {
            try {
                uRL = new URL(string.substring(0, n));
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Can't display url: " + malformedURLException.getMessage());
            }
        }
        if ((helpNode = (HelpNode)this.nodes.get(uRL)) == null) {
            return;
        }
        this.topics.setSelectionPath(new TreePath(helpNode.getPath()));
        this.showHelpWindow();
    }

    public void goBack() {
        if (this.views.size() > 1 && this.currentView > 0) {
            this.noHistory = true;
            this.showNode((HelpNode)this.views.get(--this.currentView));
        }
    }

    public void goForward() {
        if (this.currentView < this.views.size() - 1) {
            this.noHistory = true;
            this.showNode((HelpNode)this.views.get(++this.currentView));
        }
    }

    protected void showPage(URL uRL) {
        try {
            this.htmlView.setPage(uRL);
            this.location.setText(uRL.toString());
        }
        catch (IOException iOException) {
            System.out.println("Can't display url: " + iOException.getMessage());
        }
    }

    public void showNode(HelpNode helpNode) {
        this.topics.setSelectionPath(new TreePath(helpNode.getPath()));
        this.showPage(helpNode.getUrl());
    }

    public void addCategory(String string, String string2, URL uRL) {
        CategoryNode categoryNode = null;
        Enumeration<TreeNode> enumeration = this.top.children();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode instanceof HelpNode || !(categoryNode = (CategoryNode)defaultMutableTreeNode).getCategory().equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            categoryNode = new CategoryNode(string, string2, uRL);
            this.top.add(categoryNode);
        } else {
            if (this.nodes.containsKey(uRL)) {
                return;
            }
            categoryNode.add(string2, uRL);
        }
        this.pack();
    }

    public void setTop(String string, URL uRL) {
        this.top.setName(string);
        this.top.setUrl(uRL);
        this.nodes.put(uRL, this.top);
        this.views.add(this.top);
        this.showPage(uRL);
    }

    public void addTop(String string, URL uRL) {
        HelpNode helpNode = null;
        helpNode = new HelpNode(string, uRL);
        this.top.add(helpNode);
        this.pack();
    }

    public void showHelpWindow() {
        this.topics.expandRow(0);
        super.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        HelpWindow.getInstance().setTop("Urk", new URL("http://www.dagbladet.no"));
        HelpWindow.getInstance().addTop("first", new URL("http://www.skiinfo.no"));
        HelpWindow.getInstance().addCategory("Skiinfo", "second", new URL("http://www.skiinfo.no"));
        HelpWindow.getInstance().showHelpWindow();
    }

    class HelpNode
    extends DefaultMutableTreeNode {
        String name;
        URL url;

        public HelpNode() {
        }

        public HelpNode(String string, URL uRL) {
            this.name = string;
            this.url = uRL;
            HelpWindow.this.nodes.put(uRL, this);
        }

        public String toString() {
            return this.name;
        }

        public URL getUrl() {
            return this.url;
        }

        public void setUrl(URL uRL) {
            this.url = uRL;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    class CategoryNode
    extends DefaultMutableTreeNode {
        String category;

        public CategoryNode(String string, String string2, URL uRL) {
            this.category = string;
            this.add(string2, uRL);
        }

        public String getCategory() {
            return this.category;
        }

        public String toString() {
            return this.category;
        }

        public void add(String string, URL uRL) {
            this.add(new HelpNode(string, uRL));
        }
    }
}

