/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.util.JGradientViewer;

public abstract class IImageFormat {
    byte[][] data = new byte[0][0];
    double bfA0;
    double bfA1;
    boolean bestFit;
    JGradientViewer tool;

    public void setData(byte[][] byArray) {
        this.data = byArray == null ? new byte[0][0] : byArray;
    }

    public void initDefault(boolean bl, JGradientViewer jGradientViewer) {
        this.tool = jGradientViewer;
        this.bestFit = bl;
        this.bfA0 = 0.0;
        this.bfA1 = 1.0;
    }

    public boolean setFitting(boolean bl, double d, double d2) {
        if (d >= d2 || d < 0.0 || d > 100.0 || d2 < 0.0 || d2 > 100.0) {
            return false;
        }
        this.bestFit = bl;
        double d3 = this.getHistogramWidth();
        double d4 = d / 100.0;
        double d5 = d2 / 100.0;
        this.bfA0 = -d4 * d3;
        this.bfA1 = 65536.0 / (d3 * (d5 - d4));
        return true;
    }

    public abstract int getWidth();

    public int getHeight() {
        return this.data.length;
    }

    public abstract boolean isColorFormat();

    public abstract String getName();

    public abstract double getValue(int var1, int var2);

    public abstract int getHistogramWidth();

    public abstract void computeFitting();

    public abstract int getRGB(boolean var1, int[] var2, int var3, int var4);
}

