/*
 * Decompiled with CFR 0.152.
 */
package pogo.make_util;

import java.util.Vector;
import pogo.gene.PogoUtil;

public class ParseMenu {
    private String code;
    private AppMenu menuBar;
    private Vector writtenMethod = new Vector();

    public ParseMenu(String filename) throws Exception {
        this.code = PogoUtil.readFile(filename);
        this.parseMenuBar();
        System.out.println("\t//===============================================================");
        System.out.println(this.menuBar.toCode());
    }

    private void parseMenuBar() throws Exception {
        String target = "setJMenuBar(";
        int idx = this.code.indexOf(target);
        if (idx <= 0) {
            throw new Exception(target + " not found");
        }
        this.menuBar = new AppMenu(ParseMenu.getName(this.code, idx += target.length()), 0);
    }

    static String getName(String s, int idx) {
        return s.substring(idx, s.indexOf(");", idx)).trim();
    }

    public static int outMethod(String str, int start) {
        int end;
        int cnt = 1;
        block4: for (end = start + 1; cnt != 0 && end < str.length(); ++end) {
            switch (str.charAt(end)) {
                case '{': {
                    ++cnt;
                    continue block4;
                }
                case '}': {
                    --cnt;
                }
            }
        }
        if ((end = str.indexOf(10, end)) < str.length() - 1) {
            ++end;
        }
        return end;
    }

    public static void main(String[] args) {
        String filename = "../appli/PogoAppli.java";
        ParseMenu client = null;
        if (args.length > 0) {
            filename = args[0];
        }
        try {
            client = new ParseMenu(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class AppMenu
    extends Vector {
        String name;
        String _class;
        String label;
        String listener;
        String listenerMethod;
        int deep;

        AppMenu(String name, int deep) {
            this.name = name;
            this.deep = deep++;
            this.parseSubMenu(deep);
            this.parseClass();
            this.parseLabel();
            this.parseListener();
            this.parseListenerMethod();
        }

        private void parseListenerMethod() {
            String target = "private void " + this.listener;
            int start = ParseMenu.this.code.indexOf(target);
            if (start > 0) {
                int end = start + target.length();
                end = ParseMenu.this.code.indexOf(123, end);
                end = ParseMenu.outMethod(ParseMenu.this.code, end);
                start = ParseMenu.this.code.lastIndexOf(10, start) + 1;
                this.listenerMethod = ParseMenu.this.code.substring(start, end);
            }
        }

        private void parseListener() {
            String target = this.name + ".addActionListener(";
            int start = ParseMenu.this.code.indexOf(target);
            if (start > 0) {
                start += target.length();
                start = ParseMenu.this.code.indexOf(123, start);
                start = ParseMenu.this.code.indexOf(123, start + 1);
                int end = ParseMenu.this.code.indexOf("(evt);", ++start);
                this.listener = ParseMenu.this.code.substring(start, end).trim();
            }
        }

        private void parseClass() {
            String target = this.name + " = new ";
            int start = ParseMenu.this.code.indexOf(target);
            if (start > 0) {
                int end = ParseMenu.this.code.indexOf(59, start += target.length());
                this._class = ParseMenu.this.code.substring(start, end);
                target = "javax.swing.";
                start = this._class.indexOf(target);
                if (start >= 0) {
                    this._class = this._class.substring(start + target.length());
                }
                if ((start = this._class.indexOf("()")) > 0) {
                    this._class = this._class.substring(0, start);
                }
            }
        }

        private void parseLabel() {
            String target = this.name + ".setText(\"";
            int start = ParseMenu.this.code.indexOf(target);
            if (start > 0) {
                this.label = ParseMenu.getName(ParseMenu.this.code, start += target.length());
                if (this.label.indexOf(34) > 0) {
                    this.label = this.label.substring(0, this.label.indexOf(34));
                }
            }
        }

        private void parseSubMenu(int deep) {
            String target = this.name + ".add(";
            int idx = 0;
            while ((idx = ParseMenu.this.code.indexOf(target, idx)) > 0) {
                String item = ParseMenu.getName(ParseMenu.this.code, idx += target.length());
                this.add(new AppMenu(item, deep));
            }
        }

        private String constructor() {
            if (this._class == null) {
                return "";
            }
            if (this._class.equals("JMenuBar")) {
                return this._class + "();\n";
            }
            if (this._class.equals("JSeparator")) {
                return this._class + "();\n";
            }
            return this._class + "(\"" + this.label + "\");\n";
        }

        private String addingMethod() {
            int i;
            String str = "";
            if (this._class == null) {
                return "";
            }
            if (this._class.equals("JMenuBar")) {
                str = "\t\tsetJMenuBar(" + this.name + ");\n";
            }
            for (i = 0; i < this.size(); ++i) {
                str = str + "\t\t" + this.name + ".add(" + this.menuAt((int)i).name + ");\n";
            }
            for (i = 0; i < this.size(); ++i) {
                str = str + this.menuAt(i).addingMethod();
            }
            return str;
        }

        private String declaration() {
            if (this._class == null) {
                return "";
            }
            String str = "\t\t" + this._class + "\t" + this.name + " = new " + this.constructor();
            for (int i = 0; i < this.size(); ++i) {
                str = str + this.menuAt(i).declaration();
            }
            return str;
        }

        private String addListeners() {
            if (this._class == null) {
                return "";
            }
            String str = "";
            if (this.listener != null) {
                str = str + "\t\t" + this.name + ".addActionListener(new java.awt.event.ActionListener()\n";
                str = str + "\t\t{\n";
                str = str + "\t\t\tpublic void actionPerformed(java.awt.event.ActionEvent evt) {\n";
                str = str + "\t\t\t\t" + this.listener + "(evt);\n";
                str = str + "\t\t\t}\n";
                str = str + "\t\t});\n";
            }
            for (int i = 0; i < this.size(); ++i) {
                str = str + this.menuAt(i).addListeners();
            }
            return str;
        }

        private boolean methodAlreadyWritten() {
            boolean already_done = false;
            for (int i = 0; !already_done && i < ParseMenu.this.writtenMethod.size(); ++i) {
                already_done = this.listener.equals((String)ParseMenu.this.writtenMethod.get(i));
            }
            if (!already_done) {
                ParseMenu.this.writtenMethod.add(this.listener);
            }
            return already_done;
        }

        private String addListenerMethods() {
            String str = "";
            if (this.listener != null) {
                if (this.listenerMethod != null) {
                    if (!this.methodAlreadyWritten()) {
                        str = str + "\t//===============================================================\n";
                        str = str + "\tprivate void " + this.listener + "(java.awt.event.ActionEvent evt)\n";
                        str = str + "\t{\n";
                        str = str + "\t}\n";
                    }
                } else {
                    str = str + this.listener + " ----> has null method\n";
                }
            }
            for (int i = 0; i < this.size(); ++i) {
                str = str + this.menuAt(i).addListenerMethods();
            }
            return str;
        }

        public String toCode() {
            String str = "\tprivate void createMenu()\n\t{\n";
            str = str + this.declaration();
            str = str + "\n\n";
            str = str + this.addListeners();
            str = str + this.addingMethod();
            str = str + "\t}\n";
            str = str + this.addListenerMethods();
            return str;
        }

        AppMenu menuAt(int i) {
            return (AppMenu)this.get(i);
        }

        public String toString() {
            String indent = "";
            for (int i = 0; i < this.deep; ++i) {
                indent = indent + "    ";
            }
            String str = indent + this.name + " (" + this._class + ") -> " + this.listener + "\n";
            for (int i = 0; i < this.size(); ++i) {
                str = str + (AppMenu)this.get(i);
            }
            return str;
        }
    }
}

