/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.AstorUtil;
import admin.astor.DbaseObject;
import admin.astor.RemoteLoginThread;
import admin.astor.ServerCmdThread;
import admin.astor.TangoHost;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreePopupMenu
extends JPopupMenu
implements AstorDefs {
    private DefaultMutableTreeNode node_cut = null;
    private Astor astor;
    private AstorTree parent;
    private TangoHost host;
    private String collec_name;
    private TangoHost[] collec_hosts;
    private static String[] menuLabels = new String[]{"Open control Panel", "Disable control", "Enable  control", "Remote Login", "Starter info", "Starter test", "Starter Logging", "Unexport Starter device", "Branch  info", "Start all Servers", "Stop  all Servers", "Clone", "Cut", "Paste", "Edit Properties", "Remove", "Force Update", "Change Name"};
    private static final int OFFSET = 2;
    private static final int OPEN_PANEL = 0;
    private static final int DISABLE = 1;
    private static final int ENABLE = 2;
    private static final int REM_LOGIN = 3;
    private static final int STARTER_INFO = 4;
    private static final int STARTER_TEST = 5;
    private static final int STARTER_LOGG = 6;
    private static final int UNEXPORT_STARTER = 7;
    private static final int COLLEC_INFO = 8;
    private static final int START_SERVERS = 9;
    private static final int STOP_SERVERS = 10;
    private static final int CLONE_HOST = 11;
    private static final int CUT_HOST = 12;
    private static final int PASTE_HOST = 13;
    private static final int EDIT_PROP = 14;
    private static final int REMOVE_HOST = 15;
    private static final int UPDATE = 16;
    private static final int CHANGE_NAME = 17;

    public TreePopupMenu(Astor astor, AstorTree parent) {
        this.astor = astor;
        this.parent = parent;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        JLabel title = new JLabel("Host Control :");
        title.setFont(new Font("Dialog", 1, 16));
        this.add(title);
        this.add(new JPopupMenu.Separator());
        for (int i = 0; i < menuLabels.length; ++i) {
            JMenuItem btn = new JMenuItem(menuLabels[i]);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TreePopupMenu.this.hostActionPerformed(evt);
                }
            });
            this.add(btn);
        }
    }

    private boolean getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.parent.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        Object obj = node.getUserObject();
        if (obj instanceof DbaseObject) {
            return false;
        }
        if (obj instanceof TangoHost) {
            this.host = (TangoHost)((Object)obj);
            this.collec_name = null;
        } else {
            this.host = null;
            int nb = node.getChildCount();
            this.collec_hosts = new TangoHost[nb];
            for (int i = 0; i < nb; ++i) {
                Object o = (node = node.getNextNode()).getUserObject();
                if (!(o instanceof TangoHost)) {
                    return false;
                }
                this.collec_hosts[i] = (TangoHost)((Object)o);
            }
            this.collec_name = (String)obj;
        }
        return true;
    }

    public void showMenu(MouseEvent evt) {
        TreePath selectedPath = this.parent.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        this.parent.setSelectionPath(selectedPath);
        if (!this.getSelectedObject()) {
            return;
        }
        for (int i = 3; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setVisible(true);
        }
        if (this.host != null) {
            JLabel lbl = (JLabel)this.getComponent(0);
            lbl.setText("  " + this.host.getName() + "  :");
            boolean do_open = this.host.do_polling && this.host.state != 1;
            this.getComponent(2).setEnabled(do_open);
            if (this.host.use_events || !AstorUtil.getCtrlBtn()) {
                this.getComponent(3).setVisible(false);
                this.getComponent(4).setVisible(false);
            } else {
                this.getComponent(3).setEnabled(this.host.do_polling);
                this.getComponent(4).setEnabled(!this.host.do_polling);
            }
            this.getComponent(10).setVisible(false);
            this.getComponent(11).setVisible(false);
            this.getComponent(12).setVisible(false);
            this.getComponent(14).setEnabled(true);
            this.getComponent(15).setEnabled(false);
            this.getComponent(16).setEnabled(true);
            this.getComponent(19).setVisible(false);
            this.getComponent(13).setEnabled(true);
            boolean can_test = this.host.state == 3 || this.host.state == 2 || this.host.state == 4;
            this.getComponent(7).setEnabled(can_test);
            this.getComponent(8).setEnabled(can_test);
            this.getComponent(17).setEnabled(!can_test);
            this.getComponent(18).setEnabled(can_test);
            boolean can_unexport = this.host.state == 0;
            this.getComponent(9).setVisible(can_unexport);
        } else if (this.collec_name != null) {
            JLabel lbl = (JLabel)this.getComponent(0);
            lbl.setText("  " + this.collec_name + "  :");
            this.getComponent(2).setEnabled(false);
            this.getComponent(3).setVisible(AstorUtil.getCtrlBtn());
            this.getComponent(4).setVisible(AstorUtil.getCtrlBtn());
            this.getComponent(3).setEnabled(true);
            this.getComponent(4).setEnabled(true);
            this.getComponent(5).setVisible(false);
            this.getComponent(6).setVisible(false);
            this.getComponent(7).setVisible(false);
            this.getComponent(8).setVisible(false);
            this.getComponent(18).setVisible(false);
            this.getComponent(13).setEnabled(false);
            this.getComponent(14).setEnabled(false);
            this.getComponent(16).setEnabled(false);
            this.getComponent(15).setEnabled(this.node_cut != null);
            this.getComponent(17).setEnabled(false);
            this.getComponent(9).setVisible(false);
        }
        if (!AstorUtil.osIsUnix()) {
            this.getComponent(5).setVisible(false);
        }
        this.show(this.parent, evt.getX(), evt.getY());
    }

    private void hostActionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        int cmdidx = 0;
        for (int i = 0; i < menuLabels.length; ++i) {
            if (this.getComponent(2 + i) != obj) continue;
            cmdidx = i;
        }
        switch (cmdidx) {
            case 0: {
                this.parent.displayHostInfo();
                break;
            }
            case 7: {
                this.host.unexportStarter(this.astor);
                break;
            }
            case 5: {
                this.host.testStarter(this.astor);
                break;
            }
            case 6: {
                this.host.displayLogging(this.astor);
                break;
            }
            case 4: {
                this.host.displayInfo(this.parent);
                break;
            }
            case 3: {
                new RemoteLoginThread(this.host.getName(), this.parent).start();
                break;
            }
            case 2: {
                this.enablePolling(true);
                break;
            }
            case 1: {
                this.enablePolling(false);
                break;
            }
            case 11: {
                this.astor.addNewHost(this.host);
                break;
            }
            case 14: {
                this.astor.editHostProperties(this.host);
                break;
            }
            case 12: {
                this.node_cut = (DefaultMutableTreeNode)this.parent.getLastSelectedPathComponent();
                break;
            }
            case 13: {
                this.parent.moveNode(this.node_cut);
                this.node_cut = null;
                break;
            }
            case 15: {
                this.astor.removeHost(this.host.getName());
                break;
            }
            case 17: {
                this.parent.changeNodeName();
                break;
            }
            case 8: {
                this.parent.displayBranchInfo();
                break;
            }
            case 9: {
                new ServerCmdThread(this.astor, this.collec_hosts, 0).start();
                break;
            }
            case 10: {
                new ServerCmdThread(this.astor, this.collec_hosts, 1).start();
                break;
            }
            case 16: {
                this.host.updateServersList(this.astor);
            }
        }
    }

    private void enablePolling(boolean enable) {
        if (this.host != null) {
            this.host.do_polling = enable;
            if (!enable) {
                this.parent.hostDialogs.close(this.host);
            }
        } else {
            for (int i = 0; i < this.collec_hosts.length; ++i) {
                this.collec_hosts[i].do_polling = enable;
                if (enable) continue;
                this.parent.hostDialogs.close(this.collec_hosts[i]);
            }
        }
    }
}

