/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.HostInfoDialog;
import admin.astor.TangoServer;
import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jive.DevWizard;

public class ListDialog
extends JDialog {
    private static String str_filter = "*";
    private static String previous_item = null;
    private HostInfoDialog parent;
    private String selectedItem = null;
    private JButton cancelBtn;
    private JButton createBtn;
    private JTextField filterTxt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jList;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JButton startBtn;

    private void setList() throws DevFailed {
        str_filter = this.filterTxt.getText();
        String[] servlist = ApiUtil.get_db_obj().get_server_list(str_filter);
        this.jList.setListData(servlist);
        for (int i = 0; i < servlist.length; ++i) {
            if (!servlist[i].equals(previous_item)) continue;
            this.jList.setSelectedIndex(i);
        }
    }

    public ListDialog(HostInfoDialog parent) {
        super((Dialog)parent, true);
        this.parent = parent;
        this.initComponents();
        this.filterTxt.setText(str_filter);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ListDialog.this.listSelectionPerformed(e);
            }
        };
        this.jList.addMouseListener(mouseListener);
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.startBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList = new JList();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.filterTxt = new JTextField();
        this.createBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ListDialog.this.closeDialog(evt);
            }
        });
        this.startBtn.setText("Start Server");
        this.startBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.startBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.startBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jScrollPane1.setPreferredSize(new Dimension(200, 300));
        this.jScrollPane1.setViewportView(this.jList);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jLabel2.setText("Filter :  ");
        this.jPanel2.add(this.jLabel2);
        this.jPanel2.add(this.jLabel1);
        this.filterTxt.setColumns(20);
        this.filterTxt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.filterTxtActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.filterTxt);
        this.createBtn.setText("Create New Server");
        this.createBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListDialog.this.createBtnActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.createBtn);
        this.getContentPane().add((Component)this.jPanel2, "North");
    }

    private void createBtnActionPerformed(ActionEvent evt) {
        block5: {
            try {
                DevWizard wdlg = new DevWizard((Dialog)this.parent, (DeviceProxy)this.parent.host);
                wdlg.showWizard(null);
                String servname = DevWizard.lastServStarted;
                if (servname == null) break block5;
                Point p = this.getLocationOnScreen();
                p.translate(50, 50);
                try {
                    if (new TangoServer(servname, DevState.OFF).startupLevel(this.parent, this.parent.host.getName(), p)) {
                        this.parent.updateData();
                    }
                }
                catch (DevFailed e) {
                    PopupError.show((Component)this.parent, e);
                }
            }
            catch (NoSuchMethodError ex) {
                PopupError.show((Component)this.parent, "This server is too old !\nUse Jive to create it.");
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    private void filterTxtActionPerformed(ActionEvent evt) {
        try {
            this.setList();
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void startBtnActionPerformed(ActionEvent evt) {
        this.retreiveSelectedItem();
    }

    private void listSelectionPerformed(MouseEvent evt) {
        previous_item = new String((String)this.jList.getSelectedValue());
        if (evt.getClickCount() == 2) {
            this.retreiveSelectedItem();
        }
    }

    private void retreiveSelectedItem() {
        String servname = (String)this.jList.getSelectedValue();
        try {
            String devname = new String("dserver/" + servname);
            DeviceProxy dev = new DeviceProxy(devname);
            try {
                dev.ping();
                PopupError.show((Component)this.parent, new String(servname + "  is Already Running  on " + new IORdump(devname).get_host() + " !"));
                return;
            }
            catch (DevFailed e) {
            }
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
            return;
        }
        this.selectedItem = servname;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void showDialog() {
        try {
            this.setList();
        }
        catch (DevFailed e) {
            PopupError.show((Component)this.parent, e);
        }
        this.setVisible(true);
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }
}

