/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DbPollPanel
extends JDialog {
    private Component parent;
    private DeviceProxy selected_dev;
    private DeviceProxy[] devices;
    private Vector buttons = new Vector();
    private PolledAttr[] attlist;
    private static final String PollAttProp = "polled_attr";
    private JPanel panel = null;
    private JButton cancelBtn;
    private JComboBox devComboBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton okBtn;
    private JLabel titleLabel;

    public DbPollPanel(JFrame parent, String servname) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initialize(servname);
    }

    public DbPollPanel(JDialog parent, String servname) {
        super((Dialog)parent, true);
        this.parent = parent;
        this.initialize(servname);
    }

    private void initialize(String servname) {
        this.parent = this.parent;
        this.initComponents();
        this.titleLabel.setText("Polled Attributes For ");
        this.devices = this.getDeviceList(servname);
        this.buildPanel(this.devices.length - 1);
        this.okBtn.setText("Apply");
        this.cancelBtn.setText("Dismiss");
    }

    private DeviceProxy[] getDeviceList(String servname) {
        try {
            String[] classes;
            Vector<String> v = new Vector<String>();
            DbServer serv = new DbServer(servname);
            for (String classname : classes = serv.get_class_list()) {
                String[] devnames;
                for (String dn : devnames = serv.get_device_name(classname)) {
                    v.add(dn);
                }
            }
            DeviceProxy[] dp = new DeviceProxy[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                this.devComboBox.addItem(v.get(i));
                dp[i] = new DeviceProxy((String)v.get(i));
            }
            this.devComboBox.setSelectedIndex(v.size() - 1);
            return dp;
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
            return new DeviceProxy[0];
        }
    }

    private void buildPanel(int dev_idx) {
        this.selected_dev = this.devices[dev_idx];
        if (this.panel != null) {
            this.getContentPane().remove(this.panel);
        }
        try {
            GridBagConstraints gbc = new GridBagConstraints();
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            int y = 0;
            for (PolledAttr att : this.attlist = this.getPolledAttributes(this.selected_dev)) {
                gbc.gridx = 0;
                gbc.gridy = y;
                gbc.fill = 2;
                panel.add((Component)att.btn, gbc);
                gbc.gridx = 1;
                gbc.gridy = y;
                gbc.fill = 2;
                panel.add((Component)att.txt, gbc);
                gbc.gridx = 2;
                gbc.gridy = y++;
                gbc.fill = 2;
                panel.add((Component)new JLabel("ms"), gbc);
            }
            this.getContentPane().add((Component)panel, "Center");
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)e);
        }
        this.pack();
    }

    public PolledAttr[] getPolledAttributes(DeviceProxy dev) throws DevFailed {
        DbDatum argout = dev.get_property(PollAttProp);
        String[] data = argout.extractStringArray();
        if (data == null) {
            return new PolledAttr[0];
        }
        Vector<PolledAttr> v = new Vector<PolledAttr>();
        for (int i = 0; i < data.length; i += 2) {
            v.add(new PolledAttr(data[i], data[i + 1]));
        }
        PolledAttr[] pa = new PolledAttr[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            pa[i] = (PolledAttr)v.get(i);
        }
        return pa;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.devComboBox = new JComboBox();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DbPollPanel.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbPollPanel.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbPollPanel.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.devComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DbPollPanel.this.devComboBoxActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.devComboBox);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void devComboBoxActionPerformed(ActionEvent evt) {
        if (this.isVisible()) {
            this.buildPanel(this.devComboBox.getSelectedIndex());
        }
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String message = "Remove polling for :\n";
        Vector<String> v = new Vector<String>();
        for (PolledAttr att : this.attlist) {
            if (att.btn.getSelectedObjects() == null) {
                message = message + att.name + "\n";
                continue;
            }
            v.add(att.name);
            try {
                att.period = Integer.parseInt(att.txt.getText());
                v.add(att.txt.getText());
            }
            catch (NumberFormatException e) {
                ErrorPane.showErrorMessage((Component)this, (String)("NumberFormatException on  attribute " + att.name), (Exception)e);
                return;
            }
        }
        System.out.println(v.size());
        if (v.size() < this.attlist.length * 2 && JOptionPane.showConfirmDialog(this, message, "Question", 0) != 0) {
            return;
        }
        String[] str = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            str[i] = (String)v.get(i);
        }
        try {
            DbDatum data = new DbDatum(PollAttProp);
            data.insert(str);
            this.selected_dev.put_property(data);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
        JOptionPane.showMessageDialog(this, "Database Updated", "", 1);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent.getWidth() == 0) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        String servname = null;
        if (args.length > 0) {
            servname = args[0];
        }
        try {
            if (servname == null) {
                Except.throw_exception((String)"NO_SERVER_NAME", (String)"Serrver's name ????", (String)"PollPanel.main()");
            }
            new DbPollPanel(new JFrame(), servname).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            System.exit(0);
        }
    }

    class PolledAttr {
        String name;
        int period;
        JRadioButton btn;
        JTextField txt;

        public PolledAttr(String name, String strperiod) {
            this.name = name;
            try {
                this.period = Integer.parseInt(strperiod);
            }
            catch (NumberFormatException e) {
                this.period = -1;
            }
            this.btn = new JRadioButton(name);
            this.btn.setSelected(true);
            this.txt = new JTextField("" + this.period);
            this.txt.setColumns(6);
        }
    }
}

