/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.ATKEvent;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberSpectrum;

public class NumberSpectrumEvent
extends ATKEvent {
    double[] value;
    double[] devValue;

    public NumberSpectrumEvent(INumberSpectrum iNumberSpectrum, double[] dArray, long l) {
        super(iNumberSpectrum, l);
        this.setValue(dArray);
        this.devValue = new double[1];
    }

    public double[] getValue() {
        return this.value;
    }

    public double[] getDeviceValue() {
        double d = 1.0;
        if (this.source != null && this.source instanceof INumberSpectrum) {
            d = ((INumberSpectrum)this.source).getDisplayUnitFactor();
        }
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d == 1.0) {
            return this.value;
        }
        int n = this.value.length;
        if (n != this.devValue.length || this.devValue.length == 0) {
            this.devValue = new double[n];
        }
        for (int i = 0; i < n; ++i) {
            this.devValue[i] = this.value[i] / d;
        }
        return this.devValue;
    }

    public double[] getStandardValue() {
        double d = 1.0;
        double[] dArray = this.getDeviceValue();
        if (this.source != null && this.source instanceof INumberImage) {
            d = ((INumberImage)this.source).getStandardUnitFactor();
        }
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d == 1.0) {
            return dArray;
        }
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] * d;
        }
        return dArray2;
    }

    public void setValue(double[] dArray) {
        this.value = dArray;
    }

    public void setSource(INumberSpectrum iNumberSpectrum) {
        this.source = iNumberSpectrum;
    }

    public String getVersion() {
        return "$Id: NumberSpectrumEvent.java,v 1.2 2006/06/29 11:19:12 poncet Exp $";
    }
}

