/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.ITangoPeriodicListener;
import fr.esrf.TangoApi.events.ITangoUserListener;
import fr.esrf.TangoApi.events.TangoUserEvent;
import java.io.Serializable;

public class TangoUser
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoUser(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoUserListener(ITangoUserListener listener, boolean stateless) throws DevFailed {
        this.event_listeners.add(ITangoUserListener.class, listener);
        this.event_identifier = this.subscribe_user_event(this.attr_name, this.filters, stateless);
    }

    public void removeTangoUserListener(ITangoUserListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoUserListener.class, listener);
        if (this.event_listeners.getListenerCount() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    public void dispatch_event(EventData event_data) {
        TangoUserEvent user_event = new TangoUserEvent(this, event_data);
        this.fireTangoUserEvent(user_event);
    }

    private void fireTangoUserEvent(TangoUserEvent user_event) {
        Object[] listeners = this.event_listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ITangoPeriodicListener.class) continue;
            ((ITangoUserListener)listeners[i + 1]).user(user_event);
        }
    }
}

