/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.ITangoAttConfigListener;
import fr.esrf.TangoApi.events.TangoAttConfigEvent;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class TangoAttConfig
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoAttConfig(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoAttConfigListener(ITangoAttConfigListener listener, boolean stateless) throws DevFailed {
        this.event_listeners.add(ITangoAttConfigListener.class, listener);
        this.event_identifier = this.subscribe_att_config_event(this.attr_name, this.filters, stateless);
    }

    public void removeTangoAttConfigListener(ITangoAttConfigListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoAttConfigListener.class, listener);
        if (this.event_listeners.getListenerCount() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    public void dispatch_event(final EventData event_data) {
        final TangoAttConfig tg = this;
        Runnable do_work_later = new Runnable(){

            public void run() {
                TangoAttConfigEvent change_event = new TangoAttConfigEvent(tg, event_data);
                TangoAttConfig.this.fireTangoAttConfigEvent(change_event);
            }
        };
        SwingUtilities.invokeLater(do_work_later);
    }

    private void fireTangoAttConfigEvent(TangoAttConfigEvent att_config_event) {
        Object[] listeners = this.event_listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ITangoAttConfigListener.class) continue;
            ((ITangoAttConfigListener)listeners[i + 1]).attConfig(att_config_event);
        }
    }
}

