/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.Group;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.Group.GroupAttrReplyList;
import fr.esrf.TangoApi.Group.GroupCmdReplyList;
import fr.esrf.TangoApi.Group.GroupDeviceElement;
import fr.esrf.TangoApi.Group.GroupElement;
import fr.esrf.TangoApi.Group.GroupReplyList;
import fr.esrf.TangoDs.Except;
import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class Group
extends GroupElement
implements Serializable {
    private Vector elements = new Vector();
    private int asynch_req_id = 0;
    private GroupElementFactory factory = new GroupElementFactory();
    private TreeMap arp = new TreeMap();

    public Group(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        Group group = this;
        synchronized (group) {
            this.dump_i(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(boolean fwd) {
        Group group = this;
        synchronized (group) {
            return this.ping_i(fwd);
        }
    }

    public String[] get_device_list(boolean fwd) {
        return this.get_device_name_list(fwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group get_group(String n) {
        Group group = this;
        synchronized (group) {
            return this.get_group_i(n, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceProxy get_device(String n) {
        Group group = this;
        synchronized (group) {
            return this.get_device_i(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceProxy get_device(int i) {
        Group group = this;
        synchronized (group) {
            return this.get_device_i(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_size(boolean fwd) {
        Group group = this;
        synchronized (group) {
            return this.get_size_i(fwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Group g) {
        if (g == null) {
            return;
        }
        Group group = this;
        synchronized (group) {
            this.add_i(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String p) {
        Group group = this;
        synchronized (group) {
            try {
                Vector v = this.factory.instanciate(p);
                Iterator it = v.iterator();
                while (it.hasNext()) {
                    this.add_i((GroupElement)it.next());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String[] pl) {
        Group group = this;
        synchronized (group) {
            try {
                for (int i = 0; i < pl.length; ++i) {
                    if (pl[i] == null) continue;
                    Vector v = this.factory.instanciate(pl[i]);
                    Iterator it = v.iterator();
                    while (it.hasNext()) {
                        this.add_i((GroupElement)it.next());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String p, boolean fwd) {
        Group group = this;
        synchronized (group) {
            this.remove_i(p, fwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String[] pl, boolean fwd) {
        Group group = this;
        synchronized (group) {
            for (int i = 0; i < pl.length; ++i) {
                this.remove_i(pl[i], fwd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_all() {
        Group group = this;
        synchronized (group) {
            this.elements.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String n, boolean fwd) {
        Group group = this;
        synchronized (group) {
            return this.find_i(n, fwd) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_timeout_millis(int timeout, boolean fwd) throws DevFailed {
        Group group = this;
        synchronized (group) {
            for (GroupElement e : this.elements) {
                if (!(e instanceof GroupDeviceElement) && !fwd) continue;
                e.set_timeout_millis(timeout, fwd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupCmdReplyList command_inout(String c, boolean fwd) throws DevFailed {
        Group group = this;
        synchronized (group) {
            int rid = this.command_inout_asynch_i(c, false, fwd, this.next_req_id());
            return this.command_inout_reply_i(rid, 0, fwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupCmdReplyList command_inout(String c, DeviceData dd, boolean fwd) throws DevFailed {
        Group group = this;
        synchronized (group) {
            int rid = this.command_inout_asynch_i(c, dd, false, fwd, this.next_req_id());
            return this.command_inout_reply_i(rid, 0, fwd);
        }
    }

    public DeviceData[] get_command_specific_argument_list(boolean fwd) throws DevFailed {
        int al_size = this.get_size(fwd);
        DeviceData[] al = new DeviceData[al_size];
        for (int i = 0; i < al_size; ++i) {
            al[i] = new DeviceData();
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupCmdReplyList command_inout(String c, DeviceData[] dd, boolean fwd) throws DevFailed {
        Group group = this;
        synchronized (group) {
            int rid = this.command_inout_asynch_i(c, dd, false, fwd, this.next_req_id());
            return this.command_inout_reply_i(rid, 0, fwd);
        }
    }

    public int command_inout_asynch(String c, boolean fgt, boolean fwd) throws DevFailed {
        int rid = this.command_inout_asynch_i(c, fgt, fwd, this.next_req_id());
        if (!fgt) {
            this.arp.put(new Integer(rid), new Boolean(fwd));
        }
        return rid;
    }

    public int command_inout_asynch(String c, DeviceData dd, boolean fgt, boolean fwd) throws DevFailed {
        int rid = this.command_inout_asynch_i(c, dd, fgt, fwd, this.next_req_id());
        if (!fgt) {
            this.arp.put(new Integer(rid), new Boolean(fwd));
        }
        return rid;
    }

    public int command_inout_asynch(String c, DeviceData[] dd, boolean fgt, boolean fwd) throws DevFailed {
        int rid = this.command_inout_asynch_i(c, dd, fgt, fwd, this.next_req_id());
        if (!fgt) {
            this.arp.put(new Integer(rid), new Boolean(fwd));
        }
        return rid;
    }

    public GroupCmdReplyList command_inout_reply(int rid, int tmo) throws DevFailed {
        Integer rid_obj = new Integer(rid);
        Boolean fwd = (Boolean)this.arp.get(rid_obj);
        if (fwd == null) {
            Except.throw_exception("API_BadAsynPollId", "Invalid asynch. request identifier specified", "Group.command_inout_reply");
        }
        this.arp.remove(rid_obj);
        return this.command_inout_reply_i(rid, tmo, fwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupAttrReplyList read_attribute(String a, boolean fwd) throws DevFailed {
        Group group = this;
        synchronized (group) {
            int rid = this.read_attribute_asynch_i(a, fwd, this.next_req_id());
            return this.read_attribute_reply_i(rid, 0, fwd);
        }
    }

    public int read_attribute_asynch(String a, boolean fwd) throws DevFailed {
        int rid = this.read_attribute_asynch_i(a, fwd, this.next_req_id());
        this.arp.put(new Integer(rid), new Boolean(fwd));
        return rid;
    }

    public GroupAttrReplyList read_attribute_reply(int rid, int tmo) throws DevFailed {
        Integer rid_obj = new Integer(rid);
        Boolean fwd = (Boolean)this.arp.get(rid_obj);
        if (fwd == null) {
            Except.throw_exception("API_BadAsynPollId", "Invalid asynch. request identifier specified", "Group.read_inout_reply");
        }
        this.arp.remove(rid_obj);
        return this.read_attribute_reply_i(rid, tmo, fwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupReplyList write_attribute(DeviceAttribute da, boolean fwd) throws DevFailed {
        Group group = this;
        synchronized (group) {
            int rid = this.write_attribute_asynch_i(da, fwd, this.next_req_id());
            return this.write_attribute_reply_i(rid, 0, fwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceAttribute[] get_attribute_specific_value_list(boolean fwd) {
        Group group = this;
        synchronized (group) {
            int i = 0;
            int av_size = this.get_size_i(fwd);
            DeviceAttribute[] av = new DeviceAttribute[av_size];
            if (fwd) {
                Vector h = this.get_hierarchy();
                Iterator it = h.iterator();
                while (it.hasNext()) {
                    av[i++] = new DeviceAttribute(((GroupDeviceElement)it.next()).get_name());
                }
            } else {
                for (GroupElement e : this.elements) {
                    if (!(e instanceof GroupDeviceElement)) continue;
                    av[i++] = new DeviceAttribute(e.get_name());
                }
            }
            return av;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupReplyList write_attribute(DeviceAttribute[] da, boolean fwd) throws DevFailed {
        Group group = this;
        synchronized (group) {
            int rid = this.write_attribute_asynch_i(da, fwd, this.next_req_id());
            return this.write_attribute_reply_i(rid, 0, fwd);
        }
    }

    public int write_attribute_asynch(DeviceAttribute da, boolean fwd) throws DevFailed {
        int rid = this.write_attribute_asynch_i(da, fwd, this.next_req_id());
        this.arp.put(new Integer(rid), new Boolean(fwd));
        return rid;
    }

    public int write_attribute_asynch(DeviceAttribute[] da, boolean fwd) throws DevFailed {
        int rid = this.write_attribute_asynch_i(da, fwd, this.next_req_id());
        this.arp.put(new Integer(rid), new Boolean(fwd));
        return rid;
    }

    public GroupReplyList write_attribute_reply(int rid, int tmo) throws DevFailed {
        Integer rid_obj = new Integer(rid);
        Boolean fwd = (Boolean)this.arp.get(rid_obj);
        if (fwd == null) {
            Except.throw_exception("API_BadAsynPollId", "Invalid asynch. request identifier specified", "Group.write_attribute_reply");
        }
        this.arp.remove(rid_obj);
        return this.write_attribute_reply_i(rid, tmo, fwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] get_device_name_list(boolean fwd) {
        Group group = this;
        synchronized (group) {
            int i = 0;
            String[] dl = new String[this.get_size_i(fwd)];
            for (GroupElement e : this.elements) {
                if (!(e instanceof GroupDeviceElement) && !fwd) continue;
                String[] sub_dl = e.get_device_name_list(fwd);
                int j = 0;
                while (j < sub_dl.length) {
                    dl[i] = sub_dl[j];
                    ++j;
                    ++i;
                }
            }
            return dl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector get_hierarchy() {
        Group group = this;
        synchronized (group) {
            Vector<Serializable> h = new Vector<Serializable>();
            for (GroupElement e : this.elements) {
                if (e instanceof GroupDeviceElement) {
                    h.add(e);
                    continue;
                }
                h.add(((Group)e).get_hierarchy());
            }
            return h;
        }
    }

    private int get_size_i(boolean fwd) {
        int size = 0;
        for (GroupElement e : this.elements) {
            if (!(e instanceof GroupDeviceElement) && !fwd) continue;
            size += e.get_size(true);
        }
        return size;
    }

    private Group get_group_i(String n, boolean fwd) {
        GroupElement e = this.find_i(n, fwd);
        return e != null && e instanceof Group ? (Group)e : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GroupElement find(String n, boolean fwd) {
        Group group = this;
        synchronized (group) {
            return this.find_i(n, fwd);
        }
    }

    private GroupElement find_i(String n, boolean fwd) {
        if (this.name_equals(n)) {
            return this;
        }
        GroupElement e2 = null;
        for (GroupElement e2 : this.elements) {
            if (!e2.name_equals(n)) continue;
            return e2;
        }
        if (fwd) {
            Iterator it = this.elements.iterator();
            while (it.hasNext()) {
                e2 = ((GroupElement)it.next()).find(n, fwd);
                if (e2 == null) continue;
                return e2;
            }
        }
        return null;
    }

    private boolean add_i(GroupElement e) {
        if (e == null || e == this) {
            System.out.println("Group::add_i::failed to add " + e.get_name() + " (null or self)");
            return false;
        }
        GroupElement ge = this.find_i(e.get_name(), !(e instanceof Group));
        if (ge != null && ge != this) {
            System.out.println("Group::add_i::failed to add " + e.get_name() + " (already attached)");
            return false;
        }
        this.elements.add(e);
        e.set_parent(this);
        return true;
    }

    private void remove_i(String p, boolean fwd) {
        if (this.name_equals(p)) {
            System.out.println("Group::remove_i::failed to remove " + p + " (can't remove self)");
            return;
        }
        if (p.indexOf(42) == -1) {
            for (GroupElement e : this.elements) {
                if (!e.name_equals(p)) continue;
                this.elements.remove(e);
                break;
            }
        } else {
            Vector<GroupElement> remove_list = new Vector<GroupElement>();
            for (GroupElement e : this.elements) {
                if (!e.name_matches(p)) continue;
                remove_list.add(e);
            }
            Iterator it = remove_list.iterator();
            while (it.hasNext()) {
                this.elements.remove(it.next());
            }
        }
        if (fwd) {
            for (GroupElement e : this.elements) {
                if (!(e instanceof Group)) continue;
                ((Group)e).remove(p, fwd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeviceProxy get_device_i(int i) {
        Group group = this;
        synchronized (group) {
            DeviceProxy dp = null;
            Iterator it = this.elements.iterator();
            while (dp == null && it.hasNext()) {
                GroupElement e = (GroupElement)it.next();
                dp = e.get_device_i(i--);
            }
            return dp;
        }
    }

    DeviceProxy get_device_i(String n) {
        DeviceProxy dp = null;
        Iterator it = this.elements.iterator();
        while (dp == null && it.hasNext()) {
            GroupElement e = (GroupElement)it.next();
            dp = e.get_device_i(n);
        }
        return dp;
    }

    void dump_i(int indent_level) {
        for (int i = 0; i < indent_level; ++i) {
            System.out.print("  ");
        }
        System.out.println("|- Group: " + this.get_name() + " [" + this.get_size_i(true) + ":" + this.get_size_i(false) + "]");
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            ((GroupElement)it.next()).dump_i(indent_level + 1);
        }
    }

    boolean ping_i(boolean fwd) {
        boolean all_alive = true;
        Iterator it = this.elements.iterator();
        while (it.hasNext() && all_alive) {
            GroupElement e = (GroupElement)it.next();
            if (!(e instanceof GroupDeviceElement) && !fwd) continue;
            all_alive = e.ping_i(fwd) ? all_alive : false;
        }
        return all_alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int command_inout_asynch_i(String c, boolean fgt, boolean fwd, int rid) throws DevFailed {
        Group group = this;
        synchronized (group) {
            for (GroupElement e : this.elements) {
                if (!(e instanceof GroupDeviceElement) && !fwd) continue;
                e.command_inout_asynch_i(c, fgt, fwd, rid);
            }
            return rid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int command_inout_asynch_i(String c, DeviceData dd, boolean fgt, boolean fwd, int rid) throws DevFailed {
        Group group = this;
        synchronized (group) {
            for (GroupElement e : this.elements) {
                if (!(e instanceof GroupDeviceElement) && !fwd) continue;
                e.command_inout_asynch_i(c, dd, fgt, fwd, rid);
            }
            return rid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int command_inout_asynch_i(String c, DeviceData[] dd, boolean fgt, boolean fwd, int rid) throws DevFailed {
        Group group = this;
        synchronized (group) {
            int gsize = this.get_size_i(fwd);
            if (gsize != dd.length) {
                String desc = "the size of the input argument list must equal the number of device in the group [expected:" + gsize + " - got:" + dd.length + "]";
                Except.throw_exception("API_MethodArgument", desc, "Group.command_inout_asynch");
            }
            int i = 0;
            if (fwd) {
                Vector h = this.get_hierarchy();
                Iterator it = h.iterator();
                while (it.hasNext()) {
                    ((GroupDeviceElement)it.next()).command_inout_asynch_i(c, dd[i++], fgt, fwd, rid);
                }
            } else {
                for (GroupElement e : this.elements) {
                    if (!(e instanceof GroupDeviceElement)) continue;
                    e.command_inout_asynch_i(c, dd[i++], fgt, fwd, rid);
                }
            }
            return rid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GroupCmdReplyList command_inout_reply_i(int rid, int tmo, boolean fwd) throws DevFailed {
        Group group = this;
        synchronized (group) {
            GroupCmdReplyList reply = new GroupCmdReplyList();
            for (GroupElement ge : this.elements) {
                if (!(ge instanceof GroupDeviceElement) && !fwd) continue;
                GroupCmdReplyList sub_reply = ge.command_inout_reply_i(rid, tmo, fwd);
                if (!sub_reply.isEmpty()) {
                    reply.addAll(sub_reply);
                }
                if (!sub_reply.has_failed()) continue;
                reply.has_failed = true;
            }
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read_attribute_asynch_i(String a, boolean fwd, int rid) throws DevFailed {
        Group group = this;
        synchronized (group) {
            for (GroupElement e : this.elements) {
                if (!(e instanceof GroupDeviceElement) && !fwd) continue;
                e.read_attribute_asynch_i(a, fwd, rid);
            }
            return rid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GroupAttrReplyList read_attribute_reply_i(int rid, int tmo, boolean fwd) throws DevFailed {
        Group group = this;
        synchronized (group) {
            GroupAttrReplyList reply = new GroupAttrReplyList();
            for (GroupElement ge : this.elements) {
                if (!(ge instanceof GroupDeviceElement) && !fwd) continue;
                GroupAttrReplyList sub_reply = ge.read_attribute_reply_i(rid, tmo, fwd);
                if (!sub_reply.isEmpty()) {
                    reply.addAll(sub_reply);
                }
                if (!sub_reply.has_failed()) continue;
                reply.has_failed = true;
            }
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int write_attribute_asynch_i(DeviceAttribute da, boolean fwd, int rid) throws DevFailed {
        Group group = this;
        synchronized (group) {
            for (GroupElement e : this.elements) {
                if (!(e instanceof GroupDeviceElement) && !fwd) continue;
                e.write_attribute_asynch_i(da, fwd, rid);
            }
            return rid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int write_attribute_asynch_i(DeviceAttribute[] da, boolean fwd, int rid) throws DevFailed {
        Group group = this;
        synchronized (group) {
            int gsize = this.get_size_i(fwd);
            if (gsize != da.length) {
                String desc = "the size of the input argument list must equal the number of device in the group [expected:" + gsize + " - got:" + da.length + "]";
                Except.throw_exception("API_MethodArgument", desc, "Group.write_attribute_asynch");
            }
            int i = 0;
            if (fwd) {
                Vector h = this.get_hierarchy();
                Iterator it = h.iterator();
                while (it.hasNext()) {
                    ((GroupDeviceElement)it.next()).write_attribute_asynch_i(da[i++], fwd, rid);
                }
            } else {
                for (GroupElement e : this.elements) {
                    if (!(e instanceof GroupDeviceElement)) continue;
                    e.write_attribute_asynch_i(da[i++], fwd, rid);
                }
            }
            return rid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GroupReplyList write_attribute_reply_i(int rid, int tmo, boolean fwd) throws DevFailed {
        Group group = this;
        synchronized (group) {
            GroupReplyList reply = new GroupReplyList();
            for (GroupElement ge : this.elements) {
                if (!(ge instanceof GroupDeviceElement) && !fwd) continue;
                GroupReplyList sub_reply = ge.write_attribute_reply_i(rid, tmo, fwd);
                if (!sub_reply.isEmpty()) {
                    reply.addAll(sub_reply);
                }
                if (!sub_reply.has_failed()) continue;
                reply.has_failed = true;
            }
            return reply;
        }
    }

    private int next_req_id() {
        this.asynch_req_id = this.asynch_req_id++ % Integer.MAX_VALUE;
        return this.asynch_req_id;
    }

    private final class GroupElementFactory {
        private GroupElementFactory() {
        }

        public Vector instanciate(String p) throws DevFailed {
            String[] dnl = null;
            if (p.indexOf(42) == -1) {
                dnl = new String[]{p};
            } else {
                Database db = new Database();
                dnl = db.get_device_exported(p);
            }
            if (dnl.length == 0) {
                return null;
            }
            Vector<GroupDeviceElement> ge = new Vector<GroupDeviceElement>();
            for (int i = 0; i < dnl.length; ++i) {
                ge.add(new GroupDeviceElement(dnl[i]));
            }
            return ge;
        }
    }
}

