/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoDs.Except;

public class DevVarCmdArray {
    protected CommandInfo[] cmd_info;
    protected String devname;

    public DevVarCmdArray(String devname, DevCmdInfo[] info) {
        this.devname = devname;
        this.cmd_info = new CommandInfo[info.length];
        for (int i = 0; i < info.length; ++i) {
            this.cmd_info[i] = new CommandInfo(info[i]);
        }
    }

    public DevVarCmdArray(String devname, CommandInfo[] info) {
        this.devname = devname;
        this.cmd_info = info;
    }

    public int size() {
        return this.cmd_info.length;
    }

    public CommandInfo elementAt(int i) {
        return this.cmd_info[i];
    }

    public CommandInfo[] getInfoArray() {
        return this.cmd_info;
    }

    public int argoutType(String cmdname) throws DevFailed {
        for (int i = 0; i < this.cmd_info.length; ++i) {
            if (!cmdname.equals(this.cmd_info[i].cmd_name)) continue;
            return this.cmd_info[i].out_type;
        }
        Except.throw_non_supported_exception("TACO_CMD_UNAVAILABLE", new String(cmdname + " command unknown for device " + this.devname), "DevVarCmdArray.argoutType()");
        return -1;
    }

    public int arginType(String cmdname) throws DevFailed {
        for (int i = 0; i < this.cmd_info.length; ++i) {
            if (!cmdname.equals(this.cmd_info[i].cmd_name)) continue;
            return this.cmd_info[i].in_type;
        }
        Except.throw_non_supported_exception("TACO_CMD_UNAVAILABLE", new String(cmdname + " command unknown for device " + this.devname), "DevVarCmdArray.arginType()");
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.cmd_info.length; ++i) {
            sb.append(this.cmd_info[i].cmd_name);
            sb.append("(" + this.cmd_info[i].in_type);
            sb.append(", " + this.cmd_info[i].out_type + ")\n");
        }
        return sb.toString();
    }
}

