/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsyncCallObject;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbRedundancy;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IApiUtilDAO;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Request;
import org.omg.CORBA.SystemException;

public class ApiUtilDAODefaultImpl
implements IApiUtilDAO {
    private static Vector db_list = null;
    private static Database default_dbase = null;
    private static EventConsumer event_consumer = null;
    private static Hashtable async_request_table = null;
    private static int async_request_cnt = 0;
    private static int async_cb_sub_model = 1;
    private static boolean in_server_code = false;
    private static int reconnection_delay = -1;

    public Database get_db_obj(String tango_host) throws DevFailed {
        int i = tango_host.indexOf(":");
        if (i <= 0) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Cannot parse port number", "ApiUtil.get_db_obj()");
        }
        return this.get_db_obj(tango_host.substring(0, i), tango_host.substring(i + 1));
    }

    public Database get_default_db_obj() throws DevFailed {
        if (default_dbase == null) {
            return this.get_db_obj();
        }
        return default_dbase;
    }

    public synchronized Database get_db_obj() throws DevFailed {
        if (ApiUtil.getOrb() == null) {
            ApiUtilDAODefaultImpl.create_orb();
        }
        if (db_list == null) {
            db_list = new Vector();
        }
        if (default_dbase == null) {
            default_dbase = new Database();
            db_list.addElement(default_dbase);
        }
        return (Database)db_list.elementAt(0);
    }

    public Database get_db_obj(String host, String port) throws DevFailed {
        if (ApiUtil.getOrb() == null) {
            ApiUtilDAODefaultImpl.create_orb();
        }
        if (db_list == null) {
            db_list = new Vector();
        }
        String tango_host = new String(host + ":" + port);
        if (default_dbase != null && default_dbase.get_tango_host().equals(tango_host)) {
            return default_dbase;
        }
        for (int i = 0; i < db_list.size(); ++i) {
            Database dbase = (Database)db_list.elementAt(i);
            if (!dbase.get_tango_host().equals(tango_host)) continue;
            return dbase;
        }
        Database dbase = new Database(host, port);
        db_list.add(dbase);
        return dbase;
    }

    public Database change_db_obj(String host, String port) throws DevFailed {
        Database dbase = this.get_db_obj(host, port);
        db_list.remove(dbase);
        db_list.insertElementAt(dbase, 0);
        default_dbase = dbase;
        return dbase;
    }

    public Database set_db_obj(String host, String port) throws DevFailed {
        return this.change_db_obj(host, port);
    }

    public Database set_db_obj(String tango_host) throws DevFailed {
        int i = tango_host.indexOf(":");
        if (i <= 0) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Cannot parse port number", "ApiUtil.set_db_obj()");
        }
        return this.change_db_obj(tango_host.substring(0, i), tango_host.substring(i + 1));
    }

    private static synchronized void create_orb() throws DevFailed {
        try {
            Properties props = System.getProperties();
            props.put("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            props.put("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
            props.put("jacorb.retries", "1");
            props.put("jacorb.retry_interval", "100");
            props.put("jacorb.connection.client.connect_timeout", "5000");
            props.put("jacorb.maxManagedBufSize", "20");
            props.put("jacorb.config.log.verbosity", "0");
            System.setProperties(props);
            String[] argv = null;
            ApiUtil.setOrb(ORB.init(argv, null));
        }
        catch (SystemException ex) {
            ApiUtil.setOrb(null);
            ex.printStackTrace();
            Except.throw_connection_failed(ex.toString(), "Initializing ORB failed !", "ApiUtil.create_orb()");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ORB get_orb() throws DevFailed {
        if (ApiUtil.getOrb() == null) {
            ApiUtilDAODefaultImpl.create_orb();
        }
        return ApiUtil.getOrb();
    }

    public void set_in_server(boolean val) {
        in_server_code = val;
    }

    public boolean in_server() {
        return in_server_code;
    }

    public int getReconnectionDelay() {
        if (reconnection_delay < 0) {
            try {
                DbDatum data = this.get_db_obj().get_property("CtrlSystem", "ReconnectionDelay");
                if (!data.is_empty()) {
                    reconnection_delay = data.extractLong();
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            if (reconnection_delay < 0) {
                reconnection_delay = 1000;
            }
        }
        return reconnection_delay;
    }

    public int put_async_request(AsyncCallObject aco) {
        if (async_request_table == null) {
            async_request_table = new Hashtable();
        }
        aco.id = ++async_request_cnt;
        Integer key = new Integer(async_request_cnt);
        async_request_table.put(key, aco);
        return async_request_cnt;
    }

    public Request get_async_request(int id) {
        Integer key = new Integer(id);
        AsyncCallObject aco = (AsyncCallObject)async_request_table.get(key);
        return aco.request;
    }

    public AsyncCallObject get_async_object(int id) {
        Integer key = new Integer(id);
        return (AsyncCallObject)async_request_table.get(key);
    }

    public void remove_async_request(int id) {
        Integer key = new Integer(id);
        AsyncCallObject aco = (AsyncCallObject)async_request_table.get(key);
        ((org.jacorb.orb.ORB)ApiUtil.getOrb()).removeRequest(aco.request);
        async_request_table.remove(key);
    }

    public void set_async_reply_model(int id, int reply_model) {
        Integer key = new Integer(id);
        AsyncCallObject aco = (AsyncCallObject)async_request_table.get(key);
        aco.reply_model = reply_model;
    }

    public void set_async_reply_cb(int id, CallBack cb) {
        Integer key = new Integer(id);
        AsyncCallObject aco = (AsyncCallObject)async_request_table.get(key);
        aco.cb = cb;
    }

    public int pending_asynch_call(DeviceProxy dev, int reply_model) {
        int cnt = 0;
        Enumeration _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            AsyncCallObject aco = (AsyncCallObject)async_request_table.get(_enum.nextElement());
            if (aco.dev != dev || reply_model != 0 && aco.reply_model != reply_model) continue;
            ++cnt;
        }
        return cnt;
    }

    public int pending_asynch_call(int reply_model) {
        int cnt = 0;
        Enumeration _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            AsyncCallObject aco = (AsyncCallObject)async_request_table.get(_enum.nextElement());
            if (reply_model != 0 && aco.reply_model != reply_model) continue;
            ++cnt;
        }
        return cnt;
    }

    public void set_asynch_cb_sub_model(int model) {
        async_cb_sub_model = model;
    }

    public int get_asynch_cb_sub_model() {
        return async_cb_sub_model;
    }

    public void get_asynch_replies() {
        Enumeration _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            AsyncCallObject aco = (AsyncCallObject)async_request_table.get(_enum.nextElement());
            aco.manage_reply(-1);
        }
    }

    public void get_asynch_replies(int timeout) {
        Enumeration _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            AsyncCallObject aco = (AsyncCallObject)async_request_table.get(_enum.nextElement());
            aco.manage_reply(timeout);
        }
    }

    public void get_asynch_replies(DeviceProxy dev) {
        Enumeration _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            AsyncCallObject aco = (AsyncCallObject)async_request_table.get(_enum.nextElement());
            if (aco.dev != dev) continue;
            aco.manage_reply(-1);
        }
    }

    public void get_asynch_replies(DeviceProxy dev, int timeout) {
        Enumeration _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            AsyncCallObject aco = (AsyncCallObject)async_request_table.get(_enum.nextElement());
            if (aco.dev != dev) continue;
            aco.manage_reply(timeout);
        }
    }

    public String[] toStringArray(String objname, String[] argin) {
        String[] array = new String[1 + argin.length];
        array[0] = objname;
        for (int i = 0; i < argin.length; ++i) {
            array[i + 1] = argin[i];
        }
        return array;
    }

    public String[] toStringArray(String objname, String argin) {
        String[] array = new String[]{objname, argin};
        return array;
    }

    public String[] toStringArray(String argin) {
        String[] array = new String[]{argin};
        return array;
    }

    public String[] toStringArray(String objname, DbAttribute[] attr, int mode) {
        int nb_attr = attr.length;
        Vector<String> vector = new Vector<String>();
        vector.add(objname);
        vector.add(new String("" + nb_attr));
        for (int i = 0; i < nb_attr; ++i) {
            vector.add(attr[i].name);
            vector.add(new String("" + attr[i].size()));
            for (int j = 0; j < attr[i].size(); ++j) {
                vector.add(attr[i].get_property_name(j));
                String[] values = attr[i].get_value(j);
                if (mode != 1) {
                    vector.add(new String("" + values.length));
                }
                for (int v = 0; v < values.length; ++v) {
                    vector.add(values[v]);
                }
            }
        }
        String[] array = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            array[i] = (String)vector.elementAt(i);
        }
        return array;
    }

    public DbAttribute[] toDbAttributeArray(String[] array, int mode) throws DevFailed {
        if (mode < 1 && mode > 2) {
            Except.throw_non_supported_exception("API_NotSupportedMode", "Mode " + mode + " to decode attribute properties is not supported", "ApiUtil.toDbAttributeArray()");
        }
        int idx = 1;
        int nb_attr = Integer.parseInt(array[idx++]);
        DbAttribute[] attr = new DbAttribute[nb_attr];
        for (int i = 0; i < nb_attr; ++i) {
            attr[i] = new DbAttribute(array[idx++]);
            int nb_prop = Integer.parseInt(array[idx++]);
            block5: for (int j = 0; j < nb_prop; ++j) {
                String p_name = array[idx++];
                switch (mode) {
                    case 1: {
                        attr[i].add(p_name, array[idx++]);
                        continue block5;
                    }
                    case 2: {
                        int p_length = Integer.parseInt(array[idx++]);
                        String[] val = new String[p_length];
                        for (int p = 0; p < p_length; ++p) {
                            val[p] = array[idx++];
                        }
                        attr[i].add(p_name, val);
                    }
                }
            }
        }
        return attr;
    }

    public String stateName(DevState state) {
        return TangoConst.Tango_DevStateName[state.value()];
    }

    public String stateName(short state_val) {
        return TangoConst.Tango_DevStateName[state_val];
    }

    public String qualityName(AttrQuality att_q) {
        return TangoConst.Tango_QualityName[att_q.value()];
    }

    public String qualityName(short att_q_val) {
        return TangoConst.Tango_QualityName[att_q_val];
    }

    public String[] parseTangoHost(String tgh) throws DevFailed {
        String host = null;
        String strport = null;
        try {
            StringTokenizer stk = tgh.indexOf(",") > 0 ? new StringTokenizer(tgh, ",") : new StringTokenizer(tgh);
            Vector<String> vector = new Vector<String>();
            while (stk.hasMoreTokens()) {
                String th = stk.nextToken();
                StringTokenizer stk2 = new StringTokenizer(th, ":");
                vector.add(stk2.nextToken());
                vector.add(stk2.nextToken());
            }
            int i = 0;
            host = (String)vector.elementAt(i++);
            strport = (String)vector.elementAt(i++);
            Integer.parseInt(strport);
            String def_tango_host = host + ":" + strport;
            DbRedundancy dbr = DbRedundancy.get_instance();
            if (vector.size() > 3) {
                String redun = (String)vector.elementAt(i++) + ":" + (String)vector.elementAt(i++);
                dbr.put(def_tango_host, redun);
            }
        }
        catch (Exception e) {
            Except.throw_exception("TangoApi_TANGO_HOST_NOT_SET", e.toString() + " occured when parsing " + "\"TANGO_HOST\" property " + tgh, "TangoApi.ApiUtil.parseTangoHost()");
        }
        String[] array = new String[]{host, strport};
        return array;
    }

    public void create_event_consumer() throws DevFailed {
        event_consumer = EventConsumer.create();
    }

    public EventConsumer get_event_consumer() {
        return event_consumer;
    }
}

