/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class JDSwingObject
extends JDRectangular {
    public static Border lowerBevelBorder = BorderFactory.createLoweredBevelBorder();
    public static Border raiseBevelBorder = BorderFactory.createRaisedBevelBorder();
    public static Border etchedBevelBorder = BorderFactory.createEtchedBorder();
    public static final int NO_BORDER = 0;
    public static final int LOWERED_BORDER = 1;
    public static final int RAISED_BORDER = 2;
    public static final int ETCHED_BORDER = 3;
    static final int borderDefault = 0;
    private String className = "";
    private JDrawable swingComp = null;
    private Font theFont;
    private int border;

    public JDSwingObject(String string, String string2, int n, int n2) {
        Dimension dimension;
        this.initDefault();
        this.setOrigin(new Point2D.Double(0.0, 0.0));
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.className = string2;
        this.lineWidth = 0;
        this.fillStyle = 1;
        this.createSummit();
        this.constructComponent(true);
        if (this.swingComp != null) {
            dimension = this.swingComp.getComponent().getPreferredSize();
            if (dimension.width < 16) {
                dimension.width = 16;
            }
            if (dimension.height < 16) {
                dimension.height = 16;
            }
        } else {
            dimension = new Dimension(16, 16);
        }
        this.computeSummitCoordinates(n, n2, dimension.width, dimension.height);
        this.updateShape();
        this.centerOrigin();
    }

    JDSwingObject(JDSwingObject jDSwingObject, int n, int n2) {
        this.cloneObject(jDSwingObject, n, n2);
        this.className = jDSwingObject.className;
        this.theFont = new Font(jDSwingObject.theFont.getName(), jDSwingObject.theFont.getStyle(), jDSwingObject.theFont.getSize());
        this.border = jDSwingObject.border;
        this.constructComponent(false);
        this.mapExtensions();
        this.updateShape();
    }

    void initDefault() {
        super.initDefault();
        this.theFont = JDLabel.fontDefault;
        this.border = 0;
    }

    public JDObject copy(int n, int n2) {
        return new JDSwingObject(this, n, n2);
    }

    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.swingComp == null) {
            return;
        }
        if (jDrawEditor.getMode() == 3) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.antiAlias = false;
        this.prepareRendering(graphics2D);
        this.swingComp.getComponent().validate();
        SwingUtilities.paintComponent(graphics, this.swingComp.getComponent(), jDrawEditor, this.boundRect);
        this.swingComp.getComponent().setBounds(this.boundRect);
    }

    void setExtendedParam(String string, String string2, boolean bl) {
        if (this.isFixedExtendedParam(string)) {
            this.swingComp.setExtendedParam(string, string2, !bl);
            super.setExtendedParam(string, this.swingComp.getExtendedParam(string));
        } else {
            super.setExtendedParam(string, string2);
        }
    }

    public boolean isFixedExtendedParam(String string) {
        return this.getSwingExtensionIdx(string) >= 0;
    }

    private int getSwingExtensionIdx(String string) {
        int n = -1;
        if (this.swingComp != null) {
            String[] stringArray = this.swingComp.getExtensionList();
            boolean bl = false;
            int n2 = 0;
            while (n2 < stringArray.length && !bl) {
                bl = stringArray[n2].equalsIgnoreCase(string);
                if (bl) continue;
                ++n2;
            }
            if (bl) {
                return n2;
            }
        }
        return n;
    }

    public void setExtendedParam(String string, String string2) {
        this.setExtendedParam(string, string2, false);
    }

    public void removeExtension(int n) {
        String string;
        if (this.swingComp != null && this.isFixedExtendedParam(string = this.getExtendedParamName(n))) {
            System.out.println("JDSwingObject.removeExtension() : Warning, trying to remove JDrawable extension '" + string + "'.");
            return;
        }
        super.removeExtension(n);
    }

    public String getExtendedParamDesc(String string) {
        if (this.swingComp != null) {
            return this.swingComp.getDescription(string);
        }
        return "";
    }

    void updateShape() {
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        if (this.summit[0].x < this.summit[2].x) {
            if (this.summit[0].y < this.summit[6].y) {
                this.ptsx[0] = (int)this.summit[0].x;
                this.ptsy[0] = (int)this.summit[0].y;
                this.ptsx[1] = (int)this.summit[2].x + 1;
                this.ptsy[1] = (int)this.summit[2].y;
                this.ptsx[2] = (int)this.summit[4].x + 1;
                this.ptsy[2] = (int)this.summit[4].y + 1;
                this.ptsx[3] = (int)this.summit[6].x;
                this.ptsy[3] = (int)this.summit[6].y + 1;
            } else {
                this.ptsx[0] = (int)this.summit[6].x;
                this.ptsy[0] = (int)this.summit[6].y;
                this.ptsx[1] = (int)this.summit[4].x + 1;
                this.ptsy[1] = (int)this.summit[4].y;
                this.ptsx[2] = (int)this.summit[2].x + 1;
                this.ptsy[2] = (int)this.summit[2].y + 1;
                this.ptsx[3] = (int)this.summit[0].x;
                this.ptsy[3] = (int)this.summit[0].y + 1;
            }
        } else if (this.summit[0].y < this.summit[6].y) {
            this.ptsx[0] = (int)this.summit[2].x;
            this.ptsy[0] = (int)this.summit[2].y;
            this.ptsx[1] = (int)this.summit[0].x + 1;
            this.ptsy[1] = (int)this.summit[0].y;
            this.ptsx[2] = (int)this.summit[6].x + 1;
            this.ptsy[2] = (int)this.summit[6].y + 1;
            this.ptsx[3] = (int)this.summit[4].x;
            this.ptsy[3] = (int)this.summit[4].y + 1;
        } else {
            this.ptsx[0] = (int)this.summit[4].x;
            this.ptsy[0] = (int)this.summit[4].y;
            this.ptsx[1] = (int)this.summit[6].x + 1;
            this.ptsy[1] = (int)this.summit[6].y;
            this.ptsx[2] = (int)this.summit[0].x + 1;
            this.ptsy[2] = (int)this.summit[0].y + 1;
            this.ptsx[3] = (int)this.summit[2].x;
            this.ptsy[3] = (int)this.summit[2].y + 1;
        }
        this.computeBoundRect();
        if (this.swingComp != null) {
            this.swingComp.getComponent().setBackground(this.background);
            this.swingComp.getComponent().setForeground(this.foreground);
            this.swingComp.getComponent().setVisible(this.visible);
            this.swingComp.getComponent().setOpaque(this.fillStyle != 0);
            this.swingComp.getComponent().setFont(this.theFont);
            switch (this.border) {
                case 0: {
                    this.swingComp.getComponent().setBorder(null);
                    break;
                }
                case 1: {
                    this.swingComp.getComponent().setBorder(lowerBevelBorder);
                    break;
                }
                case 2: {
                    this.swingComp.getComponent().setBorder(raiseBevelBorder);
                    break;
                }
                case 3: {
                    this.swingComp.getComponent().setBorder(etchedBevelBorder);
                }
            }
            this.swingComp.getComponent().setBounds(this.boundRect);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.swingComp != null) {
            this.swingComp.getComponent().setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.swingComp != null) {
            this.swingComp.getComponent().setForeground(color);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.swingComp != null) {
            this.swingComp.getComponent().setVisible(bl);
        }
    }

    public void setFillStyle(int n) {
        super.setFillStyle(n);
        if (this.swingComp != null) {
            this.swingComp.getComponent().setOpaque(this.fillStyle != 0);
        }
    }

    public void setFont(Font font) {
        this.setFont(font, false);
    }

    public void setFont(Font font, boolean bl) {
        this.theFont = font;
        this.updateComp(bl);
    }

    public void setBorder(int n) {
        this.border = n;
        this.updateShape();
    }

    public int getBorder() {
        return this.border;
    }

    public Font getFont() {
        return this.theFont;
    }

    public boolean hasShadow() {
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public JComponent getComponent() {
        if (this.swingComp != null) {
            return this.swingComp.getComponent();
        }
        return null;
    }

    void saveObject(FileWriter fileWriter, int n) throws IOException {
        String string = this.saveObjectHeader(fileWriter, n);
        String string2 = string + "className:\"" + this.className + "\"\n";
        fileWriter.write(string2, 0, string2.length());
        if (this.theFont.getName() != JDLabel.fontDefault.getName() || this.theFont.getStyle() != JDLabel.fontDefault.getStyle() || this.theFont.getSize() != JDLabel.fontDefault.getSize()) {
            string2 = string + "font:\"" + this.theFont.getName() + "\"," + this.theFont.getStyle() + "," + this.theFont.getSize() + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        if (this.border != 0) {
            string2 = string + "border:" + this.border + "\n";
            fileWriter.write(string2, 0, string2.length());
        }
        this.closeObjectHeader(fileWriter, n);
    }

    JDSwingObject(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("className")) {
                this.className = jDFileLoader.parseString();
                continue;
            }
            if (string.equals("font")) {
                this.theFont = jDFileLoader.parseFont();
                continue;
            }
            if (string.equals("border")) {
                this.border = (int)jDFileLoader.parseDouble();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.constructComponent(false);
        this.mapExtensions();
        this.updateShape();
    }

    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(10);
        this.fillUndoPattern(undoPattern);
        undoPattern.className = this.className;
        undoPattern.swingComp = this.swingComp;
        undoPattern.fName = this.theFont.getName();
        undoPattern.fStyle = this.theFont.getStyle();
        undoPattern.fSize = this.theFont.getSize();
        undoPattern.border = this.border;
        return undoPattern;
    }

    JDSwingObject(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.className = undoPattern.className;
        this.swingComp = undoPattern.swingComp;
        this.theFont = new Font(undoPattern.fName, undoPattern.fStyle, undoPattern.fSize);
        this.border = undoPattern.border;
        this.mapExtensions();
        this.updateShape();
    }

    private void computeSummitCoordinates(int n, int n2, int n3, int n4) {
        this.summit[0].x = n;
        this.summit[0].y = n2;
        this.summit[2].x = n + n3 - 1;
        this.summit[2].y = n2;
        this.summit[4].x = n + n3 - 1;
        this.summit[4].y = n2 + n4 - 1;
        this.summit[6].x = n;
        this.summit[6].y = n2 + n4 - 1;
        this.centerSummit();
    }

    private void updateComp(boolean bl) {
        if (this.swingComp != null) {
            this.swingComp.getComponent().setFont(this.theFont);
            if (bl) {
                Dimension dimension = this.swingComp.getComponent().getPreferredSize();
                if (dimension.width < 8) {
                    dimension.width = 8;
                }
                if (dimension.height < 8) {
                    dimension.height = 8;
                }
                if (this.summit[2].x - this.summit[0].x <= (double)dimension.width || this.summit[6].y - this.summit[0].y <= (double)dimension.height) {
                    double d = this.summit[0].x + (double)dimension.width;
                    double d2 = this.summit[0].y + (double)dimension.height;
                    this.summit[2].x = d;
                    this.summit[4].x = d;
                    this.summit[4].y = d2;
                    this.summit[6].y = d2;
                    this.centerSummit();
                    this.updateShape();
                }
            }
        }
    }

    private void mapExtensions() {
        if (this.swingComp != null) {
            int n = this.getExtendedParamNumber();
            for (int i = 0; i < n; ++i) {
                this.swingComp.setExtendedParam(this.getExtendedParamName(i), this.getExtendedParam(i), false);
            }
        }
    }

    private void constructComponent(boolean bl) {
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Class<?> clazz = Class.forName(this.className);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            this.swingComp = (JDrawable)constructor.newInstance(objectArray);
            this.swingComp.initForEditing();
            String[] stringArray = this.swingComp.getExtensionList();
            if (bl) {
                this.setExtensionList(stringArray);
                for (int i = 0; i < stringArray.length; ++i) {
                    super.setExtendedParam(i, this.swingComp.getExtendedParam(stringArray[i]));
                }
                this.theFont = this.swingComp.getComponent().getFont();
                if (this.theFont == null) {
                    this.theFont = JDLabel.fontDefault;
                    this.swingComp.getComponent().setFont(this.theFont);
                }
                this.foreground = this.swingComp.getComponent().getForeground();
                this.background = this.swingComp.getComponent().getBackground();
                Border border = this.swingComp.getComponent().getBorder();
                if (border == lowerBevelBorder) {
                    this.border = 1;
                } else if (border == raiseBevelBorder) {
                    this.border = 2;
                } else if (border == etchedBevelBorder) {
                    this.border = 3;
                }
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.hasExtendedParam(stringArray[i])) continue;
                    this.addExtension(stringArray[i]);
                    super.setExtendedParam(stringArray[i], this.swingComp.getExtendedParam(stringArray[i]));
                }
            }
        }
        catch (Exception exception) {
            System.out.println("JDraw.constructComponent() : " + exception.getClass() + " while trying to construct " + this.className);
            this.swingComp = null;
        }
    }
}

