/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.chart.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JLDataViewOption
extends JDialog
implements ActionListener,
MouseListener,
ChangeListener,
KeyListener {
    private JLDataView dataView;
    protected JLChart chart;
    protected JLabel nameLabel;
    private JTabbedPane tabPane;
    protected JButton closeBtn;
    private JPanel linePanel;
    private JLabel viewTypeLabel;
    private JComboBox viewTypeCombo;
    private JLabel lineColorView;
    private JButton lineColorBtn;
    private JLabel lineColorLabel;
    private JLabel fillColorView;
    private JButton fillColorBtn;
    private JLabel fillColorLabel;
    private JLabel fillStyleLabel;
    private JComboBox fillStyleCombo;
    private JLabel lineWidthLabel;
    private JSpinner lineWidthSpinner;
    private JLabel lineDashLabel;
    private JComboBox lineDashCombo;
    private JLabel lineNameLabel;
    private JTextField lineNameText;
    private JPanel barPanel;
    private JLabel barWidthLabel;
    private JSpinner barWidthSpinner;
    private JLabel fillMethodLabel;
    private JComboBox fillMethodCombo;
    private JPanel markerPanel;
    private JLabel markerColorView;
    private JButton markerColorBtn;
    private JLabel markerColorLabel;
    private JLabel markerSizeLabel;
    private JSpinner markerSizeSpinner;
    private JLabel markerStyleLabel;
    private JComboBox markerStyleCombo;
    private JCheckBox labelVisibleCheck;
    private JPanel transformPanel;
    private JTextArea transformHelpLabel;
    private JLabel transformA0Label;
    private JTextField transformA0Text;
    private JLabel transformA1Label;
    private JTextField transformA1Text;
    private JLabel transformA2Label;
    private JTextField transformA2Text;
    private JPanel interpPanel;
    private ButtonGroup methodIntBtnGrp;
    private JRadioButton noInterpBtn;
    private JRadioButton linearBtn;
    private JRadioButton cosineBtn;
    private JRadioButton cubicBtn;
    private JRadioButton hermiteBtn;
    private JSpinner stepSpinner;
    private JTextField tensionText;
    private JTextField biasText;
    private JPanel smoothPanel;
    private ButtonGroup methodSmBtnGrp;
    private JRadioButton noSmoothBtn;
    private JRadioButton flatSmoothBtn;
    private JRadioButton triangularSmoothBtn;
    private JRadioButton gaussianSmoothBtn;
    private JSpinner neighborSpinner;
    private JTextField sigmaText;
    private ButtonGroup methodExtBtnGrp;
    private JRadioButton noExtBtn;
    private JRadioButton flatExtBtn;
    private JRadioButton linearExtBtn;
    private JPanel mathPanel;
    private ButtonGroup mathBtnGrp;
    private JRadioButton noMathBtn;
    private JRadioButton derivativeBtn;
    private JRadioButton integralBtn;
    private JRadioButton fftModBtn;
    private JRadioButton fftPhaseBtn;

    public JLDataViewOption(JDialog jDialog, JLChart jLChart, JLDataView jLDataView) {
        super((Dialog)jDialog, true);
        this.dataView = jLDataView;
        this.chart = jLChart;
        this.initComponents();
    }

    public JLDataViewOption(JFrame jFrame, JLChart jLChart, JLDataView jLDataView) {
        super((Frame)jFrame, true);
        this.dataView = jLDataView;
        this.chart = jLChart;
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JLDataViewOption.this.setVisible(false);
                JLDataViewOption.this.dispose();
            }
        });
        this.setTitle("Data view options");
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(GraphicsUtils.labelFont);
        this.linePanel = new JPanel();
        this.linePanel.setLayout(null);
        this.viewTypeLabel = new JLabel("View type");
        this.viewTypeLabel.setFont(GraphicsUtils.labelFont);
        this.viewTypeLabel.setForeground(GraphicsUtils.fColor);
        this.viewTypeCombo = new JComboBox();
        this.viewTypeCombo.setFont(GraphicsUtils.labelFont);
        this.viewTypeCombo.addItem("Line");
        this.viewTypeCombo.addItem("Bar graph");
        this.viewTypeCombo.setSelectedIndex(this.dataView.getViewType());
        this.viewTypeCombo.addActionListener(this);
        this.lineColorView = new JLabel("");
        this.lineColorView.setBackground(this.dataView.getColor());
        this.lineColorView.setOpaque(true);
        this.lineColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.lineColorBtn = new JButton("...");
        this.lineColorBtn.addMouseListener(this);
        this.lineColorLabel = new JLabel("Line Color");
        this.lineColorLabel.setFont(GraphicsUtils.labelFont);
        this.lineColorLabel.setForeground(GraphicsUtils.fColor);
        this.fillColorView = new JLabel("");
        this.fillColorView.setBackground(this.dataView.getFillColor());
        this.fillColorView.setOpaque(true);
        this.fillColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.fillColorBtn = new JButton("...");
        this.fillColorBtn.addMouseListener(this);
        this.fillColorLabel = new JLabel("Fill Color");
        this.fillColorLabel.setFont(GraphicsUtils.labelFont);
        this.fillColorLabel.setForeground(GraphicsUtils.fColor);
        this.lineWidthLabel = new JLabel("Line Width");
        this.lineWidthLabel.setFont(GraphicsUtils.labelFont);
        this.lineWidthLabel.setForeground(GraphicsUtils.fColor);
        this.lineWidthSpinner = new JSpinner();
        Integer n = new Integer(this.dataView.getLineWidth());
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(10);
        Integer n4 = new Integer(1);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
        this.lineWidthSpinner.setModel(spinnerNumberModel);
        this.lineWidthSpinner.addChangeListener(this);
        this.lineDashLabel = new JLabel("Line style");
        this.lineDashLabel.setFont(GraphicsUtils.labelFont);
        this.lineDashLabel.setForeground(GraphicsUtils.fColor);
        this.lineDashCombo = new JComboBox();
        this.lineDashCombo.setFont(GraphicsUtils.labelFont);
        this.lineDashCombo.addItem("Solid");
        this.lineDashCombo.addItem("Point dash");
        this.lineDashCombo.addItem("Short dash");
        this.lineDashCombo.addItem("Long dash");
        this.lineDashCombo.addItem("Dot dash");
        this.lineDashCombo.setSelectedIndex(this.dataView.getStyle());
        this.lineDashCombo.addActionListener(this);
        this.fillStyleLabel = new JLabel("Fill style");
        this.fillStyleLabel.setFont(GraphicsUtils.labelFont);
        this.fillStyleLabel.setForeground(GraphicsUtils.fColor);
        this.fillStyleCombo = new JComboBox();
        this.fillStyleCombo.setFont(GraphicsUtils.labelFont);
        this.fillStyleCombo.addItem("No fill");
        this.fillStyleCombo.addItem("Solid");
        this.fillStyleCombo.addItem("Large leff hatch");
        this.fillStyleCombo.addItem("Large right hatch");
        this.fillStyleCombo.addItem("Large cross hatch");
        this.fillStyleCombo.addItem("Small leff hatch");
        this.fillStyleCombo.addItem("Small right hatch");
        this.fillStyleCombo.addItem("Small cross hatch");
        this.fillStyleCombo.addItem("Dot pattern 1");
        this.fillStyleCombo.addItem("Dot pattern 2");
        this.fillStyleCombo.addItem("Dot pattern 3");
        this.fillStyleCombo.setSelectedIndex(this.dataView.getFillStyle());
        this.fillStyleCombo.addActionListener(this);
        this.lineNameLabel = new JLabel("Name");
        this.lineNameLabel.setFont(GraphicsUtils.labelFont);
        this.lineNameLabel.setForeground(GraphicsUtils.fColor);
        this.lineNameText = new JTextField();
        this.lineNameText.setEditable(true);
        this.lineNameText.setText(this.dataView.getName());
        this.lineNameText.setMargin(GraphicsUtils.zInset);
        this.lineNameText.addKeyListener(this);
        this.linePanel.add(this.viewTypeLabel);
        this.linePanel.add(this.viewTypeCombo);
        this.linePanel.add(this.lineColorLabel);
        this.linePanel.add(this.lineColorView);
        this.linePanel.add(this.lineColorBtn);
        this.linePanel.add(this.fillColorLabel);
        this.linePanel.add(this.fillColorView);
        this.linePanel.add(this.fillColorBtn);
        this.linePanel.add(this.lineWidthLabel);
        this.linePanel.add(this.lineWidthSpinner);
        this.linePanel.add(this.lineDashLabel);
        this.linePanel.add(this.lineDashCombo);
        this.linePanel.add(this.fillStyleLabel);
        this.linePanel.add(this.fillStyleCombo);
        this.linePanel.add(this.lineNameLabel);
        this.linePanel.add(this.lineNameText);
        this.viewTypeLabel.setBounds(10, 10, 100, 25);
        this.viewTypeCombo.setBounds(115, 10, 125, 25);
        this.lineColorLabel.setBounds(10, 40, 100, 25);
        this.lineColorView.setBounds(115, 40, 80, 25);
        this.lineColorBtn.setBounds(200, 40, 40, 27);
        this.fillColorLabel.setBounds(10, 70, 100, 25);
        this.fillColorView.setBounds(115, 70, 80, 25);
        this.fillColorBtn.setBounds(200, 70, 40, 27);
        this.fillStyleLabel.setBounds(10, 100, 100, 25);
        this.fillStyleCombo.setBounds(115, 100, 125, 25);
        this.lineWidthLabel.setBounds(10, 130, 100, 25);
        this.lineWidthSpinner.setBounds(115, 130, 125, 25);
        this.lineDashLabel.setBounds(10, 160, 100, 25);
        this.lineDashCombo.setBounds(115, 160, 125, 25);
        this.lineNameLabel.setBounds(10, 190, 100, 25);
        this.lineNameText.setBounds(115, 190, 125, 25);
        this.barPanel = new JPanel();
        this.barPanel.setLayout(null);
        this.barWidthLabel = new JLabel("Bar Width");
        this.barWidthLabel.setFont(GraphicsUtils.labelFont);
        this.barWidthLabel.setForeground(GraphicsUtils.fColor);
        this.barWidthSpinner = new JSpinner();
        n = new Integer(this.dataView.getBarWidth());
        n2 = new Integer(0);
        n3 = new Integer(100);
        n4 = new Integer(1);
        spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
        this.barWidthSpinner.setModel(spinnerNumberModel);
        this.barWidthSpinner.addChangeListener(this);
        this.fillMethodLabel = new JLabel("Filling method");
        this.fillMethodLabel.setFont(GraphicsUtils.labelFont);
        this.fillMethodLabel.setForeground(GraphicsUtils.fColor);
        this.fillMethodCombo = new JComboBox();
        this.fillMethodCombo.setFont(GraphicsUtils.labelFont);
        this.fillMethodCombo.addItem("From Up");
        this.fillMethodCombo.addItem("From Zero");
        this.fillMethodCombo.addItem("From Bottom");
        this.fillMethodCombo.setSelectedIndex(this.dataView.getFillMethod());
        this.fillMethodCombo.addActionListener(this);
        this.barPanel.add(this.barWidthLabel);
        this.barPanel.add(this.barWidthSpinner);
        this.barPanel.add(this.fillMethodLabel);
        this.barPanel.add(this.fillMethodCombo);
        this.barWidthLabel.setBounds(10, 10, 100, 25);
        this.barWidthSpinner.setBounds(115, 10, 125, 25);
        this.fillMethodLabel.setBounds(10, 40, 100, 25);
        this.fillMethodCombo.setBounds(115, 40, 125, 25);
        this.markerPanel = new JPanel();
        this.markerPanel.setLayout(null);
        this.markerColorView = new JLabel("");
        this.markerColorView.setBackground(this.dataView.getMarkerColor());
        this.markerColorView.setOpaque(true);
        this.markerColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.markerColorBtn = new JButton("...");
        this.markerColorBtn.addMouseListener(this);
        this.markerColorLabel = new JLabel("Color");
        this.markerColorLabel.setFont(GraphicsUtils.labelFont);
        this.markerColorLabel.setForeground(GraphicsUtils.fColor);
        this.markerSizeLabel = new JLabel("Size");
        this.markerSizeLabel.setFont(GraphicsUtils.labelFont);
        this.markerSizeLabel.setForeground(GraphicsUtils.fColor);
        this.markerSizeSpinner = new JSpinner();
        n = new Integer(this.dataView.getMarkerSize());
        spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
        this.markerSizeSpinner.setModel(spinnerNumberModel);
        this.markerSizeSpinner.addChangeListener(this);
        this.markerStyleLabel = new JLabel("Marker style");
        this.markerStyleLabel.setFont(GraphicsUtils.labelFont);
        this.markerStyleLabel.setForeground(GraphicsUtils.fColor);
        this.markerStyleCombo = new JComboBox();
        this.markerStyleCombo.addItem("None");
        this.markerStyleCombo.addItem("Dot");
        this.markerStyleCombo.addItem("Box");
        this.markerStyleCombo.addItem("triangle");
        this.markerStyleCombo.addItem("Diamond");
        this.markerStyleCombo.addItem("Star");
        this.markerStyleCombo.addItem("Vert. line");
        this.markerStyleCombo.addItem("Horz. line");
        this.markerStyleCombo.addItem("Cross");
        this.markerStyleCombo.addItem("Circle");
        this.markerStyleCombo.addItem("Sqaure");
        this.markerStyleCombo.setSelectedIndex(this.dataView.getMarker());
        this.markerStyleCombo.addActionListener(this);
        this.labelVisibleCheck = new JCheckBox();
        this.labelVisibleCheck.setFont(GraphicsUtils.labelFont);
        this.labelVisibleCheck.setForeground(GraphicsUtils.fColor);
        this.labelVisibleCheck.setText("Legend visible");
        this.labelVisibleCheck.setSelected(this.dataView.isLabelVisible());
        this.labelVisibleCheck.addActionListener(this);
        this.markerPanel.add(this.markerColorLabel);
        this.markerPanel.add(this.markerColorView);
        this.markerPanel.add(this.markerColorBtn);
        this.markerPanel.add(this.markerSizeLabel);
        this.markerPanel.add(this.markerSizeSpinner);
        this.markerPanel.add(this.markerStyleLabel);
        this.markerPanel.add(this.markerStyleCombo);
        this.markerPanel.add(this.labelVisibleCheck);
        this.markerColorLabel.setBounds(10, 10, 100, 25);
        this.markerColorView.setBounds(115, 10, 80, 25);
        this.markerColorBtn.setBounds(200, 10, 40, 27);
        this.markerSizeLabel.setBounds(10, 40, 100, 25);
        this.markerSizeSpinner.setBounds(115, 40, 125, 25);
        this.markerStyleLabel.setBounds(10, 70, 100, 25);
        this.markerStyleCombo.setBounds(115, 70, 125, 25);
        this.labelVisibleCheck.setBounds(10, 100, 225, 25);
        this.transformPanel = new JPanel();
        this.transformPanel.setLayout(null);
        this.transformHelpLabel = new JTextArea("This apply a polynomial transform\nto the data view:\n y' = A0 + A1*y + A2*y^2");
        this.transformHelpLabel.setFont(GraphicsUtils.labelFont);
        this.transformHelpLabel.setForeground(GraphicsUtils.fColor);
        this.transformHelpLabel.setFont(this.markerStyleLabel.getFont());
        this.transformHelpLabel.setEditable(false);
        this.transformHelpLabel.setBackground(this.markerStyleLabel.getBackground());
        this.transformA0Label = new JLabel("A0");
        this.transformA0Label.setFont(GraphicsUtils.labelFont);
        this.transformA0Label.setForeground(GraphicsUtils.fColor);
        this.transformA0Text = new JTextField();
        this.transformA0Text.setEditable(true);
        this.transformA0Text.setText(Double.toString(this.dataView.getA0()));
        this.transformA0Text.setMargin(GraphicsUtils.zInset);
        this.transformA0Text.addKeyListener(this);
        this.transformA1Label = new JLabel("A1");
        this.transformA1Label.setFont(GraphicsUtils.labelFont);
        this.transformA1Label.setForeground(GraphicsUtils.fColor);
        this.transformA1Text = new JTextField();
        this.transformA1Text.setEditable(true);
        this.transformA1Text.setText(Double.toString(this.dataView.getA1()));
        this.transformA1Text.setMargin(GraphicsUtils.zInset);
        this.transformA1Text.addKeyListener(this);
        this.transformA2Label = new JLabel("A2");
        this.transformA2Label.setFont(GraphicsUtils.labelFont);
        this.transformA2Label.setForeground(GraphicsUtils.fColor);
        this.transformA2Text = new JTextField();
        this.transformA2Text.setEditable(true);
        this.transformA2Text.setText(Double.toString(this.dataView.getA2()));
        this.transformA2Text.setMargin(GraphicsUtils.zInset);
        this.transformA2Text.addKeyListener(this);
        this.transformPanel.add(this.transformHelpLabel);
        this.transformPanel.add(this.transformA0Label);
        this.transformPanel.add(this.transformA0Text);
        this.transformPanel.add(this.transformA1Label);
        this.transformPanel.add(this.transformA1Text);
        this.transformPanel.add(this.transformA2Label);
        this.transformPanel.add(this.transformA2Text);
        this.transformHelpLabel.setBounds(10, 100, 240, 100);
        this.transformA0Label.setBounds(60, 10, 30, 25);
        this.transformA0Text.setBounds(95, 10, 100, 25);
        this.transformA1Label.setBounds(60, 40, 30, 25);
        this.transformA1Text.setBounds(95, 40, 100, 25);
        this.transformA2Label.setBounds(60, 70, 30, 25);
        this.transformA2Text.setBounds(95, 70, 100, 25);
        this.interpPanel = new JPanel();
        this.interpPanel.setLayout(null);
        this.methodIntBtnGrp = new ButtonGroup();
        this.noInterpBtn = new JRadioButton("None");
        this.noInterpBtn.setForeground(GraphicsUtils.fColor);
        this.noInterpBtn.setFont(GraphicsUtils.labelFont);
        this.noInterpBtn.setBounds(5, 10, 90, 25);
        this.interpPanel.add(this.noInterpBtn);
        this.methodIntBtnGrp.add(this.noInterpBtn);
        this.linearBtn = new JRadioButton("Linear");
        this.linearBtn.setForeground(GraphicsUtils.fColor);
        this.linearBtn.setFont(GraphicsUtils.labelFont);
        this.linearBtn.setBounds(5, 35, 90, 25);
        this.interpPanel.add(this.linearBtn);
        this.methodIntBtnGrp.add(this.linearBtn);
        this.cosineBtn = new JRadioButton("Cosine");
        this.cosineBtn.setForeground(GraphicsUtils.fColor);
        this.cosineBtn.setFont(GraphicsUtils.labelFont);
        this.cosineBtn.setBounds(5, 60, 90, 25);
        this.interpPanel.add(this.cosineBtn);
        this.methodIntBtnGrp.add(this.cosineBtn);
        this.cubicBtn = new JRadioButton("Cubic");
        this.cubicBtn.setForeground(GraphicsUtils.fColor);
        this.cubicBtn.setFont(GraphicsUtils.labelFont);
        this.cubicBtn.setBounds(5, 85, 90, 25);
        this.interpPanel.add(this.cubicBtn);
        this.methodIntBtnGrp.add(this.cubicBtn);
        this.hermiteBtn = new JRadioButton("Hermite");
        this.hermiteBtn.setForeground(GraphicsUtils.fColor);
        this.hermiteBtn.setFont(GraphicsUtils.labelFont);
        this.hermiteBtn.setBounds(5, 110, 90, 25);
        this.interpPanel.add(this.hermiteBtn);
        this.methodIntBtnGrp.add(this.hermiteBtn);
        JLabel jLabel = new JLabel("Step");
        jLabel.setFont(GraphicsUtils.labelFont);
        jLabel.setForeground(GraphicsUtils.fColor);
        jLabel.setHorizontalAlignment(4);
        jLabel.setBounds(100, 10, 85, 25);
        this.interpPanel.add(jLabel);
        this.stepSpinner = new JSpinner();
        n = new Integer(this.dataView.getInterpolationStep());
        n2 = new Integer(2);
        n3 = new Integer(100);
        spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
        this.stepSpinner.setModel(spinnerNumberModel);
        this.stepSpinner.addChangeListener(this);
        this.stepSpinner.setBounds(195, 10, 50, 25);
        this.interpPanel.add(this.stepSpinner);
        JLabel jLabel2 = new JLabel("Tension");
        jLabel2.setFont(GraphicsUtils.labelFont);
        jLabel2.setForeground(GraphicsUtils.fColor);
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setBounds(100, 40, 85, 25);
        this.interpPanel.add(jLabel2);
        this.tensionText = new JTextField();
        this.tensionText.setFont(GraphicsUtils.labelFont);
        this.tensionText.setEditable(true);
        this.tensionText.setBounds(195, 40, 50, 25);
        this.tensionText.setEnabled(false);
        this.tensionText.addKeyListener(this);
        this.interpPanel.add(this.tensionText);
        JLabel jLabel3 = new JLabel("Bias");
        jLabel3.setFont(GraphicsUtils.labelFont);
        jLabel3.setForeground(GraphicsUtils.fColor);
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setBounds(100, 70, 85, 25);
        this.interpPanel.add(jLabel3);
        this.biasText = new JTextField();
        this.biasText.setFont(GraphicsUtils.labelFont);
        this.biasText.setEditable(true);
        this.biasText.setBounds(195, 70, 50, 25);
        this.biasText.setEnabled(false);
        this.biasText.addKeyListener(this);
        this.interpPanel.add(this.biasText);
        switch (this.dataView.getInterpolationMethod()) {
            case 0: {
                this.noInterpBtn.setSelected(true);
                break;
            }
            case 1: {
                this.linearBtn.setSelected(true);
                break;
            }
            case 3: {
                this.cubicBtn.setSelected(true);
                break;
            }
            case 2: {
                this.cosineBtn.setSelected(true);
                break;
            }
            case 4: {
                this.hermiteBtn.setSelected(true);
            }
        }
        this.noInterpBtn.addChangeListener(this);
        this.linearBtn.addChangeListener(this);
        this.cosineBtn.addChangeListener(this);
        this.cubicBtn.addChangeListener(this);
        this.hermiteBtn.addChangeListener(this);
        this.tensionText.setText(Double.toString(this.dataView.getHermiteTension()));
        this.biasText.setText(Double.toString(this.dataView.getHermiteBias()));
        this.smoothPanel = new JPanel();
        this.smoothPanel.setLayout(null);
        this.methodSmBtnGrp = new ButtonGroup();
        this.noSmoothBtn = new JRadioButton("None");
        this.noSmoothBtn.setForeground(GraphicsUtils.fColor);
        this.noSmoothBtn.setFont(GraphicsUtils.labelFont);
        this.noSmoothBtn.setBounds(5, 10, 90, 25);
        this.smoothPanel.add(this.noSmoothBtn);
        this.methodSmBtnGrp.add(this.noSmoothBtn);
        this.flatSmoothBtn = new JRadioButton("Flat");
        this.flatSmoothBtn.setForeground(GraphicsUtils.fColor);
        this.flatSmoothBtn.setFont(GraphicsUtils.labelFont);
        this.flatSmoothBtn.setBounds(5, 35, 90, 25);
        this.smoothPanel.add(this.flatSmoothBtn);
        this.methodSmBtnGrp.add(this.flatSmoothBtn);
        this.triangularSmoothBtn = new JRadioButton("Linear");
        this.triangularSmoothBtn.setForeground(GraphicsUtils.fColor);
        this.triangularSmoothBtn.setFont(GraphicsUtils.labelFont);
        this.triangularSmoothBtn.setBounds(5, 60, 90, 25);
        this.smoothPanel.add(this.triangularSmoothBtn);
        this.methodSmBtnGrp.add(this.triangularSmoothBtn);
        this.gaussianSmoothBtn = new JRadioButton("Gaussian");
        this.gaussianSmoothBtn.setForeground(GraphicsUtils.fColor);
        this.gaussianSmoothBtn.setFont(GraphicsUtils.labelFont);
        this.gaussianSmoothBtn.setBounds(5, 85, 90, 25);
        this.smoothPanel.add(this.gaussianSmoothBtn);
        this.methodSmBtnGrp.add(this.gaussianSmoothBtn);
        JLabel jLabel4 = new JLabel("Neighbors");
        jLabel4.setFont(GraphicsUtils.labelFont);
        jLabel4.setForeground(GraphicsUtils.fColor);
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setBounds(100, 10, 90, 25);
        this.smoothPanel.add(jLabel4);
        this.neighborSpinner = new JSpinner();
        n = new Integer(this.dataView.getSmoothingNeighbors());
        n2 = new Integer(2);
        n3 = new Integer(99);
        n4 = new Integer(2);
        spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
        this.neighborSpinner.setModel(spinnerNumberModel);
        this.neighborSpinner.addChangeListener(this);
        this.neighborSpinner.setBounds(195, 10, 50, 25);
        this.smoothPanel.add(this.neighborSpinner);
        JLabel jLabel5 = new JLabel(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/chart/sigma_small.gif")));
        jLabel5.setForeground(GraphicsUtils.fColor);
        jLabel5.setHorizontalAlignment(4);
        jLabel5.setBounds(100, 40, 85, 25);
        this.smoothPanel.add(jLabel5);
        this.sigmaText = new JTextField(Double.toString(this.dataView.getSmoothingGaussSigma()));
        this.sigmaText.setFont(GraphicsUtils.labelFont);
        this.sigmaText.setEditable(true);
        this.sigmaText.setBounds(195, 40, 50, 25);
        this.sigmaText.setEnabled(false);
        this.sigmaText.addKeyListener(this);
        this.smoothPanel.add(this.sigmaText);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(null);
        jPanel2.setBorder(GraphicsUtils.createTitleBorder("Boundary extrapolation"));
        this.methodExtBtnGrp = new ButtonGroup();
        this.noExtBtn = new JRadioButton("None");
        this.noExtBtn.setForeground(GraphicsUtils.fColor);
        this.noExtBtn.setFont(GraphicsUtils.labelFont);
        this.noExtBtn.setBounds(5, 20, 90, 25);
        jPanel2.add(this.noExtBtn);
        this.methodExtBtnGrp.add(this.noExtBtn);
        this.flatExtBtn = new JRadioButton("Flat");
        this.flatExtBtn.setForeground(GraphicsUtils.fColor);
        this.flatExtBtn.setFont(GraphicsUtils.labelFont);
        this.flatExtBtn.setBounds(5, 45, 90, 25);
        jPanel2.add(this.flatExtBtn);
        this.methodExtBtnGrp.add(this.flatExtBtn);
        this.linearExtBtn = new JRadioButton("Linear");
        this.linearExtBtn.setForeground(GraphicsUtils.fColor);
        this.linearExtBtn.setFont(GraphicsUtils.labelFont);
        this.linearExtBtn.setBounds(5, 70, 90, 25);
        jPanel2.add(this.linearExtBtn);
        this.methodExtBtnGrp.add(this.linearExtBtn);
        jPanel2.setBounds(5, 120, 245, 100);
        this.smoothPanel.add(jPanel2);
        switch (this.dataView.getSmoothingExtrapolation()) {
            case 0: {
                this.noExtBtn.setSelected(true);
                break;
            }
            case 1: {
                this.flatExtBtn.setSelected(true);
                break;
            }
            case 2: {
                this.linearExtBtn.setSelected(true);
            }
        }
        switch (this.dataView.getSmoothingMethod()) {
            case 0: {
                this.noSmoothBtn.setSelected(true);
                break;
            }
            case 1: {
                this.flatSmoothBtn.setSelected(true);
                break;
            }
            case 2: {
                this.triangularSmoothBtn.setSelected(true);
                break;
            }
            case 3: {
                this.gaussianSmoothBtn.setSelected(true);
            }
        }
        this.noExtBtn.addChangeListener(this);
        this.flatExtBtn.addChangeListener(this);
        this.linearExtBtn.addChangeListener(this);
        this.noSmoothBtn.addChangeListener(this);
        this.flatSmoothBtn.addChangeListener(this);
        this.triangularSmoothBtn.addChangeListener(this);
        this.gaussianSmoothBtn.addChangeListener(this);
        this.mathPanel = new JPanel();
        this.mathPanel.setLayout(null);
        this.mathBtnGrp = new ButtonGroup();
        this.noMathBtn = new JRadioButton("No operation");
        this.noMathBtn.setForeground(GraphicsUtils.fColor);
        this.noMathBtn.setFont(GraphicsUtils.labelFont);
        this.noMathBtn.setBounds(5, 10, 160, 25);
        this.mathPanel.add(this.noMathBtn);
        this.mathBtnGrp.add(this.noMathBtn);
        this.derivativeBtn = new JRadioButton("Derivative");
        this.derivativeBtn.setForeground(GraphicsUtils.fColor);
        this.derivativeBtn.setFont(GraphicsUtils.labelFont);
        this.derivativeBtn.setBounds(5, 35, 160, 25);
        this.mathPanel.add(this.derivativeBtn);
        this.mathBtnGrp.add(this.derivativeBtn);
        this.integralBtn = new JRadioButton("Integral");
        this.integralBtn.setForeground(GraphicsUtils.fColor);
        this.integralBtn.setFont(GraphicsUtils.labelFont);
        this.integralBtn.setBounds(5, 60, 160, 25);
        this.mathPanel.add(this.integralBtn);
        this.mathBtnGrp.add(this.integralBtn);
        this.fftModBtn = new JRadioButton("FFT (modulus)");
        this.fftModBtn.setForeground(GraphicsUtils.fColor);
        this.fftModBtn.setFont(GraphicsUtils.labelFont);
        this.fftModBtn.setBounds(5, 85, 160, 25);
        this.fftModBtn.setEnabled(false);
        this.mathPanel.add(this.fftModBtn);
        this.mathBtnGrp.add(this.fftModBtn);
        this.fftPhaseBtn = new JRadioButton("FFT (phase radians)");
        this.fftPhaseBtn.setForeground(GraphicsUtils.fColor);
        this.fftPhaseBtn.setFont(GraphicsUtils.labelFont);
        this.fftPhaseBtn.setBounds(5, 110, 160, 25);
        this.fftPhaseBtn.setEnabled(false);
        this.mathPanel.add(this.fftPhaseBtn);
        this.mathBtnGrp.add(this.fftPhaseBtn);
        switch (this.dataView.getMathFunction()) {
            case 0: {
                this.noMathBtn.setSelected(true);
                break;
            }
            case 1: {
                this.derivativeBtn.setSelected(true);
                break;
            }
            case 2: {
                this.integralBtn.setSelected(true);
                break;
            }
            case 3: {
                this.fftModBtn.setSelected(true);
                break;
            }
            case 4: {
                this.fftPhaseBtn.setSelected(true);
            }
        }
        this.noMathBtn.addChangeListener(this);
        this.derivativeBtn.addChangeListener(this);
        this.integralBtn.addChangeListener(this);
        this.fftModBtn.addChangeListener(this);
        this.fftPhaseBtn.addChangeListener(this);
        this.nameLabel = new JLabel();
        this.nameLabel.setText(this.dataView.getName());
        this.tabPane.add("Curve", this.linePanel);
        this.tabPane.add("Bar", this.barPanel);
        this.tabPane.add("Marker", this.markerPanel);
        this.tabPane.add("Transform", this.transformPanel);
        this.tabPane.add("Interpolation", this.interpPanel);
        this.tabPane.add("Smoothing", this.smoothPanel);
        this.tabPane.add("Math", this.mathPanel);
        jPanel.add(this.tabPane);
        jPanel.add(this.nameLabel);
        this.closeBtn = new JButton();
        this.closeBtn.setText("Close");
        jPanel.add(this.closeBtn);
        this.tabPane.setBounds(5, 5, 260, 270);
        this.closeBtn.setBounds(185, 280, 80, 25);
        this.nameLabel.setBounds(10, 280, 170, 25);
        this.closeBtn.addMouseListener(this);
        this.updateControls();
        jPanel.setPreferredSize(new Dimension(270, 310));
        this.setContentPane(jPanel);
        this.setResizable(false);
    }

    private void updateControls() {
        this.biasText.setEnabled(false);
        this.tensionText.setEnabled(false);
        this.sigmaText.setEnabled(false);
        switch (this.dataView.getInterpolationMethod()) {
            case 4: {
                this.biasText.setEnabled(true);
                this.tensionText.setEnabled(true);
            }
        }
        switch (this.dataView.getSmoothingMethod()) {
            case 3: {
                this.sigmaText.setEnabled(true);
            }
        }
    }

    public void Commit() {
        if (this.chart != null) {
            this.chart.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Color color;
        if (mouseEvent.getSource() == this.closeBtn) {
            this.setVisible(false);
            this.dispose();
        } else if (mouseEvent.getSource() == this.lineColorBtn) {
            Color color2 = JColorChooser.showDialog(this, "Choose Line Color", this.dataView.getColor());
            if (color2 != null) {
                this.dataView.setColor(color2);
                this.lineColorView.setBackground(color2);
                this.Commit();
            }
        } else if (mouseEvent.getSource() == this.fillColorBtn) {
            Color color3 = JColorChooser.showDialog(this, "Choose Fill Color", this.dataView.getFillColor());
            if (color3 != null) {
                this.dataView.setFillColor(color3);
                this.fillColorView.setBackground(color3);
                this.Commit();
            }
        } else if (mouseEvent.getSource() == this.markerColorBtn && (color = JColorChooser.showDialog(this, "Choose marker Color", this.dataView.getMarkerColor())) != null) {
            this.dataView.setMarkerColor(color);
            this.markerColorView.setBackground(color);
            this.Commit();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.lineDashCombo) {
            this.dataView.setStyle(this.lineDashCombo.getSelectedIndex());
            this.Commit();
        } else if (actionEvent.getSource() == this.fillStyleCombo) {
            this.dataView.setFillStyle(this.fillStyleCombo.getSelectedIndex());
            this.Commit();
        } else if (actionEvent.getSource() == this.fillMethodCombo) {
            this.dataView.setFillMethod(this.fillMethodCombo.getSelectedIndex());
            this.Commit();
        } else if (actionEvent.getSource() == this.viewTypeCombo) {
            this.dataView.setViewType(this.viewTypeCombo.getSelectedIndex());
            this.Commit();
        } else if (actionEvent.getSource() == this.markerStyleCombo) {
            this.dataView.setMarker(this.markerStyleCombo.getSelectedIndex());
            this.Commit();
        } else if (actionEvent.getSource() == this.labelVisibleCheck) {
            this.dataView.setLabelVisible(this.labelVisibleCheck.isSelected());
            this.Commit();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.lineWidthSpinner) {
            Integer n = (Integer)this.lineWidthSpinner.getValue();
            this.dataView.setLineWidth(n);
        } else if (object == this.barWidthSpinner) {
            Integer n = (Integer)this.barWidthSpinner.getValue();
            this.dataView.setBarWidth(n);
        } else if (object == this.markerSizeSpinner) {
            Integer n = (Integer)this.markerSizeSpinner.getValue();
            this.dataView.setMarkerSize(n);
        } else if (object == this.stepSpinner) {
            Integer n = (Integer)this.stepSpinner.getValue();
            this.dataView.setInterpolationStep(n);
        } else if (object == this.neighborSpinner) {
            Integer n = (Integer)this.neighborSpinner.getValue();
            this.dataView.setSmoothingNeighbors(n);
        } else if (object == this.noInterpBtn) {
            if (this.noInterpBtn.isSelected()) {
                this.dataView.setInterpolationMethod(0);
            }
        } else if (object == this.linearBtn) {
            if (this.linearBtn.isSelected()) {
                this.dataView.setInterpolationMethod(1);
            }
        } else if (object == this.cosineBtn) {
            if (this.cosineBtn.isSelected()) {
                this.dataView.setInterpolationMethod(2);
            }
        } else if (object == this.cubicBtn) {
            if (this.cubicBtn.isSelected()) {
                this.dataView.setInterpolationMethod(3);
            }
        } else if (object == this.hermiteBtn) {
            if (this.hermiteBtn.isSelected()) {
                this.dataView.setInterpolationMethod(4);
            }
        } else if (object == this.noSmoothBtn) {
            if (this.noSmoothBtn.isSelected()) {
                this.dataView.setSmoothingMethod(0);
            }
        } else if (object == this.flatSmoothBtn) {
            if (this.flatSmoothBtn.isSelected()) {
                this.dataView.setSmoothingMethod(1);
            }
        } else if (object == this.triangularSmoothBtn) {
            if (this.triangularSmoothBtn.isSelected()) {
                this.dataView.setSmoothingMethod(2);
            }
        } else if (object == this.gaussianSmoothBtn) {
            if (this.gaussianSmoothBtn.isSelected()) {
                this.dataView.setSmoothingMethod(3);
            }
        } else if (object == this.noExtBtn) {
            if (this.noExtBtn.isSelected()) {
                this.dataView.setSmoothingExtrapolation(0);
            }
        } else if (object == this.flatExtBtn) {
            if (this.flatExtBtn.isSelected()) {
                this.dataView.setSmoothingExtrapolation(1);
            }
        } else if (object == this.linearExtBtn) {
            if (this.linearExtBtn.isSelected()) {
                this.dataView.setSmoothingExtrapolation(2);
            }
        } else if (object == this.noMathBtn) {
            if (this.noMathBtn.isSelected()) {
                this.dataView.setMathFunction(0);
            }
        } else if (object == this.derivativeBtn) {
            if (this.derivativeBtn.isSelected()) {
                this.dataView.setMathFunction(1);
            }
        } else if (object == this.integralBtn) {
            if (this.integralBtn.isSelected()) {
                this.dataView.setMathFunction(2);
            }
        } else if (object == this.fftModBtn) {
            if (this.fftModBtn.isSelected()) {
                this.dataView.setMathFunction(3);
            }
        } else if (object == this.fftPhaseBtn && this.fftPhaseBtn.isSelected()) {
            this.dataView.setMathFunction(4);
        }
        this.updateControls();
        this.Commit();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.transformA0Text) {
            if (keyEvent.getKeyCode() == 10) {
                String string = this.transformA0Text.getText();
                try {
                    double d = Double.parseDouble(string);
                    this.dataView.setA0(d);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.transformA0Text.setText(Double.toString(this.dataView.getA0()));
                }
            }
            if (keyEvent.getKeyCode() == 27) {
                this.transformA0Text.setText(Double.toString(this.dataView.getA0()));
            }
        } else if (keyEvent.getSource() == this.transformA1Text) {
            if (keyEvent.getKeyCode() == 10) {
                String string = this.transformA1Text.getText();
                try {
                    double d = Double.parseDouble(string);
                    this.dataView.setA1(d);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.transformA1Text.setText(Double.toString(this.dataView.getA1()));
                }
            }
            if (keyEvent.getKeyCode() == 27) {
                this.transformA1Text.setText(Double.toString(this.dataView.getA1()));
            }
        } else if (keyEvent.getSource() == this.transformA2Text) {
            if (keyEvent.getKeyCode() == 10) {
                String string = this.transformA2Text.getText();
                try {
                    double d = Double.parseDouble(string);
                    this.dataView.setA2(d);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.transformA2Text.setText(Double.toString(this.dataView.getA2()));
                }
            }
            if (keyEvent.getKeyCode() == 27) {
                this.transformA2Text.setText(Double.toString(this.dataView.getA2()));
            }
        } else if (keyEvent.getSource() == this.lineNameText) {
            this.dataView.setName(this.lineNameText.getText());
            this.Commit();
        } else if (keyEvent.getSource() == this.tensionText) {
            if (keyEvent.getKeyCode() == 10) {
                String string = this.tensionText.getText();
                try {
                    double d = Double.parseDouble(string);
                    this.dataView.setHermiteTension(d);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.tensionText.setText(Double.toString(this.dataView.getHermiteTension()));
                }
            }
            if (keyEvent.getKeyCode() == 27) {
                this.tensionText.setText(Double.toString(this.dataView.getHermiteTension()));
            }
        } else if (keyEvent.getSource() == this.biasText) {
            if (keyEvent.getKeyCode() == 10) {
                String string = this.biasText.getText();
                try {
                    double d = Double.parseDouble(string);
                    this.dataView.setHermiteBias(d);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.tensionText.setText(Double.toString(this.dataView.getHermiteBias()));
                }
            }
            if (keyEvent.getKeyCode() == 27) {
                this.biasText.setText(Double.toString(this.dataView.getHermiteBias()));
            }
        } else if (keyEvent.getSource() == this.sigmaText) {
            if (keyEvent.getKeyCode() == 10) {
                String string = this.sigmaText.getText();
                try {
                    double d = Double.parseDouble(string);
                    this.dataView.setSmoothingGaussSigma(d);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.sigmaText.setText(Double.toString(this.dataView.getSmoothingGaussSigma()));
                }
            }
            if (keyEvent.getKeyCode() == 27) {
                this.sigmaText.setText(Double.toString(this.dataView.getSmoothingGaussSigma()));
            }
        }
    }
}

