/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class ArcTanH
extends PostfixMathCommand {
    public ArcTanH() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        stack.push(this.atanh(e));
    }

    public Object atanh(Object object) throws ParseException {
        if (object instanceof Complex) {
            return ((Complex)object).atanh();
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d > -1.0 && d < 1.0) {
                double d2 = Math.log((1.0 + d) / (1.0 - d)) / 2.0;
                return new Double(d2);
            }
            Complex complex = new Complex(d, 0.0);
            return complex.atanh();
        }
        throw new ParseException("Invalid parameter type");
    }
}

